/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about an activity that successfully terminated during an execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivitySucceededEventDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ActivitySucceededEventDetails.Builder, ActivitySucceededEventDetails> {
    private static final SdkField<String> OUTPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("output")
            .getter(getter(ActivitySucceededEventDetails::output)).setter(setter(Builder::output))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final SdkField<HistoryEventExecutionDataDetails> OUTPUT_DETAILS_FIELD = SdkField
            .<HistoryEventExecutionDataDetails> builder(MarshallingType.SDK_POJO).memberName("outputDetails")
            .getter(getter(ActivitySucceededEventDetails::outputDetails)).setter(setter(Builder::outputDetails))
            .constructor(HistoryEventExecutionDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_FIELD,
            OUTPUT_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String output;

    private final HistoryEventExecutionDataDetails outputDetails;

    private ActivitySucceededEventDetails(BuilderImpl builder) {
        this.output = builder.output;
        this.outputDetails = builder.outputDetails;
    }

    /**
     * <p>
     * The JSON data output by the activity task. Length constraints apply to the payload size, and are expressed as
     * bytes in UTF-8 encoding.
     * </p>
     * 
     * @return The JSON data output by the activity task. Length constraints apply to the payload size, and are
     *         expressed as bytes in UTF-8 encoding.
     */
    public final String output() {
        return output;
    }

    /**
     * <p>
     * Contains details about the output of an execution history event.
     * </p>
     * 
     * @return Contains details about the output of an execution history event.
     */
    public final HistoryEventExecutionDataDetails outputDetails() {
        return outputDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(outputDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivitySucceededEventDetails)) {
            return false;
        }
        ActivitySucceededEventDetails other = (ActivitySucceededEventDetails) obj;
        return Objects.equals(output(), other.output()) && Objects.equals(outputDetails(), other.outputDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActivitySucceededEventDetails")
                .add("Output", output() == null ? null : "*** Sensitive Data Redacted ***").add("OutputDetails", outputDetails())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        case "outputDetails":
            return Optional.ofNullable(clazz.cast(outputDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivitySucceededEventDetails, T> g) {
        return obj -> g.apply((ActivitySucceededEventDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActivitySucceededEventDetails> {
        /**
         * <p>
         * The JSON data output by the activity task. Length constraints apply to the payload size, and are expressed as
         * bytes in UTF-8 encoding.
         * </p>
         * 
         * @param output
         *        The JSON data output by the activity task. Length constraints apply to the payload size, and are
         *        expressed as bytes in UTF-8 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(String output);

        /**
         * <p>
         * Contains details about the output of an execution history event.
         * </p>
         * 
         * @param outputDetails
         *        Contains details about the output of an execution history event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDetails(HistoryEventExecutionDataDetails outputDetails);

        /**
         * <p>
         * Contains details about the output of an execution history event.
         * </p>
         * This is a convenience that creates an instance of the {@link HistoryEventExecutionDataDetails.Builder}
         * avoiding the need to create one manually via {@link HistoryEventExecutionDataDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link HistoryEventExecutionDataDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #outputDetails(HistoryEventExecutionDataDetails)}.
         * 
         * @param outputDetails
         *        a consumer that will call methods on {@link HistoryEventExecutionDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDetails(HistoryEventExecutionDataDetails)
         */
        default Builder outputDetails(Consumer<HistoryEventExecutionDataDetails.Builder> outputDetails) {
            return outputDetails(HistoryEventExecutionDataDetails.builder().applyMutation(outputDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String output;

        private HistoryEventExecutionDataDetails outputDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivitySucceededEventDetails model) {
            output(model.output);
            outputDetails(model.outputDetails);
        }

        public final String getOutput() {
            return output;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        @Override
        @Transient
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        public final HistoryEventExecutionDataDetails.Builder getOutputDetails() {
            return outputDetails != null ? outputDetails.toBuilder() : null;
        }

        public final void setOutputDetails(HistoryEventExecutionDataDetails.BuilderImpl outputDetails) {
            this.outputDetails = outputDetails != null ? outputDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder outputDetails(HistoryEventExecutionDataDetails outputDetails) {
            this.outputDetails = outputDetails;
            return this;
        }

        @Override
        public ActivitySucceededEventDetails build() {
            return new ActivitySucceededEventDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
