/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.LoggingConfiguration;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.services.sfn.model.TracingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStateMachineForExecutionResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, DescribeStateMachineForExecutionResponse> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateMachineArn").getter(DescribeStateMachineForExecutionResponse.getter(DescribeStateMachineForExecutionResponse::stateMachineArn)).setter(DescribeStateMachineForExecutionResponse.setter(Builder::stateMachineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DescribeStateMachineForExecutionResponse.getter(DescribeStateMachineForExecutionResponse::name)).setter(DescribeStateMachineForExecutionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definition").getter(DescribeStateMachineForExecutionResponse.getter(DescribeStateMachineForExecutionResponse::definition)).setter(DescribeStateMachineForExecutionResponse.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DescribeStateMachineForExecutionResponse.getter(DescribeStateMachineForExecutionResponse::roleArn)).setter(DescribeStateMachineForExecutionResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateDate").getter(DescribeStateMachineForExecutionResponse.getter(DescribeStateMachineForExecutionResponse::updateDate)).setter(DescribeStateMachineForExecutionResponse.setter(Builder::updateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDate").build()}).build();
    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("loggingConfiguration").getter(DescribeStateMachineForExecutionResponse.getter(DescribeStateMachineForExecutionResponse::loggingConfiguration)).setter(DescribeStateMachineForExecutionResponse.setter(Builder::loggingConfiguration)).constructor(LoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfiguration").build()}).build();
    private static final SdkField<TracingConfiguration> TRACING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tracingConfiguration").getter(DescribeStateMachineForExecutionResponse.getter(DescribeStateMachineForExecutionResponse::tracingConfiguration)).setter(DescribeStateMachineForExecutionResponse.setter(Builder::tracingConfiguration)).constructor(TracingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD, NAME_FIELD, DEFINITION_FIELD, ROLE_ARN_FIELD, UPDATE_DATE_FIELD, LOGGING_CONFIGURATION_FIELD, TRACING_CONFIGURATION_FIELD));
    private final String stateMachineArn;
    private final String name;
    private final String definition;
    private final String roleArn;
    private final Instant updateDate;
    private final LoggingConfiguration loggingConfiguration;
    private final TracingConfiguration tracingConfiguration;

    private DescribeStateMachineForExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.stateMachineArn = builder.stateMachineArn;
        this.name = builder.name;
        this.definition = builder.definition;
        this.roleArn = builder.roleArn;
        this.updateDate = builder.updateDate;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.tracingConfiguration = builder.tracingConfiguration;
    }

    public final String stateMachineArn() {
        return this.stateMachineArn;
    }

    public final String name() {
        return this.name;
    }

    public final String definition() {
        return this.definition;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant updateDate() {
        return this.updateDate;
    }

    public final LoggingConfiguration loggingConfiguration() {
        return this.loggingConfiguration;
    }

    public final TracingConfiguration tracingConfiguration() {
        return this.tracingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStateMachineForExecutionResponse)) {
            return false;
        }
        DescribeStateMachineForExecutionResponse other = (DescribeStateMachineForExecutionResponse)((Object)obj);
        return Objects.equals(this.stateMachineArn(), other.stateMachineArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.updateDate(), other.updateDate()) && Objects.equals(this.loggingConfiguration(), other.loggingConfiguration()) && Objects.equals(this.tracingConfiguration(), other.tracingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStateMachineForExecutionResponse").add("StateMachineArn", (Object)this.stateMachineArn()).add("Name", (Object)this.name()).add("Definition", (Object)(this.definition() == null ? null : "*** Sensitive Data Redacted ***")).add("RoleArn", (Object)this.roleArn()).add("UpdateDate", (Object)this.updateDate()).add("LoggingConfiguration", (Object)this.loggingConfiguration()).add("TracingConfiguration", (Object)this.tracingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateMachineArn": {
                return Optional.ofNullable(clazz.cast(this.stateMachineArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "updateDate": {
                return Optional.ofNullable(clazz.cast(this.updateDate()));
            }
            case "loggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.loggingConfiguration()));
            }
            case "tracingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.tracingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStateMachineForExecutionResponse, T> g) {
        return obj -> g.apply((DescribeStateMachineForExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private String stateMachineArn;
        private String name;
        private String definition;
        private String roleArn;
        private Instant updateDate;
        private LoggingConfiguration loggingConfiguration;
        private TracingConfiguration tracingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStateMachineForExecutionResponse model) {
            super(model);
            this.stateMachineArn(model.stateMachineArn);
            this.name(model.name);
            this.definition(model.definition);
            this.roleArn(model.roleArn);
            this.updateDate(model.updateDate);
            this.loggingConfiguration(model.loggingConfiguration);
            this.tracingConfiguration(model.tracingConfiguration);
        }

        public final String getStateMachineArn() {
            return this.stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        @Transient
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDefinition() {
            return this.definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        @Transient
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        @Transient
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return this.loggingConfiguration != null ? this.loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final TracingConfiguration.Builder getTracingConfiguration() {
            return this.tracingConfiguration != null ? this.tracingConfiguration.toBuilder() : null;
        }

        public final void setTracingConfiguration(TracingConfiguration.BuilderImpl tracingConfiguration) {
            this.tracingConfiguration = tracingConfiguration != null ? tracingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder tracingConfiguration(TracingConfiguration tracingConfiguration) {
            this.tracingConfiguration = tracingConfiguration;
            return this;
        }

        @Override
        public DescribeStateMachineForExecutionResponse build() {
            return new DescribeStateMachineForExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStateMachineForExecutionResponse> {
        public Builder stateMachineArn(String var1);

        public Builder name(String var1);

        public Builder definition(String var1);

        public Builder roleArn(String var1);

        public Builder updateDate(Instant var1);

        public Builder loggingConfiguration(LoggingConfiguration var1);

        default public Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return this.loggingConfiguration((LoggingConfiguration)((LoggingConfiguration.Builder)LoggingConfiguration.builder().applyMutation(loggingConfiguration)).build());
        }

        public Builder tracingConfiguration(TracingConfiguration var1);

        default public Builder tracingConfiguration(Consumer<TracingConfiguration.Builder> tracingConfiguration) {
            return this.tracingConfiguration((TracingConfiguration)((TracingConfiguration.Builder)TracingConfiguration.builder().applyMutation(tracingConfiguration)).build());
        }
    }
}

