/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSyncExecutionResponse extends SfnResponse implements
        ToCopyableBuilder<StartSyncExecutionResponse.Builder, StartSyncExecutionResponse> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionArn").getter(getter(StartSyncExecutionResponse::executionArn))
            .setter(setter(Builder::executionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()).build();

    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineArn").getter(getter(StartSyncExecutionResponse::stateMachineArn))
            .setter(setter(Builder::stateMachineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StartSyncExecutionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDate").getter(getter(StartSyncExecutionResponse::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()).build();

    private static final SdkField<Instant> STOP_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("stopDate").getter(getter(StartSyncExecutionResponse::stopDate)).setter(setter(Builder::stopDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopDate").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(StartSyncExecutionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(StartSyncExecutionResponse::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cause")
            .getter(getter(StartSyncExecutionResponse::cause)).setter(setter(Builder::cause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(StartSyncExecutionResponse::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<CloudWatchEventsExecutionDataDetails> INPUT_DETAILS_FIELD = SdkField
            .<CloudWatchEventsExecutionDataDetails> builder(MarshallingType.SDK_POJO).memberName("inputDetails")
            .getter(getter(StartSyncExecutionResponse::inputDetails)).setter(setter(Builder::inputDetails))
            .constructor(CloudWatchEventsExecutionDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDetails").build()).build();

    private static final SdkField<String> OUTPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("output")
            .getter(getter(StartSyncExecutionResponse::output)).setter(setter(Builder::output))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final SdkField<CloudWatchEventsExecutionDataDetails> OUTPUT_DETAILS_FIELD = SdkField
            .<CloudWatchEventsExecutionDataDetails> builder(MarshallingType.SDK_POJO).memberName("outputDetails")
            .getter(getter(StartSyncExecutionResponse::outputDetails)).setter(setter(Builder::outputDetails))
            .constructor(CloudWatchEventsExecutionDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDetails").build()).build();

    private static final SdkField<String> TRACE_HEADER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceHeader").getter(getter(StartSyncExecutionResponse::traceHeader))
            .setter(setter(Builder::traceHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceHeader").build()).build();

    private static final SdkField<BillingDetails> BILLING_DETAILS_FIELD = SdkField
            .<BillingDetails> builder(MarshallingType.SDK_POJO).memberName("billingDetails")
            .getter(getter(StartSyncExecutionResponse::billingDetails)).setter(setter(Builder::billingDetails))
            .constructor(BillingDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD,
            STATE_MACHINE_ARN_FIELD, NAME_FIELD, START_DATE_FIELD, STOP_DATE_FIELD, STATUS_FIELD, ERROR_FIELD, CAUSE_FIELD,
            INPUT_FIELD, INPUT_DETAILS_FIELD, OUTPUT_FIELD, OUTPUT_DETAILS_FIELD, TRACE_HEADER_FIELD, BILLING_DETAILS_FIELD));

    private final String executionArn;

    private final String stateMachineArn;

    private final String name;

    private final Instant startDate;

    private final Instant stopDate;

    private final String status;

    private final String error;

    private final String causeValue;

    private final String input;

    private final CloudWatchEventsExecutionDataDetails inputDetails;

    private final String output;

    private final CloudWatchEventsExecutionDataDetails outputDetails;

    private final String traceHeader;

    private final BillingDetails billingDetails;

    private StartSyncExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionArn = builder.executionArn;
        this.stateMachineArn = builder.stateMachineArn;
        this.name = builder.name;
        this.startDate = builder.startDate;
        this.stopDate = builder.stopDate;
        this.status = builder.status;
        this.error = builder.error;
        this.causeValue = builder.causeValue;
        this.input = builder.input;
        this.inputDetails = builder.inputDetails;
        this.output = builder.output;
        this.outputDetails = builder.outputDetails;
        this.traceHeader = builder.traceHeader;
        this.billingDetails = builder.billingDetails;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the execution.
     */
    public final String executionArn() {
        return executionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the state machine.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the state machine.
     */
    public final String stateMachineArn() {
        return stateMachineArn;
    }

    /**
     * <p>
     * The name of the execution.
     * </p>
     * 
     * @return The name of the execution.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The date the execution is started.
     * </p>
     * 
     * @return The date the execution is started.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * If the execution has already ended, the date the execution stopped.
     * </p>
     * 
     * @return If the execution has already ended, the date the execution stopped.
     */
    public final Instant stopDate() {
        return stopDate;
    }

    /**
     * <p>
     * The current status of the execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SyncExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the execution.
     * @see SyncExecutionStatus
     */
    public final SyncExecutionStatus status() {
        return SyncExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SyncExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the execution.
     * @see SyncExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The error code of the failure.
     * </p>
     * 
     * @return The error code of the failure.
     */
    public final String error() {
        return error;
    }

    /**
     * <p>
     * A more detailed explanation of the cause of the failure.
     * </p>
     * 
     * @return A more detailed explanation of the cause of the failure.
     */
    public final String cause() {
        return causeValue;
    }

    /**
     * <p>
     * The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and
     * are expressed as bytes in UTF-8 encoding.
     * </p>
     * 
     * @return The string that contains the JSON input data of the execution. Length constraints apply to the payload
     *         size, and are expressed as bytes in UTF-8 encoding.
     */
    public final String input() {
        return input;
    }

    /**
     * Returns the value of the InputDetails property for this object.
     * 
     * @return The value of the InputDetails property for this object.
     */
    public final CloudWatchEventsExecutionDataDetails inputDetails() {
        return inputDetails;
    }

    /**
     * <p>
     * The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes
     * in UTF-8 encoding.
     * </p>
     * <note>
     * <p>
     * This field is set only if the execution succeeds. If the execution fails, this field is null.
     * </p>
     * </note>
     * 
     * @return The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as
     *         bytes in UTF-8 encoding.</p> <note>
     *         <p>
     *         This field is set only if the execution succeeds. If the execution fails, this field is null.
     *         </p>
     */
    public final String output() {
        return output;
    }

    /**
     * Returns the value of the OutputDetails property for this object.
     * 
     * @return The value of the OutputDetails property for this object.
     */
    public final CloudWatchEventsExecutionDataDetails outputDetails() {
        return outputDetails;
    }

    /**
     * <p>
     * The AWS X-Ray trace header that was passed to the execution.
     * </p>
     * 
     * @return The AWS X-Ray trace header that was passed to the execution.
     */
    public final String traceHeader() {
        return traceHeader;
    }

    /**
     * <p>
     * An object that describes workflow billing details, including billed duration and memory use.
     * </p>
     * 
     * @return An object that describes workflow billing details, including billed duration and memory use.
     */
    public final BillingDetails billingDetails() {
        return billingDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(stopDate());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(cause());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(inputDetails());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(outputDetails());
        hashCode = 31 * hashCode + Objects.hashCode(traceHeader());
        hashCode = 31 * hashCode + Objects.hashCode(billingDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSyncExecutionResponse)) {
            return false;
        }
        StartSyncExecutionResponse other = (StartSyncExecutionResponse) obj;
        return Objects.equals(executionArn(), other.executionArn()) && Objects.equals(stateMachineArn(), other.stateMachineArn())
                && Objects.equals(name(), other.name()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(stopDate(), other.stopDate()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(error(), other.error()) && Objects.equals(cause(), other.cause())
                && Objects.equals(input(), other.input()) && Objects.equals(inputDetails(), other.inputDetails())
                && Objects.equals(output(), other.output()) && Objects.equals(outputDetails(), other.outputDetails())
                && Objects.equals(traceHeader(), other.traceHeader()) && Objects.equals(billingDetails(), other.billingDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSyncExecutionResponse").add("ExecutionArn", executionArn())
                .add("StateMachineArn", stateMachineArn()).add("Name", name()).add("StartDate", startDate())
                .add("StopDate", stopDate()).add("Status", statusAsString())
                .add("Error", error() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Cause", cause() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Input", input() == null ? null : "*** Sensitive Data Redacted ***").add("InputDetails", inputDetails())
                .add("Output", output() == null ? null : "*** Sensitive Data Redacted ***").add("OutputDetails", outputDetails())
                .add("TraceHeader", traceHeader()).add("BillingDetails", billingDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionArn":
            return Optional.ofNullable(clazz.cast(executionArn()));
        case "stateMachineArn":
            return Optional.ofNullable(clazz.cast(stateMachineArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "startDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "stopDate":
            return Optional.ofNullable(clazz.cast(stopDate()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "cause":
            return Optional.ofNullable(clazz.cast(cause()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "inputDetails":
            return Optional.ofNullable(clazz.cast(inputDetails()));
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        case "outputDetails":
            return Optional.ofNullable(clazz.cast(outputDetails()));
        case "traceHeader":
            return Optional.ofNullable(clazz.cast(traceHeader()));
        case "billingDetails":
            return Optional.ofNullable(clazz.cast(billingDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSyncExecutionResponse, T> g) {
        return obj -> g.apply((StartSyncExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartSyncExecutionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the execution.
         * </p>
         * 
         * @param executionArn
         *        The Amazon Resource Name (ARN) that identifies the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionArn(String executionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the state machine.
         * </p>
         * 
         * @param stateMachineArn
         *        The Amazon Resource Name (ARN) that identifies the state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineArn(String stateMachineArn);

        /**
         * <p>
         * The name of the execution.
         * </p>
         * 
         * @param name
         *        The name of the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The date the execution is started.
         * </p>
         * 
         * @param startDate
         *        The date the execution is started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * If the execution has already ended, the date the execution stopped.
         * </p>
         * 
         * @param stopDate
         *        If the execution has already ended, the date the execution stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopDate(Instant stopDate);

        /**
         * <p>
         * The current status of the execution.
         * </p>
         * 
         * @param status
         *        The current status of the execution.
         * @see SyncExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the execution.
         * </p>
         * 
         * @param status
         *        The current status of the execution.
         * @see SyncExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncExecutionStatus
         */
        Builder status(SyncExecutionStatus status);

        /**
         * <p>
         * The error code of the failure.
         * </p>
         * 
         * @param error
         *        The error code of the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * A more detailed explanation of the cause of the failure.
         * </p>
         * 
         * @param causeValue
         *        A more detailed explanation of the cause of the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cause(String causeValue);

        /**
         * <p>
         * The string that contains the JSON input data of the execution. Length constraints apply to the payload size,
         * and are expressed as bytes in UTF-8 encoding.
         * </p>
         * 
         * @param input
         *        The string that contains the JSON input data of the execution. Length constraints apply to the payload
         *        size, and are expressed as bytes in UTF-8 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * Sets the value of the InputDetails property for this object.
         *
         * @param inputDetails
         *        The new value for the InputDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDetails(CloudWatchEventsExecutionDataDetails inputDetails);

        /**
         * Sets the value of the InputDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link CloudWatchEventsExecutionDataDetails.Builder}
         * avoiding the need to create one manually via {@link CloudWatchEventsExecutionDataDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchEventsExecutionDataDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #inputDetails(CloudWatchEventsExecutionDataDetails)}.
         * 
         * @param inputDetails
         *        a consumer that will call methods on {@link CloudWatchEventsExecutionDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDetails(CloudWatchEventsExecutionDataDetails)
         */
        default Builder inputDetails(Consumer<CloudWatchEventsExecutionDataDetails.Builder> inputDetails) {
            return inputDetails(CloudWatchEventsExecutionDataDetails.builder().applyMutation(inputDetails).build());
        }

        /**
         * <p>
         * The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as
         * bytes in UTF-8 encoding.
         * </p>
         * <note>
         * <p>
         * This field is set only if the execution succeeds. If the execution fails, this field is null.
         * </p>
         * </note>
         * 
         * @param output
         *        The JSON output data of the execution. Length constraints apply to the payload size, and are expressed
         *        as bytes in UTF-8 encoding.</p> <note>
         *        <p>
         *        This field is set only if the execution succeeds. If the execution fails, this field is null.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(String output);

        /**
         * Sets the value of the OutputDetails property for this object.
         *
         * @param outputDetails
         *        The new value for the OutputDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDetails(CloudWatchEventsExecutionDataDetails outputDetails);

        /**
         * Sets the value of the OutputDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link CloudWatchEventsExecutionDataDetails.Builder}
         * avoiding the need to create one manually via {@link CloudWatchEventsExecutionDataDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchEventsExecutionDataDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #outputDetails(CloudWatchEventsExecutionDataDetails)}.
         * 
         * @param outputDetails
         *        a consumer that will call methods on {@link CloudWatchEventsExecutionDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDetails(CloudWatchEventsExecutionDataDetails)
         */
        default Builder outputDetails(Consumer<CloudWatchEventsExecutionDataDetails.Builder> outputDetails) {
            return outputDetails(CloudWatchEventsExecutionDataDetails.builder().applyMutation(outputDetails).build());
        }

        /**
         * <p>
         * The AWS X-Ray trace header that was passed to the execution.
         * </p>
         * 
         * @param traceHeader
         *        The AWS X-Ray trace header that was passed to the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceHeader(String traceHeader);

        /**
         * <p>
         * An object that describes workflow billing details, including billed duration and memory use.
         * </p>
         * 
         * @param billingDetails
         *        An object that describes workflow billing details, including billed duration and memory use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingDetails(BillingDetails billingDetails);

        /**
         * <p>
         * An object that describes workflow billing details, including billed duration and memory use.
         * </p>
         * This is a convenience that creates an instance of the {@link BillingDetails.Builder} avoiding the need to
         * create one manually via {@link BillingDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link BillingDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #billingDetails(BillingDetails)}.
         * 
         * @param billingDetails
         *        a consumer that will call methods on {@link BillingDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingDetails(BillingDetails)
         */
        default Builder billingDetails(Consumer<BillingDetails.Builder> billingDetails) {
            return billingDetails(BillingDetails.builder().applyMutation(billingDetails).build());
        }
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private String executionArn;

        private String stateMachineArn;

        private String name;

        private Instant startDate;

        private Instant stopDate;

        private String status;

        private String error;

        private String causeValue;

        private String input;

        private CloudWatchEventsExecutionDataDetails inputDetails;

        private String output;

        private CloudWatchEventsExecutionDataDetails outputDetails;

        private String traceHeader;

        private BillingDetails billingDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSyncExecutionResponse model) {
            super(model);
            executionArn(model.executionArn);
            stateMachineArn(model.stateMachineArn);
            name(model.name);
            startDate(model.startDate);
            stopDate(model.stopDate);
            status(model.status);
            error(model.error);
            cause(model.causeValue);
            input(model.input);
            inputDetails(model.inputDetails);
            output(model.output);
            outputDetails(model.outputDetails);
            traceHeader(model.traceHeader);
            billingDetails(model.billingDetails);
        }

        public final String getExecutionArn() {
            return executionArn;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        @Override
        @Transient
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final String getStateMachineArn() {
            return stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        @Transient
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        @Transient
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getStopDate() {
            return stopDate;
        }

        public final void setStopDate(Instant stopDate) {
            this.stopDate = stopDate;
        }

        @Override
        @Transient
        public final Builder stopDate(Instant stopDate) {
            this.stopDate = stopDate;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(SyncExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        @Transient
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getCause() {
            return causeValue;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        @Override
        @Transient
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        @Transient
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final CloudWatchEventsExecutionDataDetails.Builder getInputDetails() {
            return inputDetails != null ? inputDetails.toBuilder() : null;
        }

        public final void setInputDetails(CloudWatchEventsExecutionDataDetails.BuilderImpl inputDetails) {
            this.inputDetails = inputDetails != null ? inputDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder inputDetails(CloudWatchEventsExecutionDataDetails inputDetails) {
            this.inputDetails = inputDetails;
            return this;
        }

        public final String getOutput() {
            return output;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        @Override
        @Transient
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        public final CloudWatchEventsExecutionDataDetails.Builder getOutputDetails() {
            return outputDetails != null ? outputDetails.toBuilder() : null;
        }

        public final void setOutputDetails(CloudWatchEventsExecutionDataDetails.BuilderImpl outputDetails) {
            this.outputDetails = outputDetails != null ? outputDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder outputDetails(CloudWatchEventsExecutionDataDetails outputDetails) {
            this.outputDetails = outputDetails;
            return this;
        }

        public final String getTraceHeader() {
            return traceHeader;
        }

        public final void setTraceHeader(String traceHeader) {
            this.traceHeader = traceHeader;
        }

        @Override
        @Transient
        public final Builder traceHeader(String traceHeader) {
            this.traceHeader = traceHeader;
            return this;
        }

        public final BillingDetails.Builder getBillingDetails() {
            return billingDetails != null ? billingDetails.toBuilder() : null;
        }

        public final void setBillingDetails(BillingDetails.BuilderImpl billingDetails) {
            this.billingDetails = billingDetails != null ? billingDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder billingDetails(BillingDetails billingDetails) {
            this.billingDetails = billingDetails;
            return this;
        }

        @Override
        public StartSyncExecutionResponse build() {
            return new StartSyncExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
