/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.SfnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartExecutionRequest
extends SfnRequest
implements ToCopyableBuilder<Builder, StartExecutionRequest> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateMachineArn").getter(StartExecutionRequest.getter(StartExecutionRequest::stateMachineArn)).setter(StartExecutionRequest.setter(Builder::stateMachineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StartExecutionRequest.getter(StartExecutionRequest::name)).setter(StartExecutionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("input").getter(StartExecutionRequest.getter(StartExecutionRequest::input)).setter(StartExecutionRequest.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<String> TRACE_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceHeader").getter(StartExecutionRequest.getter(StartExecutionRequest::traceHeader)).setter(StartExecutionRequest.setter(Builder::traceHeader)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceHeader").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD, NAME_FIELD, INPUT_FIELD, TRACE_HEADER_FIELD));
    private final String stateMachineArn;
    private final String name;
    private final String input;
    private final String traceHeader;

    private StartExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.stateMachineArn = builder.stateMachineArn;
        this.name = builder.name;
        this.input = builder.input;
        this.traceHeader = builder.traceHeader;
    }

    public final String stateMachineArn() {
        return this.stateMachineArn;
    }

    public final String name() {
        return this.name;
    }

    public final String input() {
        return this.input;
    }

    public final String traceHeader() {
        return this.traceHeader;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceHeader());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExecutionRequest)) {
            return false;
        }
        StartExecutionRequest other = (StartExecutionRequest)((Object)obj);
        return Objects.equals(this.stateMachineArn(), other.stateMachineArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.traceHeader(), other.traceHeader());
    }

    public final String toString() {
        return ToString.builder((String)"StartExecutionRequest").add("StateMachineArn", (Object)this.stateMachineArn()).add("Name", (Object)this.name()).add("Input", (Object)(this.input() == null ? null : "*** Sensitive Data Redacted ***")).add("TraceHeader", (Object)this.traceHeader()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateMachineArn": {
                return Optional.ofNullable(clazz.cast(this.stateMachineArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "traceHeader": {
                return Optional.ofNullable(clazz.cast(this.traceHeader()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartExecutionRequest, T> g) {
        return obj -> g.apply((StartExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnRequest.BuilderImpl
    implements Builder {
        private String stateMachineArn;
        private String name;
        private String input;
        private String traceHeader;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExecutionRequest model) {
            super(model);
            this.stateMachineArn(model.stateMachineArn);
            this.name(model.name);
            this.input(model.input);
            this.traceHeader(model.traceHeader);
        }

        public final String getStateMachineArn() {
            return this.stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        @Transient
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getInput() {
            return this.input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        @Transient
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final String getTraceHeader() {
            return this.traceHeader;
        }

        public final void setTraceHeader(String traceHeader) {
            this.traceHeader = traceHeader;
        }

        @Override
        @Transient
        public final Builder traceHeader(String traceHeader) {
            this.traceHeader = traceHeader;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartExecutionRequest build() {
            return new StartExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SfnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartExecutionRequest> {
        public Builder stateMachineArn(String var1);

        public Builder name(String var1);

        public Builder input(String var1);

        public Builder traceHeader(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

