/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartExecutionResponse extends SfnResponse implements
        ToCopyableBuilder<StartExecutionResponse.Builder, StartExecutionResponse> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionArn").getter(getter(StartExecutionResponse::executionArn))
            .setter(setter(Builder::executionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDate").getter(getter(StartExecutionResponse::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD,
            START_DATE_FIELD));

    private final String executionArn;

    private final Instant startDate;

    private StartExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionArn = builder.executionArn;
        this.startDate = builder.startDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the execution.
     */
    public final String executionArn() {
        return executionArn;
    }

    /**
     * <p>
     * The date the execution is started.
     * </p>
     * 
     * @return The date the execution is started.
     */
    public final Instant startDate() {
        return startDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExecutionResponse)) {
            return false;
        }
        StartExecutionResponse other = (StartExecutionResponse) obj;
        return Objects.equals(executionArn(), other.executionArn()) && Objects.equals(startDate(), other.startDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartExecutionResponse").add("ExecutionArn", executionArn()).add("StartDate", startDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionArn":
            return Optional.ofNullable(clazz.cast(executionArn()));
        case "startDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartExecutionResponse, T> g) {
        return obj -> g.apply((StartExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartExecutionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the execution.
         * </p>
         * 
         * @param executionArn
         *        The Amazon Resource Name (ARN) that identifies the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionArn(String executionArn);

        /**
         * <p>
         * The date the execution is started.
         * </p>
         * 
         * @param startDate
         *        The date the execution is started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private String executionArn;

        private Instant startDate;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExecutionResponse model) {
            super(model);
            executionArn(model.executionArn);
            startDate(model.startDate);
        }

        public final String getExecutionArn() {
            return executionArn;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        @Override
        @Transient
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        @Transient
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        @Override
        public StartExecutionResponse build() {
            return new StartExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
