/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStateMachineForExecutionResponse extends SfnResponse implements
        ToCopyableBuilder<DescribeStateMachineForExecutionResponse.Builder, DescribeStateMachineForExecutionResponse> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineArn").getter(getter(DescribeStateMachineForExecutionResponse::stateMachineArn))
            .setter(setter(Builder::stateMachineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DescribeStateMachineForExecutionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definition").getter(getter(DescribeStateMachineForExecutionResponse::definition))
            .setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DescribeStateMachineForExecutionResponse::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateDate").getter(getter(DescribeStateMachineForExecutionResponse::updateDate))
            .setter(setter(Builder::updateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDate").build()).build();

    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField
            .<LoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("loggingConfiguration")
            .getter(getter(DescribeStateMachineForExecutionResponse::loggingConfiguration))
            .setter(setter(Builder::loggingConfiguration)).constructor(LoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfiguration").build())
            .build();

    private static final SdkField<TracingConfiguration> TRACING_CONFIGURATION_FIELD = SdkField
            .<TracingConfiguration> builder(MarshallingType.SDK_POJO).memberName("tracingConfiguration")
            .getter(getter(DescribeStateMachineForExecutionResponse::tracingConfiguration))
            .setter(setter(Builder::tracingConfiguration)).constructor(TracingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracingConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD,
            NAME_FIELD, DEFINITION_FIELD, ROLE_ARN_FIELD, UPDATE_DATE_FIELD, LOGGING_CONFIGURATION_FIELD,
            TRACING_CONFIGURATION_FIELD));

    private final String stateMachineArn;

    private final String name;

    private final String definition;

    private final String roleArn;

    private final Instant updateDate;

    private final LoggingConfiguration loggingConfiguration;

    private final TracingConfiguration tracingConfiguration;

    private DescribeStateMachineForExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.stateMachineArn = builder.stateMachineArn;
        this.name = builder.name;
        this.definition = builder.definition;
        this.roleArn = builder.roleArn;
        this.updateDate = builder.updateDate;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.tracingConfiguration = builder.tracingConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine associated with the execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the state machine associated with the execution.
     */
    public final String stateMachineArn() {
        return stateMachineArn;
    }

    /**
     * <p>
     * The name of the state machine associated with the execution.
     * </p>
     * 
     * @return The name of the state machine associated with the execution.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon States Language definition of the state machine. See <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States
     * Language</a>.
     * </p>
     * 
     * @return The Amazon States Language definition of the state machine. See <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
     *         States Language</a>.
     */
    public final String definition() {
        return definition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The date and time the state machine associated with an execution was updated. For a newly created state machine,
     * this is the creation date.
     * </p>
     * 
     * @return The date and time the state machine associated with an execution was updated. For a newly created state
     *         machine, this is the creation date.
     */
    public final Instant updateDate() {
        return updateDate;
    }

    /**
     * Returns the value of the LoggingConfiguration property for this object.
     * 
     * @return The value of the LoggingConfiguration property for this object.
     */
    public final LoggingConfiguration loggingConfiguration() {
        return loggingConfiguration;
    }

    /**
     * <p>
     * Selects whether AWS X-Ray tracing is enabled.
     * </p>
     * 
     * @return Selects whether AWS X-Ray tracing is enabled.
     */
    public final TracingConfiguration tracingConfiguration() {
        return tracingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(updateDate());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(tracingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStateMachineForExecutionResponse)) {
            return false;
        }
        DescribeStateMachineForExecutionResponse other = (DescribeStateMachineForExecutionResponse) obj;
        return Objects.equals(stateMachineArn(), other.stateMachineArn()) && Objects.equals(name(), other.name())
                && Objects.equals(definition(), other.definition()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(updateDate(), other.updateDate())
                && Objects.equals(loggingConfiguration(), other.loggingConfiguration())
                && Objects.equals(tracingConfiguration(), other.tracingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStateMachineForExecutionResponse").add("StateMachineArn", stateMachineArn())
                .add("Name", name()).add("Definition", definition() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RoleArn", roleArn()).add("UpdateDate", updateDate()).add("LoggingConfiguration", loggingConfiguration())
                .add("TracingConfiguration", tracingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateMachineArn":
            return Optional.ofNullable(clazz.cast(stateMachineArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "updateDate":
            return Optional.ofNullable(clazz.cast(updateDate()));
        case "loggingConfiguration":
            return Optional.ofNullable(clazz.cast(loggingConfiguration()));
        case "tracingConfiguration":
            return Optional.ofNullable(clazz.cast(tracingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStateMachineForExecutionResponse, T> g) {
        return obj -> g.apply((DescribeStateMachineForExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStateMachineForExecutionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the state machine associated with the execution.
         * </p>
         * 
         * @param stateMachineArn
         *        The Amazon Resource Name (ARN) of the state machine associated with the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineArn(String stateMachineArn);

        /**
         * <p>
         * The name of the state machine associated with the execution.
         * </p>
         * 
         * @param name
         *        The name of the state machine associated with the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon States Language definition of the state machine. See <a
         * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
         * States Language</a>.
         * </p>
         * 
         * @param definition
         *        The Amazon States Language definition of the state machine. See <a
         *        href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html"
         *        >Amazon States Language</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The date and time the state machine associated with an execution was updated. For a newly created state
         * machine, this is the creation date.
         * </p>
         * 
         * @param updateDate
         *        The date and time the state machine associated with an execution was updated. For a newly created
         *        state machine, this is the creation date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDate(Instant updateDate);

        /**
         * Sets the value of the LoggingConfiguration property for this object.
         *
         * @param loggingConfiguration
         *        The new value for the LoggingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfiguration(LoggingConfiguration loggingConfiguration);

        /**
         * Sets the value of the LoggingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LoggingConfiguration.Builder} avoiding
         * the need to create one manually via {@link LoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #loggingConfiguration(LoggingConfiguration)}.
         * 
         * @param loggingConfiguration
         *        a consumer that will call methods on {@link LoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfiguration(LoggingConfiguration)
         */
        default Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return loggingConfiguration(LoggingConfiguration.builder().applyMutation(loggingConfiguration).build());
        }

        /**
         * <p>
         * Selects whether AWS X-Ray tracing is enabled.
         * </p>
         * 
         * @param tracingConfiguration
         *        Selects whether AWS X-Ray tracing is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracingConfiguration(TracingConfiguration tracingConfiguration);

        /**
         * <p>
         * Selects whether AWS X-Ray tracing is enabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link TracingConfiguration.Builder} avoiding
         * the need to create one manually via {@link TracingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TracingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #tracingConfiguration(TracingConfiguration)}.
         * 
         * @param tracingConfiguration
         *        a consumer that will call methods on {@link TracingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tracingConfiguration(TracingConfiguration)
         */
        default Builder tracingConfiguration(Consumer<TracingConfiguration.Builder> tracingConfiguration) {
            return tracingConfiguration(TracingConfiguration.builder().applyMutation(tracingConfiguration).build());
        }
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private String stateMachineArn;

        private String name;

        private String definition;

        private String roleArn;

        private Instant updateDate;

        private LoggingConfiguration loggingConfiguration;

        private TracingConfiguration tracingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStateMachineForExecutionResponse model) {
            super(model);
            stateMachineArn(model.stateMachineArn);
            name(model.name);
            definition(model.definition);
            roleArn(model.roleArn);
            updateDate(model.updateDate);
            loggingConfiguration(model.loggingConfiguration);
            tracingConfiguration(model.tracingConfiguration);
        }

        public final String getStateMachineArn() {
            return stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDefinition() {
            return definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getUpdateDate() {
            return updateDate;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return loggingConfiguration != null ? loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final TracingConfiguration.Builder getTracingConfiguration() {
            return tracingConfiguration != null ? tracingConfiguration.toBuilder() : null;
        }

        public final void setTracingConfiguration(TracingConfiguration.BuilderImpl tracingConfiguration) {
            this.tracingConfiguration = tracingConfiguration != null ? tracingConfiguration.build() : null;
        }

        @Override
        public final Builder tracingConfiguration(TracingConfiguration tracingConfiguration) {
            this.tracingConfiguration = tracingConfiguration;
            return this;
        }

        @Override
        public DescribeStateMachineForExecutionResponse build() {
            return new DescribeStateMachineForExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
