/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStateMachineResponse extends SfnResponse implements
        ToCopyableBuilder<DescribeStateMachineResponse.Builder, DescribeStateMachineResponse> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineArn").getter(getter(DescribeStateMachineResponse::stateMachineArn))
            .setter(setter(Builder::stateMachineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DescribeStateMachineResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeStateMachineResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definition").getter(getter(DescribeStateMachineResponse::definition))
            .setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DescribeStateMachineResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DescribeStateMachineResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(DescribeStateMachineResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField
            .<LoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("loggingConfiguration")
            .getter(getter(DescribeStateMachineResponse::loggingConfiguration)).setter(setter(Builder::loggingConfiguration))
            .constructor(LoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfiguration").build())
            .build();

    private static final SdkField<TracingConfiguration> TRACING_CONFIGURATION_FIELD = SdkField
            .<TracingConfiguration> builder(MarshallingType.SDK_POJO).memberName("tracingConfiguration")
            .getter(getter(DescribeStateMachineResponse::tracingConfiguration)).setter(setter(Builder::tracingConfiguration))
            .constructor(TracingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracingConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD,
            NAME_FIELD, STATUS_FIELD, DEFINITION_FIELD, ROLE_ARN_FIELD, TYPE_FIELD, CREATION_DATE_FIELD,
            LOGGING_CONFIGURATION_FIELD, TRACING_CONFIGURATION_FIELD));

    private final String stateMachineArn;

    private final String name;

    private final String status;

    private final String definition;

    private final String roleArn;

    private final String type;

    private final Instant creationDate;

    private final LoggingConfiguration loggingConfiguration;

    private final TracingConfiguration tracingConfiguration;

    private DescribeStateMachineResponse(BuilderImpl builder) {
        super(builder);
        this.stateMachineArn = builder.stateMachineArn;
        this.name = builder.name;
        this.status = builder.status;
        this.definition = builder.definition;
        this.roleArn = builder.roleArn;
        this.type = builder.type;
        this.creationDate = builder.creationDate;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.tracingConfiguration = builder.tracingConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the state machine.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the state machine.
     */
    public final String stateMachineArn() {
        return stateMachineArn;
    }

    /**
     * <p>
     * The name of the state machine.
     * </p>
     * <p>
     * A name must <i>not</i> contain:
     * </p>
     * <ul>
     * <li>
     * <p>
     * white space
     * </p>
     * </li>
     * <li>
     * <p>
     * brackets <code>&lt; &gt; { } [ ]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * wildcard characters <code>? *</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     * </p>
     * 
     * @return The name of the state machine.</p>
     *         <p>
     *         A name must <i>not</i> contain:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         white space
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         brackets <code>&lt; &gt; { } [ ]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         wildcard characters <code>? *</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the state machine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StateMachineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the state machine.
     * @see StateMachineStatus
     */
    public final StateMachineStatus status() {
        return StateMachineStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the state machine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StateMachineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the state machine.
     * @see StateMachineStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon States Language definition of the state machine. See <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States
     * Language</a>.
     * </p>
     * 
     * @return The Amazon States Language definition of the state machine. See <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
     *         States Language</a>.
     */
    public final String definition() {
        return definition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role maintains
     * security by granting Step Functions access to AWS resources.)
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role
     *         maintains security by granting Step Functions access to AWS resources.)
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The <code>type</code> of the state machine (<code>STANDARD</code> or <code>EXPRESS</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link StateMachineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The <code>type</code> of the state machine (<code>STANDARD</code> or <code>EXPRESS</code>).
     * @see StateMachineType
     */
    public final StateMachineType type() {
        return StateMachineType.fromValue(type);
    }

    /**
     * <p>
     * The <code>type</code> of the state machine (<code>STANDARD</code> or <code>EXPRESS</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link StateMachineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The <code>type</code> of the state machine (<code>STANDARD</code> or <code>EXPRESS</code>).
     * @see StateMachineType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The date the state machine is created.
     * </p>
     * 
     * @return The date the state machine is created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * Returns the value of the LoggingConfiguration property for this object.
     * 
     * @return The value of the LoggingConfiguration property for this object.
     */
    public final LoggingConfiguration loggingConfiguration() {
        return loggingConfiguration;
    }

    /**
     * <p>
     * Selects whether AWS X-Ray tracing is enabled.
     * </p>
     * 
     * @return Selects whether AWS X-Ray tracing is enabled.
     */
    public final TracingConfiguration tracingConfiguration() {
        return tracingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(tracingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStateMachineResponse)) {
            return false;
        }
        DescribeStateMachineResponse other = (DescribeStateMachineResponse) obj;
        return Objects.equals(stateMachineArn(), other.stateMachineArn()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(definition(), other.definition())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(loggingConfiguration(), other.loggingConfiguration())
                && Objects.equals(tracingConfiguration(), other.tracingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStateMachineResponse").add("StateMachineArn", stateMachineArn()).add("Name", name())
                .add("Status", statusAsString())
                .add("Definition", definition() == null ? null : "*** Sensitive Data Redacted ***").add("RoleArn", roleArn())
                .add("Type", typeAsString()).add("CreationDate", creationDate())
                .add("LoggingConfiguration", loggingConfiguration()).add("TracingConfiguration", tracingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateMachineArn":
            return Optional.ofNullable(clazz.cast(stateMachineArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "loggingConfiguration":
            return Optional.ofNullable(clazz.cast(loggingConfiguration()));
        case "tracingConfiguration":
            return Optional.ofNullable(clazz.cast(tracingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStateMachineResponse, T> g) {
        return obj -> g.apply((DescribeStateMachineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStateMachineResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the state machine.
         * </p>
         * 
         * @param stateMachineArn
         *        The Amazon Resource Name (ARN) that identifies the state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineArn(String stateMachineArn);

        /**
         * <p>
         * The name of the state machine.
         * </p>
         * <p>
         * A name must <i>not</i> contain:
         * </p>
         * <ul>
         * <li>
         * <p>
         * white space
         * </p>
         * </li>
         * <li>
         * <p>
         * brackets <code>&lt; &gt; { } [ ]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * wildcard characters <code>? *</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
         * </p>
         * </li>
         * </ul>
         * <p>
         * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         * </p>
         * 
         * @param name
         *        The name of the state machine.</p>
         *        <p>
         *        A name must <i>not</i> contain:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        white space
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        brackets <code>&lt; &gt; { } [ ]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        wildcard characters <code>? *</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the state machine.
         * </p>
         * 
         * @param status
         *        The current status of the state machine.
         * @see StateMachineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateMachineStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the state machine.
         * </p>
         * 
         * @param status
         *        The current status of the state machine.
         * @see StateMachineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateMachineStatus
         */
        Builder status(StateMachineStatus status);

        /**
         * <p>
         * The Amazon States Language definition of the state machine. See <a
         * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
         * States Language</a>.
         * </p>
         * 
         * @param definition
         *        The Amazon States Language definition of the state machine. See <a
         *        href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html"
         *        >Amazon States Language</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role maintains
         * security by granting Step Functions access to AWS resources.)
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role
         *        maintains security by granting Step Functions access to AWS resources.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The <code>type</code> of the state machine (<code>STANDARD</code> or <code>EXPRESS</code>).
         * </p>
         * 
         * @param type
         *        The <code>type</code> of the state machine (<code>STANDARD</code> or <code>EXPRESS</code>).
         * @see StateMachineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateMachineType
         */
        Builder type(String type);

        /**
         * <p>
         * The <code>type</code> of the state machine (<code>STANDARD</code> or <code>EXPRESS</code>).
         * </p>
         * 
         * @param type
         *        The <code>type</code> of the state machine (<code>STANDARD</code> or <code>EXPRESS</code>).
         * @see StateMachineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateMachineType
         */
        Builder type(StateMachineType type);

        /**
         * <p>
         * The date the state machine is created.
         * </p>
         * 
         * @param creationDate
         *        The date the state machine is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * Sets the value of the LoggingConfiguration property for this object.
         *
         * @param loggingConfiguration
         *        The new value for the LoggingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfiguration(LoggingConfiguration loggingConfiguration);

        /**
         * Sets the value of the LoggingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LoggingConfiguration.Builder} avoiding
         * the need to create one manually via {@link LoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #loggingConfiguration(LoggingConfiguration)}.
         * 
         * @param loggingConfiguration
         *        a consumer that will call methods on {@link LoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfiguration(LoggingConfiguration)
         */
        default Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return loggingConfiguration(LoggingConfiguration.builder().applyMutation(loggingConfiguration).build());
        }

        /**
         * <p>
         * Selects whether AWS X-Ray tracing is enabled.
         * </p>
         * 
         * @param tracingConfiguration
         *        Selects whether AWS X-Ray tracing is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracingConfiguration(TracingConfiguration tracingConfiguration);

        /**
         * <p>
         * Selects whether AWS X-Ray tracing is enabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link TracingConfiguration.Builder} avoiding
         * the need to create one manually via {@link TracingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TracingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #tracingConfiguration(TracingConfiguration)}.
         * 
         * @param tracingConfiguration
         *        a consumer that will call methods on {@link TracingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tracingConfiguration(TracingConfiguration)
         */
        default Builder tracingConfiguration(Consumer<TracingConfiguration.Builder> tracingConfiguration) {
            return tracingConfiguration(TracingConfiguration.builder().applyMutation(tracingConfiguration).build());
        }
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private String stateMachineArn;

        private String name;

        private String status;

        private String definition;

        private String roleArn;

        private String type;

        private Instant creationDate;

        private LoggingConfiguration loggingConfiguration;

        private TracingConfiguration tracingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStateMachineResponse model) {
            super(model);
            stateMachineArn(model.stateMachineArn);
            name(model.name);
            status(model.status);
            definition(model.definition);
            roleArn(model.roleArn);
            type(model.type);
            creationDate(model.creationDate);
            loggingConfiguration(model.loggingConfiguration);
            tracingConfiguration(model.tracingConfiguration);
        }

        public final String getStateMachineArn() {
            return stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StateMachineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDefinition() {
            return definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(StateMachineType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return loggingConfiguration != null ? loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final TracingConfiguration.Builder getTracingConfiguration() {
            return tracingConfiguration != null ? tracingConfiguration.toBuilder() : null;
        }

        public final void setTracingConfiguration(TracingConfiguration.BuilderImpl tracingConfiguration) {
            this.tracingConfiguration = tracingConfiguration != null ? tracingConfiguration.build() : null;
        }

        @Override
        public final Builder tracingConfiguration(TracingConfiguration tracingConfiguration) {
            this.tracingConfiguration = tracingConfiguration;
            return this;
        }

        @Override
        public DescribeStateMachineResponse build() {
            return new DescribeStateMachineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
