/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a task scheduled during an execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskScheduledEventDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskScheduledEventDetails.Builder, TaskScheduledEventDetails> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(TaskScheduledEventDetails::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resource").getter(getter(TaskScheduledEventDetails::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(TaskScheduledEventDetails::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parameters").getter(getter(TaskScheduledEventDetails::parameters)).setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()).build();

    private static final SdkField<Long> TIMEOUT_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("timeoutInSeconds").getter(getter(TaskScheduledEventDetails::timeoutInSeconds))
            .setter(setter(Builder::timeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInSeconds").build()).build();

    private static final SdkField<Long> HEARTBEAT_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("heartbeatInSeconds").getter(getter(TaskScheduledEventDetails::heartbeatInSeconds))
            .setter(setter(Builder::heartbeatInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heartbeatInSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            RESOURCE_FIELD, REGION_FIELD, PARAMETERS_FIELD, TIMEOUT_IN_SECONDS_FIELD, HEARTBEAT_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final String resource;

    private final String region;

    private final String parameters;

    private final Long timeoutInSeconds;

    private final Long heartbeatInSeconds;

    private TaskScheduledEventDetails(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resource = builder.resource;
        this.region = builder.region;
        this.parameters = builder.parameters;
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.heartbeatInSeconds = builder.heartbeatInSeconds;
    }

    /**
     * <p>
     * The action of the resource called by a task state.
     * </p>
     * 
     * @return The action of the resource called by a task state.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The service name of the resource in a task state.
     * </p>
     * 
     * @return The service name of the resource in a task state.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * The region of the scheduled task
     * </p>
     * 
     * @return The region of the scheduled task
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The JSON data passed to the resource referenced in a task state. Length constraints apply to the payload size,
     * and are expressed as bytes in UTF-8 encoding.
     * </p>
     * 
     * @return The JSON data passed to the resource referenced in a task state. Length constraints apply to the payload
     *         size, and are expressed as bytes in UTF-8 encoding.
     */
    public final String parameters() {
        return parameters;
    }

    /**
     * <p>
     * The maximum allowed duration of the task.
     * </p>
     * 
     * @return The maximum allowed duration of the task.
     */
    public final Long timeoutInSeconds() {
        return timeoutInSeconds;
    }

    /**
     * <p>
     * The maximum allowed duration between two heartbeats for the task.
     * </p>
     * 
     * @return The maximum allowed duration between two heartbeats for the task.
     */
    public final Long heartbeatInSeconds() {
        return heartbeatInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(heartbeatInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskScheduledEventDetails)) {
            return false;
        }
        TaskScheduledEventDetails other = (TaskScheduledEventDetails) obj;
        return Objects.equals(resourceType(), other.resourceType()) && Objects.equals(resource(), other.resource())
                && Objects.equals(region(), other.region()) && Objects.equals(parameters(), other.parameters())
                && Objects.equals(timeoutInSeconds(), other.timeoutInSeconds())
                && Objects.equals(heartbeatInSeconds(), other.heartbeatInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskScheduledEventDetails").add("ResourceType", resourceType()).add("Resource", resource())
                .add("Region", region()).add("Parameters", parameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TimeoutInSeconds", timeoutInSeconds()).add("HeartbeatInSeconds", heartbeatInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "timeoutInSeconds":
            return Optional.ofNullable(clazz.cast(timeoutInSeconds()));
        case "heartbeatInSeconds":
            return Optional.ofNullable(clazz.cast(heartbeatInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskScheduledEventDetails, T> g) {
        return obj -> g.apply((TaskScheduledEventDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskScheduledEventDetails> {
        /**
         * <p>
         * The action of the resource called by a task state.
         * </p>
         * 
         * @param resourceType
         *        The action of the resource called by a task state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The service name of the resource in a task state.
         * </p>
         * 
         * @param resource
         *        The service name of the resource in a task state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * The region of the scheduled task
         * </p>
         * 
         * @param region
         *        The region of the scheduled task
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The JSON data passed to the resource referenced in a task state. Length constraints apply to the payload
         * size, and are expressed as bytes in UTF-8 encoding.
         * </p>
         * 
         * @param parameters
         *        The JSON data passed to the resource referenced in a task state. Length constraints apply to the
         *        payload size, and are expressed as bytes in UTF-8 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(String parameters);

        /**
         * <p>
         * The maximum allowed duration of the task.
         * </p>
         * 
         * @param timeoutInSeconds
         *        The maximum allowed duration of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInSeconds(Long timeoutInSeconds);

        /**
         * <p>
         * The maximum allowed duration between two heartbeats for the task.
         * </p>
         * 
         * @param heartbeatInSeconds
         *        The maximum allowed duration between two heartbeats for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heartbeatInSeconds(Long heartbeatInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private String resource;

        private String region;

        private String parameters;

        private Long timeoutInSeconds;

        private Long heartbeatInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskScheduledEventDetails model) {
            resourceType(model.resourceType);
            resource(model.resource);
            region(model.region);
            parameters(model.parameters);
            timeoutInSeconds(model.timeoutInSeconds);
            heartbeatInSeconds(model.heartbeatInSeconds);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        @Transient
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getParameters() {
            return parameters;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        @Override
        @Transient
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final Long getTimeoutInSeconds() {
            return timeoutInSeconds;
        }

        public final void setTimeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        @Override
        @Transient
        public final Builder timeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final Long getHeartbeatInSeconds() {
            return heartbeatInSeconds;
        }

        public final void setHeartbeatInSeconds(Long heartbeatInSeconds) {
            this.heartbeatInSeconds = heartbeatInSeconds;
        }

        @Override
        @Transient
        public final Builder heartbeatInSeconds(Long heartbeatInSeconds) {
            this.heartbeatInSeconds = heartbeatInSeconds;
            return this;
        }

        @Override
        public TaskScheduledEventDetails build() {
            return new TaskScheduledEventDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
