/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about execution input or output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchEventsExecutionDataDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchEventsExecutionDataDetails.Builder, CloudWatchEventsExecutionDataDetails> {
    private static final SdkField<Boolean> INCLUDED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("included").getter(getter(CloudWatchEventsExecutionDataDetails::included))
            .setter(setter(Builder::included))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("included").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean included;

    private CloudWatchEventsExecutionDataDetails(BuilderImpl builder) {
        this.included = builder.included;
    }

    /**
     * <p>
     * Indicates whether input or output was included in the response. Always <code>true</code> for API calls.
     * </p>
     * 
     * @return Indicates whether input or output was included in the response. Always <code>true</code> for API calls.
     */
    public final Boolean included() {
        return included;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(included());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchEventsExecutionDataDetails)) {
            return false;
        }
        CloudWatchEventsExecutionDataDetails other = (CloudWatchEventsExecutionDataDetails) obj;
        return Objects.equals(included(), other.included());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchEventsExecutionDataDetails").add("Included", included()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "included":
            return Optional.ofNullable(clazz.cast(included()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchEventsExecutionDataDetails, T> g) {
        return obj -> g.apply((CloudWatchEventsExecutionDataDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchEventsExecutionDataDetails> {
        /**
         * <p>
         * Indicates whether input or output was included in the response. Always <code>true</code> for API calls.
         * </p>
         * 
         * @param included
         *        Indicates whether input or output was included in the response. Always <code>true</code> for API
         *        calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder included(Boolean included);
    }

    static final class BuilderImpl implements Builder {
        private Boolean included;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchEventsExecutionDataDetails model) {
            included(model.included);
        }

        public final Boolean getIncluded() {
            return included;
        }

        public final void setIncluded(Boolean included) {
            this.included = included;
        }

        @Override
        @Transient
        public final Builder included(Boolean included) {
            this.included = included;
            return this;
        }

        @Override
        public CloudWatchEventsExecutionDataDetails build() {
            return new CloudWatchEventsExecutionDataDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
