/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExecutionResponse extends SfnResponse implements
        ToCopyableBuilder<DescribeExecutionResponse.Builder, DescribeExecutionResponse> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionArn").getter(getter(DescribeExecutionResponse::executionArn))
            .setter(setter(Builder::executionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()).build();

    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineArn").getter(getter(DescribeExecutionResponse::stateMachineArn))
            .setter(setter(Builder::stateMachineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DescribeExecutionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeExecutionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDate").getter(getter(DescribeExecutionResponse::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()).build();

    private static final SdkField<Instant> STOP_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("stopDate").getter(getter(DescribeExecutionResponse::stopDate)).setter(setter(Builder::stopDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopDate").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(DescribeExecutionResponse::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<CloudWatchEventsExecutionDataDetails> INPUT_DETAILS_FIELD = SdkField
            .<CloudWatchEventsExecutionDataDetails> builder(MarshallingType.SDK_POJO).memberName("inputDetails")
            .getter(getter(DescribeExecutionResponse::inputDetails)).setter(setter(Builder::inputDetails))
            .constructor(CloudWatchEventsExecutionDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDetails").build()).build();

    private static final SdkField<String> OUTPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("output")
            .getter(getter(DescribeExecutionResponse::output)).setter(setter(Builder::output))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final SdkField<CloudWatchEventsExecutionDataDetails> OUTPUT_DETAILS_FIELD = SdkField
            .<CloudWatchEventsExecutionDataDetails> builder(MarshallingType.SDK_POJO).memberName("outputDetails")
            .getter(getter(DescribeExecutionResponse::outputDetails)).setter(setter(Builder::outputDetails))
            .constructor(CloudWatchEventsExecutionDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDetails").build()).build();

    private static final SdkField<String> TRACE_HEADER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceHeader").getter(getter(DescribeExecutionResponse::traceHeader))
            .setter(setter(Builder::traceHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceHeader").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD,
            STATE_MACHINE_ARN_FIELD, NAME_FIELD, STATUS_FIELD, START_DATE_FIELD, STOP_DATE_FIELD, INPUT_FIELD,
            INPUT_DETAILS_FIELD, OUTPUT_FIELD, OUTPUT_DETAILS_FIELD, TRACE_HEADER_FIELD));

    private final String executionArn;

    private final String stateMachineArn;

    private final String name;

    private final String status;

    private final Instant startDate;

    private final Instant stopDate;

    private final String input;

    private final CloudWatchEventsExecutionDataDetails inputDetails;

    private final String output;

    private final CloudWatchEventsExecutionDataDetails outputDetails;

    private final String traceHeader;

    private DescribeExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionArn = builder.executionArn;
        this.stateMachineArn = builder.stateMachineArn;
        this.name = builder.name;
        this.status = builder.status;
        this.startDate = builder.startDate;
        this.stopDate = builder.stopDate;
        this.input = builder.input;
        this.inputDetails = builder.inputDetails;
        this.output = builder.output;
        this.outputDetails = builder.outputDetails;
        this.traceHeader = builder.traceHeader;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the execution.
     */
    public final String executionArn() {
        return executionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the executed stated machine.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the executed stated machine.
     */
    public final String stateMachineArn() {
        return stateMachineArn;
    }

    /**
     * <p>
     * The name of the execution.
     * </p>
     * <p>
     * A name must <i>not</i> contain:
     * </p>
     * <ul>
     * <li>
     * <p>
     * white space
     * </p>
     * </li>
     * <li>
     * <p>
     * brackets <code>&lt; &gt; { } [ ]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * wildcard characters <code>? *</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     * </p>
     * 
     * @return The name of the execution.</p>
     *         <p>
     *         A name must <i>not</i> contain:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         white space
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         brackets <code>&lt; &gt; { } [ ]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         wildcard characters <code>? *</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the execution.
     * @see ExecutionStatus
     */
    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the execution.
     * @see ExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date the execution is started.
     * </p>
     * 
     * @return The date the execution is started.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * If the execution has already ended, the date the execution stopped.
     * </p>
     * 
     * @return If the execution has already ended, the date the execution stopped.
     */
    public final Instant stopDate() {
        return stopDate;
    }

    /**
     * <p>
     * The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and
     * are expressed as bytes in UTF-8 encoding.
     * </p>
     * 
     * @return The string that contains the JSON input data of the execution. Length constraints apply to the payload
     *         size, and are expressed as bytes in UTF-8 encoding.
     */
    public final String input() {
        return input;
    }

    /**
     * Returns the value of the InputDetails property for this object.
     * 
     * @return The value of the InputDetails property for this object.
     */
    public final CloudWatchEventsExecutionDataDetails inputDetails() {
        return inputDetails;
    }

    /**
     * <p>
     * The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes
     * in UTF-8 encoding.
     * </p>
     * <note>
     * <p>
     * This field is set only if the execution succeeds. If the execution fails, this field is null.
     * </p>
     * </note>
     * 
     * @return The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as
     *         bytes in UTF-8 encoding.</p> <note>
     *         <p>
     *         This field is set only if the execution succeeds. If the execution fails, this field is null.
     *         </p>
     */
    public final String output() {
        return output;
    }

    /**
     * Returns the value of the OutputDetails property for this object.
     * 
     * @return The value of the OutputDetails property for this object.
     */
    public final CloudWatchEventsExecutionDataDetails outputDetails() {
        return outputDetails;
    }

    /**
     * <p>
     * The X-Ray trace header that was passed to the execution.
     * </p>
     * 
     * @return The X-Ray trace header that was passed to the execution.
     */
    public final String traceHeader() {
        return traceHeader;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(stopDate());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(inputDetails());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(outputDetails());
        hashCode = 31 * hashCode + Objects.hashCode(traceHeader());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExecutionResponse)) {
            return false;
        }
        DescribeExecutionResponse other = (DescribeExecutionResponse) obj;
        return Objects.equals(executionArn(), other.executionArn()) && Objects.equals(stateMachineArn(), other.stateMachineArn())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(startDate(), other.startDate()) && Objects.equals(stopDate(), other.stopDate())
                && Objects.equals(input(), other.input()) && Objects.equals(inputDetails(), other.inputDetails())
                && Objects.equals(output(), other.output()) && Objects.equals(outputDetails(), other.outputDetails())
                && Objects.equals(traceHeader(), other.traceHeader());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeExecutionResponse").add("ExecutionArn", executionArn())
                .add("StateMachineArn", stateMachineArn()).add("Name", name()).add("Status", statusAsString())
                .add("StartDate", startDate()).add("StopDate", stopDate())
                .add("Input", input() == null ? null : "*** Sensitive Data Redacted ***").add("InputDetails", inputDetails())
                .add("Output", output() == null ? null : "*** Sensitive Data Redacted ***").add("OutputDetails", outputDetails())
                .add("TraceHeader", traceHeader()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionArn":
            return Optional.ofNullable(clazz.cast(executionArn()));
        case "stateMachineArn":
            return Optional.ofNullable(clazz.cast(stateMachineArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "startDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "stopDate":
            return Optional.ofNullable(clazz.cast(stopDate()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "inputDetails":
            return Optional.ofNullable(clazz.cast(inputDetails()));
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        case "outputDetails":
            return Optional.ofNullable(clazz.cast(outputDetails()));
        case "traceHeader":
            return Optional.ofNullable(clazz.cast(traceHeader()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExecutionResponse, T> g) {
        return obj -> g.apply((DescribeExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeExecutionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the execution.
         * </p>
         * 
         * @param executionArn
         *        The Amazon Resource Name (ARN) that identifies the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionArn(String executionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the executed stated machine.
         * </p>
         * 
         * @param stateMachineArn
         *        The Amazon Resource Name (ARN) of the executed stated machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineArn(String stateMachineArn);

        /**
         * <p>
         * The name of the execution.
         * </p>
         * <p>
         * A name must <i>not</i> contain:
         * </p>
         * <ul>
         * <li>
         * <p>
         * white space
         * </p>
         * </li>
         * <li>
         * <p>
         * brackets <code>&lt; &gt; { } [ ]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * wildcard characters <code>? *</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
         * </p>
         * </li>
         * </ul>
         * <p>
         * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         * </p>
         * 
         * @param name
         *        The name of the execution.</p>
         *        <p>
         *        A name must <i>not</i> contain:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        white space
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        brackets <code>&lt; &gt; { } [ ]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        wildcard characters <code>? *</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the execution.
         * </p>
         * 
         * @param status
         *        The current status of the execution.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the execution.
         * </p>
         * 
         * @param status
         *        The current status of the execution.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(ExecutionStatus status);

        /**
         * <p>
         * The date the execution is started.
         * </p>
         * 
         * @param startDate
         *        The date the execution is started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * If the execution has already ended, the date the execution stopped.
         * </p>
         * 
         * @param stopDate
         *        If the execution has already ended, the date the execution stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopDate(Instant stopDate);

        /**
         * <p>
         * The string that contains the JSON input data of the execution. Length constraints apply to the payload size,
         * and are expressed as bytes in UTF-8 encoding.
         * </p>
         * 
         * @param input
         *        The string that contains the JSON input data of the execution. Length constraints apply to the payload
         *        size, and are expressed as bytes in UTF-8 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * Sets the value of the InputDetails property for this object.
         *
         * @param inputDetails
         *        The new value for the InputDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDetails(CloudWatchEventsExecutionDataDetails inputDetails);

        /**
         * Sets the value of the InputDetails property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link CloudWatchEventsExecutionDataDetails.Builder} avoiding the need to create one manually via
         * {@link CloudWatchEventsExecutionDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchEventsExecutionDataDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #inputDetails(CloudWatchEventsExecutionDataDetails)}.
         * 
         * @param inputDetails
         *        a consumer that will call methods on {@link CloudWatchEventsExecutionDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDetails(CloudWatchEventsExecutionDataDetails)
         */
        default Builder inputDetails(Consumer<CloudWatchEventsExecutionDataDetails.Builder> inputDetails) {
            return inputDetails(CloudWatchEventsExecutionDataDetails.builder().applyMutation(inputDetails).build());
        }

        /**
         * <p>
         * The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as
         * bytes in UTF-8 encoding.
         * </p>
         * <note>
         * <p>
         * This field is set only if the execution succeeds. If the execution fails, this field is null.
         * </p>
         * </note>
         * 
         * @param output
         *        The JSON output data of the execution. Length constraints apply to the payload size, and are expressed
         *        as bytes in UTF-8 encoding.</p> <note>
         *        <p>
         *        This field is set only if the execution succeeds. If the execution fails, this field is null.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(String output);

        /**
         * Sets the value of the OutputDetails property for this object.
         *
         * @param outputDetails
         *        The new value for the OutputDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDetails(CloudWatchEventsExecutionDataDetails outputDetails);

        /**
         * Sets the value of the OutputDetails property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link CloudWatchEventsExecutionDataDetails.Builder} avoiding the need to create one manually via
         * {@link CloudWatchEventsExecutionDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchEventsExecutionDataDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #outputDetails(CloudWatchEventsExecutionDataDetails)}.
         * 
         * @param outputDetails
         *        a consumer that will call methods on {@link CloudWatchEventsExecutionDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDetails(CloudWatchEventsExecutionDataDetails)
         */
        default Builder outputDetails(Consumer<CloudWatchEventsExecutionDataDetails.Builder> outputDetails) {
            return outputDetails(CloudWatchEventsExecutionDataDetails.builder().applyMutation(outputDetails).build());
        }

        /**
         * <p>
         * The X-Ray trace header that was passed to the execution.
         * </p>
         * 
         * @param traceHeader
         *        The X-Ray trace header that was passed to the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceHeader(String traceHeader);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private String executionArn;

        private String stateMachineArn;

        private String name;

        private String status;

        private Instant startDate;

        private Instant stopDate;

        private String input;

        private CloudWatchEventsExecutionDataDetails inputDetails;

        private String output;

        private CloudWatchEventsExecutionDataDetails outputDetails;

        private String traceHeader;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExecutionResponse model) {
            super(model);
            executionArn(model.executionArn);
            stateMachineArn(model.stateMachineArn);
            name(model.name);
            status(model.status);
            startDate(model.startDate);
            stopDate(model.stopDate);
            input(model.input);
            inputDetails(model.inputDetails);
            output(model.output);
            outputDetails(model.outputDetails);
            traceHeader(model.traceHeader);
        }

        public final String getExecutionArn() {
            return executionArn;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final String getStateMachineArn() {
            return stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getStopDate() {
            return stopDate;
        }

        public final void setStopDate(Instant stopDate) {
            this.stopDate = stopDate;
        }

        @Override
        public final Builder stopDate(Instant stopDate) {
            this.stopDate = stopDate;
            return this;
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final CloudWatchEventsExecutionDataDetails.Builder getInputDetails() {
            return inputDetails != null ? inputDetails.toBuilder() : null;
        }

        public final void setInputDetails(CloudWatchEventsExecutionDataDetails.BuilderImpl inputDetails) {
            this.inputDetails = inputDetails != null ? inputDetails.build() : null;
        }

        @Override
        public final Builder inputDetails(CloudWatchEventsExecutionDataDetails inputDetails) {
            this.inputDetails = inputDetails;
            return this;
        }

        public final String getOutput() {
            return output;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        public final CloudWatchEventsExecutionDataDetails.Builder getOutputDetails() {
            return outputDetails != null ? outputDetails.toBuilder() : null;
        }

        public final void setOutputDetails(CloudWatchEventsExecutionDataDetails.BuilderImpl outputDetails) {
            this.outputDetails = outputDetails != null ? outputDetails.build() : null;
        }

        @Override
        public final Builder outputDetails(CloudWatchEventsExecutionDataDetails outputDetails) {
            this.outputDetails = outputDetails;
            return this;
        }

        public final String getTraceHeader() {
            return traceHeader;
        }

        public final void setTraceHeader(String traceHeader) {
            this.traceHeader = traceHeader;
        }

        @Override
        public final Builder traceHeader(String traceHeader) {
            this.traceHeader = traceHeader;
            return this;
        }

        @Override
        public DescribeExecutionResponse build() {
            return new DescribeExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
