/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStateMachineAliasesResponse extends SfnResponse implements
        ToCopyableBuilder<ListStateMachineAliasesResponse.Builder, ListStateMachineAliasesResponse> {
    private static final SdkField<List<StateMachineAliasListItem>> STATE_MACHINE_ALIASES_FIELD = SdkField
            .<List<StateMachineAliasListItem>> builder(MarshallingType.LIST)
            .memberName("stateMachineAliases")
            .getter(getter(ListStateMachineAliasesResponse::stateMachineAliases))
            .setter(setter(Builder::stateMachineAliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineAliases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StateMachineAliasListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(StateMachineAliasListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListStateMachineAliasesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ALIASES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<StateMachineAliasListItem> stateMachineAliases;

    private final String nextToken;

    private ListStateMachineAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.stateMachineAliases = builder.stateMachineAliases;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StateMachineAliases property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStateMachineAliases() {
        return stateMachineAliases != null && !(stateMachineAliases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Aliases for the state machine.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStateMachineAliases} method.
     * </p>
     * 
     * @return Aliases for the state machine.
     */
    public final List<StateMachineAliasListItem> stateMachineAliases() {
        return stateMachineAliases;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * 
     * @return If <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after
     *         24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStateMachineAliases() ? stateMachineAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStateMachineAliasesResponse)) {
            return false;
        }
        ListStateMachineAliasesResponse other = (ListStateMachineAliasesResponse) obj;
        return hasStateMachineAliases() == other.hasStateMachineAliases()
                && Objects.equals(stateMachineAliases(), other.stateMachineAliases())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStateMachineAliasesResponse")
                .add("StateMachineAliases", hasStateMachineAliases() ? stateMachineAliases() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateMachineAliases":
            return Optional.ofNullable(clazz.cast(stateMachineAliases()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStateMachineAliasesResponse, T> g) {
        return obj -> g.apply((ListStateMachineAliasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStateMachineAliasesResponse> {
        /**
         * <p>
         * Aliases for the state machine.
         * </p>
         * 
         * @param stateMachineAliases
         *        Aliases for the state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineAliases(Collection<StateMachineAliasListItem> stateMachineAliases);

        /**
         * <p>
         * Aliases for the state machine.
         * </p>
         * 
         * @param stateMachineAliases
         *        Aliases for the state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineAliases(StateMachineAliasListItem... stateMachineAliases);

        /**
         * <p>
         * Aliases for the state machine.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sfn.model.StateMachineAliasListItem.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sfn.model.StateMachineAliasListItem#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sfn.model.StateMachineAliasListItem.Builder#build()} is called
         * immediately and its result is passed to {@link #stateMachineAliases(List<StateMachineAliasListItem>)}.
         * 
         * @param stateMachineAliases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sfn.model.StateMachineAliasListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateMachineAliases(java.util.Collection<StateMachineAliasListItem>)
         */
        Builder stateMachineAliases(Consumer<StateMachineAliasListItem.Builder>... stateMachineAliases);

        /**
         * <p>
         * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired
         * pagination token will return an <i>HTTP 400 InvalidToken</i> error.
         * </p>
         * 
         * @param nextToken
         *        If <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
         *        expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private List<StateMachineAliasListItem> stateMachineAliases = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStateMachineAliasesResponse model) {
            super(model);
            stateMachineAliases(model.stateMachineAliases);
            nextToken(model.nextToken);
        }

        public final List<StateMachineAliasListItem.Builder> getStateMachineAliases() {
            List<StateMachineAliasListItem.Builder> result = StateMachineAliasListCopier.copyToBuilder(this.stateMachineAliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStateMachineAliases(Collection<StateMachineAliasListItem.BuilderImpl> stateMachineAliases) {
            this.stateMachineAliases = StateMachineAliasListCopier.copyFromBuilder(stateMachineAliases);
        }

        @Override
        public final Builder stateMachineAliases(Collection<StateMachineAliasListItem> stateMachineAliases) {
            this.stateMachineAliases = StateMachineAliasListCopier.copy(stateMachineAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateMachineAliases(StateMachineAliasListItem... stateMachineAliases) {
            stateMachineAliases(Arrays.asList(stateMachineAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateMachineAliases(Consumer<StateMachineAliasListItem.Builder>... stateMachineAliases) {
            stateMachineAliases(Stream.of(stateMachineAliases)
                    .map(c -> StateMachineAliasListItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStateMachineAliasesResponse build() {
            return new ListStateMachineAliasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
