/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMapRunsResponse extends SfnResponse implements
        ToCopyableBuilder<ListMapRunsResponse.Builder, ListMapRunsResponse> {
    private static final SdkField<List<MapRunListItem>> MAP_RUNS_FIELD = SdkField
            .<List<MapRunListItem>> builder(MarshallingType.LIST)
            .memberName("mapRuns")
            .getter(getter(ListMapRunsResponse::mapRuns))
            .setter(setter(Builder::mapRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapRuns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MapRunListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(MapRunListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListMapRunsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_RUNS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MapRunListItem> mapRuns;

    private final String nextToken;

    private ListMapRunsResponse(BuilderImpl builder) {
        super(builder);
        this.mapRuns = builder.mapRuns;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MapRuns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMapRuns() {
        return mapRuns != null && !(mapRuns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that lists information related to a Map Run, such as the Amazon Resource Name (ARN) of the Map Run and
     * the ARN of the state machine that started the Map Run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMapRuns} method.
     * </p>
     * 
     * @return An array that lists information related to a Map Run, such as the Amazon Resource Name (ARN) of the Map
     *         Run and the ARN of the state machine that started the Map Run.
     */
    public final List<MapRunListItem> mapRuns() {
        return mapRuns;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * 
     * @return If <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after
     *         24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMapRuns() ? mapRuns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMapRunsResponse)) {
            return false;
        }
        ListMapRunsResponse other = (ListMapRunsResponse) obj;
        return hasMapRuns() == other.hasMapRuns() && Objects.equals(mapRuns(), other.mapRuns())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMapRunsResponse").add("MapRuns", hasMapRuns() ? mapRuns() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mapRuns":
            return Optional.ofNullable(clazz.cast(mapRuns()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMapRunsResponse, T> g) {
        return obj -> g.apply((ListMapRunsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMapRunsResponse> {
        /**
         * <p>
         * An array that lists information related to a Map Run, such as the Amazon Resource Name (ARN) of the Map Run
         * and the ARN of the state machine that started the Map Run.
         * </p>
         * 
         * @param mapRuns
         *        An array that lists information related to a Map Run, such as the Amazon Resource Name (ARN) of the
         *        Map Run and the ARN of the state machine that started the Map Run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapRuns(Collection<MapRunListItem> mapRuns);

        /**
         * <p>
         * An array that lists information related to a Map Run, such as the Amazon Resource Name (ARN) of the Map Run
         * and the ARN of the state machine that started the Map Run.
         * </p>
         * 
         * @param mapRuns
         *        An array that lists information related to a Map Run, such as the Amazon Resource Name (ARN) of the
         *        Map Run and the ARN of the state machine that started the Map Run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapRuns(MapRunListItem... mapRuns);

        /**
         * <p>
         * An array that lists information related to a Map Run, such as the Amazon Resource Name (ARN) of the Map Run
         * and the ARN of the state machine that started the Map Run.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sfn.model.MapRunListItem.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sfn.model.MapRunListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sfn.model.MapRunListItem.Builder#build()} is called immediately and
         * its result is passed to {@link #mapRuns(List<MapRunListItem>)}.
         * 
         * @param mapRuns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sfn.model.MapRunListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapRuns(java.util.Collection<MapRunListItem>)
         */
        Builder mapRuns(Consumer<MapRunListItem.Builder>... mapRuns);

        /**
         * <p>
         * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired
         * pagination token will return an <i>HTTP 400 InvalidToken</i> error.
         * </p>
         * 
         * @param nextToken
         *        If <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
         *        expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private List<MapRunListItem> mapRuns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMapRunsResponse model) {
            super(model);
            mapRuns(model.mapRuns);
            nextToken(model.nextToken);
        }

        public final List<MapRunListItem.Builder> getMapRuns() {
            List<MapRunListItem.Builder> result = MapRunListCopier.copyToBuilder(this.mapRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMapRuns(Collection<MapRunListItem.BuilderImpl> mapRuns) {
            this.mapRuns = MapRunListCopier.copyFromBuilder(mapRuns);
        }

        @Override
        public final Builder mapRuns(Collection<MapRunListItem> mapRuns) {
            this.mapRuns = MapRunListCopier.copy(mapRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapRuns(MapRunListItem... mapRuns) {
            mapRuns(Arrays.asList(mapRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapRuns(Consumer<MapRunListItem.Builder>... mapRuns) {
            mapRuns(Stream.of(mapRuns).map(c -> MapRunListItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMapRunsResponse build() {
            return new ListMapRunsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
