/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.sfn.model.ActivityDoesNotExistException;
import software.amazon.awssdk.services.sfn.model.ActivityLimitExceededException;
import software.amazon.awssdk.services.sfn.model.ActivityWorkerLimitExceededException;
import software.amazon.awssdk.services.sfn.model.ConflictException;
import software.amazon.awssdk.services.sfn.model.CreateActivityRequest;
import software.amazon.awssdk.services.sfn.model.CreateActivityResponse;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasRequest;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasResponse;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.DeleteActivityRequest;
import software.amazon.awssdk.services.sfn.model.DeleteActivityResponse;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineAliasRequest;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineAliasResponse;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineVersionRequest;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineVersionResponse;
import software.amazon.awssdk.services.sfn.model.DescribeActivityRequest;
import software.amazon.awssdk.services.sfn.model.DescribeActivityResponse;
import software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest;
import software.amazon.awssdk.services.sfn.model.DescribeExecutionResponse;
import software.amazon.awssdk.services.sfn.model.DescribeMapRunRequest;
import software.amazon.awssdk.services.sfn.model.DescribeMapRunResponse;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasRequest;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasResponse;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionRequest;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionResponse;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.ExecutionAlreadyExistsException;
import software.amazon.awssdk.services.sfn.model.ExecutionDoesNotExistException;
import software.amazon.awssdk.services.sfn.model.ExecutionLimitExceededException;
import software.amazon.awssdk.services.sfn.model.ExecutionNotRedrivableException;
import software.amazon.awssdk.services.sfn.model.GetActivityTaskRequest;
import software.amazon.awssdk.services.sfn.model.GetActivityTaskResponse;
import software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest;
import software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse;
import software.amazon.awssdk.services.sfn.model.InvalidArnException;
import software.amazon.awssdk.services.sfn.model.InvalidDefinitionException;
import software.amazon.awssdk.services.sfn.model.InvalidExecutionInputException;
import software.amazon.awssdk.services.sfn.model.InvalidLoggingConfigurationException;
import software.amazon.awssdk.services.sfn.model.InvalidNameException;
import software.amazon.awssdk.services.sfn.model.InvalidOutputException;
import software.amazon.awssdk.services.sfn.model.InvalidTokenException;
import software.amazon.awssdk.services.sfn.model.InvalidTracingConfigurationException;
import software.amazon.awssdk.services.sfn.model.ListActivitiesRequest;
import software.amazon.awssdk.services.sfn.model.ListActivitiesResponse;
import software.amazon.awssdk.services.sfn.model.ListExecutionsRequest;
import software.amazon.awssdk.services.sfn.model.ListExecutionsResponse;
import software.amazon.awssdk.services.sfn.model.ListMapRunsRequest;
import software.amazon.awssdk.services.sfn.model.ListMapRunsResponse;
import software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesResponse;
import software.amazon.awssdk.services.sfn.model.ListStateMachineVersionsRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachineVersionsResponse;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse;
import software.amazon.awssdk.services.sfn.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sfn.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sfn.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionRequest;
import software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionResponse;
import software.amazon.awssdk.services.sfn.model.RedriveExecutionRequest;
import software.amazon.awssdk.services.sfn.model.RedriveExecutionResponse;
import software.amazon.awssdk.services.sfn.model.ResourceNotFoundException;
import software.amazon.awssdk.services.sfn.model.SendTaskFailureRequest;
import software.amazon.awssdk.services.sfn.model.SendTaskFailureResponse;
import software.amazon.awssdk.services.sfn.model.SendTaskHeartbeatRequest;
import software.amazon.awssdk.services.sfn.model.SendTaskHeartbeatResponse;
import software.amazon.awssdk.services.sfn.model.SendTaskSuccessRequest;
import software.amazon.awssdk.services.sfn.model.SendTaskSuccessResponse;
import software.amazon.awssdk.services.sfn.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.sfn.model.SfnException;
import software.amazon.awssdk.services.sfn.model.StartExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StartExecutionResponse;
import software.amazon.awssdk.services.sfn.model.StartSyncExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StartSyncExecutionResponse;
import software.amazon.awssdk.services.sfn.model.StateMachineAlreadyExistsException;
import software.amazon.awssdk.services.sfn.model.StateMachineDeletingException;
import software.amazon.awssdk.services.sfn.model.StateMachineDoesNotExistException;
import software.amazon.awssdk.services.sfn.model.StateMachineLimitExceededException;
import software.amazon.awssdk.services.sfn.model.StateMachineTypeNotSupportedException;
import software.amazon.awssdk.services.sfn.model.StopExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StopExecutionResponse;
import software.amazon.awssdk.services.sfn.model.TagResourceRequest;
import software.amazon.awssdk.services.sfn.model.TagResourceResponse;
import software.amazon.awssdk.services.sfn.model.TaskDoesNotExistException;
import software.amazon.awssdk.services.sfn.model.TaskTimedOutException;
import software.amazon.awssdk.services.sfn.model.TestStateRequest;
import software.amazon.awssdk.services.sfn.model.TestStateResponse;
import software.amazon.awssdk.services.sfn.model.TooManyTagsException;
import software.amazon.awssdk.services.sfn.model.UntagResourceRequest;
import software.amazon.awssdk.services.sfn.model.UntagResourceResponse;
import software.amazon.awssdk.services.sfn.model.UpdateMapRunRequest;
import software.amazon.awssdk.services.sfn.model.UpdateMapRunResponse;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasRequest;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasResponse;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionRequest;
import software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionResponse;
import software.amazon.awssdk.services.sfn.model.ValidationException;
import software.amazon.awssdk.services.sfn.paginators.GetExecutionHistoryIterable;
import software.amazon.awssdk.services.sfn.paginators.ListActivitiesIterable;
import software.amazon.awssdk.services.sfn.paginators.ListExecutionsIterable;
import software.amazon.awssdk.services.sfn.paginators.ListMapRunsIterable;
import software.amazon.awssdk.services.sfn.paginators.ListStateMachinesIterable;

/**
 * Service client for accessing AWS SFN. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Step Functions</fullname>
 * <p>
 * Step Functions is a service that lets you coordinate the components of distributed applications and microservices
 * using visual workflows.
 * </p>
 * <p>
 * You can use Step Functions to build applications from individual components, each of which performs a discrete
 * function, or <i>task</i>, allowing you to scale and change applications quickly. Step Functions provides a console
 * that helps visualize the components of your application as a series of steps. Step Functions automatically triggers
 * and tracks each step, and retries steps when there are errors, so your application executes predictably and in the
 * right order every time. Step Functions logs the state of each step, so you can quickly diagnose and debug any issues.
 * </p>
 * <p>
 * Step Functions manages operations and underlying infrastructure to ensure your application is available at any scale.
 * You can run tasks on Amazon Web Services, your own servers, or any system that has access to Amazon Web Services. You
 * can access and use Step Functions using the console, the Amazon Web Services SDKs, or an HTTP API. For more
 * information about Step Functions, see the <i> <a
 * href="https://docs.aws.amazon.com/step-functions/latest/dg/welcome.html">Step Functions Developer Guide</a> </i>.
 * </p>
 * <important>
 * <p>
 * If you use the Step Functions API actions using Amazon Web Services SDK integrations, make sure the API actions are
 * in camel case and parameter names are in Pascal case. For example, you could use Step Functions API action
 * <code>startSyncExecution</code> and specify its parameter as <code>StateMachineArn</code>.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SfnClient extends AwsClient {
    String SERVICE_NAME = "states";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "states";

    /**
     * <p>
     * Creates an activity. An activity is a task that you write in any programming language and host on any machine
     * that has access to Step Functions. Activities must poll Step Functions using the <code>GetActivityTask</code> API
     * action and respond using <code>SendTask*</code> API actions. This function lets Step Functions know the existence
     * of your activity and returns an identifier for use in a state machine and when polling from the activity.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note> <note>
     * <p>
     * <code>CreateActivity</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if it was
     * already created. <code>CreateActivity</code>'s idempotency check is based on the activity <code>name</code>. If a
     * following request has different <code>tags</code> values, Step Functions will ignore these differences and treat
     * it as an idempotent request of the previous. In this case, <code>tags</code> will not be updated, even if they
     * are different.
     * </p>
     * </note>
     *
     * @param createActivityRequest
     * @return Result of the CreateActivity operation returned by the service.
     * @throws ActivityLimitExceededException
     *         The maximum number of activities has been reached. Existing activities must be deleted before a new
     *         activity can be created.
     * @throws InvalidNameException
     *         The provided name is not valid.
     * @throws TooManyTagsException
     *         You've exceeded the number of tags allowed for a resource. See the <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the Step
     *         Functions Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.CreateActivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateActivity" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateActivityResponse createActivity(CreateActivityRequest createActivityRequest)
            throws ActivityLimitExceededException, InvalidNameException, TooManyTagsException, AwsServiceException,
            SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an activity. An activity is a task that you write in any programming language and host on any machine
     * that has access to Step Functions. Activities must poll Step Functions using the <code>GetActivityTask</code> API
     * action and respond using <code>SendTask*</code> API actions. This function lets Step Functions know the existence
     * of your activity and returns an identifier for use in a state machine and when polling from the activity.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note> <note>
     * <p>
     * <code>CreateActivity</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if it was
     * already created. <code>CreateActivity</code>'s idempotency check is based on the activity <code>name</code>. If a
     * following request has different <code>tags</code> values, Step Functions will ignore these differences and treat
     * it as an idempotent request of the previous. In this case, <code>tags</code> will not be updated, even if they
     * are different.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateActivityRequest.Builder} avoiding the need to
     * create one manually via {@link CreateActivityRequest#builder()}
     * </p>
     *
     * @param createActivityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.CreateActivityRequest.Builder} to create a request.
     * @return Result of the CreateActivity operation returned by the service.
     * @throws ActivityLimitExceededException
     *         The maximum number of activities has been reached. Existing activities must be deleted before a new
     *         activity can be created.
     * @throws InvalidNameException
     *         The provided name is not valid.
     * @throws TooManyTagsException
     *         You've exceeded the number of tags allowed for a resource. See the <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the Step
     *         Functions Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.CreateActivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateActivity" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateActivityResponse createActivity(Consumer<CreateActivityRequest.Builder> createActivityRequest)
            throws ActivityLimitExceededException, InvalidNameException, TooManyTagsException, AwsServiceException,
            SdkClientException, SfnException {
        return createActivity(CreateActivityRequest.builder().applyMutation(createActivityRequest).build());
    }

    /**
     * <p>
     * Creates a state machine. A state machine consists of a collection of states that can do work (<code>Task</code>
     * states), determine to which states to transition next (<code>Choice</code> states), stop an execution with an
     * error (<code>Fail</code> states), and so on. State machines are specified using a JSON-based, structured
     * language. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States
     * Language</a> in the Step Functions User Guide.
     * </p>
     * <p>
     * If you set the <code>publish</code> parameter of this API action to <code>true</code>, it publishes version
     * <code>1</code> as the first revision of the state machine.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note> <note>
     * <p>
     * <code>CreateStateMachine</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if it
     * was already created. <code>CreateStateMachine</code>'s idempotency check is based on the state machine
     * <code>name</code>, <code>definition</code>, <code>type</code>, <code>LoggingConfiguration</code>, and
     * <code>TracingConfiguration</code>. The check is also based on the <code>publish</code> and
     * <code>versionDescription</code> parameters. If a following request has a different <code>roleArn</code> or
     * <code>tags</code>, Step Functions will ignore these differences and treat it as an idempotent request of the
     * previous. In this case, <code>roleArn</code> and <code>tags</code> will not be updated, even if they are
     * different.
     * </p>
     * </note>
     *
     * @param createStateMachineRequest
     * @return Result of the CreateStateMachine operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidDefinitionException
     *         The provided Amazon States Language definition is not valid.
     * @throws InvalidNameException
     *         The provided name is not valid.
     * @throws InvalidLoggingConfigurationException
     * @throws InvalidTracingConfigurationException
     *         Your <code>tracingConfiguration</code> key does not match, or <code>enabled</code> has not been set to
     *         <code>true</code> or <code>false</code>.
     * @throws StateMachineAlreadyExistsException
     *         A state machine with the same name but a different definition or role ARN already exists.
     * @throws StateMachineDeletingException
     *         The specified state machine is being deleted.
     * @throws StateMachineLimitExceededException
     *         The maximum number of state machines has been reached. Existing state machines must be deleted before a
     *         new state machine can be created.
     * @throws StateMachineTypeNotSupportedException
     * @throws TooManyTagsException
     *         You've exceeded the number of tags allowed for a resource. See the <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the Step
     *         Functions Developer Guide.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state. This error occurs when there're
     *         concurrent requests for <a>DeleteStateMachineVersion</a>, <a>PublishStateMachineVersion</a>, or
     *         <a>UpdateStateMachine</a> with the <code>publish</code> parameter set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.CreateStateMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateStateMachine" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateStateMachineResponse createStateMachine(CreateStateMachineRequest createStateMachineRequest)
            throws InvalidArnException, InvalidDefinitionException, InvalidNameException, InvalidLoggingConfigurationException,
            InvalidTracingConfigurationException, StateMachineAlreadyExistsException, StateMachineDeletingException,
            StateMachineLimitExceededException, StateMachineTypeNotSupportedException, TooManyTagsException, ValidationException,
            ConflictException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a state machine. A state machine consists of a collection of states that can do work (<code>Task</code>
     * states), determine to which states to transition next (<code>Choice</code> states), stop an execution with an
     * error (<code>Fail</code> states), and so on. State machines are specified using a JSON-based, structured
     * language. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States
     * Language</a> in the Step Functions User Guide.
     * </p>
     * <p>
     * If you set the <code>publish</code> parameter of this API action to <code>true</code>, it publishes version
     * <code>1</code> as the first revision of the state machine.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note> <note>
     * <p>
     * <code>CreateStateMachine</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if it
     * was already created. <code>CreateStateMachine</code>'s idempotency check is based on the state machine
     * <code>name</code>, <code>definition</code>, <code>type</code>, <code>LoggingConfiguration</code>, and
     * <code>TracingConfiguration</code>. The check is also based on the <code>publish</code> and
     * <code>versionDescription</code> parameters. If a following request has a different <code>roleArn</code> or
     * <code>tags</code>, Step Functions will ignore these differences and treat it as an idempotent request of the
     * previous. In this case, <code>roleArn</code> and <code>tags</code> will not be updated, even if they are
     * different.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStateMachineRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStateMachineRequest#builder()}
     * </p>
     *
     * @param createStateMachineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.CreateStateMachineRequest.Builder} to create a request.
     * @return Result of the CreateStateMachine operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidDefinitionException
     *         The provided Amazon States Language definition is not valid.
     * @throws InvalidNameException
     *         The provided name is not valid.
     * @throws InvalidLoggingConfigurationException
     * @throws InvalidTracingConfigurationException
     *         Your <code>tracingConfiguration</code> key does not match, or <code>enabled</code> has not been set to
     *         <code>true</code> or <code>false</code>.
     * @throws StateMachineAlreadyExistsException
     *         A state machine with the same name but a different definition or role ARN already exists.
     * @throws StateMachineDeletingException
     *         The specified state machine is being deleted.
     * @throws StateMachineLimitExceededException
     *         The maximum number of state machines has been reached. Existing state machines must be deleted before a
     *         new state machine can be created.
     * @throws StateMachineTypeNotSupportedException
     * @throws TooManyTagsException
     *         You've exceeded the number of tags allowed for a resource. See the <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the Step
     *         Functions Developer Guide.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state. This error occurs when there're
     *         concurrent requests for <a>DeleteStateMachineVersion</a>, <a>PublishStateMachineVersion</a>, or
     *         <a>UpdateStateMachine</a> with the <code>publish</code> parameter set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.CreateStateMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateStateMachine" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateStateMachineResponse createStateMachine(Consumer<CreateStateMachineRequest.Builder> createStateMachineRequest)
            throws InvalidArnException, InvalidDefinitionException, InvalidNameException, InvalidLoggingConfigurationException,
            InvalidTracingConfigurationException, StateMachineAlreadyExistsException, StateMachineDeletingException,
            StateMachineLimitExceededException, StateMachineTypeNotSupportedException, TooManyTagsException, ValidationException,
            ConflictException, AwsServiceException, SdkClientException, SfnException {
        return createStateMachine(CreateStateMachineRequest.builder().applyMutation(createStateMachineRequest).build());
    }

    /**
     * <p>
     * Creates an <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> for a
     * state machine that points to one or two <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">versions</a> of
     * the same state machine. You can set your application to call <a>StartExecution</a> with an alias and update the
     * version the alias uses without changing the client's code.
     * </p>
     * <p>
     * You can also map an alias to split <a>StartExecution</a> requests between two versions of a state machine. To do
     * this, add a second <code>RoutingConfig</code> object in the <code>routingConfiguration</code> parameter. You must
     * also specify the percentage of execution run requests each version should receive in both
     * <code>RoutingConfig</code> objects. Step Functions randomly chooses which version runs a given execution based on
     * the percentage you specify.
     * </p>
     * <p>
     * To create an alias that points to a single version, specify a single <code>RoutingConfig</code> object with a
     * <code>weight</code> set to 100.
     * </p>
     * <p>
     * You can create up to 100 aliases for each state machine. You must delete unused aliases using the
     * <a>DeleteStateMachineAlias</a> API action.
     * </p>
     * <p>
     * <code>CreateStateMachineAlias</code> is an idempotent API. Step Functions bases the idempotency check on the
     * <code>stateMachineArn</code>, <code>description</code>, <code>name</code>, and <code>routingConfiguration</code>
     * parameters. Requests that contain the same values for these parameters return a successful idempotent response
     * without creating a duplicate resource.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DescribeStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineAliases</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>UpdateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createStateMachineAliasRequest
     * @return Result of the CreateStateMachineAlias operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidNameException
     *         The provided name is not valid.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws StateMachineDeletingException
     *         The specified state machine is being deleted.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state. This error occurs when there're
     *         concurrent requests for <a>DeleteStateMachineVersion</a>, <a>PublishStateMachineVersion</a>, or
     *         <a>UpdateStateMachine</a> with the <code>publish</code> parameter set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     *         </p>
     *         <p>
     *         HTTP Status Code: 402
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.CreateStateMachineAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateStateMachineAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStateMachineAliasResponse createStateMachineAlias(CreateStateMachineAliasRequest createStateMachineAliasRequest)
            throws InvalidArnException, InvalidNameException, ValidationException, StateMachineDeletingException,
            ResourceNotFoundException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> for a
     * state machine that points to one or two <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">versions</a> of
     * the same state machine. You can set your application to call <a>StartExecution</a> with an alias and update the
     * version the alias uses without changing the client's code.
     * </p>
     * <p>
     * You can also map an alias to split <a>StartExecution</a> requests between two versions of a state machine. To do
     * this, add a second <code>RoutingConfig</code> object in the <code>routingConfiguration</code> parameter. You must
     * also specify the percentage of execution run requests each version should receive in both
     * <code>RoutingConfig</code> objects. Step Functions randomly chooses which version runs a given execution based on
     * the percentage you specify.
     * </p>
     * <p>
     * To create an alias that points to a single version, specify a single <code>RoutingConfig</code> object with a
     * <code>weight</code> set to 100.
     * </p>
     * <p>
     * You can create up to 100 aliases for each state machine. You must delete unused aliases using the
     * <a>DeleteStateMachineAlias</a> API action.
     * </p>
     * <p>
     * <code>CreateStateMachineAlias</code> is an idempotent API. Step Functions bases the idempotency check on the
     * <code>stateMachineArn</code>, <code>description</code>, <code>name</code>, and <code>routingConfiguration</code>
     * parameters. Requests that contain the same values for these parameters return a successful idempotent response
     * without creating a duplicate resource.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DescribeStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineAliases</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>UpdateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStateMachineAliasRequest.Builder} avoiding
     * the need to create one manually via {@link CreateStateMachineAliasRequest#builder()}
     * </p>
     *
     * @param createStateMachineAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasRequest.Builder} to create a
     *        request.
     * @return Result of the CreateStateMachineAlias operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidNameException
     *         The provided name is not valid.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws StateMachineDeletingException
     *         The specified state machine is being deleted.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state. This error occurs when there're
     *         concurrent requests for <a>DeleteStateMachineVersion</a>, <a>PublishStateMachineVersion</a>, or
     *         <a>UpdateStateMachine</a> with the <code>publish</code> parameter set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     *         </p>
     *         <p>
     *         HTTP Status Code: 402
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.CreateStateMachineAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateStateMachineAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStateMachineAliasResponse createStateMachineAlias(
            Consumer<CreateStateMachineAliasRequest.Builder> createStateMachineAliasRequest) throws InvalidArnException,
            InvalidNameException, ValidationException, StateMachineDeletingException, ResourceNotFoundException,
            ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, SfnException {
        return createStateMachineAlias(CreateStateMachineAliasRequest.builder().applyMutation(createStateMachineAliasRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an activity.
     * </p>
     *
     * @param deleteActivityRequest
     * @return Result of the DeleteActivity operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DeleteActivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteActivity" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteActivityResponse deleteActivity(DeleteActivityRequest deleteActivityRequest) throws InvalidArnException,
            AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an activity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteActivityRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteActivityRequest#builder()}
     * </p>
     *
     * @param deleteActivityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DeleteActivityRequest.Builder} to create a request.
     * @return Result of the DeleteActivity operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DeleteActivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteActivity" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteActivityResponse deleteActivity(Consumer<DeleteActivityRequest.Builder> deleteActivityRequest)
            throws InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        return deleteActivity(DeleteActivityRequest.builder().applyMutation(deleteActivityRequest).build());
    }

    /**
     * <p>
     * Deletes a state machine. This is an asynchronous operation. It sets the state machine's status to
     * <code>DELETING</code> and begins the deletion process. A state machine is deleted only when all its executions
     * are completed. On the next state transition, the state machine's executions are terminated.
     * </p>
     * <p>
     * A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine,
     * a version ARN, or an alias ARN.
     * </p>
     * <p>
     * The following are some examples of qualified and unqualified state machine ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label
     * <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails
     * with <code>ValidationException</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This API action also deletes all <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">versions</a> and
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">aliases</a>
     * associated with a state machine.
     * </p>
     * <note>
     * <p>
     * For <code>EXPRESS</code> state machines, the deletion happens eventually (usually in less than a minute). Running
     * executions may emit logs after <code>DeleteStateMachine</code> API is called.
     * </p>
     * </note>
     *
     * @param deleteStateMachineRequest
     * @return Result of the DeleteStateMachine operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DeleteStateMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachine" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteStateMachineResponse deleteStateMachine(DeleteStateMachineRequest deleteStateMachineRequest)
            throws InvalidArnException, ValidationException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a state machine. This is an asynchronous operation. It sets the state machine's status to
     * <code>DELETING</code> and begins the deletion process. A state machine is deleted only when all its executions
     * are completed. On the next state transition, the state machine's executions are terminated.
     * </p>
     * <p>
     * A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine,
     * a version ARN, or an alias ARN.
     * </p>
     * <p>
     * The following are some examples of qualified and unqualified state machine ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label
     * <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails
     * with <code>ValidationException</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This API action also deletes all <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">versions</a> and
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">aliases</a>
     * associated with a state machine.
     * </p>
     * <note>
     * <p>
     * For <code>EXPRESS</code> state machines, the deletion happens eventually (usually in less than a minute). Running
     * executions may emit logs after <code>DeleteStateMachine</code> API is called.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStateMachineRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteStateMachineRequest#builder()}
     * </p>
     *
     * @param deleteStateMachineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DeleteStateMachineRequest.Builder} to create a request.
     * @return Result of the DeleteStateMachine operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DeleteStateMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachine" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteStateMachineResponse deleteStateMachine(Consumer<DeleteStateMachineRequest.Builder> deleteStateMachineRequest)
            throws InvalidArnException, ValidationException, AwsServiceException, SdkClientException, SfnException {
        return deleteStateMachine(DeleteStateMachineRequest.builder().applyMutation(deleteStateMachineRequest).build());
    }

    /**
     * <p>
     * Deletes a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>.
     * </p>
     * <p>
     * After you delete a state machine alias, you can't use it to start executions. When you delete a state machine
     * alias, Step Functions doesn't delete the state machine versions that alias references.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineAliases</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>UpdateStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteStateMachineAliasRequest
     * @return Result of the DeleteStateMachineAlias operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state. This error occurs when there're
     *         concurrent requests for <a>DeleteStateMachineVersion</a>, <a>PublishStateMachineVersion</a>, or
     *         <a>UpdateStateMachine</a> with the <code>publish</code> parameter set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DeleteStateMachineAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachineAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteStateMachineAliasResponse deleteStateMachineAlias(DeleteStateMachineAliasRequest deleteStateMachineAliasRequest)
            throws ValidationException, InvalidArnException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>.
     * </p>
     * <p>
     * After you delete a state machine alias, you can't use it to start executions. When you delete a state machine
     * alias, Step Functions doesn't delete the state machine versions that alias references.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineAliases</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>UpdateStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStateMachineAliasRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteStateMachineAliasRequest#builder()}
     * </p>
     *
     * @param deleteStateMachineAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DeleteStateMachineAliasRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteStateMachineAlias operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state. This error occurs when there're
     *         concurrent requests for <a>DeleteStateMachineVersion</a>, <a>PublishStateMachineVersion</a>, or
     *         <a>UpdateStateMachine</a> with the <code>publish</code> parameter set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DeleteStateMachineAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachineAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteStateMachineAliasResponse deleteStateMachineAlias(
            Consumer<DeleteStateMachineAliasRequest.Builder> deleteStateMachineAliasRequest) throws ValidationException,
            InvalidArnException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException,
            SfnException {
        return deleteStateMachineAlias(DeleteStateMachineAliasRequest.builder().applyMutation(deleteStateMachineAliasRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>.
     * After you delete a version, you can't call <a>StartExecution</a> using that version's ARN or use the version with
     * a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>.
     * </p>
     * <note>
     * <p>
     * Deleting a state machine version won't terminate its in-progress executions.
     * </p>
     * </note> <note>
     * <p>
     * You can't delete a state machine version currently referenced by one or more aliases. Before you delete a
     * version, you must either delete the aliases or update them to point to another state machine version.
     * </p>
     * </note>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>PublishStateMachineVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineVersions</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteStateMachineVersionRequest
     * @return Result of the DeleteStateMachineVersion operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state. This error occurs when there're
     *         concurrent requests for <a>DeleteStateMachineVersion</a>, <a>PublishStateMachineVersion</a>, or
     *         <a>UpdateStateMachine</a> with the <code>publish</code> parameter set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DeleteStateMachineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteStateMachineVersionResponse deleteStateMachineVersion(
            DeleteStateMachineVersionRequest deleteStateMachineVersionRequest) throws ValidationException, InvalidArnException,
            ConflictException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>.
     * After you delete a version, you can't call <a>StartExecution</a> using that version's ARN or use the version with
     * a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>.
     * </p>
     * <note>
     * <p>
     * Deleting a state machine version won't terminate its in-progress executions.
     * </p>
     * </note> <note>
     * <p>
     * You can't delete a state machine version currently referenced by one or more aliases. Before you delete a
     * version, you must either delete the aliases or update them to point to another state machine version.
     * </p>
     * </note>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>PublishStateMachineVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineVersions</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStateMachineVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteStateMachineVersionRequest#builder()}
     * </p>
     *
     * @param deleteStateMachineVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DeleteStateMachineVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteStateMachineVersion operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state. This error occurs when there're
     *         concurrent requests for <a>DeleteStateMachineVersion</a>, <a>PublishStateMachineVersion</a>, or
     *         <a>UpdateStateMachine</a> with the <code>publish</code> parameter set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DeleteStateMachineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteStateMachineVersionResponse deleteStateMachineVersion(
            Consumer<DeleteStateMachineVersionRequest.Builder> deleteStateMachineVersionRequest) throws ValidationException,
            InvalidArnException, ConflictException, AwsServiceException, SdkClientException, SfnException {
        return deleteStateMachineVersion(DeleteStateMachineVersionRequest.builder()
                .applyMutation(deleteStateMachineVersionRequest).build());
    }

    /**
     * <p>
     * Describes an activity.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     *
     * @param describeActivityRequest
     * @return Result of the DescribeActivity operation returned by the service.
     * @throws ActivityDoesNotExistException
     *         The specified activity does not exist.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DescribeActivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeActivity" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeActivityResponse describeActivity(DescribeActivityRequest describeActivityRequest)
            throws ActivityDoesNotExistException, InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an activity.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActivityRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeActivityRequest#builder()}
     * </p>
     *
     * @param describeActivityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DescribeActivityRequest.Builder} to create a request.
     * @return Result of the DescribeActivity operation returned by the service.
     * @throws ActivityDoesNotExistException
     *         The specified activity does not exist.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DescribeActivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeActivity" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeActivityResponse describeActivity(Consumer<DescribeActivityRequest.Builder> describeActivityRequest)
            throws ActivityDoesNotExistException, InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        return describeActivity(DescribeActivityRequest.builder().applyMutation(describeActivityRequest).build());
    }

    /**
     * <p>
     * Provides information about a state machine execution, such as the state machine associated with the execution,
     * the execution input and output, and relevant execution metadata. If you've <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html">redriven</a> an execution,
     * you can use this API action to return information about the redrives of that execution. In addition, you can use
     * this API action to return the Map Run Amazon Resource Name (ARN) if the execution was dispatched by a Map Run.
     * </p>
     * <p>
     * If you specify a version or alias ARN when you call the <a>StartExecution</a> API action,
     * <code>DescribeExecution</code> returns that ARN.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     * <p>
     * Executions of an <code>EXPRESS</code> state machine aren't supported by <code>DescribeExecution</code> unless a
     * Map Run dispatched them.
     * </p>
     *
     * @param describeExecutionRequest
     * @return Result of the DescribeExecution operation returned by the service.
     * @throws ExecutionDoesNotExistException
     *         The specified execution does not exist.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DescribeExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeExecutionResponse describeExecution(DescribeExecutionRequest describeExecutionRequest)
            throws ExecutionDoesNotExistException, InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a state machine execution, such as the state machine associated with the execution,
     * the execution input and output, and relevant execution metadata. If you've <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html">redriven</a> an execution,
     * you can use this API action to return information about the redrives of that execution. In addition, you can use
     * this API action to return the Map Run Amazon Resource Name (ARN) if the execution was dispatched by a Map Run.
     * </p>
     * <p>
     * If you specify a version or alias ARN when you call the <a>StartExecution</a> API action,
     * <code>DescribeExecution</code> returns that ARN.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     * <p>
     * Executions of an <code>EXPRESS</code> state machine aren't supported by <code>DescribeExecution</code> unless a
     * Map Run dispatched them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExecutionRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeExecutionRequest#builder()}
     * </p>
     *
     * @param describeExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest.Builder} to create a request.
     * @return Result of the DescribeExecution operation returned by the service.
     * @throws ExecutionDoesNotExistException
     *         The specified execution does not exist.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DescribeExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeExecutionResponse describeExecution(Consumer<DescribeExecutionRequest.Builder> describeExecutionRequest)
            throws ExecutionDoesNotExistException, InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        return describeExecution(DescribeExecutionRequest.builder().applyMutation(describeExecutionRequest).build());
    }

    /**
     * <p>
     * Provides information about a Map Run's configuration, progress, and results. If you've <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">redriven</a> a Map Run, this API
     * action also returns information about the redrives of that Map Run. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html">Examining Map Run</a>
     * in the <i>Step Functions Developer Guide</i>.
     * </p>
     *
     * @param describeMapRunRequest
     * @return Result of the DescribeMapRun operation returned by the service.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DescribeMapRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeMapRun" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeMapRunResponse describeMapRun(DescribeMapRunRequest describeMapRunRequest) throws ResourceNotFoundException,
            InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a Map Run's configuration, progress, and results. If you've <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">redriven</a> a Map Run, this API
     * action also returns information about the redrives of that Map Run. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html">Examining Map Run</a>
     * in the <i>Step Functions Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMapRunRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeMapRunRequest#builder()}
     * </p>
     *
     * @param describeMapRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DescribeMapRunRequest.Builder} to create a request.
     * @return Result of the DescribeMapRun operation returned by the service.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DescribeMapRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeMapRun" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeMapRunResponse describeMapRun(Consumer<DescribeMapRunRequest.Builder> describeMapRunRequest)
            throws ResourceNotFoundException, InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        return describeMapRun(DescribeMapRunRequest.builder().applyMutation(describeMapRunRequest).build());
    }

    /**
     * <p>
     * Provides information about a state machine's definition, its IAM role Amazon Resource Name (ARN), and
     * configuration.
     * </p>
     * <p>
     * A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine,
     * a version ARN, or an alias ARN.
     * </p>
     * <p>
     * The following are some examples of qualified and unqualified state machine ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label
     * <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails
     * with <code>ValidationException</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to an alias named <code>PROD</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts
     * execution for that version or alias.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This API action returns the details for a state machine version if the <code>stateMachineArn</code> you specify
     * is a state machine version ARN.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     *
     * @param describeStateMachineRequest
     * @return Result of the DescribeStateMachine operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws StateMachineDoesNotExistException
     *         The specified state machine does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DescribeStateMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachine" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStateMachineResponse describeStateMachine(DescribeStateMachineRequest describeStateMachineRequest)
            throws InvalidArnException, StateMachineDoesNotExistException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a state machine's definition, its IAM role Amazon Resource Name (ARN), and
     * configuration.
     * </p>
     * <p>
     * A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine,
     * a version ARN, or an alias ARN.
     * </p>
     * <p>
     * The following are some examples of qualified and unqualified state machine ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label
     * <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails
     * with <code>ValidationException</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to an alias named <code>PROD</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts
     * execution for that version or alias.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This API action returns the details for a state machine version if the <code>stateMachineArn</code> you specify
     * is a state machine version ARN.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStateMachineRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStateMachineRequest#builder()}
     * </p>
     *
     * @param describeStateMachineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest.Builder} to create a request.
     * @return Result of the DescribeStateMachine operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws StateMachineDoesNotExistException
     *         The specified state machine does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DescribeStateMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachine" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStateMachineResponse describeStateMachine(
            Consumer<DescribeStateMachineRequest.Builder> describeStateMachineRequest) throws InvalidArnException,
            StateMachineDoesNotExistException, AwsServiceException, SdkClientException, SfnException {
        return describeStateMachine(DescribeStateMachineRequest.builder().applyMutation(describeStateMachineRequest).build());
    }

    /**
     * <p>
     * Returns details about a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineAliases</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>UpdateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeStateMachineAliasRequest
     * @return Result of the DescribeStateMachineAlias operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DescribeStateMachineAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachineAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStateMachineAliasResponse describeStateMachineAlias(
            DescribeStateMachineAliasRequest describeStateMachineAliasRequest) throws ValidationException, InvalidArnException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineAliases</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>UpdateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStateMachineAliasRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeStateMachineAliasRequest#builder()}
     * </p>
     *
     * @param describeStateMachineAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeStateMachineAlias operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DescribeStateMachineAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachineAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStateMachineAliasResponse describeStateMachineAlias(
            Consumer<DescribeStateMachineAliasRequest.Builder> describeStateMachineAliasRequest) throws ValidationException,
            InvalidArnException, ResourceNotFoundException, AwsServiceException, SdkClientException, SfnException {
        return describeStateMachineAlias(DescribeStateMachineAliasRequest.builder()
                .applyMutation(describeStateMachineAliasRequest).build());
    }

    /**
     * <p>
     * Provides information about a state machine's definition, its execution role ARN, and configuration. If a Map Run
     * dispatched the execution, this action returns the Map Run Amazon Resource Name (ARN) in the response. The state
     * machine returned is the state machine associated with the Map Run.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     *
     * @param describeStateMachineForExecutionRequest
     * @return Result of the DescribeStateMachineForExecution operation returned by the service.
     * @throws ExecutionDoesNotExistException
     *         The specified execution does not exist.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DescribeStateMachineForExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachineForExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStateMachineForExecutionResponse describeStateMachineForExecution(
            DescribeStateMachineForExecutionRequest describeStateMachineForExecutionRequest)
            throws ExecutionDoesNotExistException, InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a state machine's definition, its execution role ARN, and configuration. If a Map Run
     * dispatched the execution, this action returns the Map Run Amazon Resource Name (ARN) in the response. The state
     * machine returned is the state machine associated with the Map Run.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStateMachineForExecutionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStateMachineForExecutionRequest#builder()}
     * </p>
     *
     * @param describeStateMachineForExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeStateMachineForExecution operation returned by the service.
     * @throws ExecutionDoesNotExistException
     *         The specified execution does not exist.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.DescribeStateMachineForExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachineForExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStateMachineForExecutionResponse describeStateMachineForExecution(
            Consumer<DescribeStateMachineForExecutionRequest.Builder> describeStateMachineForExecutionRequest)
            throws ExecutionDoesNotExistException, InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        return describeStateMachineForExecution(DescribeStateMachineForExecutionRequest.builder()
                .applyMutation(describeStateMachineForExecutionRequest).build());
    }

    /**
     * <p>
     * Used by workers to retrieve a task (with the specified activity ARN) which has been scheduled for execution by a
     * running state machine. This initiates a long poll, where the service holds the HTTP connection open and responds
     * as soon as a task becomes available (i.e. an execution of a task of this type is needed.) The maximum time the
     * service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the
     * poll returns a <code>taskToken</code> with a null string.
     * </p>
     * <note>
     * <p>
     * This API action isn't logged in CloudTrail.
     * </p>
     * </note> <important>
     * <p>
     * Workers should set their client side socket timeout to at least 65 seconds (5 seconds higher than the maximum
     * time the service may hold the poll request).
     * </p>
     * <p>
     * Polling with <code>GetActivityTask</code> can cause latency in some implementations. See <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/bp-activity-pollers.html">Avoid Latency When Polling
     * for Activity Tasks</a> in the Step Functions Developer Guide.
     * </p>
     * </important>
     *
     * @param getActivityTaskRequest
     * @return Result of the GetActivityTask operation returned by the service.
     * @throws ActivityDoesNotExistException
     *         The specified activity does not exist.
     * @throws ActivityWorkerLimitExceededException
     *         The maximum number of workers concurrently polling for activity tasks has been reached.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.GetActivityTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetActivityTask" target="_top">AWS API
     *      Documentation</a>
     */
    default GetActivityTaskResponse getActivityTask(GetActivityTaskRequest getActivityTaskRequest)
            throws ActivityDoesNotExistException, ActivityWorkerLimitExceededException, InvalidArnException, AwsServiceException,
            SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by workers to retrieve a task (with the specified activity ARN) which has been scheduled for execution by a
     * running state machine. This initiates a long poll, where the service holds the HTTP connection open and responds
     * as soon as a task becomes available (i.e. an execution of a task of this type is needed.) The maximum time the
     * service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the
     * poll returns a <code>taskToken</code> with a null string.
     * </p>
     * <note>
     * <p>
     * This API action isn't logged in CloudTrail.
     * </p>
     * </note> <important>
     * <p>
     * Workers should set their client side socket timeout to at least 65 seconds (5 seconds higher than the maximum
     * time the service may hold the poll request).
     * </p>
     * <p>
     * Polling with <code>GetActivityTask</code> can cause latency in some implementations. See <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/bp-activity-pollers.html">Avoid Latency When Polling
     * for Activity Tasks</a> in the Step Functions Developer Guide.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetActivityTaskRequest.Builder} avoiding the need
     * to create one manually via {@link GetActivityTaskRequest#builder()}
     * </p>
     *
     * @param getActivityTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.GetActivityTaskRequest.Builder} to create a request.
     * @return Result of the GetActivityTask operation returned by the service.
     * @throws ActivityDoesNotExistException
     *         The specified activity does not exist.
     * @throws ActivityWorkerLimitExceededException
     *         The maximum number of workers concurrently polling for activity tasks has been reached.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.GetActivityTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetActivityTask" target="_top">AWS API
     *      Documentation</a>
     */
    default GetActivityTaskResponse getActivityTask(Consumer<GetActivityTaskRequest.Builder> getActivityTaskRequest)
            throws ActivityDoesNotExistException, ActivityWorkerLimitExceededException, InvalidArnException, AwsServiceException,
            SdkClientException, SfnException {
        return getActivityTask(GetActivityTaskRequest.builder().applyMutation(getActivityTaskRequest).build());
    }

    /**
     * <p>
     * Returns the history of the specified execution as a list of events. By default, the results are returned in
     * ascending order of the <code>timeStamp</code> of the events. Use the <code>reverseOrder</code> parameter to get
     * the latest events first.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     *
     * @param getExecutionHistoryRequest
     * @return Result of the GetExecutionHistory operation returned by the service.
     * @throws ExecutionDoesNotExistException
     *         The specified execution does not exist.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.GetExecutionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetExecutionHistory" target="_top">AWS
     *      API Documentation</a>
     */
    default GetExecutionHistoryResponse getExecutionHistory(GetExecutionHistoryRequest getExecutionHistoryRequest)
            throws ExecutionDoesNotExistException, InvalidArnException, InvalidTokenException, AwsServiceException,
            SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the history of the specified execution as a list of events. By default, the results are returned in
     * ascending order of the <code>timeStamp</code> of the events. Use the <code>reverseOrder</code> parameter to get
     * the latest events first.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExecutionHistoryRequest.Builder} avoiding the
     * need to create one manually via {@link GetExecutionHistoryRequest#builder()}
     * </p>
     *
     * @param getExecutionHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest.Builder} to create a request.
     * @return Result of the GetExecutionHistory operation returned by the service.
     * @throws ExecutionDoesNotExistException
     *         The specified execution does not exist.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.GetExecutionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetExecutionHistory" target="_top">AWS
     *      API Documentation</a>
     */
    default GetExecutionHistoryResponse getExecutionHistory(
            Consumer<GetExecutionHistoryRequest.Builder> getExecutionHistoryRequest) throws ExecutionDoesNotExistException,
            InvalidArnException, InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        return getExecutionHistory(GetExecutionHistoryRequest.builder().applyMutation(getExecutionHistoryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getExecutionHistory(software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.GetExecutionHistoryIterable responses = client.getExecutionHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sfn.paginators.GetExecutionHistoryIterable responses = client
     *             .getExecutionHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.GetExecutionHistoryIterable responses = client.getExecutionHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getExecutionHistory(software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest)} operation.</b>
     * </p>
     *
     * @param getExecutionHistoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ExecutionDoesNotExistException
     *         The specified execution does not exist.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.GetExecutionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetExecutionHistory" target="_top">AWS
     *      API Documentation</a>
     */
    default GetExecutionHistoryIterable getExecutionHistoryPaginator(GetExecutionHistoryRequest getExecutionHistoryRequest)
            throws ExecutionDoesNotExistException, InvalidArnException, InvalidTokenException, AwsServiceException,
            SdkClientException, SfnException {
        return new GetExecutionHistoryIterable(this, getExecutionHistoryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getExecutionHistory(software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.GetExecutionHistoryIterable responses = client.getExecutionHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sfn.paginators.GetExecutionHistoryIterable responses = client
     *             .getExecutionHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.GetExecutionHistoryIterable responses = client.getExecutionHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getExecutionHistory(software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExecutionHistoryRequest.Builder} avoiding the
     * need to create one manually via {@link GetExecutionHistoryRequest#builder()}
     * </p>
     *
     * @param getExecutionHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ExecutionDoesNotExistException
     *         The specified execution does not exist.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.GetExecutionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetExecutionHistory" target="_top">AWS
     *      API Documentation</a>
     */
    default GetExecutionHistoryIterable getExecutionHistoryPaginator(
            Consumer<GetExecutionHistoryRequest.Builder> getExecutionHistoryRequest) throws ExecutionDoesNotExistException,
            InvalidArnException, InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        return getExecutionHistoryPaginator(GetExecutionHistoryRequest.builder().applyMutation(getExecutionHistoryRequest)
                .build());
    }

    /**
     * <p>
     * Lists the existing activities.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     *
     * @param listActivitiesRequest
     * @return Result of the ListActivities operation returned by the service.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActivitiesResponse listActivities(ListActivitiesRequest listActivitiesRequest) throws InvalidTokenException,
            AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the existing activities.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActivitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListActivitiesRequest#builder()}
     * </p>
     *
     * @param listActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListActivitiesRequest.Builder} to create a request.
     * @return Result of the ListActivities operation returned by the service.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActivitiesResponse listActivities(Consumer<ListActivitiesRequest.Builder> listActivitiesRequest)
            throws InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        return listActivities(ListActivitiesRequest.builder().applyMutation(listActivitiesRequest).build());
    }

    /**
     * <p>
     * Lists the existing activities.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     *
     * @return Result of the ListActivities operation returned by the service.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListActivities
     * @see #listActivities(ListActivitiesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActivitiesResponse listActivities() throws InvalidTokenException, AwsServiceException, SdkClientException,
            SfnException {
        return listActivities(ListActivitiesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listActivities(software.amazon.awssdk.services.sfn.model.ListActivitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListActivitiesIterable responses = client.listActivitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sfn.paginators.ListActivitiesIterable responses = client.listActivitiesPaginator(request);
     *     for (software.amazon.awssdk.services.sfn.model.ListActivitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListActivitiesIterable responses = client.listActivitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActivities(software.amazon.awssdk.services.sfn.model.ListActivitiesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListActivities
     * @see #listActivitiesPaginator(ListActivitiesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActivitiesIterable listActivitiesPaginator() throws InvalidTokenException, AwsServiceException,
            SdkClientException, SfnException {
        return listActivitiesPaginator(ListActivitiesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listActivities(software.amazon.awssdk.services.sfn.model.ListActivitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListActivitiesIterable responses = client.listActivitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sfn.paginators.ListActivitiesIterable responses = client.listActivitiesPaginator(request);
     *     for (software.amazon.awssdk.services.sfn.model.ListActivitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListActivitiesIterable responses = client.listActivitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActivities(software.amazon.awssdk.services.sfn.model.ListActivitiesRequest)} operation.</b>
     * </p>
     *
     * @param listActivitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActivitiesIterable listActivitiesPaginator(ListActivitiesRequest listActivitiesRequest)
            throws InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        return new ListActivitiesIterable(this, listActivitiesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listActivities(software.amazon.awssdk.services.sfn.model.ListActivitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListActivitiesIterable responses = client.listActivitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sfn.paginators.ListActivitiesIterable responses = client.listActivitiesPaginator(request);
     *     for (software.amazon.awssdk.services.sfn.model.ListActivitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListActivitiesIterable responses = client.listActivitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActivities(software.amazon.awssdk.services.sfn.model.ListActivitiesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActivitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListActivitiesRequest#builder()}
     * </p>
     *
     * @param listActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListActivitiesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActivitiesIterable listActivitiesPaginator(Consumer<ListActivitiesRequest.Builder> listActivitiesRequest)
            throws InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        return listActivitiesPaginator(ListActivitiesRequest.builder().applyMutation(listActivitiesRequest).build());
    }

    /**
     * <p>
     * Lists all executions of a state machine or a Map Run. You can list all executions related to a state machine by
     * specifying a state machine Amazon Resource Name (ARN), or those related to a Map Run by specifying a Map Run ARN.
     * Using this API action, you can also list all <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html">redriven</a> executions.
     * </p>
     * <p>
     * You can also provide a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> ARN or <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a> ARN
     * to list the executions associated with a specific alias or version.
     * </p>
     * <p>
     * Results are sorted by time, with the most recent execution first.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     *
     * @param listExecutionsRequest
     * @return Result of the ListExecutions operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws StateMachineDoesNotExistException
     *         The specified state machine does not exist.
     * @throws StateMachineTypeNotSupportedException
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExecutionsResponse listExecutions(ListExecutionsRequest listExecutionsRequest) throws InvalidArnException,
            InvalidTokenException, StateMachineDoesNotExistException, StateMachineTypeNotSupportedException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all executions of a state machine or a Map Run. You can list all executions related to a state machine by
     * specifying a state machine Amazon Resource Name (ARN), or those related to a Map Run by specifying a Map Run ARN.
     * Using this API action, you can also list all <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html">redriven</a> executions.
     * </p>
     * <p>
     * You can also provide a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> ARN or <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a> ARN
     * to list the executions associated with a specific alias or version.
     * </p>
     * <p>
     * Results are sorted by time, with the most recent execution first.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExecutionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExecutionsRequest#builder()}
     * </p>
     *
     * @param listExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListExecutionsRequest.Builder} to create a request.
     * @return Result of the ListExecutions operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws StateMachineDoesNotExistException
     *         The specified state machine does not exist.
     * @throws StateMachineTypeNotSupportedException
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExecutionsResponse listExecutions(Consumer<ListExecutionsRequest.Builder> listExecutionsRequest)
            throws InvalidArnException, InvalidTokenException, StateMachineDoesNotExistException,
            StateMachineTypeNotSupportedException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, SfnException {
        return listExecutions(ListExecutionsRequest.builder().applyMutation(listExecutionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listExecutions(software.amazon.awssdk.services.sfn.model.ListExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListExecutionsIterable responses = client.listExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sfn.paginators.ListExecutionsIterable responses = client.listExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.sfn.model.ListExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListExecutionsIterable responses = client.listExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExecutions(software.amazon.awssdk.services.sfn.model.ListExecutionsRequest)} operation.</b>
     * </p>
     *
     * @param listExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws StateMachineDoesNotExistException
     *         The specified state machine does not exist.
     * @throws StateMachineTypeNotSupportedException
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExecutionsIterable listExecutionsPaginator(ListExecutionsRequest listExecutionsRequest)
            throws InvalidArnException, InvalidTokenException, StateMachineDoesNotExistException,
            StateMachineTypeNotSupportedException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, SfnException {
        return new ListExecutionsIterable(this, listExecutionsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listExecutions(software.amazon.awssdk.services.sfn.model.ListExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListExecutionsIterable responses = client.listExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sfn.paginators.ListExecutionsIterable responses = client.listExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.sfn.model.ListExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListExecutionsIterable responses = client.listExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExecutions(software.amazon.awssdk.services.sfn.model.ListExecutionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExecutionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExecutionsRequest#builder()}
     * </p>
     *
     * @param listExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListExecutionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws StateMachineDoesNotExistException
     *         The specified state machine does not exist.
     * @throws StateMachineTypeNotSupportedException
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExecutionsIterable listExecutionsPaginator(Consumer<ListExecutionsRequest.Builder> listExecutionsRequest)
            throws InvalidArnException, InvalidTokenException, StateMachineDoesNotExistException,
            StateMachineTypeNotSupportedException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, SfnException {
        return listExecutionsPaginator(ListExecutionsRequest.builder().applyMutation(listExecutionsRequest).build());
    }

    /**
     * <p>
     * Lists all Map Runs that were started by a given state machine execution. Use this API action to obtain Map Run
     * ARNs, and then call <code>DescribeMapRun</code> to obtain more information, if needed.
     * </p>
     *
     * @param listMapRunsRequest
     * @return Result of the ListMapRuns operation returned by the service.
     * @throws ExecutionDoesNotExistException
     *         The specified execution does not exist.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListMapRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListMapRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMapRunsResponse listMapRuns(ListMapRunsRequest listMapRunsRequest) throws ExecutionDoesNotExistException,
            InvalidArnException, InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Map Runs that were started by a given state machine execution. Use this API action to obtain Map Run
     * ARNs, and then call <code>DescribeMapRun</code> to obtain more information, if needed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMapRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMapRunsRequest#builder()}
     * </p>
     *
     * @param listMapRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListMapRunsRequest.Builder} to create a request.
     * @return Result of the ListMapRuns operation returned by the service.
     * @throws ExecutionDoesNotExistException
     *         The specified execution does not exist.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListMapRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListMapRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMapRunsResponse listMapRuns(Consumer<ListMapRunsRequest.Builder> listMapRunsRequest)
            throws ExecutionDoesNotExistException, InvalidArnException, InvalidTokenException, AwsServiceException,
            SdkClientException, SfnException {
        return listMapRuns(ListMapRunsRequest.builder().applyMutation(listMapRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listMapRuns(software.amazon.awssdk.services.sfn.model.ListMapRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListMapRunsIterable responses = client.listMapRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sfn.paginators.ListMapRunsIterable responses = client.listMapRunsPaginator(request);
     *     for (software.amazon.awssdk.services.sfn.model.ListMapRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListMapRunsIterable responses = client.listMapRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMapRuns(software.amazon.awssdk.services.sfn.model.ListMapRunsRequest)} operation.</b>
     * </p>
     *
     * @param listMapRunsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ExecutionDoesNotExistException
     *         The specified execution does not exist.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListMapRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListMapRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMapRunsIterable listMapRunsPaginator(ListMapRunsRequest listMapRunsRequest)
            throws ExecutionDoesNotExistException, InvalidArnException, InvalidTokenException, AwsServiceException,
            SdkClientException, SfnException {
        return new ListMapRunsIterable(this, listMapRunsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listMapRuns(software.amazon.awssdk.services.sfn.model.ListMapRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListMapRunsIterable responses = client.listMapRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sfn.paginators.ListMapRunsIterable responses = client.listMapRunsPaginator(request);
     *     for (software.amazon.awssdk.services.sfn.model.ListMapRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListMapRunsIterable responses = client.listMapRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMapRuns(software.amazon.awssdk.services.sfn.model.ListMapRunsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMapRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMapRunsRequest#builder()}
     * </p>
     *
     * @param listMapRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListMapRunsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ExecutionDoesNotExistException
     *         The specified execution does not exist.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListMapRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListMapRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMapRunsIterable listMapRunsPaginator(Consumer<ListMapRunsRequest.Builder> listMapRunsRequest)
            throws ExecutionDoesNotExistException, InvalidArnException, InvalidTokenException, AwsServiceException,
            SdkClientException, SfnException {
        return listMapRunsPaginator(ListMapRunsRequest.builder().applyMutation(listMapRunsRequest).build());
    }

    /**
     * <p>
     * Lists <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">aliases</a> for a
     * specified state machine ARN. Results are sorted by time, with the most recently created aliases listed first.
     * </p>
     * <p>
     * To list aliases that reference a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>, you
     * can specify the version ARN in the <code>stateMachineArn</code> parameter.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>UpdateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listStateMachineAliasesRequest
     * @return Result of the ListStateMachineAliases operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws StateMachineDoesNotExistException
     *         The specified state machine does not exist.
     * @throws StateMachineDeletingException
     *         The specified state machine is being deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListStateMachineAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachineAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStateMachineAliasesResponse listStateMachineAliases(ListStateMachineAliasesRequest listStateMachineAliasesRequest)
            throws InvalidArnException, InvalidTokenException, ResourceNotFoundException, StateMachineDoesNotExistException,
            StateMachineDeletingException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">aliases</a> for a
     * specified state machine ARN. Results are sorted by time, with the most recently created aliases listed first.
     * </p>
     * <p>
     * To list aliases that reference a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>, you
     * can specify the version ARN in the <code>stateMachineArn</code> parameter.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>UpdateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStateMachineAliasesRequest.Builder} avoiding
     * the need to create one manually via {@link ListStateMachineAliasesRequest#builder()}
     * </p>
     *
     * @param listStateMachineAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesRequest.Builder} to create a
     *        request.
     * @return Result of the ListStateMachineAliases operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws StateMachineDoesNotExistException
     *         The specified state machine does not exist.
     * @throws StateMachineDeletingException
     *         The specified state machine is being deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListStateMachineAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachineAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStateMachineAliasesResponse listStateMachineAliases(
            Consumer<ListStateMachineAliasesRequest.Builder> listStateMachineAliasesRequest) throws InvalidArnException,
            InvalidTokenException, ResourceNotFoundException, StateMachineDoesNotExistException, StateMachineDeletingException,
            AwsServiceException, SdkClientException, SfnException {
        return listStateMachineAliases(ListStateMachineAliasesRequest.builder().applyMutation(listStateMachineAliasesRequest)
                .build());
    }

    /**
     * <p>
     * Lists <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">versions</a> for
     * the specified state machine Amazon Resource Name (ARN).
     * </p>
     * <p>
     * The results are sorted in descending order of the version creation time.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>PublishStateMachineVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineVersion</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listStateMachineVersionsRequest
     * @return Result of the ListStateMachineVersions operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListStateMachineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStateMachineVersionsResponse listStateMachineVersions(
            ListStateMachineVersionsRequest listStateMachineVersionsRequest) throws ValidationException, InvalidArnException,
            InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">versions</a> for
     * the specified state machine Amazon Resource Name (ARN).
     * </p>
     * <p>
     * The results are sorted in descending order of the version creation time.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>PublishStateMachineVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineVersion</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStateMachineVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListStateMachineVersionsRequest#builder()}
     * </p>
     *
     * @param listStateMachineVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListStateMachineVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListStateMachineVersions operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListStateMachineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStateMachineVersionsResponse listStateMachineVersions(
            Consumer<ListStateMachineVersionsRequest.Builder> listStateMachineVersionsRequest) throws ValidationException,
            InvalidArnException, InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        return listStateMachineVersions(ListStateMachineVersionsRequest.builder().applyMutation(listStateMachineVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the existing state machines.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     *
     * @param listStateMachinesRequest
     * @return Result of the ListStateMachines operation returned by the service.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListStateMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachines" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStateMachinesResponse listStateMachines(ListStateMachinesRequest listStateMachinesRequest)
            throws InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the existing state machines.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStateMachinesRequest.Builder} avoiding the need
     * to create one manually via {@link ListStateMachinesRequest#builder()}
     * </p>
     *
     * @param listStateMachinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest.Builder} to create a request.
     * @return Result of the ListStateMachines operation returned by the service.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListStateMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachines" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStateMachinesResponse listStateMachines(Consumer<ListStateMachinesRequest.Builder> listStateMachinesRequest)
            throws InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        return listStateMachines(ListStateMachinesRequest.builder().applyMutation(listStateMachinesRequest).build());
    }

    /**
     * <p>
     * Lists the existing state machines.
     * </p>
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     *
     * @return Result of the ListStateMachines operation returned by the service.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListStateMachines
     * @see #listStateMachines(ListStateMachinesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachines" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStateMachinesResponse listStateMachines() throws InvalidTokenException, AwsServiceException, SdkClientException,
            SfnException {
        return listStateMachines(ListStateMachinesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStateMachines(software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListStateMachinesIterable responses = client.listStateMachinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sfn.paginators.ListStateMachinesIterable responses = client
     *             .listStateMachinesPaginator(request);
     *     for (software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListStateMachinesIterable responses = client.listStateMachinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStateMachines(software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListStateMachines
     * @see #listStateMachinesPaginator(ListStateMachinesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachines" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStateMachinesIterable listStateMachinesPaginator() throws InvalidTokenException, AwsServiceException,
            SdkClientException, SfnException {
        return listStateMachinesPaginator(ListStateMachinesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStateMachines(software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListStateMachinesIterable responses = client.listStateMachinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sfn.paginators.ListStateMachinesIterable responses = client
     *             .listStateMachinesPaginator(request);
     *     for (software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListStateMachinesIterable responses = client.listStateMachinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStateMachines(software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest)} operation.</b>
     * </p>
     *
     * @param listStateMachinesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListStateMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachines" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStateMachinesIterable listStateMachinesPaginator(ListStateMachinesRequest listStateMachinesRequest)
            throws InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        return new ListStateMachinesIterable(this, listStateMachinesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStateMachines(software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListStateMachinesIterable responses = client.listStateMachinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sfn.paginators.ListStateMachinesIterable responses = client
     *             .listStateMachinesPaginator(request);
     *     for (software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sfn.paginators.ListStateMachinesIterable responses = client.listStateMachinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStateMachines(software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStateMachinesRequest.Builder} avoiding the need
     * to create one manually via {@link ListStateMachinesRequest#builder()}
     * </p>
     *
     * @param listStateMachinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListStateMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachines" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStateMachinesIterable listStateMachinesPaginator(
            Consumer<ListStateMachinesRequest.Builder> listStateMachinesRequest) throws InvalidTokenException,
            AwsServiceException, SdkClientException, SfnException {
        return listStateMachinesPaginator(ListStateMachinesRequest.builder().applyMutation(listStateMachinesRequest).build());
    }

    /**
     * <p>
     * List tags for a given resource.
     * </p>
     * <p>
     * Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidArnException, ResourceNotFoundException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tags for a given resource.
     * </p>
     * <p>
     * Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidArnException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SfnException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates a <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a> from
     * the current revision of a state machine. Use versions to create immutable snapshots of your state machine. You
     * can start executions from versions either directly or with an alias. To create an alias, use
     * <a>CreateStateMachineAlias</a>.
     * </p>
     * <p>
     * You can publish up to 1000 versions for each state machine. You must manually delete unused versions using the
     * <a>DeleteStateMachineVersion</a> API action.
     * </p>
     * <p>
     * <code>PublishStateMachineVersion</code> is an idempotent API. It doesn't create a duplicate state machine version
     * if it already exists for the current revision. Step Functions bases <code>PublishStateMachineVersion</code>'s
     * idempotency check on the <code>stateMachineArn</code>, <code>name</code>, and <code>revisionId</code> parameters.
     * Requests with the same parameters return a successful idempotent response. If you don't specify a
     * <code>revisionId</code>, Step Functions checks for a previously published version of the state machine's current
     * revision.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DeleteStateMachineVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineVersions</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param publishStateMachineVersionRequest
     * @return Result of the PublishStateMachineVersion operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws StateMachineDeletingException
     *         The specified state machine is being deleted.
     * @throws StateMachineDoesNotExistException
     *         The specified state machine does not exist.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.</p>
     *         <p>
     *         HTTP Status Code: 402
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state. This error occurs when there're
     *         concurrent requests for <a>DeleteStateMachineVersion</a>, <a>PublishStateMachineVersion</a>, or
     *         <a>UpdateStateMachine</a> with the <code>publish</code> parameter set to <code>true</code>.
     *         </p>
     *         <p>
     *         HTTP Status Code: 409
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.PublishStateMachineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/PublishStateMachineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default PublishStateMachineVersionResponse publishStateMachineVersion(
            PublishStateMachineVersionRequest publishStateMachineVersionRequest) throws ValidationException,
            StateMachineDeletingException, StateMachineDoesNotExistException, ServiceQuotaExceededException, ConflictException,
            InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a> from
     * the current revision of a state machine. Use versions to create immutable snapshots of your state machine. You
     * can start executions from versions either directly or with an alias. To create an alias, use
     * <a>CreateStateMachineAlias</a>.
     * </p>
     * <p>
     * You can publish up to 1000 versions for each state machine. You must manually delete unused versions using the
     * <a>DeleteStateMachineVersion</a> API action.
     * </p>
     * <p>
     * <code>PublishStateMachineVersion</code> is an idempotent API. It doesn't create a duplicate state machine version
     * if it already exists for the current revision. Step Functions bases <code>PublishStateMachineVersion</code>'s
     * idempotency check on the <code>stateMachineArn</code>, <code>name</code>, and <code>revisionId</code> parameters.
     * Requests with the same parameters return a successful idempotent response. If you don't specify a
     * <code>revisionId</code>, Step Functions checks for a previously published version of the state machine's current
     * revision.
     * </p>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DeleteStateMachineVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineVersions</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishStateMachineVersionRequest.Builder} avoiding
     * the need to create one manually via {@link PublishStateMachineVersionRequest#builder()}
     * </p>
     *
     * @param publishStateMachineVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionRequest.Builder} to create a
     *        request.
     * @return Result of the PublishStateMachineVersion operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws StateMachineDeletingException
     *         The specified state machine is being deleted.
     * @throws StateMachineDoesNotExistException
     *         The specified state machine does not exist.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.</p>
     *         <p>
     *         HTTP Status Code: 402
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state. This error occurs when there're
     *         concurrent requests for <a>DeleteStateMachineVersion</a>, <a>PublishStateMachineVersion</a>, or
     *         <a>UpdateStateMachine</a> with the <code>publish</code> parameter set to <code>true</code>.
     *         </p>
     *         <p>
     *         HTTP Status Code: 409
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.PublishStateMachineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/PublishStateMachineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default PublishStateMachineVersionResponse publishStateMachineVersion(
            Consumer<PublishStateMachineVersionRequest.Builder> publishStateMachineVersionRequest) throws ValidationException,
            StateMachineDeletingException, StateMachineDoesNotExistException, ServiceQuotaExceededException, ConflictException,
            InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        return publishStateMachineVersion(PublishStateMachineVersionRequest.builder()
                .applyMutation(publishStateMachineVersionRequest).build());
    }

    /**
     * <p>
     * Restarts unsuccessful executions of Standard workflows that didn't complete successfully in the last 14 days.
     * These include failed, aborted, or timed out executions. When you <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html">redrive</a> an execution, it
     * continues the failed execution from the unsuccessful step and uses the same input. Step Functions preserves the
     * results and execution history of the successful steps, and doesn't rerun these steps when you redrive an
     * execution. Redriven executions use the same state machine definition and execution ARN as the original execution
     * attempt.
     * </p>
     * <p>
     * For workflows that include an <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html">Inline Map</a>
     * or <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-parallel-state.html">Parallel
     * </a> state, <code>RedriveExecution</code> API action reschedules and redrives only the iterations and branches
     * that failed or aborted.
     * </p>
     * <p>
     * To redrive a workflow that includes a Distributed Map state whose Map Run failed, you must redrive the <a href=
     * "https://docs.aws.amazon.com/step-functions/latest/dg/use-dist-map-orchestrate-large-scale-parallel-workloads.html#dist-map-orchestrate-parallel-workloads-key-terms"
     * >parent workflow</a>. The parent workflow redrives all the unsuccessful states, including a failed Map Run. If a
     * Map Run was not started in the original execution attempt, the redriven parent workflow starts the Map Run.
     * </p>
     * <note>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     * <p>
     * However, you can restart the unsuccessful executions of Express child workflows in a Distributed Map by redriving
     * its Map Run. When you redrive a Map Run, the Express child workflows are rerun using the <a>StartExecution</a>
     * API action. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">Redriving Map Runs</a>.
     * </p>
     * </note>
     * <p>
     * You can redrive executions if your original execution meets the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The execution status isn't <code>SUCCEEDED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your workflow execution has not exceeded the redrivable period of 14 days. Redrivable period refers to the time
     * during which you can redrive a given execution. This period starts from the day a state machine completes its
     * execution.
     * </p>
     * </li>
     * <li>
     * <p>
     * The workflow execution has not exceeded the maximum open time of one year. For more information about state
     * machine quotas, see <a href=
     * "https://docs.aws.amazon.com/step-functions/latest/dg/limits-overview.html#service-limits-state-machine-executions"
     * >Quotas related to state machine executions</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The execution event history count is less than 24,999. Redriven executions append their event history to the
     * existing event history. Make sure your workflow execution contains less than 24,999 events to accommodate the
     * <code>ExecutionRedriven</code> history event and at least one other history event.
     * </p>
     * </li>
     * </ul>
     *
     * @param redriveExecutionRequest
     * @return Result of the RedriveExecution operation returned by the service.
     * @throws ExecutionDoesNotExistException
     *         The specified execution does not exist.
     * @throws ExecutionNotRedrivableException
     *         The execution Amazon Resource Name (ARN) that you specified for <code>executionArn</code> cannot be
     *         redriven.
     * @throws ExecutionLimitExceededException
     *         The maximum number of running executions has been reached. Running executions must end or be stopped
     *         before a new execution can be started.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.RedriveExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/RedriveExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default RedriveExecutionResponse redriveExecution(RedriveExecutionRequest redriveExecutionRequest)
            throws ExecutionDoesNotExistException, ExecutionNotRedrivableException, ExecutionLimitExceededException,
            InvalidArnException, ValidationException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts unsuccessful executions of Standard workflows that didn't complete successfully in the last 14 days.
     * These include failed, aborted, or timed out executions. When you <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html">redrive</a> an execution, it
     * continues the failed execution from the unsuccessful step and uses the same input. Step Functions preserves the
     * results and execution history of the successful steps, and doesn't rerun these steps when you redrive an
     * execution. Redriven executions use the same state machine definition and execution ARN as the original execution
     * attempt.
     * </p>
     * <p>
     * For workflows that include an <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html">Inline Map</a>
     * or <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-parallel-state.html">Parallel
     * </a> state, <code>RedriveExecution</code> API action reschedules and redrives only the iterations and branches
     * that failed or aborted.
     * </p>
     * <p>
     * To redrive a workflow that includes a Distributed Map state whose Map Run failed, you must redrive the <a href=
     * "https://docs.aws.amazon.com/step-functions/latest/dg/use-dist-map-orchestrate-large-scale-parallel-workloads.html#dist-map-orchestrate-parallel-workloads-key-terms"
     * >parent workflow</a>. The parent workflow redrives all the unsuccessful states, including a failed Map Run. If a
     * Map Run was not started in the original execution attempt, the redriven parent workflow starts the Map Run.
     * </p>
     * <note>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     * <p>
     * However, you can restart the unsuccessful executions of Express child workflows in a Distributed Map by redriving
     * its Map Run. When you redrive a Map Run, the Express child workflows are rerun using the <a>StartExecution</a>
     * API action. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">Redriving Map Runs</a>.
     * </p>
     * </note>
     * <p>
     * You can redrive executions if your original execution meets the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The execution status isn't <code>SUCCEEDED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your workflow execution has not exceeded the redrivable period of 14 days. Redrivable period refers to the time
     * during which you can redrive a given execution. This period starts from the day a state machine completes its
     * execution.
     * </p>
     * </li>
     * <li>
     * <p>
     * The workflow execution has not exceeded the maximum open time of one year. For more information about state
     * machine quotas, see <a href=
     * "https://docs.aws.amazon.com/step-functions/latest/dg/limits-overview.html#service-limits-state-machine-executions"
     * >Quotas related to state machine executions</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The execution event history count is less than 24,999. Redriven executions append their event history to the
     * existing event history. Make sure your workflow execution contains less than 24,999 events to accommodate the
     * <code>ExecutionRedriven</code> history event and at least one other history event.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RedriveExecutionRequest.Builder} avoiding the need
     * to create one manually via {@link RedriveExecutionRequest#builder()}
     * </p>
     *
     * @param redriveExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.RedriveExecutionRequest.Builder} to create a request.
     * @return Result of the RedriveExecution operation returned by the service.
     * @throws ExecutionDoesNotExistException
     *         The specified execution does not exist.
     * @throws ExecutionNotRedrivableException
     *         The execution Amazon Resource Name (ARN) that you specified for <code>executionArn</code> cannot be
     *         redriven.
     * @throws ExecutionLimitExceededException
     *         The maximum number of running executions has been reached. Running executions must end or be stopped
     *         before a new execution can be started.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.RedriveExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/RedriveExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default RedriveExecutionResponse redriveExecution(Consumer<RedriveExecutionRequest.Builder> redriveExecutionRequest)
            throws ExecutionDoesNotExistException, ExecutionNotRedrivableException, ExecutionLimitExceededException,
            InvalidArnException, ValidationException, AwsServiceException, SdkClientException, SfnException {
        return redriveExecution(RedriveExecutionRequest.builder().applyMutation(redriveExecutionRequest).build());
    }

    /**
     * <p>
     * Used by activity workers, Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token"
     * >callback</a> pattern, and optionally Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a>
     * pattern to report that the task identified by the <code>taskToken</code> failed.
     * </p>
     *
     * @param sendTaskFailureRequest
     * @return Result of the SendTaskFailure operation returned by the service.
     * @throws TaskDoesNotExistException
     *         The activity does not exist.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws TaskTimedOutException
     *         The task token has either expired or the task associated with the token has already been closed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.SendTaskFailure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskFailure" target="_top">AWS API
     *      Documentation</a>
     */
    default SendTaskFailureResponse sendTaskFailure(SendTaskFailureRequest sendTaskFailureRequest)
            throws TaskDoesNotExistException, InvalidTokenException, TaskTimedOutException, AwsServiceException,
            SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by activity workers, Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token"
     * >callback</a> pattern, and optionally Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a>
     * pattern to report that the task identified by the <code>taskToken</code> failed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendTaskFailureRequest.Builder} avoiding the need
     * to create one manually via {@link SendTaskFailureRequest#builder()}
     * </p>
     *
     * @param sendTaskFailureRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.SendTaskFailureRequest.Builder} to create a request.
     * @return Result of the SendTaskFailure operation returned by the service.
     * @throws TaskDoesNotExistException
     *         The activity does not exist.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws TaskTimedOutException
     *         The task token has either expired or the task associated with the token has already been closed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.SendTaskFailure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskFailure" target="_top">AWS API
     *      Documentation</a>
     */
    default SendTaskFailureResponse sendTaskFailure(Consumer<SendTaskFailureRequest.Builder> sendTaskFailureRequest)
            throws TaskDoesNotExistException, InvalidTokenException, TaskTimedOutException, AwsServiceException,
            SdkClientException, SfnException {
        return sendTaskFailure(SendTaskFailureRequest.builder().applyMutation(sendTaskFailureRequest).build());
    }

    /**
     * <p>
     * Used by activity workers and Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token"
     * >callback</a> pattern, and optionally Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a>
     * pattern to report to Step Functions that the task represented by the specified <code>taskToken</code> is still
     * making progress. This action resets the <code>Heartbeat</code> clock. The <code>Heartbeat</code> threshold is
     * specified in the state machine's Amazon States Language definition (<code>HeartbeatSeconds</code>). This action
     * does not in itself create an event in the execution history. However, if the task times out, the execution
     * history contains an <code>ActivityTimedOut</code> entry for activities, or a <code>TaskTimedOut</code> entry for
     * tasks using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a> or
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">
     * callback</a> pattern.
     * </p>
     * <note>
     * <p>
     * The <code>Timeout</code> of a task, defined in the state machine's Amazon States Language definition, is its
     * maximum allowed duration, regardless of the number of <a>SendTaskHeartbeat</a> requests received. Use
     * <code>HeartbeatSeconds</code> to configure the timeout interval for heartbeats.
     * </p>
     * </note>
     *
     * @param sendTaskHeartbeatRequest
     * @return Result of the SendTaskHeartbeat operation returned by the service.
     * @throws TaskDoesNotExistException
     *         The activity does not exist.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws TaskTimedOutException
     *         The task token has either expired or the task associated with the token has already been closed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.SendTaskHeartbeat
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskHeartbeat" target="_top">AWS API
     *      Documentation</a>
     */
    default SendTaskHeartbeatResponse sendTaskHeartbeat(SendTaskHeartbeatRequest sendTaskHeartbeatRequest)
            throws TaskDoesNotExistException, InvalidTokenException, TaskTimedOutException, AwsServiceException,
            SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by activity workers and Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token"
     * >callback</a> pattern, and optionally Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a>
     * pattern to report to Step Functions that the task represented by the specified <code>taskToken</code> is still
     * making progress. This action resets the <code>Heartbeat</code> clock. The <code>Heartbeat</code> threshold is
     * specified in the state machine's Amazon States Language definition (<code>HeartbeatSeconds</code>). This action
     * does not in itself create an event in the execution history. However, if the task times out, the execution
     * history contains an <code>ActivityTimedOut</code> entry for activities, or a <code>TaskTimedOut</code> entry for
     * tasks using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a> or
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">
     * callback</a> pattern.
     * </p>
     * <note>
     * <p>
     * The <code>Timeout</code> of a task, defined in the state machine's Amazon States Language definition, is its
     * maximum allowed duration, regardless of the number of <a>SendTaskHeartbeat</a> requests received. Use
     * <code>HeartbeatSeconds</code> to configure the timeout interval for heartbeats.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendTaskHeartbeatRequest.Builder} avoiding the need
     * to create one manually via {@link SendTaskHeartbeatRequest#builder()}
     * </p>
     *
     * @param sendTaskHeartbeatRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.SendTaskHeartbeatRequest.Builder} to create a request.
     * @return Result of the SendTaskHeartbeat operation returned by the service.
     * @throws TaskDoesNotExistException
     *         The activity does not exist.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws TaskTimedOutException
     *         The task token has either expired or the task associated with the token has already been closed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.SendTaskHeartbeat
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskHeartbeat" target="_top">AWS API
     *      Documentation</a>
     */
    default SendTaskHeartbeatResponse sendTaskHeartbeat(Consumer<SendTaskHeartbeatRequest.Builder> sendTaskHeartbeatRequest)
            throws TaskDoesNotExistException, InvalidTokenException, TaskTimedOutException, AwsServiceException,
            SdkClientException, SfnException {
        return sendTaskHeartbeat(SendTaskHeartbeatRequest.builder().applyMutation(sendTaskHeartbeatRequest).build());
    }

    /**
     * <p>
     * Used by activity workers, Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token"
     * >callback</a> pattern, and optionally Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a>
     * pattern to report that the task identified by the <code>taskToken</code> completed successfully.
     * </p>
     *
     * @param sendTaskSuccessRequest
     * @return Result of the SendTaskSuccess operation returned by the service.
     * @throws TaskDoesNotExistException
     *         The activity does not exist.
     * @throws InvalidOutputException
     *         The provided JSON output data is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws TaskTimedOutException
     *         The task token has either expired or the task associated with the token has already been closed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.SendTaskSuccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskSuccess" target="_top">AWS API
     *      Documentation</a>
     */
    default SendTaskSuccessResponse sendTaskSuccess(SendTaskSuccessRequest sendTaskSuccessRequest)
            throws TaskDoesNotExistException, InvalidOutputException, InvalidTokenException, TaskTimedOutException,
            AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by activity workers, Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token"
     * >callback</a> pattern, and optionally Task states using the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a>
     * pattern to report that the task identified by the <code>taskToken</code> completed successfully.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendTaskSuccessRequest.Builder} avoiding the need
     * to create one manually via {@link SendTaskSuccessRequest#builder()}
     * </p>
     *
     * @param sendTaskSuccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.SendTaskSuccessRequest.Builder} to create a request.
     * @return Result of the SendTaskSuccess operation returned by the service.
     * @throws TaskDoesNotExistException
     *         The activity does not exist.
     * @throws InvalidOutputException
     *         The provided JSON output data is not valid.
     * @throws InvalidTokenException
     *         The provided token is not valid.
     * @throws TaskTimedOutException
     *         The task token has either expired or the task associated with the token has already been closed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.SendTaskSuccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskSuccess" target="_top">AWS API
     *      Documentation</a>
     */
    default SendTaskSuccessResponse sendTaskSuccess(Consumer<SendTaskSuccessRequest.Builder> sendTaskSuccessRequest)
            throws TaskDoesNotExistException, InvalidOutputException, InvalidTokenException, TaskTimedOutException,
            AwsServiceException, SdkClientException, SfnException {
        return sendTaskSuccess(SendTaskSuccessRequest.builder().applyMutation(sendTaskSuccessRequest).build());
    }

    /**
     * <p>
     * Starts a state machine execution.
     * </p>
     * <p>
     * A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine,
     * a version ARN, or an alias ARN.
     * </p>
     * <p>
     * The following are some examples of qualified and unqualified state machine ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label
     * <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails
     * with <code>ValidationException</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to an alias named <code>PROD</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts
     * execution for that version or alias.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you start an execution with an unqualified state machine ARN, Step Functions uses the latest revision of the
     * state machine for the execution.
     * </p>
     * <p>
     * To start executions of a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>, call
     * <code>StartExecution</code> and provide the version ARN or the ARN of an <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> that
     * points to the version.
     * </p>
     * <note>
     * <p>
     * <code>StartExecution</code> is idempotent for <code>STANDARD</code> workflows. For a <code>STANDARD</code>
     * workflow, if you call <code>StartExecution</code> with the same name and input as a running execution, the call
     * succeeds and return the same response as the original request. If the execution is closed or if the input is
     * different, it returns a <code>400 ExecutionAlreadyExists</code> error. You can reuse names after 90 days.
     * </p>
     * <p>
     * <code>StartExecution</code> isn't idempotent for <code>EXPRESS</code> workflows.
     * </p>
     * </note>
     *
     * @param startExecutionRequest
     * @return Result of the StartExecution operation returned by the service.
     * @throws ExecutionLimitExceededException
     *         The maximum number of running executions has been reached. Running executions must end or be stopped
     *         before a new execution can be started.
     * @throws ExecutionAlreadyExistsException
     *         The execution has the same <code>name</code> as another execution (but a different <code>input</code>
     *         ).</p> <note>
     *         <p>
     *         Executions with the same <code>name</code> and <code>input</code> are considered idempotent.
     *         </p>
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidExecutionInputException
     *         The provided JSON input data is not valid.
     * @throws InvalidNameException
     *         The provided name is not valid.
     * @throws StateMachineDoesNotExistException
     *         The specified state machine does not exist.
     * @throws StateMachineDeletingException
     *         The specified state machine is being deleted.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.StartExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StartExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default StartExecutionResponse startExecution(StartExecutionRequest startExecutionRequest)
            throws ExecutionLimitExceededException, ExecutionAlreadyExistsException, InvalidArnException,
            InvalidExecutionInputException, InvalidNameException, StateMachineDoesNotExistException,
            StateMachineDeletingException, ValidationException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a state machine execution.
     * </p>
     * <p>
     * A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine,
     * a version ARN, or an alias ARN.
     * </p>
     * <p>
     * The following are some examples of qualified and unqualified state machine ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label
     * <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails
     * with <code>ValidationException</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to an alias named <code>PROD</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts
     * execution for that version or alias.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you start an execution with an unqualified state machine ARN, Step Functions uses the latest revision of the
     * state machine for the execution.
     * </p>
     * <p>
     * To start executions of a state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>, call
     * <code>StartExecution</code> and provide the version ARN or the ARN of an <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> that
     * points to the version.
     * </p>
     * <note>
     * <p>
     * <code>StartExecution</code> is idempotent for <code>STANDARD</code> workflows. For a <code>STANDARD</code>
     * workflow, if you call <code>StartExecution</code> with the same name and input as a running execution, the call
     * succeeds and return the same response as the original request. If the execution is closed or if the input is
     * different, it returns a <code>400 ExecutionAlreadyExists</code> error. You can reuse names after 90 days.
     * </p>
     * <p>
     * <code>StartExecution</code> isn't idempotent for <code>EXPRESS</code> workflows.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartExecutionRequest.Builder} avoiding the need to
     * create one manually via {@link StartExecutionRequest#builder()}
     * </p>
     *
     * @param startExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.StartExecutionRequest.Builder} to create a request.
     * @return Result of the StartExecution operation returned by the service.
     * @throws ExecutionLimitExceededException
     *         The maximum number of running executions has been reached. Running executions must end or be stopped
     *         before a new execution can be started.
     * @throws ExecutionAlreadyExistsException
     *         The execution has the same <code>name</code> as another execution (but a different <code>input</code>
     *         ).</p> <note>
     *         <p>
     *         Executions with the same <code>name</code> and <code>input</code> are considered idempotent.
     *         </p>
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidExecutionInputException
     *         The provided JSON input data is not valid.
     * @throws InvalidNameException
     *         The provided name is not valid.
     * @throws StateMachineDoesNotExistException
     *         The specified state machine does not exist.
     * @throws StateMachineDeletingException
     *         The specified state machine is being deleted.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.StartExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StartExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default StartExecutionResponse startExecution(Consumer<StartExecutionRequest.Builder> startExecutionRequest)
            throws ExecutionLimitExceededException, ExecutionAlreadyExistsException, InvalidArnException,
            InvalidExecutionInputException, InvalidNameException, StateMachineDoesNotExistException,
            StateMachineDeletingException, ValidationException, AwsServiceException, SdkClientException, SfnException {
        return startExecution(StartExecutionRequest.builder().applyMutation(startExecutionRequest).build());
    }

    /**
     * <p>
     * Starts a Synchronous Express state machine execution. <code>StartSyncExecution</code> is not available for
     * <code>STANDARD</code> workflows.
     * </p>
     * <note>
     * <p>
     * <code>StartSyncExecution</code> will return a <code>200 OK</code> response, even if your execution fails, because
     * the status code in the API response doesn't reflect function errors. Error codes are reserved for errors that
     * prevent your execution from running, such as permissions errors, limit errors, or issues with your state machine
     * code and configuration.
     * </p>
     * </note> <note>
     * <p>
     * This API action isn't logged in CloudTrail.
     * </p>
     * </note>
     *
     * @param startSyncExecutionRequest
     * @return Result of the StartSyncExecution operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidExecutionInputException
     *         The provided JSON input data is not valid.
     * @throws InvalidNameException
     *         The provided name is not valid.
     * @throws StateMachineDoesNotExistException
     *         The specified state machine does not exist.
     * @throws StateMachineDeletingException
     *         The specified state machine is being deleted.
     * @throws StateMachineTypeNotSupportedException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.StartSyncExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StartSyncExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default StartSyncExecutionResponse startSyncExecution(StartSyncExecutionRequest startSyncExecutionRequest)
            throws InvalidArnException, InvalidExecutionInputException, InvalidNameException, StateMachineDoesNotExistException,
            StateMachineDeletingException, StateMachineTypeNotSupportedException, AwsServiceException, SdkClientException,
            SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a Synchronous Express state machine execution. <code>StartSyncExecution</code> is not available for
     * <code>STANDARD</code> workflows.
     * </p>
     * <note>
     * <p>
     * <code>StartSyncExecution</code> will return a <code>200 OK</code> response, even if your execution fails, because
     * the status code in the API response doesn't reflect function errors. Error codes are reserved for errors that
     * prevent your execution from running, such as permissions errors, limit errors, or issues with your state machine
     * code and configuration.
     * </p>
     * </note> <note>
     * <p>
     * This API action isn't logged in CloudTrail.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSyncExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StartSyncExecutionRequest#builder()}
     * </p>
     *
     * @param startSyncExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.StartSyncExecutionRequest.Builder} to create a request.
     * @return Result of the StartSyncExecution operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidExecutionInputException
     *         The provided JSON input data is not valid.
     * @throws InvalidNameException
     *         The provided name is not valid.
     * @throws StateMachineDoesNotExistException
     *         The specified state machine does not exist.
     * @throws StateMachineDeletingException
     *         The specified state machine is being deleted.
     * @throws StateMachineTypeNotSupportedException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.StartSyncExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StartSyncExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default StartSyncExecutionResponse startSyncExecution(Consumer<StartSyncExecutionRequest.Builder> startSyncExecutionRequest)
            throws InvalidArnException, InvalidExecutionInputException, InvalidNameException, StateMachineDoesNotExistException,
            StateMachineDeletingException, StateMachineTypeNotSupportedException, AwsServiceException, SdkClientException,
            SfnException {
        return startSyncExecution(StartSyncExecutionRequest.builder().applyMutation(startSyncExecutionRequest).build());
    }

    /**
     * <p>
     * Stops an execution.
     * </p>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     *
     * @param stopExecutionRequest
     * @return Result of the StopExecution operation returned by the service.
     * @throws ExecutionDoesNotExistException
     *         The specified execution does not exist.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.StopExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StopExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default StopExecutionResponse stopExecution(StopExecutionRequest stopExecutionRequest) throws ExecutionDoesNotExistException,
            InvalidArnException, ValidationException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an execution.
     * </p>
     * <p>
     * This API action is not supported by <code>EXPRESS</code> state machines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopExecutionRequest.Builder} avoiding the need to
     * create one manually via {@link StopExecutionRequest#builder()}
     * </p>
     *
     * @param stopExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.StopExecutionRequest.Builder} to create a request.
     * @return Result of the StopExecution operation returned by the service.
     * @throws ExecutionDoesNotExistException
     *         The specified execution does not exist.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.StopExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StopExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default StopExecutionResponse stopExecution(Consumer<StopExecutionRequest.Builder> stopExecutionRequest)
            throws ExecutionDoesNotExistException, InvalidArnException, ValidationException, AwsServiceException,
            SdkClientException, SfnException {
        return stopExecution(StopExecutionRequest.builder().applyMutation(stopExecutionRequest).build());
    }

    /**
     * <p>
     * Add a tag to a Step Functions resource.
     * </p>
     * <p>
     * An array of key-value pairs. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>, and <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
     * Tags</a>.
     * </p>
     * <p>
     * Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws TooManyTagsException
     *         You've exceeded the number of tags allowed for a resource. See the <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the Step
     *         Functions Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidArnException,
            ResourceNotFoundException, TooManyTagsException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add a tag to a Step Functions resource.
     * </p>
     * <p>
     * An array of key-value pairs. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>, and <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
     * Tags</a>.
     * </p>
     * <p>
     * Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws TooManyTagsException
     *         You've exceeded the number of tags allowed for a resource. See the <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the Step
     *         Functions Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws InvalidArnException,
            ResourceNotFoundException, TooManyTagsException, AwsServiceException, SdkClientException, SfnException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Accepts the definition of a single state and executes it. You can test a state without creating a state machine
     * or updating an existing state machine. Using this API, you can test the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A state's <a href=
     * "https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-input-output-dataflow"
     * >input and output processing</a> data flow
     * </p>
     * </li>
     * <li>
     * <p>
     * An <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-services.html">Amazon Web Services
     * service integration</a> request and response
     * </p>
     * </li>
     * <li>
     * <p>
     * An <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-third-party-apis.html">HTTP Task</a>
     * request and response
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can call this API on only one state at a time. The states that you can test include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-task-state.html#task-types">
     * All Task types</a> except <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html">Activity</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-pass-state.html">Pass</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-wait-state.html">Wait</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-choice-state.html">Choice</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-succeed-state.html">Succeed</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-fail-state.html">Fail</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The <code>TestState</code> API assumes an IAM role which must contain the required IAM permissions for the
     * resources your state is accessing. For information about the permissions a state might need, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions">IAM
     * permissions to test a state</a>.
     * </p>
     * <p>
     * The <code>TestState</code> API can run for up to five minutes. If the execution of a state exceeds this duration,
     * it fails with the <code>States.Timeout</code> error.
     * </p>
     * <p>
     * <code>TestState</code> doesn't support <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html">Activity tasks</a>,
     * <code>.sync</code> or <code>.waitForTaskToken</code> <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html">service integration
     * patterns</a>, <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-parallel-state.html"
     * >Parallel</a>, or <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html">Map</a> states.
     * </p>
     *
     * @param testStateRequest
     * @return Result of the TestState operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidDefinitionException
     *         The provided Amazon States Language definition is not valid.
     * @throws InvalidExecutionInputException
     *         The provided JSON input data is not valid.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.TestState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/TestState" target="_top">AWS API
     *      Documentation</a>
     */
    default TestStateResponse testState(TestStateRequest testStateRequest) throws InvalidArnException,
            InvalidDefinitionException, InvalidExecutionInputException, ValidationException, AwsServiceException,
            SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts the definition of a single state and executes it. You can test a state without creating a state machine
     * or updating an existing state machine. Using this API, you can test the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A state's <a href=
     * "https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-input-output-dataflow"
     * >input and output processing</a> data flow
     * </p>
     * </li>
     * <li>
     * <p>
     * An <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-services.html">Amazon Web Services
     * service integration</a> request and response
     * </p>
     * </li>
     * <li>
     * <p>
     * An <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-third-party-apis.html">HTTP Task</a>
     * request and response
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can call this API on only one state at a time. The states that you can test include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-task-state.html#task-types">
     * All Task types</a> except <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html">Activity</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-pass-state.html">Pass</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-wait-state.html">Wait</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-choice-state.html">Choice</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-succeed-state.html">Succeed</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-fail-state.html">Fail</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The <code>TestState</code> API assumes an IAM role which must contain the required IAM permissions for the
     * resources your state is accessing. For information about the permissions a state might need, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions">IAM
     * permissions to test a state</a>.
     * </p>
     * <p>
     * The <code>TestState</code> API can run for up to five minutes. If the execution of a state exceeds this duration,
     * it fails with the <code>States.Timeout</code> error.
     * </p>
     * <p>
     * <code>TestState</code> doesn't support <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html">Activity tasks</a>,
     * <code>.sync</code> or <code>.waitForTaskToken</code> <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html">service integration
     * patterns</a>, <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-parallel-state.html"
     * >Parallel</a>, or <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html">Map</a> states.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestStateRequest.Builder} avoiding the need to
     * create one manually via {@link TestStateRequest#builder()}
     * </p>
     *
     * @param testStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.TestStateRequest.Builder} to create a request.
     * @return Result of the TestState operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidDefinitionException
     *         The provided Amazon States Language definition is not valid.
     * @throws InvalidExecutionInputException
     *         The provided JSON input data is not valid.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.TestState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/TestState" target="_top">AWS API
     *      Documentation</a>
     */
    default TestStateResponse testState(Consumer<TestStateRequest.Builder> testStateRequest) throws InvalidArnException,
            InvalidDefinitionException, InvalidExecutionInputException, ValidationException, AwsServiceException,
            SdkClientException, SfnException {
        return testState(TestStateRequest.builder().applyMutation(testStateRequest).build());
    }

    /**
     * <p>
     * Remove a tag from a Step Functions resource
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidArnException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a tag from a Step Functions resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InvalidArnException, ResourceNotFoundException, AwsServiceException, SdkClientException, SfnException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an in-progress Map Run's configuration to include changes to the settings that control maximum
     * concurrency and Map Run failure.
     * </p>
     *
     * @param updateMapRunRequest
     * @return Result of the UpdateMapRun operation returned by the service.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.UpdateMapRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UpdateMapRun" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateMapRunResponse updateMapRun(UpdateMapRunRequest updateMapRunRequest) throws ResourceNotFoundException,
            InvalidArnException, ValidationException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an in-progress Map Run's configuration to include changes to the settings that control maximum
     * concurrency and Map Run failure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMapRunRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateMapRunRequest#builder()}
     * </p>
     *
     * @param updateMapRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.UpdateMapRunRequest.Builder} to create a request.
     * @return Result of the UpdateMapRun operation returned by the service.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.UpdateMapRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UpdateMapRun" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateMapRunResponse updateMapRun(Consumer<UpdateMapRunRequest.Builder> updateMapRunRequest)
            throws ResourceNotFoundException, InvalidArnException, ValidationException, AwsServiceException, SdkClientException,
            SfnException {
        return updateMapRun(UpdateMapRunRequest.builder().applyMutation(updateMapRunRequest).build());
    }

    /**
     * <p>
     * Updates an existing state machine by modifying its <code>definition</code>, <code>roleArn</code>, or
     * <code>loggingConfiguration</code>. Running executions will continue to use the previous <code>definition</code>
     * and <code>roleArn</code>. You must include at least one of <code>definition</code> or <code>roleArn</code> or you
     * will receive a <code>MissingRequiredParameter</code> error.
     * </p>
     * <p>
     * A qualified state machine ARN refers to a <i>Distributed Map state</i> defined within a state machine. For
     * example, the qualified state machine ARN
     * <code>arn:partition:states:region:account-id:stateMachine:stateMachineName/mapStateLabel</code> refers to a
     * <i>Distributed Map state</i> with a label <code>mapStateLabel</code> in the state machine named
     * <code>stateMachineName</code>.
     * </p>
     * <p>
     * A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine,
     * a version ARN, or an alias ARN.
     * </p>
     * <p>
     * The following are some examples of qualified and unqualified state machine ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label
     * <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails
     * with <code>ValidationException</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to an alias named <code>PROD</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts
     * execution for that version or alias.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * After you update your state machine, you can set the <code>publish</code> parameter to <code>true</code> in the
     * same action to publish a new <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>. This
     * way, you can opt-in to strict versioning of your state machine.
     * </p>
     * <note>
     * <p>
     * Step Functions assigns monotonically increasing integers for state machine versions, starting at version number
     * 1.
     * </p>
     * </note> <note>
     * <p>
     * All <code>StartExecution</code> calls within a few seconds use the updated <code>definition</code> and
     * <code>roleArn</code>. Executions started immediately after you call <code>UpdateStateMachine</code> may use the
     * previous state machine <code>definition</code> and <code>roleArn</code>.
     * </p>
     * </note>
     *
     * @param updateStateMachineRequest
     * @return Result of the UpdateStateMachine operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidDefinitionException
     *         The provided Amazon States Language definition is not valid.
     * @throws InvalidLoggingConfigurationException
     * @throws InvalidTracingConfigurationException
     *         Your <code>tracingConfiguration</code> key does not match, or <code>enabled</code> has not been set to
     *         <code>true</code> or <code>false</code>.
     * @throws MissingRequiredParameterException
     *         Request is missing a required parameter. This error occurs if both <code>definition</code> and
     *         <code>roleArn</code> are not specified.
     * @throws StateMachineDeletingException
     *         The specified state machine is being deleted.
     * @throws StateMachineDoesNotExistException
     *         The specified state machine does not exist.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.</p>
     *         <p>
     *         HTTP Status Code: 402
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state. This error occurs when there're
     *         concurrent requests for <a>DeleteStateMachineVersion</a>, <a>PublishStateMachineVersion</a>, or
     *         <a>UpdateStateMachine</a> with the <code>publish</code> parameter set to <code>true</code>.
     *         </p>
     *         <p>
     *         HTTP Status Code: 409
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.UpdateStateMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UpdateStateMachine" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateStateMachineResponse updateStateMachine(UpdateStateMachineRequest updateStateMachineRequest)
            throws InvalidArnException, InvalidDefinitionException, InvalidLoggingConfigurationException,
            InvalidTracingConfigurationException, MissingRequiredParameterException, StateMachineDeletingException,
            StateMachineDoesNotExistException, ServiceQuotaExceededException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing state machine by modifying its <code>definition</code>, <code>roleArn</code>, or
     * <code>loggingConfiguration</code>. Running executions will continue to use the previous <code>definition</code>
     * and <code>roleArn</code>. You must include at least one of <code>definition</code> or <code>roleArn</code> or you
     * will receive a <code>MissingRequiredParameter</code> error.
     * </p>
     * <p>
     * A qualified state machine ARN refers to a <i>Distributed Map state</i> defined within a state machine. For
     * example, the qualified state machine ARN
     * <code>arn:partition:states:region:account-id:stateMachine:stateMachineName/mapStateLabel</code> refers to a
     * <i>Distributed Map state</i> with a label <code>mapStateLabel</code> in the state machine named
     * <code>stateMachineName</code>.
     * </p>
     * <p>
     * A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine,
     * a version ARN, or an alias ARN.
     * </p>
     * <p>
     * The following are some examples of qualified and unqualified state machine ARNs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label
     * <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails
     * with <code>ValidationException</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following qualified state machine ARN refers to an alias named <code>PROD</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code>
     * </p>
     * <note>
     * <p>
     * If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts
     * execution for that version or alias.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * After you update your state machine, you can set the <code>publish</code> parameter to <code>true</code> in the
     * same action to publish a new <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>. This
     * way, you can opt-in to strict versioning of your state machine.
     * </p>
     * <note>
     * <p>
     * Step Functions assigns monotonically increasing integers for state machine versions, starting at version number
     * 1.
     * </p>
     * </note> <note>
     * <p>
     * All <code>StartExecution</code> calls within a few seconds use the updated <code>definition</code> and
     * <code>roleArn</code>. Executions started immediately after you call <code>UpdateStateMachine</code> may use the
     * previous state machine <code>definition</code> and <code>roleArn</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStateMachineRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateStateMachineRequest#builder()}
     * </p>
     *
     * @param updateStateMachineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest.Builder} to create a request.
     * @return Result of the UpdateStateMachine operation returned by the service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws InvalidDefinitionException
     *         The provided Amazon States Language definition is not valid.
     * @throws InvalidLoggingConfigurationException
     * @throws InvalidTracingConfigurationException
     *         Your <code>tracingConfiguration</code> key does not match, or <code>enabled</code> has not been set to
     *         <code>true</code> or <code>false</code>.
     * @throws MissingRequiredParameterException
     *         Request is missing a required parameter. This error occurs if both <code>definition</code> and
     *         <code>roleArn</code> are not specified.
     * @throws StateMachineDeletingException
     *         The specified state machine is being deleted.
     * @throws StateMachineDoesNotExistException
     *         The specified state machine does not exist.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.</p>
     *         <p>
     *         HTTP Status Code: 402
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state. This error occurs when there're
     *         concurrent requests for <a>DeleteStateMachineVersion</a>, <a>PublishStateMachineVersion</a>, or
     *         <a>UpdateStateMachine</a> with the <code>publish</code> parameter set to <code>true</code>.
     *         </p>
     *         <p>
     *         HTTP Status Code: 409
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.UpdateStateMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UpdateStateMachine" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateStateMachineResponse updateStateMachine(Consumer<UpdateStateMachineRequest.Builder> updateStateMachineRequest)
            throws InvalidArnException, InvalidDefinitionException, InvalidLoggingConfigurationException,
            InvalidTracingConfigurationException, MissingRequiredParameterException, StateMachineDeletingException,
            StateMachineDoesNotExistException, ServiceQuotaExceededException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, SfnException {
        return updateStateMachine(UpdateStateMachineRequest.builder().applyMutation(updateStateMachineRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> by
     * modifying its <code>description</code> or <code>routingConfiguration</code>.
     * </p>
     * <p>
     * You must specify at least one of the <code>description</code> or <code>routingConfiguration</code> parameters to
     * update a state machine alias.
     * </p>
     * <note>
     * <p>
     * <code>UpdateStateMachineAlias</code> is an idempotent API. Step Functions bases the idempotency check on the
     * <code>stateMachineAliasArn</code>, <code>description</code>, and <code>routingConfiguration</code> parameters.
     * Requests with the same parameters return an idempotent response.
     * </p>
     * </note> <note>
     * <p>
     * This operation is eventually consistent. All <a>StartExecution</a> requests made within a few seconds use the
     * latest alias configuration. Executions started immediately after calling <code>UpdateStateMachineAlias</code> may
     * use the previous routing configuration.
     * </p>
     * </note>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineAliases</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param updateStateMachineAliasRequest
     * @return Result of the UpdateStateMachineAlias operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state. This error occurs when there're
     *         concurrent requests for <a>DeleteStateMachineVersion</a>, <a>PublishStateMachineVersion</a>, or
     *         <a>UpdateStateMachine</a> with the <code>publish</code> parameter set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409
     * @throws StateMachineDeletingException
     *         The specified state machine is being deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.UpdateStateMachineAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UpdateStateMachineAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateStateMachineAliasResponse updateStateMachineAlias(UpdateStateMachineAliasRequest updateStateMachineAliasRequest)
            throws ValidationException, InvalidArnException, ResourceNotFoundException, ConflictException,
            StateMachineDeletingException, AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing state machine <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> by
     * modifying its <code>description</code> or <code>routingConfiguration</code>.
     * </p>
     * <p>
     * You must specify at least one of the <code>description</code> or <code>routingConfiguration</code> parameters to
     * update a state machine alias.
     * </p>
     * <note>
     * <p>
     * <code>UpdateStateMachineAlias</code> is an idempotent API. Step Functions bases the idempotency check on the
     * <code>stateMachineAliasArn</code>, <code>description</code>, and <code>routingConfiguration</code> parameters.
     * Requests with the same parameters return an idempotent response.
     * </p>
     * </note> <note>
     * <p>
     * This operation is eventually consistent. All <a>StartExecution</a> requests made within a few seconds use the
     * latest alias configuration. Executions started immediately after calling <code>UpdateStateMachineAlias</code> may
     * use the previous routing configuration.
     * </p>
     * </note>
     * <p>
     * <b>Related operations:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeStateMachineAlias</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListStateMachineAliases</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteStateMachineAlias</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStateMachineAliasRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateStateMachineAliasRequest#builder()}
     * </p>
     *
     * @param updateStateMachineAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateStateMachineAlias operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidArnException
     *         The provided Amazon Resource Name (ARN) is not valid.
     * @throws ResourceNotFoundException
     *         Could not find the referenced resource.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state. This error occurs when there're
     *         concurrent requests for <a>DeleteStateMachineVersion</a>, <a>PublishStateMachineVersion</a>, or
     *         <a>UpdateStateMachine</a> with the <code>publish</code> parameter set to <code>true</code>.</p>
     *         <p>
     *         HTTP Status Code: 409
     * @throws StateMachineDeletingException
     *         The specified state machine is being deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.UpdateStateMachineAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UpdateStateMachineAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateStateMachineAliasResponse updateStateMachineAlias(
            Consumer<UpdateStateMachineAliasRequest.Builder> updateStateMachineAliasRequest) throws ValidationException,
            InvalidArnException, ResourceNotFoundException, ConflictException, StateMachineDeletingException,
            AwsServiceException, SdkClientException, SfnException {
        return updateStateMachineAlias(UpdateStateMachineAliasRequest.builder().applyMutation(updateStateMachineAliasRequest)
                .build());
    }

    /**
     * <p>
     * Validates the syntax of a state machine definition.
     * </p>
     * <p>
     * You can validate that a state machine definition is correct without creating a state machine resource. Step
     * Functions will implicitly perform the same syntax check when you invoke <code>CreateStateMachine</code> and
     * <code>UpdateStateMachine</code>. State machine definitions are specified using a JSON-based, structured language.
     * For more information on Amazon States Language see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States
     * Language</a> (ASL).
     * </p>
     * <p>
     * Suggested uses for <code>ValidateStateMachineDefinition</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Integrate automated checks into your code review or Continuous Integration (CI) process to validate state machine
     * definitions before starting deployments.
     * </p>
     * </li>
     * <li>
     * <p>
     * Run the validation from a Git pre-commit hook to check your state machine definitions before committing them to
     * your source repository.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Errors found in the state machine definition will be returned in the response as a list of <b>diagnostic
     * elements</b>, rather than raise an exception.
     * </p>
     * </note>
     *
     * @param validateStateMachineDefinitionRequest
     * @return Result of the ValidateStateMachineDefinition operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ValidateStateMachineDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ValidateStateMachineDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default ValidateStateMachineDefinitionResponse validateStateMachineDefinition(
            ValidateStateMachineDefinitionRequest validateStateMachineDefinitionRequest) throws ValidationException,
            AwsServiceException, SdkClientException, SfnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates the syntax of a state machine definition.
     * </p>
     * <p>
     * You can validate that a state machine definition is correct without creating a state machine resource. Step
     * Functions will implicitly perform the same syntax check when you invoke <code>CreateStateMachine</code> and
     * <code>UpdateStateMachine</code>. State machine definitions are specified using a JSON-based, structured language.
     * For more information on Amazon States Language see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States
     * Language</a> (ASL).
     * </p>
     * <p>
     * Suggested uses for <code>ValidateStateMachineDefinition</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Integrate automated checks into your code review or Continuous Integration (CI) process to validate state machine
     * definitions before starting deployments.
     * </p>
     * </li>
     * <li>
     * <p>
     * Run the validation from a Git pre-commit hook to check your state machine definitions before committing them to
     * your source repository.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Errors found in the state machine definition will be returned in the response as a list of <b>diagnostic
     * elements</b>, rather than raise an exception.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidateStateMachineDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link ValidateStateMachineDefinitionRequest#builder()}
     * </p>
     *
     * @param validateStateMachineDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionRequest.Builder} to create
     *        a request.
     * @return Result of the ValidateStateMachineDefinition operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SfnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SfnClient.ValidateStateMachineDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ValidateStateMachineDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default ValidateStateMachineDefinitionResponse validateStateMachineDefinition(
            Consumer<ValidateStateMachineDefinitionRequest.Builder> validateStateMachineDefinitionRequest)
            throws ValidationException, AwsServiceException, SdkClientException, SfnException {
        return validateStateMachineDefinition(ValidateStateMachineDefinitionRequest.builder()
                .applyMutation(validateStateMachineDefinitionRequest).build());
    }

    /**
     * Create a {@link SfnClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SfnClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SfnClient}.
     */
    static SfnClientBuilder builder() {
        return new DefaultSfnClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SfnServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
