/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidateStateMachineDefinitionResponse extends SfnResponse implements
        ToCopyableBuilder<ValidateStateMachineDefinitionResponse.Builder, ValidateStateMachineDefinitionResponse> {
    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("result")
            .getter(getter(ValidateStateMachineDefinitionResponse::resultAsString)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final SdkField<List<ValidateStateMachineDefinitionDiagnostic>> DIAGNOSTICS_FIELD = SdkField
            .<List<ValidateStateMachineDefinitionDiagnostic>> builder(MarshallingType.LIST)
            .memberName("diagnostics")
            .getter(getter(ValidateStateMachineDefinitionResponse::diagnostics))
            .setter(setter(Builder::diagnostics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diagnostics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidateStateMachineDefinitionDiagnostic> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidateStateMachineDefinitionDiagnostic::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FIELD,
            DIAGNOSTICS_FIELD));

    private final String result;

    private final List<ValidateStateMachineDefinitionDiagnostic> diagnostics;

    private ValidateStateMachineDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.result = builder.result;
        this.diagnostics = builder.diagnostics;
    }

    /**
     * <p>
     * The result value will be <code>OK</code> when no syntax errors are found, or <code>FAIL</code> if the workflow
     * definition does not pass verification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ValidateStateMachineDefinitionResultCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #resultAsString}.
     * </p>
     * 
     * @return The result value will be <code>OK</code> when no syntax errors are found, or <code>FAIL</code> if the
     *         workflow definition does not pass verification.
     * @see ValidateStateMachineDefinitionResultCode
     */
    public final ValidateStateMachineDefinitionResultCode result() {
        return ValidateStateMachineDefinitionResultCode.fromValue(result);
    }

    /**
     * <p>
     * The result value will be <code>OK</code> when no syntax errors are found, or <code>FAIL</code> if the workflow
     * definition does not pass verification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ValidateStateMachineDefinitionResultCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #resultAsString}.
     * </p>
     * 
     * @return The result value will be <code>OK</code> when no syntax errors are found, or <code>FAIL</code> if the
     *         workflow definition does not pass verification.
     * @see ValidateStateMachineDefinitionResultCode
     */
    public final String resultAsString() {
        return result;
    }

    /**
     * For responses, this returns true if the service returned a value for the Diagnostics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDiagnostics() {
        return diagnostics != null && !(diagnostics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the result is <code>OK</code>, this field will be empty. When there are errors, this field will contain an
     * array of <b>Diagnostic</b> objects to help you troubleshoot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDiagnostics} method.
     * </p>
     * 
     * @return If the result is <code>OK</code>, this field will be empty. When there are errors, this field will
     *         contain an array of <b>Diagnostic</b> objects to help you troubleshoot.
     */
    public final List<ValidateStateMachineDefinitionDiagnostic> diagnostics() {
        return diagnostics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDiagnostics() ? diagnostics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateStateMachineDefinitionResponse)) {
            return false;
        }
        ValidateStateMachineDefinitionResponse other = (ValidateStateMachineDefinitionResponse) obj;
        return Objects.equals(resultAsString(), other.resultAsString()) && hasDiagnostics() == other.hasDiagnostics()
                && Objects.equals(diagnostics(), other.diagnostics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidateStateMachineDefinitionResponse").add("Result", resultAsString())
                .add("Diagnostics", hasDiagnostics() ? diagnostics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "result":
            return Optional.ofNullable(clazz.cast(resultAsString()));
        case "diagnostics":
            return Optional.ofNullable(clazz.cast(diagnostics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateStateMachineDefinitionResponse, T> g) {
        return obj -> g.apply((ValidateStateMachineDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ValidateStateMachineDefinitionResponse> {
        /**
         * <p>
         * The result value will be <code>OK</code> when no syntax errors are found, or <code>FAIL</code> if the
         * workflow definition does not pass verification.
         * </p>
         * 
         * @param result
         *        The result value will be <code>OK</code> when no syntax errors are found, or <code>FAIL</code> if the
         *        workflow definition does not pass verification.
         * @see ValidateStateMachineDefinitionResultCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidateStateMachineDefinitionResultCode
         */
        Builder result(String result);

        /**
         * <p>
         * The result value will be <code>OK</code> when no syntax errors are found, or <code>FAIL</code> if the
         * workflow definition does not pass verification.
         * </p>
         * 
         * @param result
         *        The result value will be <code>OK</code> when no syntax errors are found, or <code>FAIL</code> if the
         *        workflow definition does not pass verification.
         * @see ValidateStateMachineDefinitionResultCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidateStateMachineDefinitionResultCode
         */
        Builder result(ValidateStateMachineDefinitionResultCode result);

        /**
         * <p>
         * If the result is <code>OK</code>, this field will be empty. When there are errors, this field will contain an
         * array of <b>Diagnostic</b> objects to help you troubleshoot.
         * </p>
         * 
         * @param diagnostics
         *        If the result is <code>OK</code>, this field will be empty. When there are errors, this field will
         *        contain an array of <b>Diagnostic</b> objects to help you troubleshoot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diagnostics(Collection<ValidateStateMachineDefinitionDiagnostic> diagnostics);

        /**
         * <p>
         * If the result is <code>OK</code>, this field will be empty. When there are errors, this field will contain an
         * array of <b>Diagnostic</b> objects to help you troubleshoot.
         * </p>
         * 
         * @param diagnostics
         *        If the result is <code>OK</code>, this field will be empty. When there are errors, this field will
         *        contain an array of <b>Diagnostic</b> objects to help you troubleshoot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diagnostics(ValidateStateMachineDefinitionDiagnostic... diagnostics);

        /**
         * <p>
         * If the result is <code>OK</code>, this field will be empty. When there are errors, this field will contain an
         * array of <b>Diagnostic</b> objects to help you troubleshoot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionDiagnostic.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionDiagnostic#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionDiagnostic.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #diagnostics(List<ValidateStateMachineDefinitionDiagnostic>)}.
         * 
         * @param diagnostics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionDiagnostic.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diagnostics(java.util.Collection<ValidateStateMachineDefinitionDiagnostic>)
         */
        Builder diagnostics(Consumer<ValidateStateMachineDefinitionDiagnostic.Builder>... diagnostics);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private String result;

        private List<ValidateStateMachineDefinitionDiagnostic> diagnostics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateStateMachineDefinitionResponse model) {
            super(model);
            result(model.result);
            diagnostics(model.diagnostics);
        }

        public final String getResult() {
            return result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ValidateStateMachineDefinitionResultCode result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final List<ValidateStateMachineDefinitionDiagnostic.Builder> getDiagnostics() {
            List<ValidateStateMachineDefinitionDiagnostic.Builder> result = ValidateStateMachineDefinitionDiagnosticListCopier
                    .copyToBuilder(this.diagnostics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDiagnostics(Collection<ValidateStateMachineDefinitionDiagnostic.BuilderImpl> diagnostics) {
            this.diagnostics = ValidateStateMachineDefinitionDiagnosticListCopier.copyFromBuilder(diagnostics);
        }

        @Override
        public final Builder diagnostics(Collection<ValidateStateMachineDefinitionDiagnostic> diagnostics) {
            this.diagnostics = ValidateStateMachineDefinitionDiagnosticListCopier.copy(diagnostics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diagnostics(ValidateStateMachineDefinitionDiagnostic... diagnostics) {
            diagnostics(Arrays.asList(diagnostics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diagnostics(Consumer<ValidateStateMachineDefinitionDiagnostic.Builder>... diagnostics) {
            diagnostics(Stream.of(diagnostics)
                    .map(c -> ValidateStateMachineDefinitionDiagnostic.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ValidateStateMachineDefinitionResponse build() {
            return new ValidateStateMachineDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
