/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an error found during validation. Validation errors found in the definition return in the response as
 * <b>diagnostic elements</b>, rather than raise an exception.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidateStateMachineDefinitionDiagnostic implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidateStateMachineDefinitionDiagnostic.Builder, ValidateStateMachineDefinitionDiagnostic> {
    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("severity").getter(getter(ValidateStateMachineDefinitionDiagnostic::severityAsString))
            .setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(ValidateStateMachineDefinitionDiagnostic::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(ValidateStateMachineDefinitionDiagnostic::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(ValidateStateMachineDefinitionDiagnostic::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEVERITY_FIELD, CODE_FIELD,
            MESSAGE_FIELD, LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String severity;

    private final String code;

    private final String message;

    private final String location;

    private ValidateStateMachineDefinitionDiagnostic(BuilderImpl builder) {
        this.severity = builder.severity;
        this.code = builder.code;
        this.message = builder.message;
        this.location = builder.location;
    }

    /**
     * <p>
     * A value of <code>ERROR</code> means that you cannot create or update a state machine with this definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link ValidateStateMachineDefinitionSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #severityAsString}.
     * </p>
     * 
     * @return A value of <code>ERROR</code> means that you cannot create or update a state machine with this
     *         definition.
     * @see ValidateStateMachineDefinitionSeverity
     */
    public final ValidateStateMachineDefinitionSeverity severity() {
        return ValidateStateMachineDefinitionSeverity.fromValue(severity);
    }

    /**
     * <p>
     * A value of <code>ERROR</code> means that you cannot create or update a state machine with this definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link ValidateStateMachineDefinitionSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #severityAsString}.
     * </p>
     * 
     * @return A value of <code>ERROR</code> means that you cannot create or update a state machine with this
     *         definition.
     * @see ValidateStateMachineDefinitionSeverity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * Identifying code for the diagnostic.
     * </p>
     * 
     * @return Identifying code for the diagnostic.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * Message describing the diagnostic condition.
     * </p>
     * 
     * @return Message describing the diagnostic condition.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * Location of the issue in the state machine, if available.
     * </p>
     * <p>
     * For errors specific to a field, the location could be in the format:
     * <code>/States/&lt;StateName&gt;/&lt;FieldName&gt;</code>, for example: <code>/States/FailState/ErrorPath</code>.
     * </p>
     * 
     * @return Location of the issue in the state machine, if available.</p>
     *         <p>
     *         For errors specific to a field, the location could be in the format:
     *         <code>/States/&lt;StateName&gt;/&lt;FieldName&gt;</code>, for example:
     *         <code>/States/FailState/ErrorPath</code>.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateStateMachineDefinitionDiagnostic)) {
            return false;
        }
        ValidateStateMachineDefinitionDiagnostic other = (ValidateStateMachineDefinitionDiagnostic) obj;
        return Objects.equals(severityAsString(), other.severityAsString()) && Objects.equals(code(), other.code())
                && Objects.equals(message(), other.message()) && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidateStateMachineDefinitionDiagnostic").add("Severity", severityAsString())
                .add("Code", code()).add("Message", message()).add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateStateMachineDefinitionDiagnostic, T> g) {
        return obj -> g.apply((ValidateStateMachineDefinitionDiagnostic) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidateStateMachineDefinitionDiagnostic> {
        /**
         * <p>
         * A value of <code>ERROR</code> means that you cannot create or update a state machine with this definition.
         * </p>
         * 
         * @param severity
         *        A value of <code>ERROR</code> means that you cannot create or update a state machine with this
         *        definition.
         * @see ValidateStateMachineDefinitionSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidateStateMachineDefinitionSeverity
         */
        Builder severity(String severity);

        /**
         * <p>
         * A value of <code>ERROR</code> means that you cannot create or update a state machine with this definition.
         * </p>
         * 
         * @param severity
         *        A value of <code>ERROR</code> means that you cannot create or update a state machine with this
         *        definition.
         * @see ValidateStateMachineDefinitionSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidateStateMachineDefinitionSeverity
         */
        Builder severity(ValidateStateMachineDefinitionSeverity severity);

        /**
         * <p>
         * Identifying code for the diagnostic.
         * </p>
         * 
         * @param code
         *        Identifying code for the diagnostic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * Message describing the diagnostic condition.
         * </p>
         * 
         * @param message
         *        Message describing the diagnostic condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * Location of the issue in the state machine, if available.
         * </p>
         * <p>
         * For errors specific to a field, the location could be in the format:
         * <code>/States/&lt;StateName&gt;/&lt;FieldName&gt;</code>, for example:
         * <code>/States/FailState/ErrorPath</code>.
         * </p>
         * 
         * @param location
         *        Location of the issue in the state machine, if available.</p>
         *        <p>
         *        For errors specific to a field, the location could be in the format:
         *        <code>/States/&lt;StateName&gt;/&lt;FieldName&gt;</code>, for example:
         *        <code>/States/FailState/ErrorPath</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl implements Builder {
        private String severity;

        private String code;

        private String message;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateStateMachineDefinitionDiagnostic model) {
            severity(model.severity);
            code(model.code);
            message(model.message);
            location(model.location);
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(ValidateStateMachineDefinitionSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public ValidateStateMachineDefinitionDiagnostic build() {
            return new ValidateStateMachineDefinitionDiagnostic(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
