/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogDestination implements SdkPojo, Serializable, ToCopyableBuilder<LogDestination.Builder, LogDestination> {
    private static final SdkField<CloudWatchLogsLogGroup> CLOUD_WATCH_LOGS_LOG_GROUP_FIELD = SdkField
            .<CloudWatchLogsLogGroup> builder(MarshallingType.SDK_POJO).memberName("cloudWatchLogsLogGroup")
            .getter(getter(LogDestination::cloudWatchLogsLogGroup)).setter(setter(Builder::cloudWatchLogsLogGroup))
            .constructor(CloudWatchLogsLogGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogsLogGroup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CLOUD_WATCH_LOGS_LOG_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("cloudWatchLogsLogGroup", CLOUD_WATCH_LOGS_LOG_GROUP_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final CloudWatchLogsLogGroup cloudWatchLogsLogGroup;

    private LogDestination(BuilderImpl builder) {
        this.cloudWatchLogsLogGroup = builder.cloudWatchLogsLogGroup;
    }

    /**
     * <p>
     * An object describing a CloudWatch log group. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html"
     * >AWS::Logs::LogGroup</a> in the CloudFormation User Guide.
     * </p>
     * 
     * @return An object describing a CloudWatch log group. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html"
     *         >AWS::Logs::LogGroup</a> in the CloudFormation User Guide.
     */
    public final CloudWatchLogsLogGroup cloudWatchLogsLogGroup() {
        return cloudWatchLogsLogGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsLogGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogDestination)) {
            return false;
        }
        LogDestination other = (LogDestination) obj;
        return Objects.equals(cloudWatchLogsLogGroup(), other.cloudWatchLogsLogGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogDestination").add("CloudWatchLogsLogGroup", cloudWatchLogsLogGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudWatchLogsLogGroup":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsLogGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LogDestination, T> g) {
        return obj -> g.apply((LogDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogDestination> {
        /**
         * <p>
         * An object describing a CloudWatch log group. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html"
         * >AWS::Logs::LogGroup</a> in the CloudFormation User Guide.
         * </p>
         * 
         * @param cloudWatchLogsLogGroup
         *        An object describing a CloudWatch log group. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html"
         *        >AWS::Logs::LogGroup</a> in the CloudFormation User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsLogGroup(CloudWatchLogsLogGroup cloudWatchLogsLogGroup);

        /**
         * <p>
         * An object describing a CloudWatch log group. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html"
         * >AWS::Logs::LogGroup</a> in the CloudFormation User Guide.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLogsLogGroup.Builder} avoiding
         * the need to create one manually via {@link CloudWatchLogsLogGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogsLogGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudWatchLogsLogGroup(CloudWatchLogsLogGroup)}.
         * 
         * @param cloudWatchLogsLogGroup
         *        a consumer that will call methods on {@link CloudWatchLogsLogGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogsLogGroup(CloudWatchLogsLogGroup)
         */
        default Builder cloudWatchLogsLogGroup(Consumer<CloudWatchLogsLogGroup.Builder> cloudWatchLogsLogGroup) {
            return cloudWatchLogsLogGroup(CloudWatchLogsLogGroup.builder().applyMutation(cloudWatchLogsLogGroup).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudWatchLogsLogGroup cloudWatchLogsLogGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(LogDestination model) {
            cloudWatchLogsLogGroup(model.cloudWatchLogsLogGroup);
        }

        public final CloudWatchLogsLogGroup.Builder getCloudWatchLogsLogGroup() {
            return cloudWatchLogsLogGroup != null ? cloudWatchLogsLogGroup.toBuilder() : null;
        }

        public final void setCloudWatchLogsLogGroup(CloudWatchLogsLogGroup.BuilderImpl cloudWatchLogsLogGroup) {
            this.cloudWatchLogsLogGroup = cloudWatchLogsLogGroup != null ? cloudWatchLogsLogGroup.build() : null;
        }

        @Override
        public final Builder cloudWatchLogsLogGroup(CloudWatchLogsLogGroup cloudWatchLogsLogGroup) {
            this.cloudWatchLogsLogGroup = cloudWatchLogsLogGroup;
            return this;
        }

        @Override
        public LogDestination build() {
            return new LogDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
