/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a Map Run that was redriven.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MapRunRedrivenEventDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<MapRunRedrivenEventDetails.Builder, MapRunRedrivenEventDetails> {
    private static final SdkField<String> MAP_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mapRunArn").getter(getter(MapRunRedrivenEventDetails::mapRunArn)).setter(setter(Builder::mapRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapRunArn").build()).build();

    private static final SdkField<Integer> REDRIVE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("redriveCount").getter(getter(MapRunRedrivenEventDetails::redriveCount))
            .setter(setter(Builder::redriveCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redriveCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_RUN_ARN_FIELD,
            REDRIVE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("mapRunArn", MAP_RUN_ARN_FIELD);
                    put("redriveCount", REDRIVE_COUNT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String mapRunArn;

    private final Integer redriveCount;

    private MapRunRedrivenEventDetails(BuilderImpl builder) {
        this.mapRunArn = builder.mapRunArn;
        this.redriveCount = builder.redriveCount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a Map Run that was redriven.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a Map Run that was redriven.
     */
    public final String mapRunArn() {
        return mapRunArn;
    }

    /**
     * <p>
     * The number of times the Map Run has been redriven at this point in the execution's history including this event.
     * The redrive count for a redriven Map Run is always greater than 0.
     * </p>
     * 
     * @return The number of times the Map Run has been redriven at this point in the execution's history including this
     *         event. The redrive count for a redriven Map Run is always greater than 0.
     */
    public final Integer redriveCount() {
        return redriveCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mapRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(redriveCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapRunRedrivenEventDetails)) {
            return false;
        }
        MapRunRedrivenEventDetails other = (MapRunRedrivenEventDetails) obj;
        return Objects.equals(mapRunArn(), other.mapRunArn()) && Objects.equals(redriveCount(), other.redriveCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MapRunRedrivenEventDetails").add("MapRunArn", mapRunArn()).add("RedriveCount", redriveCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mapRunArn":
            return Optional.ofNullable(clazz.cast(mapRunArn()));
        case "redriveCount":
            return Optional.ofNullable(clazz.cast(redriveCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MapRunRedrivenEventDetails, T> g) {
        return obj -> g.apply((MapRunRedrivenEventDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MapRunRedrivenEventDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a Map Run that was redriven.
         * </p>
         * 
         * @param mapRunArn
         *        The Amazon Resource Name (ARN) of a Map Run that was redriven.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapRunArn(String mapRunArn);

        /**
         * <p>
         * The number of times the Map Run has been redriven at this point in the execution's history including this
         * event. The redrive count for a redriven Map Run is always greater than 0.
         * </p>
         * 
         * @param redriveCount
         *        The number of times the Map Run has been redriven at this point in the execution's history including
         *        this event. The redrive count for a redriven Map Run is always greater than 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redriveCount(Integer redriveCount);
    }

    static final class BuilderImpl implements Builder {
        private String mapRunArn;

        private Integer redriveCount;

        private BuilderImpl() {
        }

        private BuilderImpl(MapRunRedrivenEventDetails model) {
            mapRunArn(model.mapRunArn);
            redriveCount(model.redriveCount);
        }

        public final String getMapRunArn() {
            return mapRunArn;
        }

        public final void setMapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
        }

        @Override
        public final Builder mapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
            return this;
        }

        public final Integer getRedriveCount() {
            return redriveCount;
        }

        public final void setRedriveCount(Integer redriveCount) {
            this.redriveCount = redriveCount;
        }

        @Override
        public final Builder redriveCount(Integer redriveCount) {
            this.redriveCount = redriveCount;
            return this;
        }

        @Override
        public MapRunRedrivenEventDetails build() {
            return new MapRunRedrivenEventDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
