/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestStateRequest extends SfnRequest implements ToCopyableBuilder<TestStateRequest.Builder, TestStateRequest> {
    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definition").getter(getter(TestStateRequest::definition)).setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(TestStateRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(TestStateRequest::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<String> INSPECTION_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inspectionLevel").getter(getter(TestStateRequest::inspectionLevelAsString))
            .setter(setter(Builder::inspectionLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inspectionLevel").build()).build();

    private static final SdkField<Boolean> REVEAL_SECRETS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("revealSecrets").getter(getter(TestStateRequest::revealSecrets)).setter(setter(Builder::revealSecrets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revealSecrets").build()).build();

    private static final SdkField<String> VARIABLES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("variables").getter(getter(TestStateRequest::variables)).setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD,
            ROLE_ARN_FIELD, INPUT_FIELD, INSPECTION_LEVEL_FIELD, REVEAL_SECRETS_FIELD, VARIABLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String definition;

    private final String roleArn;

    private final String input;

    private final String inspectionLevel;

    private final Boolean revealSecrets;

    private final String variables;

    private TestStateRequest(BuilderImpl builder) {
        super(builder);
        this.definition = builder.definition;
        this.roleArn = builder.roleArn;
        this.input = builder.input;
        this.inspectionLevel = builder.inspectionLevel;
        this.revealSecrets = builder.revealSecrets;
        this.variables = builder.variables;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
     * States Language</a> (ASL) definition of the state.
     * </p>
     * 
     * @return The <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
     *         States Language</a> (ASL) definition of the state.
     */
    public final String definition() {
        return definition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the execution role with the required IAM permissions for the state.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the execution role with the required IAM permissions for the state.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A string that contains the JSON input data for the state.
     * </p>
     * 
     * @return A string that contains the JSON input data for the state.
     */
    public final String input() {
        return input;
    }

    /**
     * <p>
     * Determines the values to return when a state is tested. You can specify one of the following types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INFO</code>: Shows the final state output. By default, Step Functions sets <code>inspectionLevel</code> to
     * <code>INFO</code> if you don't specify a level.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEBUG</code>: Shows the final state output along with the input and output data processing result.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the final state
     * output along with the input and output data processing result.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each of these levels also provide information about the status of the state execution and the next state to
     * transition to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inspectionLevel}
     * will return {@link InspectionLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inspectionLevelAsString}.
     * </p>
     * 
     * @return Determines the values to return when a state is tested. You can specify one of the following types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INFO</code>: Shows the final state output. By default, Step Functions sets
     *         <code>inspectionLevel</code> to <code>INFO</code> if you don't specify a level.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEBUG</code>: Shows the final state output along with the input and output data processing result.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the final
     *         state output along with the input and output data processing result.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Each of these levels also provide information about the status of the state execution and the next state
     *         to transition to.
     * @see InspectionLevel
     */
    public final InspectionLevel inspectionLevel() {
        return InspectionLevel.fromValue(inspectionLevel);
    }

    /**
     * <p>
     * Determines the values to return when a state is tested. You can specify one of the following types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INFO</code>: Shows the final state output. By default, Step Functions sets <code>inspectionLevel</code> to
     * <code>INFO</code> if you don't specify a level.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEBUG</code>: Shows the final state output along with the input and output data processing result.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the final state
     * output along with the input and output data processing result.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each of these levels also provide information about the status of the state execution and the next state to
     * transition to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inspectionLevel}
     * will return {@link InspectionLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inspectionLevelAsString}.
     * </p>
     * 
     * @return Determines the values to return when a state is tested. You can specify one of the following types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INFO</code>: Shows the final state output. By default, Step Functions sets
     *         <code>inspectionLevel</code> to <code>INFO</code> if you don't specify a level.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEBUG</code>: Shows the final state output along with the input and output data processing result.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the final
     *         state output along with the input and output data processing result.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Each of these levels also provide information about the status of the state execution and the next state
     *         to transition to.
     * @see InspectionLevel
     */
    public final String inspectionLevelAsString() {
        return inspectionLevel;
    }

    /**
     * <p>
     * Specifies whether or not to include secret information in the test result. For HTTP Tasks, a secret includes the
     * data that an EventBridge connection adds to modify the HTTP request headers, query parameters, and body. Step
     * Functions doesn't omit any information included in the state definition or the HTTP response.
     * </p>
     * <p>
     * If you set <code>revealSecrets</code> to <code>true</code>, you must make sure that the IAM user that calls the
     * <code>TestState</code> API has permission for the <code>states:RevealSecrets</code> action. For an example of IAM
     * policy that sets the <code>states:RevealSecrets</code> permission, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions">IAM
     * permissions to test a state</a>. Without this permission, Step Functions throws an access denied error.
     * </p>
     * <p>
     * By default, <code>revealSecrets</code> is set to <code>false</code>.
     * </p>
     * 
     * @return Specifies whether or not to include secret information in the test result. For HTTP Tasks, a secret
     *         includes the data that an EventBridge connection adds to modify the HTTP request headers, query
     *         parameters, and body. Step Functions doesn't omit any information included in the state definition or the
     *         HTTP response.</p>
     *         <p>
     *         If you set <code>revealSecrets</code> to <code>true</code>, you must make sure that the IAM user that
     *         calls the <code>TestState</code> API has permission for the <code>states:RevealSecrets</code> action. For
     *         an example of IAM policy that sets the <code>states:RevealSecrets</code> permission, see <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions"
     *         >IAM permissions to test a state</a>. Without this permission, Step Functions throws an access denied
     *         error.
     *         </p>
     *         <p>
     *         By default, <code>revealSecrets</code> is set to <code>false</code>.
     */
    public final Boolean revealSecrets() {
        return revealSecrets;
    }

    /**
     * <p>
     * JSON object literal that sets variables used in the state under test. Object keys are the variable names and
     * values are the variable values.
     * </p>
     * 
     * @return JSON object literal that sets variables used in the state under test. Object keys are the variable names
     *         and values are the variable values.
     */
    public final String variables() {
        return variables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(inspectionLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(revealSecrets());
        hashCode = 31 * hashCode + Objects.hashCode(variables());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestStateRequest)) {
            return false;
        }
        TestStateRequest other = (TestStateRequest) obj;
        return Objects.equals(definition(), other.definition()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(input(), other.input())
                && Objects.equals(inspectionLevelAsString(), other.inspectionLevelAsString())
                && Objects.equals(revealSecrets(), other.revealSecrets()) && Objects.equals(variables(), other.variables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestStateRequest")
                .add("Definition", definition() == null ? null : "*** Sensitive Data Redacted ***").add("RoleArn", roleArn())
                .add("Input", input() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InspectionLevel", inspectionLevelAsString()).add("RevealSecrets", revealSecrets())
                .add("Variables", variables() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "inspectionLevel":
            return Optional.ofNullable(clazz.cast(inspectionLevelAsString()));
        case "revealSecrets":
            return Optional.ofNullable(clazz.cast(revealSecrets()));
        case "variables":
            return Optional.ofNullable(clazz.cast(variables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("definition", DEFINITION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("input", INPUT_FIELD);
        map.put("inspectionLevel", INSPECTION_LEVEL_FIELD);
        map.put("revealSecrets", REVEAL_SECRETS_FIELD);
        map.put("variables", VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestStateRequest, T> g) {
        return obj -> g.apply((TestStateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestStateRequest> {
        /**
         * <p>
         * The <a
         * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
         * States Language</a> (ASL) definition of the state.
         * </p>
         * 
         * @param definition
         *        The <a
         *        href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html"
         *        >Amazon States Language</a> (ASL) definition of the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the execution role with the required IAM permissions for the state.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the execution role with the required IAM permissions for the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A string that contains the JSON input data for the state.
         * </p>
         * 
         * @param input
         *        A string that contains the JSON input data for the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * Determines the values to return when a state is tested. You can specify one of the following types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INFO</code>: Shows the final state output. By default, Step Functions sets <code>inspectionLevel</code>
         * to <code>INFO</code> if you don't specify a level.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEBUG</code>: Shows the final state output along with the input and output data processing result.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the final
         * state output along with the input and output data processing result.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Each of these levels also provide information about the status of the state execution and the next state to
         * transition to.
         * </p>
         * 
         * @param inspectionLevel
         *        Determines the values to return when a state is tested. You can specify one of the following
         *        types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INFO</code>: Shows the final state output. By default, Step Functions sets
         *        <code>inspectionLevel</code> to <code>INFO</code> if you don't specify a level.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEBUG</code>: Shows the final state output along with the input and output data processing
         *        result.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the
         *        final state output along with the input and output data processing result.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Each of these levels also provide information about the status of the state execution and the next
         *        state to transition to.
         * @see InspectionLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InspectionLevel
         */
        Builder inspectionLevel(String inspectionLevel);

        /**
         * <p>
         * Determines the values to return when a state is tested. You can specify one of the following types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INFO</code>: Shows the final state output. By default, Step Functions sets <code>inspectionLevel</code>
         * to <code>INFO</code> if you don't specify a level.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEBUG</code>: Shows the final state output along with the input and output data processing result.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the final
         * state output along with the input and output data processing result.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Each of these levels also provide information about the status of the state execution and the next state to
         * transition to.
         * </p>
         * 
         * @param inspectionLevel
         *        Determines the values to return when a state is tested. You can specify one of the following
         *        types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INFO</code>: Shows the final state output. By default, Step Functions sets
         *        <code>inspectionLevel</code> to <code>INFO</code> if you don't specify a level.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEBUG</code>: Shows the final state output along with the input and output data processing
         *        result.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the
         *        final state output along with the input and output data processing result.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Each of these levels also provide information about the status of the state execution and the next
         *        state to transition to.
         * @see InspectionLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InspectionLevel
         */
        Builder inspectionLevel(InspectionLevel inspectionLevel);

        /**
         * <p>
         * Specifies whether or not to include secret information in the test result. For HTTP Tasks, a secret includes
         * the data that an EventBridge connection adds to modify the HTTP request headers, query parameters, and body.
         * Step Functions doesn't omit any information included in the state definition or the HTTP response.
         * </p>
         * <p>
         * If you set <code>revealSecrets</code> to <code>true</code>, you must make sure that the IAM user that calls
         * the <code>TestState</code> API has permission for the <code>states:RevealSecrets</code> action. For an
         * example of IAM policy that sets the <code>states:RevealSecrets</code> permission, see <a href=
         * "https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions">IAM
         * permissions to test a state</a>. Without this permission, Step Functions throws an access denied error.
         * </p>
         * <p>
         * By default, <code>revealSecrets</code> is set to <code>false</code>.
         * </p>
         * 
         * @param revealSecrets
         *        Specifies whether or not to include secret information in the test result. For HTTP Tasks, a secret
         *        includes the data that an EventBridge connection adds to modify the HTTP request headers, query
         *        parameters, and body. Step Functions doesn't omit any information included in the state definition or
         *        the HTTP response.</p>
         *        <p>
         *        If you set <code>revealSecrets</code> to <code>true</code>, you must make sure that the IAM user that
         *        calls the <code>TestState</code> API has permission for the <code>states:RevealSecrets</code> action.
         *        For an example of IAM policy that sets the <code>states:RevealSecrets</code> permission, see <a href=
         *        "https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions"
         *        >IAM permissions to test a state</a>. Without this permission, Step Functions throws an access denied
         *        error.
         *        </p>
         *        <p>
         *        By default, <code>revealSecrets</code> is set to <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revealSecrets(Boolean revealSecrets);

        /**
         * <p>
         * JSON object literal that sets variables used in the state under test. Object keys are the variable names and
         * values are the variable values.
         * </p>
         * 
         * @param variables
         *        JSON object literal that sets variables used in the state under test. Object keys are the variable
         *        names and values are the variable values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(String variables);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SfnRequest.BuilderImpl implements Builder {
        private String definition;

        private String roleArn;

        private String input;

        private String inspectionLevel;

        private Boolean revealSecrets;

        private String variables;

        private BuilderImpl() {
        }

        private BuilderImpl(TestStateRequest model) {
            super(model);
            definition(model.definition);
            roleArn(model.roleArn);
            input(model.input);
            inspectionLevel(model.inspectionLevel);
            revealSecrets(model.revealSecrets);
            variables(model.variables);
        }

        public final String getDefinition() {
            return definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final String getInspectionLevel() {
            return inspectionLevel;
        }

        public final void setInspectionLevel(String inspectionLevel) {
            this.inspectionLevel = inspectionLevel;
        }

        @Override
        public final Builder inspectionLevel(String inspectionLevel) {
            this.inspectionLevel = inspectionLevel;
            return this;
        }

        @Override
        public final Builder inspectionLevel(InspectionLevel inspectionLevel) {
            this.inspectionLevel(inspectionLevel == null ? null : inspectionLevel.toString());
            return this;
        }

        public final Boolean getRevealSecrets() {
            return revealSecrets;
        }

        public final void setRevealSecrets(Boolean revealSecrets) {
            this.revealSecrets = revealSecrets;
        }

        @Override
        public final Builder revealSecrets(Boolean revealSecrets) {
            this.revealSecrets = revealSecrets;
            return this;
        }

        public final String getVariables() {
            return variables;
        }

        public final void setVariables(String variables) {
            this.variables = variables;
        }

        @Override
        public final Builder variables(String variables) {
            this.variables = variables;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestStateRequest build() {
            return new TestStateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
