/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.InspectionData;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.services.sfn.model.TestExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestStateResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, TestStateResponse> {
    private static final SdkField<String> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("output").getter(TestStateResponse.getter(TestStateResponse::output)).setter(TestStateResponse.setter(Builder::output)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("error").getter(TestStateResponse.getter(TestStateResponse::error)).setter(TestStateResponse.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<String> CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cause").getter(TestStateResponse.getter(TestStateResponse::cause)).setter(TestStateResponse.setter(Builder::cause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()}).build();
    private static final SdkField<InspectionData> INSPECTION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inspectionData").getter(TestStateResponse.getter(TestStateResponse::inspectionData)).setter(TestStateResponse.setter(Builder::inspectionData)).constructor(InspectionData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inspectionData").build()}).build();
    private static final SdkField<String> NEXT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextState").getter(TestStateResponse.getter(TestStateResponse::nextState)).setter(TestStateResponse.setter(Builder::nextState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextState").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TestStateResponse.getter(TestStateResponse::statusAsString)).setter(TestStateResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_FIELD, ERROR_FIELD, CAUSE_FIELD, INSPECTION_DATA_FIELD, NEXT_STATE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestStateResponse.memberNameToFieldInitializer();
    private final String output;
    private final String error;
    private final String causeValue;
    private final InspectionData inspectionData;
    private final String nextState;
    private final String status;

    private TestStateResponse(BuilderImpl builder) {
        super(builder);
        this.output = builder.output;
        this.error = builder.error;
        this.causeValue = builder.causeValue;
        this.inspectionData = builder.inspectionData;
        this.nextState = builder.nextState;
        this.status = builder.status;
    }

    public final String output() {
        return this.output;
    }

    public final String error() {
        return this.error;
    }

    public final String cause() {
        return this.causeValue;
    }

    public final InspectionData inspectionData() {
        return this.inspectionData;
    }

    public final String nextState() {
        return this.nextState;
    }

    public final TestExecutionStatus status() {
        return TestExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.cause());
        hashCode = 31 * hashCode + Objects.hashCode(this.inspectionData());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextState());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestStateResponse)) {
            return false;
        }
        TestStateResponse other = (TestStateResponse)((Object)obj);
        return Objects.equals(this.output(), other.output()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.cause(), other.cause()) && Objects.equals(this.inspectionData(), other.inspectionData()) && Objects.equals(this.nextState(), other.nextState()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TestStateResponse").add("Output", (Object)(this.output() == null ? null : "*** Sensitive Data Redacted ***")).add("Error", (Object)(this.error() == null ? null : "*** Sensitive Data Redacted ***")).add("Cause", (Object)(this.cause() == null ? null : "*** Sensitive Data Redacted ***")).add("InspectionData", (Object)(this.inspectionData() == null ? null : "*** Sensitive Data Redacted ***")).add("NextState", (Object)this.nextState()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "cause": {
                return Optional.ofNullable(clazz.cast(this.cause()));
            }
            case "inspectionData": {
                return Optional.ofNullable(clazz.cast(this.inspectionData()));
            }
            case "nextState": {
                return Optional.ofNullable(clazz.cast(this.nextState()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("output", OUTPUT_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("cause", CAUSE_FIELD);
        map.put("inspectionData", INSPECTION_DATA_FIELD);
        map.put("nextState", NEXT_STATE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestStateResponse, T> g) {
        return obj -> g.apply((TestStateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private String output;
        private String error;
        private String causeValue;
        private InspectionData inspectionData;
        private String nextState;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(TestStateResponse model) {
            super(model);
            this.output(model.output);
            this.error(model.error);
            this.cause(model.causeValue);
            this.inspectionData(model.inspectionData);
            this.nextState(model.nextState);
            this.status(model.status);
        }

        public final String getOutput() {
            return this.output;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getCause() {
            return this.causeValue;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        public final InspectionData.Builder getInspectionData() {
            return this.inspectionData != null ? this.inspectionData.toBuilder() : null;
        }

        public final void setInspectionData(InspectionData.BuilderImpl inspectionData) {
            this.inspectionData = inspectionData != null ? inspectionData.build() : null;
        }

        @Override
        public final Builder inspectionData(InspectionData inspectionData) {
            this.inspectionData = inspectionData;
            return this;
        }

        public final String getNextState() {
            return this.nextState;
        }

        public final void setNextState(String nextState) {
            this.nextState = nextState;
        }

        @Override
        public final Builder nextState(String nextState) {
            this.nextState = nextState;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public TestStateResponse build() {
            return new TestStateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestStateResponse> {
        public Builder output(String var1);

        public Builder error(String var1);

        public Builder cause(String var1);

        public Builder inspectionData(InspectionData var1);

        default public Builder inspectionData(Consumer<InspectionData.Builder> inspectionData) {
            return this.inspectionData((InspectionData)((InspectionData.Builder)InspectionData.builder().applyMutation(inspectionData)).build());
        }

        public Builder nextState(String var1);

        public Builder status(String var1);

        public Builder status(TestExecutionStatus var1);
    }
}

