/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExecutionHistoryRequest extends SfnRequest implements
        ToCopyableBuilder<GetExecutionHistoryRequest.Builder, GetExecutionHistoryRequest> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionArn").getter(getter(GetExecutionHistoryRequest::executionArn))
            .setter(setter(Builder::executionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetExecutionHistoryRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("reverseOrder").getter(getter(GetExecutionHistoryRequest::reverseOrder))
            .setter(setter(Builder::reverseOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reverseOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetExecutionHistoryRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Boolean> INCLUDE_EXECUTION_DATA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeExecutionData").getter(getter(GetExecutionHistoryRequest::includeExecutionData))
            .setter(setter(Builder::includeExecutionData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeExecutionData").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD,
            MAX_RESULTS_FIELD, REVERSE_ORDER_FIELD, NEXT_TOKEN_FIELD, INCLUDE_EXECUTION_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String executionArn;

    private final Integer maxResults;

    private final Boolean reverseOrder;

    private final String nextToken;

    private final Boolean includeExecutionData;

    private GetExecutionHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.executionArn = builder.executionArn;
        this.maxResults = builder.maxResults;
        this.reverseOrder = builder.reverseOrder;
        this.nextToken = builder.nextToken;
        this.includeExecutionData = builder.includeExecutionData;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the execution.
     */
    public final String executionArn() {
        return executionArn;
    }

    /**
     * <p>
     * The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further
     * pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.
     * </p>
     * <p>
     * This is only an upper limit. The actual number of results returned per call might be fewer than the specified
     * maximum.
     * </p>
     * 
     * @return The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain
     *         further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses
     *         the default.</p>
     *         <p>
     *         This is only an upper limit. The actual number of results returned per call might be fewer than the
     *         specified maximum.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Lists events in descending order of their <code>timeStamp</code>.
     * </p>
     * 
     * @return Lists events in descending order of their <code>timeStamp</code>.
     */
    public final Boolean reverseOrder() {
        return reverseOrder;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * 
     * @return If <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after
     *         24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * You can select whether execution data (input or output of a history event) is returned. The default is
     * <code>true</code>.
     * </p>
     * 
     * @return You can select whether execution data (input or output of a history event) is returned. The default is
     *         <code>true</code>.
     */
    public final Boolean includeExecutionData() {
        return includeExecutionData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(reverseOrder());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(includeExecutionData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExecutionHistoryRequest)) {
            return false;
        }
        GetExecutionHistoryRequest other = (GetExecutionHistoryRequest) obj;
        return Objects.equals(executionArn(), other.executionArn()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(reverseOrder(), other.reverseOrder()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(includeExecutionData(), other.includeExecutionData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExecutionHistoryRequest").add("ExecutionArn", executionArn()).add("MaxResults", maxResults())
                .add("ReverseOrder", reverseOrder()).add("NextToken", nextToken())
                .add("IncludeExecutionData", includeExecutionData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionArn":
            return Optional.ofNullable(clazz.cast(executionArn()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "reverseOrder":
            return Optional.ofNullable(clazz.cast(reverseOrder()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "includeExecutionData":
            return Optional.ofNullable(clazz.cast(includeExecutionData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionArn", EXECUTION_ARN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("reverseOrder", REVERSE_ORDER_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("includeExecutionData", INCLUDE_EXECUTION_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetExecutionHistoryRequest, T> g) {
        return obj -> g.apply((GetExecutionHistoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetExecutionHistoryRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the execution.
         * </p>
         * 
         * @param executionArn
         *        The Amazon Resource Name (ARN) of the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionArn(String executionArn);

        /**
         * <p>
         * The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain
         * further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the
         * default.
         * </p>
         * <p>
         * This is only an upper limit. The actual number of results returned per call might be fewer than the specified
         * maximum.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain
         *        further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0
         *        uses the default.</p>
         *        <p>
         *        This is only an upper limit. The actual number of results returned per call might be fewer than the
         *        specified maximum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Lists events in descending order of their <code>timeStamp</code>.
         * </p>
         * 
         * @param reverseOrder
         *        Lists events in descending order of their <code>timeStamp</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reverseOrder(Boolean reverseOrder);

        /**
         * <p>
         * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired
         * pagination token will return an <i>HTTP 400 InvalidToken</i> error.
         * </p>
         * 
         * @param nextToken
         *        If <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
         *        expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * You can select whether execution data (input or output of a history event) is returned. The default is
         * <code>true</code>.
         * </p>
         * 
         * @param includeExecutionData
         *        You can select whether execution data (input or output of a history event) is returned. The default is
         *        <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeExecutionData(Boolean includeExecutionData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SfnRequest.BuilderImpl implements Builder {
        private String executionArn;

        private Integer maxResults;

        private Boolean reverseOrder;

        private String nextToken;

        private Boolean includeExecutionData;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExecutionHistoryRequest model) {
            super(model);
            executionArn(model.executionArn);
            maxResults(model.maxResults);
            reverseOrder(model.reverseOrder);
            nextToken(model.nextToken);
            includeExecutionData(model.includeExecutionData);
        }

        public final String getExecutionArn() {
            return executionArn;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getReverseOrder() {
            return reverseOrder;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getIncludeExecutionData() {
            return includeExecutionData;
        }

        public final void setIncludeExecutionData(Boolean includeExecutionData) {
            this.includeExecutionData = includeExecutionData;
        }

        @Override
        public final Builder includeExecutionData(Boolean includeExecutionData) {
            this.includeExecutionData = includeExecutionData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetExecutionHistoryRequest build() {
            return new GetExecutionHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
