/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendTaskSuccessRequest extends SfnRequest implements
        ToCopyableBuilder<SendTaskSuccessRequest.Builder, SendTaskSuccessRequest> {
    private static final SdkField<String> TASK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskToken").getter(getter(SendTaskSuccessRequest::taskToken)).setter(setter(Builder::taskToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskToken").build()).build();

    private static final SdkField<String> OUTPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("output")
            .getter(getter(SendTaskSuccessRequest::output)).setter(setter(Builder::output))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TASK_TOKEN_FIELD, OUTPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String taskToken;

    private final String output;

    private SendTaskSuccessRequest(BuilderImpl builder) {
        super(builder);
        this.taskToken = builder.taskToken;
        this.output = builder.output;
    }

    /**
     * <p>
     * The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a
     * worker, or in the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a>
     * when a workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.
     * </p>
     * 
     * @return The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned
     *         to a worker, or in the <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context
     *         object</a> when a workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.
     */
    public final String taskToken() {
        return taskToken;
    }

    /**
     * <p>
     * The JSON output of the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8
     * encoding.
     * </p>
     * 
     * @return The JSON output of the task. Length constraints apply to the payload size, and are expressed as bytes in
     *         UTF-8 encoding.
     */
    public final String output() {
        return output;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskToken());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendTaskSuccessRequest)) {
            return false;
        }
        SendTaskSuccessRequest other = (SendTaskSuccessRequest) obj;
        return Objects.equals(taskToken(), other.taskToken()) && Objects.equals(output(), other.output());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendTaskSuccessRequest").add("TaskToken", taskToken())
                .add("Output", output() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskToken":
            return Optional.ofNullable(clazz.cast(taskToken()));
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taskToken", TASK_TOKEN_FIELD);
        map.put("output", OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendTaskSuccessRequest, T> g) {
        return obj -> g.apply((SendTaskSuccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendTaskSuccessRequest> {
        /**
         * <p>
         * The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a
         * worker, or in the <a
         * href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context
         * object</a> when a workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.
         * </p>
         * 
         * @param taskToken
         *        The token that represents this task. Task tokens are generated by Step Functions when tasks are
         *        assigned to a worker, or in the <a
         *        href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context
         *        object</a> when a workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskToken(String taskToken);

        /**
         * <p>
         * The JSON output of the task. Length constraints apply to the payload size, and are expressed as bytes in
         * UTF-8 encoding.
         * </p>
         * 
         * @param output
         *        The JSON output of the task. Length constraints apply to the payload size, and are expressed as bytes
         *        in UTF-8 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(String output);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SfnRequest.BuilderImpl implements Builder {
        private String taskToken;

        private String output;

        private BuilderImpl() {
        }

        private BuilderImpl(SendTaskSuccessRequest model) {
            super(model);
            taskToken(model.taskToken);
            output(model.output);
        }

        public final String getTaskToken() {
            return taskToken;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final String getOutput() {
            return output;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendTaskSuccessRequest build() {
            return new SendTaskSuccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
