/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a specific state machine version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StateMachineVersionListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<StateMachineVersionListItem.Builder, StateMachineVersionListItem> {
    private static final SdkField<String> STATE_MACHINE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineVersionArn").getter(getter(StateMachineVersionListItem::stateMachineVersionArn))
            .setter(setter(Builder::stateMachineVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineVersionArn").build())
            .build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(StateMachineVersionListItem::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STATE_MACHINE_VERSION_ARN_FIELD, CREATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stateMachineVersionArn;

    private final Instant creationDate;

    private StateMachineVersionListItem(BuilderImpl builder) {
        this.stateMachineVersionArn = builder.stateMachineVersionArn;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies a state machine version. The version ARN is a combination of state
     * machine ARN and the version number separated by a colon (:). For example, <code>stateMachineARN:1</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies a state machine version. The version ARN is a combination
     *         of state machine ARN and the version number separated by a colon (:). For example,
     *         <code>stateMachineARN:1</code>.
     */
    public final String stateMachineVersionArn() {
        return stateMachineVersionArn;
    }

    /**
     * <p>
     * The creation date of a state machine version.
     * </p>
     * 
     * @return The creation date of a state machine version.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StateMachineVersionListItem)) {
            return false;
        }
        StateMachineVersionListItem other = (StateMachineVersionListItem) obj;
        return Objects.equals(stateMachineVersionArn(), other.stateMachineVersionArn())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StateMachineVersionListItem").add("StateMachineVersionArn", stateMachineVersionArn())
                .add("CreationDate", creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateMachineVersionArn":
            return Optional.ofNullable(clazz.cast(stateMachineVersionArn()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stateMachineVersionArn", STATE_MACHINE_VERSION_ARN_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StateMachineVersionListItem, T> g) {
        return obj -> g.apply((StateMachineVersionListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StateMachineVersionListItem> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies a state machine version. The version ARN is a combination of
         * state machine ARN and the version number separated by a colon (:). For example,
         * <code>stateMachineARN:1</code>.
         * </p>
         * 
         * @param stateMachineVersionArn
         *        The Amazon Resource Name (ARN) that identifies a state machine version. The version ARN is a
         *        combination of state machine ARN and the version number separated by a colon (:). For example,
         *        <code>stateMachineARN:1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineVersionArn(String stateMachineVersionArn);

        /**
         * <p>
         * The creation date of a state machine version.
         * </p>
         * 
         * @param creationDate
         *        The creation date of a state machine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String stateMachineVersionArn;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(StateMachineVersionListItem model) {
            stateMachineVersionArn(model.stateMachineVersionArn);
            creationDate(model.creationDate);
        }

        public final String getStateMachineVersionArn() {
            return stateMachineVersionArn;
        }

        public final void setStateMachineVersionArn(String stateMachineVersionArn) {
            this.stateMachineVersionArn = stateMachineVersionArn;
        }

        @Override
        public final Builder stateMachineVersionArn(String stateMachineVersionArn) {
            this.stateMachineVersionArn = stateMachineVersionArn;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public StateMachineVersionListItem build() {
            return new StateMachineVersionListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
