/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublishStateMachineVersionRequest extends SfnRequest implements
        ToCopyableBuilder<PublishStateMachineVersionRequest.Builder, PublishStateMachineVersionRequest> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineArn").getter(getter(PublishStateMachineVersionRequest::stateMachineArn))
            .setter(setter(Builder::stateMachineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(PublishStateMachineVersionRequest::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(PublishStateMachineVersionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD,
            REVISION_ID_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stateMachineArn;

    private final String revisionId;

    private final String description;

    private PublishStateMachineVersionRequest(BuilderImpl builder) {
        super(builder);
        this.stateMachineArn = builder.stateMachineArn;
        this.revisionId = builder.revisionId;
        this.description = builder.description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the state machine.
     */
    public final String stateMachineArn() {
        return stateMachineArn;
    }

    /**
     * <p>
     * Only publish the state machine version if the current state machine's revision ID matches the specified ID.
     * </p>
     * <p>
     * Use this option to avoid publishing a version if the state machine changed since you last updated it. If the
     * specified revision ID doesn't match the state machine's current revision ID, the API returns
     * <code>ConflictException</code>.
     * </p>
     * <note>
     * <p>
     * To specify an initial revision ID for a state machine with no revision ID assigned, specify the string
     * <code>INITIAL</code> for the <code>revisionId</code> parameter. For example, you can specify a
     * <code>revisionID</code> of <code>INITIAL</code> when you create a state machine using the
     * <a>CreateStateMachine</a> API action.
     * </p>
     * </note>
     * 
     * @return Only publish the state machine version if the current state machine's revision ID matches the specified
     *         ID.</p>
     *         <p>
     *         Use this option to avoid publishing a version if the state machine changed since you last updated it. If
     *         the specified revision ID doesn't match the state machine's current revision ID, the API returns
     *         <code>ConflictException</code>.
     *         </p>
     *         <note>
     *         <p>
     *         To specify an initial revision ID for a state machine with no revision ID assigned, specify the string
     *         <code>INITIAL</code> for the <code>revisionId</code> parameter. For example, you can specify a
     *         <code>revisionID</code> of <code>INITIAL</code> when you create a state machine using the
     *         <a>CreateStateMachine</a> API action.
     *         </p>
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * An optional description of the state machine version.
     * </p>
     * 
     * @return An optional description of the state machine version.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishStateMachineVersionRequest)) {
            return false;
        }
        PublishStateMachineVersionRequest other = (PublishStateMachineVersionRequest) obj;
        return Objects.equals(stateMachineArn(), other.stateMachineArn()) && Objects.equals(revisionId(), other.revisionId())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublishStateMachineVersionRequest").add("StateMachineArn", stateMachineArn())
                .add("RevisionId", revisionId())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateMachineArn":
            return Optional.ofNullable(clazz.cast(stateMachineArn()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stateMachineArn", STATE_MACHINE_ARN_FIELD);
        map.put("revisionId", REVISION_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PublishStateMachineVersionRequest, T> g) {
        return obj -> g.apply((PublishStateMachineVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnRequest.Builder, SdkPojo, CopyableBuilder<Builder, PublishStateMachineVersionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the state machine.
         * </p>
         * 
         * @param stateMachineArn
         *        The Amazon Resource Name (ARN) of the state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineArn(String stateMachineArn);

        /**
         * <p>
         * Only publish the state machine version if the current state machine's revision ID matches the specified ID.
         * </p>
         * <p>
         * Use this option to avoid publishing a version if the state machine changed since you last updated it. If the
         * specified revision ID doesn't match the state machine's current revision ID, the API returns
         * <code>ConflictException</code>.
         * </p>
         * <note>
         * <p>
         * To specify an initial revision ID for a state machine with no revision ID assigned, specify the string
         * <code>INITIAL</code> for the <code>revisionId</code> parameter. For example, you can specify a
         * <code>revisionID</code> of <code>INITIAL</code> when you create a state machine using the
         * <a>CreateStateMachine</a> API action.
         * </p>
         * </note>
         * 
         * @param revisionId
         *        Only publish the state machine version if the current state machine's revision ID matches the
         *        specified ID.</p>
         *        <p>
         *        Use this option to avoid publishing a version if the state machine changed since you last updated it.
         *        If the specified revision ID doesn't match the state machine's current revision ID, the API returns
         *        <code>ConflictException</code>.
         *        </p>
         *        <note>
         *        <p>
         *        To specify an initial revision ID for a state machine with no revision ID assigned, specify the string
         *        <code>INITIAL</code> for the <code>revisionId</code> parameter. For example, you can specify a
         *        <code>revisionID</code> of <code>INITIAL</code> when you create a state machine using the
         *        <a>CreateStateMachine</a> API action.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * An optional description of the state machine version.
         * </p>
         * 
         * @param description
         *        An optional description of the state machine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SfnRequest.BuilderImpl implements Builder {
        private String stateMachineArn;

        private String revisionId;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishStateMachineVersionRequest model) {
            super(model);
            stateMachineArn(model.stateMachineArn);
            revisionId(model.revisionId);
            description(model.description);
        }

        public final String getStateMachineArn() {
            return stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishStateMachineVersionRequest build() {
            return new PublishStateMachineVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
