/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The KMS key is not in valid state, for example: Disabled or Deleted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KmsInvalidStateException extends SfnException implements
        ToCopyableBuilder<KmsInvalidStateException.Builder, KmsInvalidStateException> {
    private static final SdkField<String> KMS_KEY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyState").getter(getter(KmsInvalidStateException::kmsKeyStateAsString))
            .setter(setter(Builder::kmsKeyState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String kmsKeyState;

    private KmsInvalidStateException(BuilderImpl builder) {
        super(builder);
        this.kmsKeyState = builder.kmsKeyState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * Current status of the KMS; key. For example: <code>DISABLED</code>, <code>PENDING_DELETION</code>,
     * <code>PENDING_IMPORT</code>, <code>UNAVAILABLE</code>, <code>CREATING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kmsKeyState} will
     * return {@link KmsKeyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kmsKeyStateAsString}.
     * </p>
     * 
     * @return Current status of the KMS; key. For example: <code>DISABLED</code>, <code>PENDING_DELETION</code>,
     *         <code>PENDING_IMPORT</code>, <code>UNAVAILABLE</code>, <code>CREATING</code>.
     * @see KmsKeyState
     */
    public KmsKeyState kmsKeyState() {
        return KmsKeyState.fromValue(kmsKeyState);
    }

    /**
     * <p>
     * Current status of the KMS; key. For example: <code>DISABLED</code>, <code>PENDING_DELETION</code>,
     * <code>PENDING_IMPORT</code>, <code>UNAVAILABLE</code>, <code>CREATING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kmsKeyState} will
     * return {@link KmsKeyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kmsKeyStateAsString}.
     * </p>
     * 
     * @return Current status of the KMS; key. For example: <code>DISABLED</code>, <code>PENDING_DELETION</code>,
     *         <code>PENDING_IMPORT</code>, <code>UNAVAILABLE</code>, <code>CREATING</code>.
     * @see KmsKeyState
     */
    public String kmsKeyStateAsString() {
        return kmsKeyState;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("kmsKeyState", KMS_KEY_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KmsInvalidStateException, T> g) {
        return obj -> g.apply((KmsInvalidStateException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KmsInvalidStateException>, SfnException.Builder {
        /**
         * <p>
         * Current status of the KMS; key. For example: <code>DISABLED</code>, <code>PENDING_DELETION</code>,
         * <code>PENDING_IMPORT</code>, <code>UNAVAILABLE</code>, <code>CREATING</code>.
         * </p>
         * 
         * @param kmsKeyState
         *        Current status of the KMS; key. For example: <code>DISABLED</code>, <code>PENDING_DELETION</code>,
         *        <code>PENDING_IMPORT</code>, <code>UNAVAILABLE</code>, <code>CREATING</code>.
         * @see KmsKeyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KmsKeyState
         */
        Builder kmsKeyState(String kmsKeyState);

        /**
         * <p>
         * Current status of the KMS; key. For example: <code>DISABLED</code>, <code>PENDING_DELETION</code>,
         * <code>PENDING_IMPORT</code>, <code>UNAVAILABLE</code>, <code>CREATING</code>.
         * </p>
         * 
         * @param kmsKeyState
         *        Current status of the KMS; key. For example: <code>DISABLED</code>, <code>PENDING_DELETION</code>,
         *        <code>PENDING_IMPORT</code>, <code>UNAVAILABLE</code>, <code>CREATING</code>.
         * @see KmsKeyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KmsKeyState
         */
        Builder kmsKeyState(KmsKeyState kmsKeyState);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);

        @Override
        Builder numAttempts(Integer numAttempts);
    }

    static final class BuilderImpl extends SfnException.BuilderImpl implements Builder {
        private String kmsKeyState;

        private BuilderImpl() {
        }

        private BuilderImpl(KmsInvalidStateException model) {
            super(model);
            kmsKeyState(model.kmsKeyState);
        }

        public final String getKmsKeyState() {
            return kmsKeyState;
        }

        public final void setKmsKeyState(String kmsKeyState) {
            this.kmsKeyState = kmsKeyState;
        }

        @Override
        public final Builder kmsKeyState(String kmsKeyState) {
            this.kmsKeyState = kmsKeyState;
            return this;
        }

        @Override
        public final Builder kmsKeyState(KmsKeyState kmsKeyState) {
            this.kmsKeyState(kmsKeyState == null ? null : kmsKeyState.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public KmsInvalidStateException build() {
            return new KmsInvalidStateException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
