/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStateMachineResponse extends SfnResponse implements
        ToCopyableBuilder<CreateStateMachineResponse.Builder, CreateStateMachineResponse> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStateMachineResponse::stateMachineArn)).setter(setter(Builder::stateMachineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateStateMachineResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD,
            CREATION_DATE_FIELD));

    private final String stateMachineArn;

    private final Instant creationDate;

    private CreateStateMachineResponse(BuilderImpl builder) {
        super(builder);
        this.stateMachineArn = builder.stateMachineArn;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the created state machine.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the created state machine.
     */
    public String stateMachineArn() {
        return stateMachineArn;
    }

    /**
     * <p>
     * The date the state machine is created.
     * </p>
     * 
     * @return The date the state machine is created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStateMachineResponse)) {
            return false;
        }
        CreateStateMachineResponse other = (CreateStateMachineResponse) obj;
        return Objects.equals(stateMachineArn(), other.stateMachineArn()) && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateStateMachineResponse").add("StateMachineArn", stateMachineArn())
                .add("CreationDate", creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateMachineArn":
            return Optional.ofNullable(clazz.cast(stateMachineArn()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStateMachineResponse, T> g) {
        return obj -> g.apply((CreateStateMachineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateStateMachineResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the created state machine.
         * </p>
         * 
         * @param stateMachineArn
         *        The Amazon Resource Name (ARN) that identifies the created state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineArn(String stateMachineArn);

        /**
         * <p>
         * The date the state machine is created.
         * </p>
         * 
         * @param creationDate
         *        The date the state machine is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private String stateMachineArn;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStateMachineResponse model) {
            super(model);
            stateMachineArn(model.stateMachineArn);
            creationDate(model.creationDate);
        }

        public final String getStateMachineArn() {
            return stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public CreateStateMachineResponse build() {
            return new CreateStateMachineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
