/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a lambda function scheduled during an execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaFunctionScheduledEventDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaFunctionScheduledEventDetails.Builder, LambdaFunctionScheduledEventDetails> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaFunctionScheduledEventDetails::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaFunctionScheduledEventDetails::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<Long> TIMEOUT_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(LambdaFunctionScheduledEventDetails::timeoutInSeconds)).setter(setter(Builder::timeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, INPUT_FIELD,
            TIMEOUT_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resource;

    private final String input;

    private final Long timeoutInSeconds;

    private LambdaFunctionScheduledEventDetails(BuilderImpl builder) {
        this.resource = builder.resource;
        this.input = builder.input;
        this.timeoutInSeconds = builder.timeoutInSeconds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the scheduled lambda function.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the scheduled lambda function.
     */
    public String resource() {
        return resource;
    }

    /**
     * <p>
     * The JSON data input to the lambda function.
     * </p>
     * 
     * @return The JSON data input to the lambda function.
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * The maximum allowed duration of the lambda function.
     * </p>
     * 
     * @return The maximum allowed duration of the lambda function.
     */
    public Long timeoutInSeconds() {
        return timeoutInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionScheduledEventDetails)) {
            return false;
        }
        LambdaFunctionScheduledEventDetails other = (LambdaFunctionScheduledEventDetails) obj;
        return Objects.equals(resource(), other.resource()) && Objects.equals(input(), other.input())
                && Objects.equals(timeoutInSeconds(), other.timeoutInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LambdaFunctionScheduledEventDetails").add("Resource", resource())
                .add("Input", input() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TimeoutInSeconds", timeoutInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "timeoutInSeconds":
            return Optional.ofNullable(clazz.cast(timeoutInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionScheduledEventDetails, T> g) {
        return obj -> g.apply((LambdaFunctionScheduledEventDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaFunctionScheduledEventDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the scheduled lambda function.
         * </p>
         * 
         * @param resource
         *        The Amazon Resource Name (ARN) of the scheduled lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * The JSON data input to the lambda function.
         * </p>
         * 
         * @param input
         *        The JSON data input to the lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The maximum allowed duration of the lambda function.
         * </p>
         * 
         * @param timeoutInSeconds
         *        The maximum allowed duration of the lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInSeconds(Long timeoutInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String resource;

        private String input;

        private Long timeoutInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionScheduledEventDetails model) {
            resource(model.resource);
            input(model.input);
            timeoutInSeconds(model.timeoutInSeconds);
        }

        public final String getResource() {
            return resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final Long getTimeoutInSeconds() {
            return timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final void setTimeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        @Override
        public LambdaFunctionScheduledEventDetails build() {
            return new LambdaFunctionScheduledEventDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
