/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the events of an execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HistoryEvent implements SdkPojo, Serializable, ToCopyableBuilder<HistoryEvent.Builder, HistoryEvent> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(HistoryEvent::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HistoryEvent::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Long> ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG).getter(getter(HistoryEvent::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Long> PREVIOUS_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(HistoryEvent::previousEventId)).setter(setter(Builder::previousEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousEventId").build()).build();

    private static final SdkField<ActivityFailedEventDetails> ACTIVITY_FAILED_EVENT_DETAILS_FIELD = SdkField
            .<ActivityFailedEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::activityFailedEventDetails))
            .setter(setter(Builder::activityFailedEventDetails))
            .constructor(ActivityFailedEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityFailedEventDetails").build())
            .build();

    private static final SdkField<ActivityScheduleFailedEventDetails> ACTIVITY_SCHEDULE_FAILED_EVENT_DETAILS_FIELD = SdkField
            .<ActivityScheduleFailedEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::activityScheduleFailedEventDetails))
            .setter(setter(Builder::activityScheduleFailedEventDetails))
            .constructor(ActivityScheduleFailedEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityScheduleFailedEventDetails")
                    .build()).build();

    private static final SdkField<ActivityScheduledEventDetails> ACTIVITY_SCHEDULED_EVENT_DETAILS_FIELD = SdkField
            .<ActivityScheduledEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::activityScheduledEventDetails))
            .setter(setter(Builder::activityScheduledEventDetails))
            .constructor(ActivityScheduledEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityScheduledEventDetails")
                    .build()).build();

    private static final SdkField<ActivityStartedEventDetails> ACTIVITY_STARTED_EVENT_DETAILS_FIELD = SdkField
            .<ActivityStartedEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::activityStartedEventDetails))
            .setter(setter(Builder::activityStartedEventDetails))
            .constructor(ActivityStartedEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityStartedEventDetails")
                    .build()).build();

    private static final SdkField<ActivitySucceededEventDetails> ACTIVITY_SUCCEEDED_EVENT_DETAILS_FIELD = SdkField
            .<ActivitySucceededEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::activitySucceededEventDetails))
            .setter(setter(Builder::activitySucceededEventDetails))
            .constructor(ActivitySucceededEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activitySucceededEventDetails")
                    .build()).build();

    private static final SdkField<ActivityTimedOutEventDetails> ACTIVITY_TIMED_OUT_EVENT_DETAILS_FIELD = SdkField
            .<ActivityTimedOutEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::activityTimedOutEventDetails))
            .setter(setter(Builder::activityTimedOutEventDetails))
            .constructor(ActivityTimedOutEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityTimedOutEventDetails")
                    .build()).build();

    private static final SdkField<TaskFailedEventDetails> TASK_FAILED_EVENT_DETAILS_FIELD = SdkField
            .<TaskFailedEventDetails> builder(MarshallingType.SDK_POJO).getter(getter(HistoryEvent::taskFailedEventDetails))
            .setter(setter(Builder::taskFailedEventDetails)).constructor(TaskFailedEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskFailedEventDetails").build())
            .build();

    private static final SdkField<TaskScheduledEventDetails> TASK_SCHEDULED_EVENT_DETAILS_FIELD = SdkField
            .<TaskScheduledEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::taskScheduledEventDetails)).setter(setter(Builder::taskScheduledEventDetails))
            .constructor(TaskScheduledEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskScheduledEventDetails").build())
            .build();

    private static final SdkField<TaskStartFailedEventDetails> TASK_START_FAILED_EVENT_DETAILS_FIELD = SdkField
            .<TaskStartFailedEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::taskStartFailedEventDetails))
            .setter(setter(Builder::taskStartFailedEventDetails))
            .constructor(TaskStartFailedEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartFailedEventDetails")
                    .build()).build();

    private static final SdkField<TaskStartedEventDetails> TASK_STARTED_EVENT_DETAILS_FIELD = SdkField
            .<TaskStartedEventDetails> builder(MarshallingType.SDK_POJO).getter(getter(HistoryEvent::taskStartedEventDetails))
            .setter(setter(Builder::taskStartedEventDetails)).constructor(TaskStartedEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartedEventDetails").build())
            .build();

    private static final SdkField<TaskSubmitFailedEventDetails> TASK_SUBMIT_FAILED_EVENT_DETAILS_FIELD = SdkField
            .<TaskSubmitFailedEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::taskSubmitFailedEventDetails))
            .setter(setter(Builder::taskSubmitFailedEventDetails))
            .constructor(TaskSubmitFailedEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSubmitFailedEventDetails")
                    .build()).build();

    private static final SdkField<TaskSubmittedEventDetails> TASK_SUBMITTED_EVENT_DETAILS_FIELD = SdkField
            .<TaskSubmittedEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::taskSubmittedEventDetails)).setter(setter(Builder::taskSubmittedEventDetails))
            .constructor(TaskSubmittedEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSubmittedEventDetails").build())
            .build();

    private static final SdkField<TaskSucceededEventDetails> TASK_SUCCEEDED_EVENT_DETAILS_FIELD = SdkField
            .<TaskSucceededEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::taskSucceededEventDetails)).setter(setter(Builder::taskSucceededEventDetails))
            .constructor(TaskSucceededEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSucceededEventDetails").build())
            .build();

    private static final SdkField<TaskTimedOutEventDetails> TASK_TIMED_OUT_EVENT_DETAILS_FIELD = SdkField
            .<TaskTimedOutEventDetails> builder(MarshallingType.SDK_POJO).getter(getter(HistoryEvent::taskTimedOutEventDetails))
            .setter(setter(Builder::taskTimedOutEventDetails)).constructor(TaskTimedOutEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskTimedOutEventDetails").build())
            .build();

    private static final SdkField<ExecutionFailedEventDetails> EXECUTION_FAILED_EVENT_DETAILS_FIELD = SdkField
            .<ExecutionFailedEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::executionFailedEventDetails))
            .setter(setter(Builder::executionFailedEventDetails))
            .constructor(ExecutionFailedEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionFailedEventDetails")
                    .build()).build();

    private static final SdkField<ExecutionStartedEventDetails> EXECUTION_STARTED_EVENT_DETAILS_FIELD = SdkField
            .<ExecutionStartedEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::executionStartedEventDetails))
            .setter(setter(Builder::executionStartedEventDetails))
            .constructor(ExecutionStartedEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStartedEventDetails")
                    .build()).build();

    private static final SdkField<ExecutionSucceededEventDetails> EXECUTION_SUCCEEDED_EVENT_DETAILS_FIELD = SdkField
            .<ExecutionSucceededEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::executionSucceededEventDetails))
            .setter(setter(Builder::executionSucceededEventDetails))
            .constructor(ExecutionSucceededEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionSucceededEventDetails")
                    .build()).build();

    private static final SdkField<ExecutionAbortedEventDetails> EXECUTION_ABORTED_EVENT_DETAILS_FIELD = SdkField
            .<ExecutionAbortedEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::executionAbortedEventDetails))
            .setter(setter(Builder::executionAbortedEventDetails))
            .constructor(ExecutionAbortedEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionAbortedEventDetails")
                    .build()).build();

    private static final SdkField<ExecutionTimedOutEventDetails> EXECUTION_TIMED_OUT_EVENT_DETAILS_FIELD = SdkField
            .<ExecutionTimedOutEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::executionTimedOutEventDetails))
            .setter(setter(Builder::executionTimedOutEventDetails))
            .constructor(ExecutionTimedOutEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTimedOutEventDetails")
                    .build()).build();

    private static final SdkField<LambdaFunctionFailedEventDetails> LAMBDA_FUNCTION_FAILED_EVENT_DETAILS_FIELD = SdkField
            .<LambdaFunctionFailedEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::lambdaFunctionFailedEventDetails))
            .setter(setter(Builder::lambdaFunctionFailedEventDetails))
            .constructor(LambdaFunctionFailedEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionFailedEventDetails")
                    .build()).build();

    private static final SdkField<LambdaFunctionScheduleFailedEventDetails> LAMBDA_FUNCTION_SCHEDULE_FAILED_EVENT_DETAILS_FIELD = SdkField
            .<LambdaFunctionScheduleFailedEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::lambdaFunctionScheduleFailedEventDetails))
            .setter(setter(Builder::lambdaFunctionScheduleFailedEventDetails))
            .constructor(LambdaFunctionScheduleFailedEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("lambdaFunctionScheduleFailedEventDetails").build()).build();

    private static final SdkField<LambdaFunctionScheduledEventDetails> LAMBDA_FUNCTION_SCHEDULED_EVENT_DETAILS_FIELD = SdkField
            .<LambdaFunctionScheduledEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::lambdaFunctionScheduledEventDetails))
            .setter(setter(Builder::lambdaFunctionScheduledEventDetails))
            .constructor(LambdaFunctionScheduledEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("lambdaFunctionScheduledEventDetails").build()).build();

    private static final SdkField<LambdaFunctionStartFailedEventDetails> LAMBDA_FUNCTION_START_FAILED_EVENT_DETAILS_FIELD = SdkField
            .<LambdaFunctionStartFailedEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::lambdaFunctionStartFailedEventDetails))
            .setter(setter(Builder::lambdaFunctionStartFailedEventDetails))
            .constructor(LambdaFunctionStartFailedEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("lambdaFunctionStartFailedEventDetails").build()).build();

    private static final SdkField<LambdaFunctionSucceededEventDetails> LAMBDA_FUNCTION_SUCCEEDED_EVENT_DETAILS_FIELD = SdkField
            .<LambdaFunctionSucceededEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::lambdaFunctionSucceededEventDetails))
            .setter(setter(Builder::lambdaFunctionSucceededEventDetails))
            .constructor(LambdaFunctionSucceededEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("lambdaFunctionSucceededEventDetails").build()).build();

    private static final SdkField<LambdaFunctionTimedOutEventDetails> LAMBDA_FUNCTION_TIMED_OUT_EVENT_DETAILS_FIELD = SdkField
            .<LambdaFunctionTimedOutEventDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoryEvent::lambdaFunctionTimedOutEventDetails))
            .setter(setter(Builder::lambdaFunctionTimedOutEventDetails))
            .constructor(LambdaFunctionTimedOutEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionTimedOutEventDetails")
                    .build()).build();

    private static final SdkField<StateEnteredEventDetails> STATE_ENTERED_EVENT_DETAILS_FIELD = SdkField
            .<StateEnteredEventDetails> builder(MarshallingType.SDK_POJO).getter(getter(HistoryEvent::stateEnteredEventDetails))
            .setter(setter(Builder::stateEnteredEventDetails)).constructor(StateEnteredEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateEnteredEventDetails").build())
            .build();

    private static final SdkField<StateExitedEventDetails> STATE_EXITED_EVENT_DETAILS_FIELD = SdkField
            .<StateExitedEventDetails> builder(MarshallingType.SDK_POJO).getter(getter(HistoryEvent::stateExitedEventDetails))
            .setter(setter(Builder::stateExitedEventDetails)).constructor(StateExitedEventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateExitedEventDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, TYPE_FIELD,
            ID_FIELD, PREVIOUS_EVENT_ID_FIELD, ACTIVITY_FAILED_EVENT_DETAILS_FIELD, ACTIVITY_SCHEDULE_FAILED_EVENT_DETAILS_FIELD,
            ACTIVITY_SCHEDULED_EVENT_DETAILS_FIELD, ACTIVITY_STARTED_EVENT_DETAILS_FIELD, ACTIVITY_SUCCEEDED_EVENT_DETAILS_FIELD,
            ACTIVITY_TIMED_OUT_EVENT_DETAILS_FIELD, TASK_FAILED_EVENT_DETAILS_FIELD, TASK_SCHEDULED_EVENT_DETAILS_FIELD,
            TASK_START_FAILED_EVENT_DETAILS_FIELD, TASK_STARTED_EVENT_DETAILS_FIELD, TASK_SUBMIT_FAILED_EVENT_DETAILS_FIELD,
            TASK_SUBMITTED_EVENT_DETAILS_FIELD, TASK_SUCCEEDED_EVENT_DETAILS_FIELD, TASK_TIMED_OUT_EVENT_DETAILS_FIELD,
            EXECUTION_FAILED_EVENT_DETAILS_FIELD, EXECUTION_STARTED_EVENT_DETAILS_FIELD, EXECUTION_SUCCEEDED_EVENT_DETAILS_FIELD,
            EXECUTION_ABORTED_EVENT_DETAILS_FIELD, EXECUTION_TIMED_OUT_EVENT_DETAILS_FIELD,
            LAMBDA_FUNCTION_FAILED_EVENT_DETAILS_FIELD, LAMBDA_FUNCTION_SCHEDULE_FAILED_EVENT_DETAILS_FIELD,
            LAMBDA_FUNCTION_SCHEDULED_EVENT_DETAILS_FIELD, LAMBDA_FUNCTION_START_FAILED_EVENT_DETAILS_FIELD,
            LAMBDA_FUNCTION_SUCCEEDED_EVENT_DETAILS_FIELD, LAMBDA_FUNCTION_TIMED_OUT_EVENT_DETAILS_FIELD,
            STATE_ENTERED_EVENT_DETAILS_FIELD, STATE_EXITED_EVENT_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant timestamp;

    private final String type;

    private final Long id;

    private final Long previousEventId;

    private final ActivityFailedEventDetails activityFailedEventDetails;

    private final ActivityScheduleFailedEventDetails activityScheduleFailedEventDetails;

    private final ActivityScheduledEventDetails activityScheduledEventDetails;

    private final ActivityStartedEventDetails activityStartedEventDetails;

    private final ActivitySucceededEventDetails activitySucceededEventDetails;

    private final ActivityTimedOutEventDetails activityTimedOutEventDetails;

    private final TaskFailedEventDetails taskFailedEventDetails;

    private final TaskScheduledEventDetails taskScheduledEventDetails;

    private final TaskStartFailedEventDetails taskStartFailedEventDetails;

    private final TaskStartedEventDetails taskStartedEventDetails;

    private final TaskSubmitFailedEventDetails taskSubmitFailedEventDetails;

    private final TaskSubmittedEventDetails taskSubmittedEventDetails;

    private final TaskSucceededEventDetails taskSucceededEventDetails;

    private final TaskTimedOutEventDetails taskTimedOutEventDetails;

    private final ExecutionFailedEventDetails executionFailedEventDetails;

    private final ExecutionStartedEventDetails executionStartedEventDetails;

    private final ExecutionSucceededEventDetails executionSucceededEventDetails;

    private final ExecutionAbortedEventDetails executionAbortedEventDetails;

    private final ExecutionTimedOutEventDetails executionTimedOutEventDetails;

    private final LambdaFunctionFailedEventDetails lambdaFunctionFailedEventDetails;

    private final LambdaFunctionScheduleFailedEventDetails lambdaFunctionScheduleFailedEventDetails;

    private final LambdaFunctionScheduledEventDetails lambdaFunctionScheduledEventDetails;

    private final LambdaFunctionStartFailedEventDetails lambdaFunctionStartFailedEventDetails;

    private final LambdaFunctionSucceededEventDetails lambdaFunctionSucceededEventDetails;

    private final LambdaFunctionTimedOutEventDetails lambdaFunctionTimedOutEventDetails;

    private final StateEnteredEventDetails stateEnteredEventDetails;

    private final StateExitedEventDetails stateExitedEventDetails;

    private HistoryEvent(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.type = builder.type;
        this.id = builder.id;
        this.previousEventId = builder.previousEventId;
        this.activityFailedEventDetails = builder.activityFailedEventDetails;
        this.activityScheduleFailedEventDetails = builder.activityScheduleFailedEventDetails;
        this.activityScheduledEventDetails = builder.activityScheduledEventDetails;
        this.activityStartedEventDetails = builder.activityStartedEventDetails;
        this.activitySucceededEventDetails = builder.activitySucceededEventDetails;
        this.activityTimedOutEventDetails = builder.activityTimedOutEventDetails;
        this.taskFailedEventDetails = builder.taskFailedEventDetails;
        this.taskScheduledEventDetails = builder.taskScheduledEventDetails;
        this.taskStartFailedEventDetails = builder.taskStartFailedEventDetails;
        this.taskStartedEventDetails = builder.taskStartedEventDetails;
        this.taskSubmitFailedEventDetails = builder.taskSubmitFailedEventDetails;
        this.taskSubmittedEventDetails = builder.taskSubmittedEventDetails;
        this.taskSucceededEventDetails = builder.taskSucceededEventDetails;
        this.taskTimedOutEventDetails = builder.taskTimedOutEventDetails;
        this.executionFailedEventDetails = builder.executionFailedEventDetails;
        this.executionStartedEventDetails = builder.executionStartedEventDetails;
        this.executionSucceededEventDetails = builder.executionSucceededEventDetails;
        this.executionAbortedEventDetails = builder.executionAbortedEventDetails;
        this.executionTimedOutEventDetails = builder.executionTimedOutEventDetails;
        this.lambdaFunctionFailedEventDetails = builder.lambdaFunctionFailedEventDetails;
        this.lambdaFunctionScheduleFailedEventDetails = builder.lambdaFunctionScheduleFailedEventDetails;
        this.lambdaFunctionScheduledEventDetails = builder.lambdaFunctionScheduledEventDetails;
        this.lambdaFunctionStartFailedEventDetails = builder.lambdaFunctionStartFailedEventDetails;
        this.lambdaFunctionSucceededEventDetails = builder.lambdaFunctionSucceededEventDetails;
        this.lambdaFunctionTimedOutEventDetails = builder.lambdaFunctionTimedOutEventDetails;
        this.stateEnteredEventDetails = builder.stateEnteredEventDetails;
        this.stateExitedEventDetails = builder.stateExitedEventDetails;
    }

    /**
     * <p>
     * The date and time the event occurred.
     * </p>
     * 
     * @return The date and time the event occurred.
     */
    public Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The type of the event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HistoryEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the event.
     * @see HistoryEventType
     */
    public HistoryEventType type() {
        return HistoryEventType.fromValue(type);
    }

    /**
     * <p>
     * The type of the event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HistoryEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the event.
     * @see HistoryEventType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The id of the event. Events are numbered sequentially, starting at one.
     * </p>
     * 
     * @return The id of the event. Events are numbered sequentially, starting at one.
     */
    public Long id() {
        return id;
    }

    /**
     * <p>
     * The id of the previous event.
     * </p>
     * 
     * @return The id of the previous event.
     */
    public Long previousEventId() {
        return previousEventId;
    }

    /**
     * Returns the value of the ActivityFailedEventDetails property for this object.
     * 
     * @return The value of the ActivityFailedEventDetails property for this object.
     */
    public ActivityFailedEventDetails activityFailedEventDetails() {
        return activityFailedEventDetails;
    }

    /**
     * <p>
     * Contains details about an activity schedule event that failed during an execution.
     * </p>
     * 
     * @return Contains details about an activity schedule event that failed during an execution.
     */
    public ActivityScheduleFailedEventDetails activityScheduleFailedEventDetails() {
        return activityScheduleFailedEventDetails;
    }

    /**
     * Returns the value of the ActivityScheduledEventDetails property for this object.
     * 
     * @return The value of the ActivityScheduledEventDetails property for this object.
     */
    public ActivityScheduledEventDetails activityScheduledEventDetails() {
        return activityScheduledEventDetails;
    }

    /**
     * Returns the value of the ActivityStartedEventDetails property for this object.
     * 
     * @return The value of the ActivityStartedEventDetails property for this object.
     */
    public ActivityStartedEventDetails activityStartedEventDetails() {
        return activityStartedEventDetails;
    }

    /**
     * Returns the value of the ActivitySucceededEventDetails property for this object.
     * 
     * @return The value of the ActivitySucceededEventDetails property for this object.
     */
    public ActivitySucceededEventDetails activitySucceededEventDetails() {
        return activitySucceededEventDetails;
    }

    /**
     * Returns the value of the ActivityTimedOutEventDetails property for this object.
     * 
     * @return The value of the ActivityTimedOutEventDetails property for this object.
     */
    public ActivityTimedOutEventDetails activityTimedOutEventDetails() {
        return activityTimedOutEventDetails;
    }

    /**
     * <p>
     * Contains details about the failure of a task.
     * </p>
     * 
     * @return Contains details about the failure of a task.
     */
    public TaskFailedEventDetails taskFailedEventDetails() {
        return taskFailedEventDetails;
    }

    /**
     * <p>
     * Contains details about a task that was scheduled.
     * </p>
     * 
     * @return Contains details about a task that was scheduled.
     */
    public TaskScheduledEventDetails taskScheduledEventDetails() {
        return taskScheduledEventDetails;
    }

    /**
     * <p>
     * Contains details about a task that failed to start.
     * </p>
     * 
     * @return Contains details about a task that failed to start.
     */
    public TaskStartFailedEventDetails taskStartFailedEventDetails() {
        return taskStartFailedEventDetails;
    }

    /**
     * <p>
     * Contains details about a task that was started.
     * </p>
     * 
     * @return Contains details about a task that was started.
     */
    public TaskStartedEventDetails taskStartedEventDetails() {
        return taskStartedEventDetails;
    }

    /**
     * <p>
     * Contains details about a task that where the submit failed.
     * </p>
     * 
     * @return Contains details about a task that where the submit failed.
     */
    public TaskSubmitFailedEventDetails taskSubmitFailedEventDetails() {
        return taskSubmitFailedEventDetails;
    }

    /**
     * <p>
     * Contains details about a submitted task.
     * </p>
     * 
     * @return Contains details about a submitted task.
     */
    public TaskSubmittedEventDetails taskSubmittedEventDetails() {
        return taskSubmittedEventDetails;
    }

    /**
     * <p>
     * Contains details about a task that succeeded.
     * </p>
     * 
     * @return Contains details about a task that succeeded.
     */
    public TaskSucceededEventDetails taskSucceededEventDetails() {
        return taskSucceededEventDetails;
    }

    /**
     * <p>
     * Contains details about a task that timed out.
     * </p>
     * 
     * @return Contains details about a task that timed out.
     */
    public TaskTimedOutEventDetails taskTimedOutEventDetails() {
        return taskTimedOutEventDetails;
    }

    /**
     * Returns the value of the ExecutionFailedEventDetails property for this object.
     * 
     * @return The value of the ExecutionFailedEventDetails property for this object.
     */
    public ExecutionFailedEventDetails executionFailedEventDetails() {
        return executionFailedEventDetails;
    }

    /**
     * Returns the value of the ExecutionStartedEventDetails property for this object.
     * 
     * @return The value of the ExecutionStartedEventDetails property for this object.
     */
    public ExecutionStartedEventDetails executionStartedEventDetails() {
        return executionStartedEventDetails;
    }

    /**
     * Returns the value of the ExecutionSucceededEventDetails property for this object.
     * 
     * @return The value of the ExecutionSucceededEventDetails property for this object.
     */
    public ExecutionSucceededEventDetails executionSucceededEventDetails() {
        return executionSucceededEventDetails;
    }

    /**
     * Returns the value of the ExecutionAbortedEventDetails property for this object.
     * 
     * @return The value of the ExecutionAbortedEventDetails property for this object.
     */
    public ExecutionAbortedEventDetails executionAbortedEventDetails() {
        return executionAbortedEventDetails;
    }

    /**
     * Returns the value of the ExecutionTimedOutEventDetails property for this object.
     * 
     * @return The value of the ExecutionTimedOutEventDetails property for this object.
     */
    public ExecutionTimedOutEventDetails executionTimedOutEventDetails() {
        return executionTimedOutEventDetails;
    }

    /**
     * Returns the value of the LambdaFunctionFailedEventDetails property for this object.
     * 
     * @return The value of the LambdaFunctionFailedEventDetails property for this object.
     */
    public LambdaFunctionFailedEventDetails lambdaFunctionFailedEventDetails() {
        return lambdaFunctionFailedEventDetails;
    }

    /**
     * Returns the value of the LambdaFunctionScheduleFailedEventDetails property for this object.
     * 
     * @return The value of the LambdaFunctionScheduleFailedEventDetails property for this object.
     */
    public LambdaFunctionScheduleFailedEventDetails lambdaFunctionScheduleFailedEventDetails() {
        return lambdaFunctionScheduleFailedEventDetails;
    }

    /**
     * Returns the value of the LambdaFunctionScheduledEventDetails property for this object.
     * 
     * @return The value of the LambdaFunctionScheduledEventDetails property for this object.
     */
    public LambdaFunctionScheduledEventDetails lambdaFunctionScheduledEventDetails() {
        return lambdaFunctionScheduledEventDetails;
    }

    /**
     * <p>
     * Contains details about a lambda function that failed to start during an execution.
     * </p>
     * 
     * @return Contains details about a lambda function that failed to start during an execution.
     */
    public LambdaFunctionStartFailedEventDetails lambdaFunctionStartFailedEventDetails() {
        return lambdaFunctionStartFailedEventDetails;
    }

    /**
     * <p>
     * Contains details about a lambda function that terminated successfully during an execution.
     * </p>
     * 
     * @return Contains details about a lambda function that terminated successfully during an execution.
     */
    public LambdaFunctionSucceededEventDetails lambdaFunctionSucceededEventDetails() {
        return lambdaFunctionSucceededEventDetails;
    }

    /**
     * Returns the value of the LambdaFunctionTimedOutEventDetails property for this object.
     * 
     * @return The value of the LambdaFunctionTimedOutEventDetails property for this object.
     */
    public LambdaFunctionTimedOutEventDetails lambdaFunctionTimedOutEventDetails() {
        return lambdaFunctionTimedOutEventDetails;
    }

    /**
     * Returns the value of the StateEnteredEventDetails property for this object.
     * 
     * @return The value of the StateEnteredEventDetails property for this object.
     */
    public StateEnteredEventDetails stateEnteredEventDetails() {
        return stateEnteredEventDetails;
    }

    /**
     * Returns the value of the StateExitedEventDetails property for this object.
     * 
     * @return The value of the StateExitedEventDetails property for this object.
     */
    public StateExitedEventDetails stateExitedEventDetails() {
        return stateExitedEventDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(previousEventId());
        hashCode = 31 * hashCode + Objects.hashCode(activityFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(activityScheduleFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(activityScheduledEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(activityStartedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(activitySucceededEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(activityTimedOutEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(taskFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(taskScheduledEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(taskStartFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(taskStartedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(taskSubmitFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(taskSubmittedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(taskSucceededEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(taskTimedOutEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(executionFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(executionStartedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(executionSucceededEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(executionAbortedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(executionTimedOutEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionScheduleFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionScheduledEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionStartFailedEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionSucceededEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionTimedOutEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(stateEnteredEventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(stateExitedEventDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoryEvent)) {
            return false;
        }
        HistoryEvent other = (HistoryEvent) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(id(), other.id()) && Objects.equals(previousEventId(), other.previousEventId())
                && Objects.equals(activityFailedEventDetails(), other.activityFailedEventDetails())
                && Objects.equals(activityScheduleFailedEventDetails(), other.activityScheduleFailedEventDetails())
                && Objects.equals(activityScheduledEventDetails(), other.activityScheduledEventDetails())
                && Objects.equals(activityStartedEventDetails(), other.activityStartedEventDetails())
                && Objects.equals(activitySucceededEventDetails(), other.activitySucceededEventDetails())
                && Objects.equals(activityTimedOutEventDetails(), other.activityTimedOutEventDetails())
                && Objects.equals(taskFailedEventDetails(), other.taskFailedEventDetails())
                && Objects.equals(taskScheduledEventDetails(), other.taskScheduledEventDetails())
                && Objects.equals(taskStartFailedEventDetails(), other.taskStartFailedEventDetails())
                && Objects.equals(taskStartedEventDetails(), other.taskStartedEventDetails())
                && Objects.equals(taskSubmitFailedEventDetails(), other.taskSubmitFailedEventDetails())
                && Objects.equals(taskSubmittedEventDetails(), other.taskSubmittedEventDetails())
                && Objects.equals(taskSucceededEventDetails(), other.taskSucceededEventDetails())
                && Objects.equals(taskTimedOutEventDetails(), other.taskTimedOutEventDetails())
                && Objects.equals(executionFailedEventDetails(), other.executionFailedEventDetails())
                && Objects.equals(executionStartedEventDetails(), other.executionStartedEventDetails())
                && Objects.equals(executionSucceededEventDetails(), other.executionSucceededEventDetails())
                && Objects.equals(executionAbortedEventDetails(), other.executionAbortedEventDetails())
                && Objects.equals(executionTimedOutEventDetails(), other.executionTimedOutEventDetails())
                && Objects.equals(lambdaFunctionFailedEventDetails(), other.lambdaFunctionFailedEventDetails())
                && Objects.equals(lambdaFunctionScheduleFailedEventDetails(), other.lambdaFunctionScheduleFailedEventDetails())
                && Objects.equals(lambdaFunctionScheduledEventDetails(), other.lambdaFunctionScheduledEventDetails())
                && Objects.equals(lambdaFunctionStartFailedEventDetails(), other.lambdaFunctionStartFailedEventDetails())
                && Objects.equals(lambdaFunctionSucceededEventDetails(), other.lambdaFunctionSucceededEventDetails())
                && Objects.equals(lambdaFunctionTimedOutEventDetails(), other.lambdaFunctionTimedOutEventDetails())
                && Objects.equals(stateEnteredEventDetails(), other.stateEnteredEventDetails())
                && Objects.equals(stateExitedEventDetails(), other.stateExitedEventDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HistoryEvent").add("Timestamp", timestamp()).add("Type", typeAsString()).add("Id", id())
                .add("PreviousEventId", previousEventId()).add("ActivityFailedEventDetails", activityFailedEventDetails())
                .add("ActivityScheduleFailedEventDetails", activityScheduleFailedEventDetails())
                .add("ActivityScheduledEventDetails", activityScheduledEventDetails())
                .add("ActivityStartedEventDetails", activityStartedEventDetails())
                .add("ActivitySucceededEventDetails", activitySucceededEventDetails())
                .add("ActivityTimedOutEventDetails", activityTimedOutEventDetails())
                .add("TaskFailedEventDetails", taskFailedEventDetails())
                .add("TaskScheduledEventDetails", taskScheduledEventDetails())
                .add("TaskStartFailedEventDetails", taskStartFailedEventDetails())
                .add("TaskStartedEventDetails", taskStartedEventDetails())
                .add("TaskSubmitFailedEventDetails", taskSubmitFailedEventDetails())
                .add("TaskSubmittedEventDetails", taskSubmittedEventDetails())
                .add("TaskSucceededEventDetails", taskSucceededEventDetails())
                .add("TaskTimedOutEventDetails", taskTimedOutEventDetails())
                .add("ExecutionFailedEventDetails", executionFailedEventDetails())
                .add("ExecutionStartedEventDetails", executionStartedEventDetails())
                .add("ExecutionSucceededEventDetails", executionSucceededEventDetails())
                .add("ExecutionAbortedEventDetails", executionAbortedEventDetails())
                .add("ExecutionTimedOutEventDetails", executionTimedOutEventDetails())
                .add("LambdaFunctionFailedEventDetails", lambdaFunctionFailedEventDetails())
                .add("LambdaFunctionScheduleFailedEventDetails", lambdaFunctionScheduleFailedEventDetails())
                .add("LambdaFunctionScheduledEventDetails", lambdaFunctionScheduledEventDetails())
                .add("LambdaFunctionStartFailedEventDetails", lambdaFunctionStartFailedEventDetails())
                .add("LambdaFunctionSucceededEventDetails", lambdaFunctionSucceededEventDetails())
                .add("LambdaFunctionTimedOutEventDetails", lambdaFunctionTimedOutEventDetails())
                .add("StateEnteredEventDetails", stateEnteredEventDetails())
                .add("StateExitedEventDetails", stateExitedEventDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "previousEventId":
            return Optional.ofNullable(clazz.cast(previousEventId()));
        case "activityFailedEventDetails":
            return Optional.ofNullable(clazz.cast(activityFailedEventDetails()));
        case "activityScheduleFailedEventDetails":
            return Optional.ofNullable(clazz.cast(activityScheduleFailedEventDetails()));
        case "activityScheduledEventDetails":
            return Optional.ofNullable(clazz.cast(activityScheduledEventDetails()));
        case "activityStartedEventDetails":
            return Optional.ofNullable(clazz.cast(activityStartedEventDetails()));
        case "activitySucceededEventDetails":
            return Optional.ofNullable(clazz.cast(activitySucceededEventDetails()));
        case "activityTimedOutEventDetails":
            return Optional.ofNullable(clazz.cast(activityTimedOutEventDetails()));
        case "taskFailedEventDetails":
            return Optional.ofNullable(clazz.cast(taskFailedEventDetails()));
        case "taskScheduledEventDetails":
            return Optional.ofNullable(clazz.cast(taskScheduledEventDetails()));
        case "taskStartFailedEventDetails":
            return Optional.ofNullable(clazz.cast(taskStartFailedEventDetails()));
        case "taskStartedEventDetails":
            return Optional.ofNullable(clazz.cast(taskStartedEventDetails()));
        case "taskSubmitFailedEventDetails":
            return Optional.ofNullable(clazz.cast(taskSubmitFailedEventDetails()));
        case "taskSubmittedEventDetails":
            return Optional.ofNullable(clazz.cast(taskSubmittedEventDetails()));
        case "taskSucceededEventDetails":
            return Optional.ofNullable(clazz.cast(taskSucceededEventDetails()));
        case "taskTimedOutEventDetails":
            return Optional.ofNullable(clazz.cast(taskTimedOutEventDetails()));
        case "executionFailedEventDetails":
            return Optional.ofNullable(clazz.cast(executionFailedEventDetails()));
        case "executionStartedEventDetails":
            return Optional.ofNullable(clazz.cast(executionStartedEventDetails()));
        case "executionSucceededEventDetails":
            return Optional.ofNullable(clazz.cast(executionSucceededEventDetails()));
        case "executionAbortedEventDetails":
            return Optional.ofNullable(clazz.cast(executionAbortedEventDetails()));
        case "executionTimedOutEventDetails":
            return Optional.ofNullable(clazz.cast(executionTimedOutEventDetails()));
        case "lambdaFunctionFailedEventDetails":
            return Optional.ofNullable(clazz.cast(lambdaFunctionFailedEventDetails()));
        case "lambdaFunctionScheduleFailedEventDetails":
            return Optional.ofNullable(clazz.cast(lambdaFunctionScheduleFailedEventDetails()));
        case "lambdaFunctionScheduledEventDetails":
            return Optional.ofNullable(clazz.cast(lambdaFunctionScheduledEventDetails()));
        case "lambdaFunctionStartFailedEventDetails":
            return Optional.ofNullable(clazz.cast(lambdaFunctionStartFailedEventDetails()));
        case "lambdaFunctionSucceededEventDetails":
            return Optional.ofNullable(clazz.cast(lambdaFunctionSucceededEventDetails()));
        case "lambdaFunctionTimedOutEventDetails":
            return Optional.ofNullable(clazz.cast(lambdaFunctionTimedOutEventDetails()));
        case "stateEnteredEventDetails":
            return Optional.ofNullable(clazz.cast(stateEnteredEventDetails()));
        case "stateExitedEventDetails":
            return Optional.ofNullable(clazz.cast(stateExitedEventDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HistoryEvent, T> g) {
        return obj -> g.apply((HistoryEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HistoryEvent> {
        /**
         * <p>
         * The date and time the event occurred.
         * </p>
         * 
         * @param timestamp
         *        The date and time the event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The type of the event.
         * </p>
         * 
         * @param type
         *        The type of the event.
         * @see HistoryEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistoryEventType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the event.
         * </p>
         * 
         * @param type
         *        The type of the event.
         * @see HistoryEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistoryEventType
         */
        Builder type(HistoryEventType type);

        /**
         * <p>
         * The id of the event. Events are numbered sequentially, starting at one.
         * </p>
         * 
         * @param id
         *        The id of the event. Events are numbered sequentially, starting at one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(Long id);

        /**
         * <p>
         * The id of the previous event.
         * </p>
         * 
         * @param previousEventId
         *        The id of the previous event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousEventId(Long previousEventId);

        /**
         * Sets the value of the ActivityFailedEventDetails property for this object.
         *
         * @param activityFailedEventDetails
         *        The new value for the ActivityFailedEventDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityFailedEventDetails(ActivityFailedEventDetails activityFailedEventDetails);

        /**
         * Sets the value of the ActivityFailedEventDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link ActivityFailedEventDetails.Builder} avoiding the
         * need to create one manually via {@link ActivityFailedEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActivityFailedEventDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #activityFailedEventDetails(ActivityFailedEventDetails)}.
         * 
         * @param activityFailedEventDetails
         *        a consumer that will call methods on {@link ActivityFailedEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityFailedEventDetails(ActivityFailedEventDetails)
         */
        default Builder activityFailedEventDetails(Consumer<ActivityFailedEventDetails.Builder> activityFailedEventDetails) {
            return activityFailedEventDetails(ActivityFailedEventDetails.builder().applyMutation(activityFailedEventDetails)
                    .build());
        }

        /**
         * <p>
         * Contains details about an activity schedule event that failed during an execution.
         * </p>
         * 
         * @param activityScheduleFailedEventDetails
         *        Contains details about an activity schedule event that failed during an execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityScheduleFailedEventDetails(ActivityScheduleFailedEventDetails activityScheduleFailedEventDetails);

        /**
         * <p>
         * Contains details about an activity schedule event that failed during an execution.
         * </p>
         * This is a convenience that creates an instance of the {@link ActivityScheduleFailedEventDetails.Builder}
         * avoiding the need to create one manually via {@link ActivityScheduleFailedEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActivityScheduleFailedEventDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #activityScheduleFailedEventDetails(ActivityScheduleFailedEventDetails)}.
         * 
         * @param activityScheduleFailedEventDetails
         *        a consumer that will call methods on {@link ActivityScheduleFailedEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityScheduleFailedEventDetails(ActivityScheduleFailedEventDetails)
         */
        default Builder activityScheduleFailedEventDetails(
                Consumer<ActivityScheduleFailedEventDetails.Builder> activityScheduleFailedEventDetails) {
            return activityScheduleFailedEventDetails(ActivityScheduleFailedEventDetails.builder()
                    .applyMutation(activityScheduleFailedEventDetails).build());
        }

        /**
         * Sets the value of the ActivityScheduledEventDetails property for this object.
         *
         * @param activityScheduledEventDetails
         *        The new value for the ActivityScheduledEventDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityScheduledEventDetails(ActivityScheduledEventDetails activityScheduledEventDetails);

        /**
         * Sets the value of the ActivityScheduledEventDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link ActivityScheduledEventDetails.Builder} avoiding
         * the need to create one manually via {@link ActivityScheduledEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActivityScheduledEventDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #activityScheduledEventDetails(ActivityScheduledEventDetails)}
         * .
         * 
         * @param activityScheduledEventDetails
         *        a consumer that will call methods on {@link ActivityScheduledEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityScheduledEventDetails(ActivityScheduledEventDetails)
         */
        default Builder activityScheduledEventDetails(
                Consumer<ActivityScheduledEventDetails.Builder> activityScheduledEventDetails) {
            return activityScheduledEventDetails(ActivityScheduledEventDetails.builder()
                    .applyMutation(activityScheduledEventDetails).build());
        }

        /**
         * Sets the value of the ActivityStartedEventDetails property for this object.
         *
         * @param activityStartedEventDetails
         *        The new value for the ActivityStartedEventDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityStartedEventDetails(ActivityStartedEventDetails activityStartedEventDetails);

        /**
         * Sets the value of the ActivityStartedEventDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link ActivityStartedEventDetails.Builder} avoiding
         * the need to create one manually via {@link ActivityStartedEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActivityStartedEventDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #activityStartedEventDetails(ActivityStartedEventDetails)}.
         * 
         * @param activityStartedEventDetails
         *        a consumer that will call methods on {@link ActivityStartedEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityStartedEventDetails(ActivityStartedEventDetails)
         */
        default Builder activityStartedEventDetails(Consumer<ActivityStartedEventDetails.Builder> activityStartedEventDetails) {
            return activityStartedEventDetails(ActivityStartedEventDetails.builder().applyMutation(activityStartedEventDetails)
                    .build());
        }

        /**
         * Sets the value of the ActivitySucceededEventDetails property for this object.
         *
         * @param activitySucceededEventDetails
         *        The new value for the ActivitySucceededEventDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activitySucceededEventDetails(ActivitySucceededEventDetails activitySucceededEventDetails);

        /**
         * Sets the value of the ActivitySucceededEventDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link ActivitySucceededEventDetails.Builder} avoiding
         * the need to create one manually via {@link ActivitySucceededEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActivitySucceededEventDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #activitySucceededEventDetails(ActivitySucceededEventDetails)}
         * .
         * 
         * @param activitySucceededEventDetails
         *        a consumer that will call methods on {@link ActivitySucceededEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activitySucceededEventDetails(ActivitySucceededEventDetails)
         */
        default Builder activitySucceededEventDetails(
                Consumer<ActivitySucceededEventDetails.Builder> activitySucceededEventDetails) {
            return activitySucceededEventDetails(ActivitySucceededEventDetails.builder()
                    .applyMutation(activitySucceededEventDetails).build());
        }

        /**
         * Sets the value of the ActivityTimedOutEventDetails property for this object.
         *
         * @param activityTimedOutEventDetails
         *        The new value for the ActivityTimedOutEventDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityTimedOutEventDetails(ActivityTimedOutEventDetails activityTimedOutEventDetails);

        /**
         * Sets the value of the ActivityTimedOutEventDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link ActivityTimedOutEventDetails.Builder} avoiding
         * the need to create one manually via {@link ActivityTimedOutEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActivityTimedOutEventDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #activityTimedOutEventDetails(ActivityTimedOutEventDetails)}.
         * 
         * @param activityTimedOutEventDetails
         *        a consumer that will call methods on {@link ActivityTimedOutEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityTimedOutEventDetails(ActivityTimedOutEventDetails)
         */
        default Builder activityTimedOutEventDetails(Consumer<ActivityTimedOutEventDetails.Builder> activityTimedOutEventDetails) {
            return activityTimedOutEventDetails(ActivityTimedOutEventDetails.builder()
                    .applyMutation(activityTimedOutEventDetails).build());
        }

        /**
         * <p>
         * Contains details about the failure of a task.
         * </p>
         * 
         * @param taskFailedEventDetails
         *        Contains details about the failure of a task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskFailedEventDetails(TaskFailedEventDetails taskFailedEventDetails);

        /**
         * <p>
         * Contains details about the failure of a task.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskFailedEventDetails.Builder} avoiding the
         * need to create one manually via {@link TaskFailedEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskFailedEventDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #taskFailedEventDetails(TaskFailedEventDetails)}.
         * 
         * @param taskFailedEventDetails
         *        a consumer that will call methods on {@link TaskFailedEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskFailedEventDetails(TaskFailedEventDetails)
         */
        default Builder taskFailedEventDetails(Consumer<TaskFailedEventDetails.Builder> taskFailedEventDetails) {
            return taskFailedEventDetails(TaskFailedEventDetails.builder().applyMutation(taskFailedEventDetails).build());
        }

        /**
         * <p>
         * Contains details about a task that was scheduled.
         * </p>
         * 
         * @param taskScheduledEventDetails
         *        Contains details about a task that was scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskScheduledEventDetails(TaskScheduledEventDetails taskScheduledEventDetails);

        /**
         * <p>
         * Contains details about a task that was scheduled.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskScheduledEventDetails.Builder} avoiding the
         * need to create one manually via {@link TaskScheduledEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskScheduledEventDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #taskScheduledEventDetails(TaskScheduledEventDetails)}.
         * 
         * @param taskScheduledEventDetails
         *        a consumer that will call methods on {@link TaskScheduledEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskScheduledEventDetails(TaskScheduledEventDetails)
         */
        default Builder taskScheduledEventDetails(Consumer<TaskScheduledEventDetails.Builder> taskScheduledEventDetails) {
            return taskScheduledEventDetails(TaskScheduledEventDetails.builder().applyMutation(taskScheduledEventDetails).build());
        }

        /**
         * <p>
         * Contains details about a task that failed to start.
         * </p>
         * 
         * @param taskStartFailedEventDetails
         *        Contains details about a task that failed to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStartFailedEventDetails(TaskStartFailedEventDetails taskStartFailedEventDetails);

        /**
         * <p>
         * Contains details about a task that failed to start.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskStartFailedEventDetails.Builder} avoiding
         * the need to create one manually via {@link TaskStartFailedEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskStartFailedEventDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #taskStartFailedEventDetails(TaskStartFailedEventDetails)}.
         * 
         * @param taskStartFailedEventDetails
         *        a consumer that will call methods on {@link TaskStartFailedEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskStartFailedEventDetails(TaskStartFailedEventDetails)
         */
        default Builder taskStartFailedEventDetails(Consumer<TaskStartFailedEventDetails.Builder> taskStartFailedEventDetails) {
            return taskStartFailedEventDetails(TaskStartFailedEventDetails.builder().applyMutation(taskStartFailedEventDetails)
                    .build());
        }

        /**
         * <p>
         * Contains details about a task that was started.
         * </p>
         * 
         * @param taskStartedEventDetails
         *        Contains details about a task that was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStartedEventDetails(TaskStartedEventDetails taskStartedEventDetails);

        /**
         * <p>
         * Contains details about a task that was started.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskStartedEventDetails.Builder} avoiding the
         * need to create one manually via {@link TaskStartedEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskStartedEventDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #taskStartedEventDetails(TaskStartedEventDetails)}.
         * 
         * @param taskStartedEventDetails
         *        a consumer that will call methods on {@link TaskStartedEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskStartedEventDetails(TaskStartedEventDetails)
         */
        default Builder taskStartedEventDetails(Consumer<TaskStartedEventDetails.Builder> taskStartedEventDetails) {
            return taskStartedEventDetails(TaskStartedEventDetails.builder().applyMutation(taskStartedEventDetails).build());
        }

        /**
         * <p>
         * Contains details about a task that where the submit failed.
         * </p>
         * 
         * @param taskSubmitFailedEventDetails
         *        Contains details about a task that where the submit failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSubmitFailedEventDetails(TaskSubmitFailedEventDetails taskSubmitFailedEventDetails);

        /**
         * <p>
         * Contains details about a task that where the submit failed.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskSubmitFailedEventDetails.Builder} avoiding
         * the need to create one manually via {@link TaskSubmitFailedEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskSubmitFailedEventDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #taskSubmitFailedEventDetails(TaskSubmitFailedEventDetails)}.
         * 
         * @param taskSubmitFailedEventDetails
         *        a consumer that will call methods on {@link TaskSubmitFailedEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskSubmitFailedEventDetails(TaskSubmitFailedEventDetails)
         */
        default Builder taskSubmitFailedEventDetails(Consumer<TaskSubmitFailedEventDetails.Builder> taskSubmitFailedEventDetails) {
            return taskSubmitFailedEventDetails(TaskSubmitFailedEventDetails.builder()
                    .applyMutation(taskSubmitFailedEventDetails).build());
        }

        /**
         * <p>
         * Contains details about a submitted task.
         * </p>
         * 
         * @param taskSubmittedEventDetails
         *        Contains details about a submitted task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSubmittedEventDetails(TaskSubmittedEventDetails taskSubmittedEventDetails);

        /**
         * <p>
         * Contains details about a submitted task.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskSubmittedEventDetails.Builder} avoiding the
         * need to create one manually via {@link TaskSubmittedEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskSubmittedEventDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #taskSubmittedEventDetails(TaskSubmittedEventDetails)}.
         * 
         * @param taskSubmittedEventDetails
         *        a consumer that will call methods on {@link TaskSubmittedEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskSubmittedEventDetails(TaskSubmittedEventDetails)
         */
        default Builder taskSubmittedEventDetails(Consumer<TaskSubmittedEventDetails.Builder> taskSubmittedEventDetails) {
            return taskSubmittedEventDetails(TaskSubmittedEventDetails.builder().applyMutation(taskSubmittedEventDetails).build());
        }

        /**
         * <p>
         * Contains details about a task that succeeded.
         * </p>
         * 
         * @param taskSucceededEventDetails
         *        Contains details about a task that succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSucceededEventDetails(TaskSucceededEventDetails taskSucceededEventDetails);

        /**
         * <p>
         * Contains details about a task that succeeded.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskSucceededEventDetails.Builder} avoiding the
         * need to create one manually via {@link TaskSucceededEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskSucceededEventDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #taskSucceededEventDetails(TaskSucceededEventDetails)}.
         * 
         * @param taskSucceededEventDetails
         *        a consumer that will call methods on {@link TaskSucceededEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskSucceededEventDetails(TaskSucceededEventDetails)
         */
        default Builder taskSucceededEventDetails(Consumer<TaskSucceededEventDetails.Builder> taskSucceededEventDetails) {
            return taskSucceededEventDetails(TaskSucceededEventDetails.builder().applyMutation(taskSucceededEventDetails).build());
        }

        /**
         * <p>
         * Contains details about a task that timed out.
         * </p>
         * 
         * @param taskTimedOutEventDetails
         *        Contains details about a task that timed out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskTimedOutEventDetails(TaskTimedOutEventDetails taskTimedOutEventDetails);

        /**
         * <p>
         * Contains details about a task that timed out.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskTimedOutEventDetails.Builder} avoiding the
         * need to create one manually via {@link TaskTimedOutEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskTimedOutEventDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #taskTimedOutEventDetails(TaskTimedOutEventDetails)}.
         * 
         * @param taskTimedOutEventDetails
         *        a consumer that will call methods on {@link TaskTimedOutEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskTimedOutEventDetails(TaskTimedOutEventDetails)
         */
        default Builder taskTimedOutEventDetails(Consumer<TaskTimedOutEventDetails.Builder> taskTimedOutEventDetails) {
            return taskTimedOutEventDetails(TaskTimedOutEventDetails.builder().applyMutation(taskTimedOutEventDetails).build());
        }

        /**
         * Sets the value of the ExecutionFailedEventDetails property for this object.
         *
         * @param executionFailedEventDetails
         *        The new value for the ExecutionFailedEventDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionFailedEventDetails(ExecutionFailedEventDetails executionFailedEventDetails);

        /**
         * Sets the value of the ExecutionFailedEventDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link ExecutionFailedEventDetails.Builder} avoiding
         * the need to create one manually via {@link ExecutionFailedEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionFailedEventDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #executionFailedEventDetails(ExecutionFailedEventDetails)}.
         * 
         * @param executionFailedEventDetails
         *        a consumer that will call methods on {@link ExecutionFailedEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionFailedEventDetails(ExecutionFailedEventDetails)
         */
        default Builder executionFailedEventDetails(Consumer<ExecutionFailedEventDetails.Builder> executionFailedEventDetails) {
            return executionFailedEventDetails(ExecutionFailedEventDetails.builder().applyMutation(executionFailedEventDetails)
                    .build());
        }

        /**
         * Sets the value of the ExecutionStartedEventDetails property for this object.
         *
         * @param executionStartedEventDetails
         *        The new value for the ExecutionStartedEventDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartedEventDetails(ExecutionStartedEventDetails executionStartedEventDetails);

        /**
         * Sets the value of the ExecutionStartedEventDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link ExecutionStartedEventDetails.Builder} avoiding
         * the need to create one manually via {@link ExecutionStartedEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionStartedEventDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #executionStartedEventDetails(ExecutionStartedEventDetails)}.
         * 
         * @param executionStartedEventDetails
         *        a consumer that will call methods on {@link ExecutionStartedEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionStartedEventDetails(ExecutionStartedEventDetails)
         */
        default Builder executionStartedEventDetails(Consumer<ExecutionStartedEventDetails.Builder> executionStartedEventDetails) {
            return executionStartedEventDetails(ExecutionStartedEventDetails.builder()
                    .applyMutation(executionStartedEventDetails).build());
        }

        /**
         * Sets the value of the ExecutionSucceededEventDetails property for this object.
         *
         * @param executionSucceededEventDetails
         *        The new value for the ExecutionSucceededEventDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionSucceededEventDetails(ExecutionSucceededEventDetails executionSucceededEventDetails);

        /**
         * Sets the value of the ExecutionSucceededEventDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link ExecutionSucceededEventDetails.Builder} avoiding
         * the need to create one manually via {@link ExecutionSucceededEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionSucceededEventDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #executionSucceededEventDetails(ExecutionSucceededEventDetails)}.
         * 
         * @param executionSucceededEventDetails
         *        a consumer that will call methods on {@link ExecutionSucceededEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionSucceededEventDetails(ExecutionSucceededEventDetails)
         */
        default Builder executionSucceededEventDetails(
                Consumer<ExecutionSucceededEventDetails.Builder> executionSucceededEventDetails) {
            return executionSucceededEventDetails(ExecutionSucceededEventDetails.builder()
                    .applyMutation(executionSucceededEventDetails).build());
        }

        /**
         * Sets the value of the ExecutionAbortedEventDetails property for this object.
         *
         * @param executionAbortedEventDetails
         *        The new value for the ExecutionAbortedEventDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionAbortedEventDetails(ExecutionAbortedEventDetails executionAbortedEventDetails);

        /**
         * Sets the value of the ExecutionAbortedEventDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link ExecutionAbortedEventDetails.Builder} avoiding
         * the need to create one manually via {@link ExecutionAbortedEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionAbortedEventDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #executionAbortedEventDetails(ExecutionAbortedEventDetails)}.
         * 
         * @param executionAbortedEventDetails
         *        a consumer that will call methods on {@link ExecutionAbortedEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionAbortedEventDetails(ExecutionAbortedEventDetails)
         */
        default Builder executionAbortedEventDetails(Consumer<ExecutionAbortedEventDetails.Builder> executionAbortedEventDetails) {
            return executionAbortedEventDetails(ExecutionAbortedEventDetails.builder()
                    .applyMutation(executionAbortedEventDetails).build());
        }

        /**
         * Sets the value of the ExecutionTimedOutEventDetails property for this object.
         *
         * @param executionTimedOutEventDetails
         *        The new value for the ExecutionTimedOutEventDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTimedOutEventDetails(ExecutionTimedOutEventDetails executionTimedOutEventDetails);

        /**
         * Sets the value of the ExecutionTimedOutEventDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link ExecutionTimedOutEventDetails.Builder} avoiding
         * the need to create one manually via {@link ExecutionTimedOutEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionTimedOutEventDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #executionTimedOutEventDetails(ExecutionTimedOutEventDetails)}
         * .
         * 
         * @param executionTimedOutEventDetails
         *        a consumer that will call methods on {@link ExecutionTimedOutEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionTimedOutEventDetails(ExecutionTimedOutEventDetails)
         */
        default Builder executionTimedOutEventDetails(
                Consumer<ExecutionTimedOutEventDetails.Builder> executionTimedOutEventDetails) {
            return executionTimedOutEventDetails(ExecutionTimedOutEventDetails.builder()
                    .applyMutation(executionTimedOutEventDetails).build());
        }

        /**
         * Sets the value of the LambdaFunctionFailedEventDetails property for this object.
         *
         * @param lambdaFunctionFailedEventDetails
         *        The new value for the LambdaFunctionFailedEventDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionFailedEventDetails(LambdaFunctionFailedEventDetails lambdaFunctionFailedEventDetails);

        /**
         * Sets the value of the LambdaFunctionFailedEventDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link LambdaFunctionFailedEventDetails.Builder}
         * avoiding the need to create one manually via {@link LambdaFunctionFailedEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaFunctionFailedEventDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #lambdaFunctionFailedEventDetails(LambdaFunctionFailedEventDetails)}.
         * 
         * @param lambdaFunctionFailedEventDetails
         *        a consumer that will call methods on {@link LambdaFunctionFailedEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionFailedEventDetails(LambdaFunctionFailedEventDetails)
         */
        default Builder lambdaFunctionFailedEventDetails(
                Consumer<LambdaFunctionFailedEventDetails.Builder> lambdaFunctionFailedEventDetails) {
            return lambdaFunctionFailedEventDetails(LambdaFunctionFailedEventDetails.builder()
                    .applyMutation(lambdaFunctionFailedEventDetails).build());
        }

        /**
         * Sets the value of the LambdaFunctionScheduleFailedEventDetails property for this object.
         *
         * @param lambdaFunctionScheduleFailedEventDetails
         *        The new value for the LambdaFunctionScheduleFailedEventDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionScheduleFailedEventDetails(
                LambdaFunctionScheduleFailedEventDetails lambdaFunctionScheduleFailedEventDetails);

        /**
         * Sets the value of the LambdaFunctionScheduleFailedEventDetails property for this object.
         *
         * This is a convenience that creates an instance of the
         * {@link LambdaFunctionScheduleFailedEventDetails.Builder} avoiding the need to create one manually via
         * {@link LambdaFunctionScheduleFailedEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaFunctionScheduleFailedEventDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #lambdaFunctionScheduleFailedEventDetails(LambdaFunctionScheduleFailedEventDetails)}.
         * 
         * @param lambdaFunctionScheduleFailedEventDetails
         *        a consumer that will call methods on {@link LambdaFunctionScheduleFailedEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionScheduleFailedEventDetails(LambdaFunctionScheduleFailedEventDetails)
         */
        default Builder lambdaFunctionScheduleFailedEventDetails(
                Consumer<LambdaFunctionScheduleFailedEventDetails.Builder> lambdaFunctionScheduleFailedEventDetails) {
            return lambdaFunctionScheduleFailedEventDetails(LambdaFunctionScheduleFailedEventDetails.builder()
                    .applyMutation(lambdaFunctionScheduleFailedEventDetails).build());
        }

        /**
         * Sets the value of the LambdaFunctionScheduledEventDetails property for this object.
         *
         * @param lambdaFunctionScheduledEventDetails
         *        The new value for the LambdaFunctionScheduledEventDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionScheduledEventDetails(LambdaFunctionScheduledEventDetails lambdaFunctionScheduledEventDetails);

        /**
         * Sets the value of the LambdaFunctionScheduledEventDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link LambdaFunctionScheduledEventDetails.Builder}
         * avoiding the need to create one manually via {@link LambdaFunctionScheduledEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaFunctionScheduledEventDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #lambdaFunctionScheduledEventDetails(LambdaFunctionScheduledEventDetails)}.
         * 
         * @param lambdaFunctionScheduledEventDetails
         *        a consumer that will call methods on {@link LambdaFunctionScheduledEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionScheduledEventDetails(LambdaFunctionScheduledEventDetails)
         */
        default Builder lambdaFunctionScheduledEventDetails(
                Consumer<LambdaFunctionScheduledEventDetails.Builder> lambdaFunctionScheduledEventDetails) {
            return lambdaFunctionScheduledEventDetails(LambdaFunctionScheduledEventDetails.builder()
                    .applyMutation(lambdaFunctionScheduledEventDetails).build());
        }

        /**
         * <p>
         * Contains details about a lambda function that failed to start during an execution.
         * </p>
         * 
         * @param lambdaFunctionStartFailedEventDetails
         *        Contains details about a lambda function that failed to start during an execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionStartFailedEventDetails(LambdaFunctionStartFailedEventDetails lambdaFunctionStartFailedEventDetails);

        /**
         * <p>
         * Contains details about a lambda function that failed to start during an execution.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaFunctionStartFailedEventDetails.Builder}
         * avoiding the need to create one manually via {@link LambdaFunctionStartFailedEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaFunctionStartFailedEventDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #lambdaFunctionStartFailedEventDetails(LambdaFunctionStartFailedEventDetails)}.
         * 
         * @param lambdaFunctionStartFailedEventDetails
         *        a consumer that will call methods on {@link LambdaFunctionStartFailedEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionStartFailedEventDetails(LambdaFunctionStartFailedEventDetails)
         */
        default Builder lambdaFunctionStartFailedEventDetails(
                Consumer<LambdaFunctionStartFailedEventDetails.Builder> lambdaFunctionStartFailedEventDetails) {
            return lambdaFunctionStartFailedEventDetails(LambdaFunctionStartFailedEventDetails.builder()
                    .applyMutation(lambdaFunctionStartFailedEventDetails).build());
        }

        /**
         * <p>
         * Contains details about a lambda function that terminated successfully during an execution.
         * </p>
         * 
         * @param lambdaFunctionSucceededEventDetails
         *        Contains details about a lambda function that terminated successfully during an execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionSucceededEventDetails(LambdaFunctionSucceededEventDetails lambdaFunctionSucceededEventDetails);

        /**
         * <p>
         * Contains details about a lambda function that terminated successfully during an execution.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaFunctionSucceededEventDetails.Builder}
         * avoiding the need to create one manually via {@link LambdaFunctionSucceededEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaFunctionSucceededEventDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #lambdaFunctionSucceededEventDetails(LambdaFunctionSucceededEventDetails)}.
         * 
         * @param lambdaFunctionSucceededEventDetails
         *        a consumer that will call methods on {@link LambdaFunctionSucceededEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionSucceededEventDetails(LambdaFunctionSucceededEventDetails)
         */
        default Builder lambdaFunctionSucceededEventDetails(
                Consumer<LambdaFunctionSucceededEventDetails.Builder> lambdaFunctionSucceededEventDetails) {
            return lambdaFunctionSucceededEventDetails(LambdaFunctionSucceededEventDetails.builder()
                    .applyMutation(lambdaFunctionSucceededEventDetails).build());
        }

        /**
         * Sets the value of the LambdaFunctionTimedOutEventDetails property for this object.
         *
         * @param lambdaFunctionTimedOutEventDetails
         *        The new value for the LambdaFunctionTimedOutEventDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionTimedOutEventDetails(LambdaFunctionTimedOutEventDetails lambdaFunctionTimedOutEventDetails);

        /**
         * Sets the value of the LambdaFunctionTimedOutEventDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link LambdaFunctionTimedOutEventDetails.Builder}
         * avoiding the need to create one manually via {@link LambdaFunctionTimedOutEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaFunctionTimedOutEventDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #lambdaFunctionTimedOutEventDetails(LambdaFunctionTimedOutEventDetails)}.
         * 
         * @param lambdaFunctionTimedOutEventDetails
         *        a consumer that will call methods on {@link LambdaFunctionTimedOutEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionTimedOutEventDetails(LambdaFunctionTimedOutEventDetails)
         */
        default Builder lambdaFunctionTimedOutEventDetails(
                Consumer<LambdaFunctionTimedOutEventDetails.Builder> lambdaFunctionTimedOutEventDetails) {
            return lambdaFunctionTimedOutEventDetails(LambdaFunctionTimedOutEventDetails.builder()
                    .applyMutation(lambdaFunctionTimedOutEventDetails).build());
        }

        /**
         * Sets the value of the StateEnteredEventDetails property for this object.
         *
         * @param stateEnteredEventDetails
         *        The new value for the StateEnteredEventDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateEnteredEventDetails(StateEnteredEventDetails stateEnteredEventDetails);

        /**
         * Sets the value of the StateEnteredEventDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link StateEnteredEventDetails.Builder} avoiding the
         * need to create one manually via {@link StateEnteredEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link StateEnteredEventDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #stateEnteredEventDetails(StateEnteredEventDetails)}.
         * 
         * @param stateEnteredEventDetails
         *        a consumer that will call methods on {@link StateEnteredEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateEnteredEventDetails(StateEnteredEventDetails)
         */
        default Builder stateEnteredEventDetails(Consumer<StateEnteredEventDetails.Builder> stateEnteredEventDetails) {
            return stateEnteredEventDetails(StateEnteredEventDetails.builder().applyMutation(stateEnteredEventDetails).build());
        }

        /**
         * Sets the value of the StateExitedEventDetails property for this object.
         *
         * @param stateExitedEventDetails
         *        The new value for the StateExitedEventDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateExitedEventDetails(StateExitedEventDetails stateExitedEventDetails);

        /**
         * Sets the value of the StateExitedEventDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link StateExitedEventDetails.Builder} avoiding the
         * need to create one manually via {@link StateExitedEventDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link StateExitedEventDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #stateExitedEventDetails(StateExitedEventDetails)}.
         * 
         * @param stateExitedEventDetails
         *        a consumer that will call methods on {@link StateExitedEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateExitedEventDetails(StateExitedEventDetails)
         */
        default Builder stateExitedEventDetails(Consumer<StateExitedEventDetails.Builder> stateExitedEventDetails) {
            return stateExitedEventDetails(StateExitedEventDetails.builder().applyMutation(stateExitedEventDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant timestamp;

        private String type;

        private Long id;

        private Long previousEventId;

        private ActivityFailedEventDetails activityFailedEventDetails;

        private ActivityScheduleFailedEventDetails activityScheduleFailedEventDetails;

        private ActivityScheduledEventDetails activityScheduledEventDetails;

        private ActivityStartedEventDetails activityStartedEventDetails;

        private ActivitySucceededEventDetails activitySucceededEventDetails;

        private ActivityTimedOutEventDetails activityTimedOutEventDetails;

        private TaskFailedEventDetails taskFailedEventDetails;

        private TaskScheduledEventDetails taskScheduledEventDetails;

        private TaskStartFailedEventDetails taskStartFailedEventDetails;

        private TaskStartedEventDetails taskStartedEventDetails;

        private TaskSubmitFailedEventDetails taskSubmitFailedEventDetails;

        private TaskSubmittedEventDetails taskSubmittedEventDetails;

        private TaskSucceededEventDetails taskSucceededEventDetails;

        private TaskTimedOutEventDetails taskTimedOutEventDetails;

        private ExecutionFailedEventDetails executionFailedEventDetails;

        private ExecutionStartedEventDetails executionStartedEventDetails;

        private ExecutionSucceededEventDetails executionSucceededEventDetails;

        private ExecutionAbortedEventDetails executionAbortedEventDetails;

        private ExecutionTimedOutEventDetails executionTimedOutEventDetails;

        private LambdaFunctionFailedEventDetails lambdaFunctionFailedEventDetails;

        private LambdaFunctionScheduleFailedEventDetails lambdaFunctionScheduleFailedEventDetails;

        private LambdaFunctionScheduledEventDetails lambdaFunctionScheduledEventDetails;

        private LambdaFunctionStartFailedEventDetails lambdaFunctionStartFailedEventDetails;

        private LambdaFunctionSucceededEventDetails lambdaFunctionSucceededEventDetails;

        private LambdaFunctionTimedOutEventDetails lambdaFunctionTimedOutEventDetails;

        private StateEnteredEventDetails stateEnteredEventDetails;

        private StateExitedEventDetails stateExitedEventDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoryEvent model) {
            timestamp(model.timestamp);
            type(model.type);
            id(model.id);
            previousEventId(model.previousEventId);
            activityFailedEventDetails(model.activityFailedEventDetails);
            activityScheduleFailedEventDetails(model.activityScheduleFailedEventDetails);
            activityScheduledEventDetails(model.activityScheduledEventDetails);
            activityStartedEventDetails(model.activityStartedEventDetails);
            activitySucceededEventDetails(model.activitySucceededEventDetails);
            activityTimedOutEventDetails(model.activityTimedOutEventDetails);
            taskFailedEventDetails(model.taskFailedEventDetails);
            taskScheduledEventDetails(model.taskScheduledEventDetails);
            taskStartFailedEventDetails(model.taskStartFailedEventDetails);
            taskStartedEventDetails(model.taskStartedEventDetails);
            taskSubmitFailedEventDetails(model.taskSubmitFailedEventDetails);
            taskSubmittedEventDetails(model.taskSubmittedEventDetails);
            taskSucceededEventDetails(model.taskSucceededEventDetails);
            taskTimedOutEventDetails(model.taskTimedOutEventDetails);
            executionFailedEventDetails(model.executionFailedEventDetails);
            executionStartedEventDetails(model.executionStartedEventDetails);
            executionSucceededEventDetails(model.executionSucceededEventDetails);
            executionAbortedEventDetails(model.executionAbortedEventDetails);
            executionTimedOutEventDetails(model.executionTimedOutEventDetails);
            lambdaFunctionFailedEventDetails(model.lambdaFunctionFailedEventDetails);
            lambdaFunctionScheduleFailedEventDetails(model.lambdaFunctionScheduleFailedEventDetails);
            lambdaFunctionScheduledEventDetails(model.lambdaFunctionScheduledEventDetails);
            lambdaFunctionStartFailedEventDetails(model.lambdaFunctionStartFailedEventDetails);
            lambdaFunctionSucceededEventDetails(model.lambdaFunctionSucceededEventDetails);
            lambdaFunctionTimedOutEventDetails(model.lambdaFunctionTimedOutEventDetails);
            stateEnteredEventDetails(model.stateEnteredEventDetails);
            stateExitedEventDetails(model.stateExitedEventDetails);
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HistoryEventType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Long getId() {
            return id;
        }

        @Override
        public final Builder id(Long id) {
            this.id = id;
            return this;
        }

        public final void setId(Long id) {
            this.id = id;
        }

        public final Long getPreviousEventId() {
            return previousEventId;
        }

        @Override
        public final Builder previousEventId(Long previousEventId) {
            this.previousEventId = previousEventId;
            return this;
        }

        public final void setPreviousEventId(Long previousEventId) {
            this.previousEventId = previousEventId;
        }

        public final ActivityFailedEventDetails.Builder getActivityFailedEventDetails() {
            return activityFailedEventDetails != null ? activityFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder activityFailedEventDetails(ActivityFailedEventDetails activityFailedEventDetails) {
            this.activityFailedEventDetails = activityFailedEventDetails;
            return this;
        }

        public final void setActivityFailedEventDetails(ActivityFailedEventDetails.BuilderImpl activityFailedEventDetails) {
            this.activityFailedEventDetails = activityFailedEventDetails != null ? activityFailedEventDetails.build() : null;
        }

        public final ActivityScheduleFailedEventDetails.Builder getActivityScheduleFailedEventDetails() {
            return activityScheduleFailedEventDetails != null ? activityScheduleFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder activityScheduleFailedEventDetails(
                ActivityScheduleFailedEventDetails activityScheduleFailedEventDetails) {
            this.activityScheduleFailedEventDetails = activityScheduleFailedEventDetails;
            return this;
        }

        public final void setActivityScheduleFailedEventDetails(
                ActivityScheduleFailedEventDetails.BuilderImpl activityScheduleFailedEventDetails) {
            this.activityScheduleFailedEventDetails = activityScheduleFailedEventDetails != null ? activityScheduleFailedEventDetails
                    .build() : null;
        }

        public final ActivityScheduledEventDetails.Builder getActivityScheduledEventDetails() {
            return activityScheduledEventDetails != null ? activityScheduledEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder activityScheduledEventDetails(ActivityScheduledEventDetails activityScheduledEventDetails) {
            this.activityScheduledEventDetails = activityScheduledEventDetails;
            return this;
        }

        public final void setActivityScheduledEventDetails(ActivityScheduledEventDetails.BuilderImpl activityScheduledEventDetails) {
            this.activityScheduledEventDetails = activityScheduledEventDetails != null ? activityScheduledEventDetails.build()
                    : null;
        }

        public final ActivityStartedEventDetails.Builder getActivityStartedEventDetails() {
            return activityStartedEventDetails != null ? activityStartedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder activityStartedEventDetails(ActivityStartedEventDetails activityStartedEventDetails) {
            this.activityStartedEventDetails = activityStartedEventDetails;
            return this;
        }

        public final void setActivityStartedEventDetails(ActivityStartedEventDetails.BuilderImpl activityStartedEventDetails) {
            this.activityStartedEventDetails = activityStartedEventDetails != null ? activityStartedEventDetails.build() : null;
        }

        public final ActivitySucceededEventDetails.Builder getActivitySucceededEventDetails() {
            return activitySucceededEventDetails != null ? activitySucceededEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder activitySucceededEventDetails(ActivitySucceededEventDetails activitySucceededEventDetails) {
            this.activitySucceededEventDetails = activitySucceededEventDetails;
            return this;
        }

        public final void setActivitySucceededEventDetails(ActivitySucceededEventDetails.BuilderImpl activitySucceededEventDetails) {
            this.activitySucceededEventDetails = activitySucceededEventDetails != null ? activitySucceededEventDetails.build()
                    : null;
        }

        public final ActivityTimedOutEventDetails.Builder getActivityTimedOutEventDetails() {
            return activityTimedOutEventDetails != null ? activityTimedOutEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder activityTimedOutEventDetails(ActivityTimedOutEventDetails activityTimedOutEventDetails) {
            this.activityTimedOutEventDetails = activityTimedOutEventDetails;
            return this;
        }

        public final void setActivityTimedOutEventDetails(ActivityTimedOutEventDetails.BuilderImpl activityTimedOutEventDetails) {
            this.activityTimedOutEventDetails = activityTimedOutEventDetails != null ? activityTimedOutEventDetails.build()
                    : null;
        }

        public final TaskFailedEventDetails.Builder getTaskFailedEventDetails() {
            return taskFailedEventDetails != null ? taskFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder taskFailedEventDetails(TaskFailedEventDetails taskFailedEventDetails) {
            this.taskFailedEventDetails = taskFailedEventDetails;
            return this;
        }

        public final void setTaskFailedEventDetails(TaskFailedEventDetails.BuilderImpl taskFailedEventDetails) {
            this.taskFailedEventDetails = taskFailedEventDetails != null ? taskFailedEventDetails.build() : null;
        }

        public final TaskScheduledEventDetails.Builder getTaskScheduledEventDetails() {
            return taskScheduledEventDetails != null ? taskScheduledEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder taskScheduledEventDetails(TaskScheduledEventDetails taskScheduledEventDetails) {
            this.taskScheduledEventDetails = taskScheduledEventDetails;
            return this;
        }

        public final void setTaskScheduledEventDetails(TaskScheduledEventDetails.BuilderImpl taskScheduledEventDetails) {
            this.taskScheduledEventDetails = taskScheduledEventDetails != null ? taskScheduledEventDetails.build() : null;
        }

        public final TaskStartFailedEventDetails.Builder getTaskStartFailedEventDetails() {
            return taskStartFailedEventDetails != null ? taskStartFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder taskStartFailedEventDetails(TaskStartFailedEventDetails taskStartFailedEventDetails) {
            this.taskStartFailedEventDetails = taskStartFailedEventDetails;
            return this;
        }

        public final void setTaskStartFailedEventDetails(TaskStartFailedEventDetails.BuilderImpl taskStartFailedEventDetails) {
            this.taskStartFailedEventDetails = taskStartFailedEventDetails != null ? taskStartFailedEventDetails.build() : null;
        }

        public final TaskStartedEventDetails.Builder getTaskStartedEventDetails() {
            return taskStartedEventDetails != null ? taskStartedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder taskStartedEventDetails(TaskStartedEventDetails taskStartedEventDetails) {
            this.taskStartedEventDetails = taskStartedEventDetails;
            return this;
        }

        public final void setTaskStartedEventDetails(TaskStartedEventDetails.BuilderImpl taskStartedEventDetails) {
            this.taskStartedEventDetails = taskStartedEventDetails != null ? taskStartedEventDetails.build() : null;
        }

        public final TaskSubmitFailedEventDetails.Builder getTaskSubmitFailedEventDetails() {
            return taskSubmitFailedEventDetails != null ? taskSubmitFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder taskSubmitFailedEventDetails(TaskSubmitFailedEventDetails taskSubmitFailedEventDetails) {
            this.taskSubmitFailedEventDetails = taskSubmitFailedEventDetails;
            return this;
        }

        public final void setTaskSubmitFailedEventDetails(TaskSubmitFailedEventDetails.BuilderImpl taskSubmitFailedEventDetails) {
            this.taskSubmitFailedEventDetails = taskSubmitFailedEventDetails != null ? taskSubmitFailedEventDetails.build()
                    : null;
        }

        public final TaskSubmittedEventDetails.Builder getTaskSubmittedEventDetails() {
            return taskSubmittedEventDetails != null ? taskSubmittedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder taskSubmittedEventDetails(TaskSubmittedEventDetails taskSubmittedEventDetails) {
            this.taskSubmittedEventDetails = taskSubmittedEventDetails;
            return this;
        }

        public final void setTaskSubmittedEventDetails(TaskSubmittedEventDetails.BuilderImpl taskSubmittedEventDetails) {
            this.taskSubmittedEventDetails = taskSubmittedEventDetails != null ? taskSubmittedEventDetails.build() : null;
        }

        public final TaskSucceededEventDetails.Builder getTaskSucceededEventDetails() {
            return taskSucceededEventDetails != null ? taskSucceededEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder taskSucceededEventDetails(TaskSucceededEventDetails taskSucceededEventDetails) {
            this.taskSucceededEventDetails = taskSucceededEventDetails;
            return this;
        }

        public final void setTaskSucceededEventDetails(TaskSucceededEventDetails.BuilderImpl taskSucceededEventDetails) {
            this.taskSucceededEventDetails = taskSucceededEventDetails != null ? taskSucceededEventDetails.build() : null;
        }

        public final TaskTimedOutEventDetails.Builder getTaskTimedOutEventDetails() {
            return taskTimedOutEventDetails != null ? taskTimedOutEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder taskTimedOutEventDetails(TaskTimedOutEventDetails taskTimedOutEventDetails) {
            this.taskTimedOutEventDetails = taskTimedOutEventDetails;
            return this;
        }

        public final void setTaskTimedOutEventDetails(TaskTimedOutEventDetails.BuilderImpl taskTimedOutEventDetails) {
            this.taskTimedOutEventDetails = taskTimedOutEventDetails != null ? taskTimedOutEventDetails.build() : null;
        }

        public final ExecutionFailedEventDetails.Builder getExecutionFailedEventDetails() {
            return executionFailedEventDetails != null ? executionFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder executionFailedEventDetails(ExecutionFailedEventDetails executionFailedEventDetails) {
            this.executionFailedEventDetails = executionFailedEventDetails;
            return this;
        }

        public final void setExecutionFailedEventDetails(ExecutionFailedEventDetails.BuilderImpl executionFailedEventDetails) {
            this.executionFailedEventDetails = executionFailedEventDetails != null ? executionFailedEventDetails.build() : null;
        }

        public final ExecutionStartedEventDetails.Builder getExecutionStartedEventDetails() {
            return executionStartedEventDetails != null ? executionStartedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder executionStartedEventDetails(ExecutionStartedEventDetails executionStartedEventDetails) {
            this.executionStartedEventDetails = executionStartedEventDetails;
            return this;
        }

        public final void setExecutionStartedEventDetails(ExecutionStartedEventDetails.BuilderImpl executionStartedEventDetails) {
            this.executionStartedEventDetails = executionStartedEventDetails != null ? executionStartedEventDetails.build()
                    : null;
        }

        public final ExecutionSucceededEventDetails.Builder getExecutionSucceededEventDetails() {
            return executionSucceededEventDetails != null ? executionSucceededEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder executionSucceededEventDetails(ExecutionSucceededEventDetails executionSucceededEventDetails) {
            this.executionSucceededEventDetails = executionSucceededEventDetails;
            return this;
        }

        public final void setExecutionSucceededEventDetails(
                ExecutionSucceededEventDetails.BuilderImpl executionSucceededEventDetails) {
            this.executionSucceededEventDetails = executionSucceededEventDetails != null ? executionSucceededEventDetails.build()
                    : null;
        }

        public final ExecutionAbortedEventDetails.Builder getExecutionAbortedEventDetails() {
            return executionAbortedEventDetails != null ? executionAbortedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder executionAbortedEventDetails(ExecutionAbortedEventDetails executionAbortedEventDetails) {
            this.executionAbortedEventDetails = executionAbortedEventDetails;
            return this;
        }

        public final void setExecutionAbortedEventDetails(ExecutionAbortedEventDetails.BuilderImpl executionAbortedEventDetails) {
            this.executionAbortedEventDetails = executionAbortedEventDetails != null ? executionAbortedEventDetails.build()
                    : null;
        }

        public final ExecutionTimedOutEventDetails.Builder getExecutionTimedOutEventDetails() {
            return executionTimedOutEventDetails != null ? executionTimedOutEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder executionTimedOutEventDetails(ExecutionTimedOutEventDetails executionTimedOutEventDetails) {
            this.executionTimedOutEventDetails = executionTimedOutEventDetails;
            return this;
        }

        public final void setExecutionTimedOutEventDetails(ExecutionTimedOutEventDetails.BuilderImpl executionTimedOutEventDetails) {
            this.executionTimedOutEventDetails = executionTimedOutEventDetails != null ? executionTimedOutEventDetails.build()
                    : null;
        }

        public final LambdaFunctionFailedEventDetails.Builder getLambdaFunctionFailedEventDetails() {
            return lambdaFunctionFailedEventDetails != null ? lambdaFunctionFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunctionFailedEventDetails(LambdaFunctionFailedEventDetails lambdaFunctionFailedEventDetails) {
            this.lambdaFunctionFailedEventDetails = lambdaFunctionFailedEventDetails;
            return this;
        }

        public final void setLambdaFunctionFailedEventDetails(
                LambdaFunctionFailedEventDetails.BuilderImpl lambdaFunctionFailedEventDetails) {
            this.lambdaFunctionFailedEventDetails = lambdaFunctionFailedEventDetails != null ? lambdaFunctionFailedEventDetails
                    .build() : null;
        }

        public final LambdaFunctionScheduleFailedEventDetails.Builder getLambdaFunctionScheduleFailedEventDetails() {
            return lambdaFunctionScheduleFailedEventDetails != null ? lambdaFunctionScheduleFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunctionScheduleFailedEventDetails(
                LambdaFunctionScheduleFailedEventDetails lambdaFunctionScheduleFailedEventDetails) {
            this.lambdaFunctionScheduleFailedEventDetails = lambdaFunctionScheduleFailedEventDetails;
            return this;
        }

        public final void setLambdaFunctionScheduleFailedEventDetails(
                LambdaFunctionScheduleFailedEventDetails.BuilderImpl lambdaFunctionScheduleFailedEventDetails) {
            this.lambdaFunctionScheduleFailedEventDetails = lambdaFunctionScheduleFailedEventDetails != null ? lambdaFunctionScheduleFailedEventDetails
                    .build() : null;
        }

        public final LambdaFunctionScheduledEventDetails.Builder getLambdaFunctionScheduledEventDetails() {
            return lambdaFunctionScheduledEventDetails != null ? lambdaFunctionScheduledEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunctionScheduledEventDetails(
                LambdaFunctionScheduledEventDetails lambdaFunctionScheduledEventDetails) {
            this.lambdaFunctionScheduledEventDetails = lambdaFunctionScheduledEventDetails;
            return this;
        }

        public final void setLambdaFunctionScheduledEventDetails(
                LambdaFunctionScheduledEventDetails.BuilderImpl lambdaFunctionScheduledEventDetails) {
            this.lambdaFunctionScheduledEventDetails = lambdaFunctionScheduledEventDetails != null ? lambdaFunctionScheduledEventDetails
                    .build() : null;
        }

        public final LambdaFunctionStartFailedEventDetails.Builder getLambdaFunctionStartFailedEventDetails() {
            return lambdaFunctionStartFailedEventDetails != null ? lambdaFunctionStartFailedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunctionStartFailedEventDetails(
                LambdaFunctionStartFailedEventDetails lambdaFunctionStartFailedEventDetails) {
            this.lambdaFunctionStartFailedEventDetails = lambdaFunctionStartFailedEventDetails;
            return this;
        }

        public final void setLambdaFunctionStartFailedEventDetails(
                LambdaFunctionStartFailedEventDetails.BuilderImpl lambdaFunctionStartFailedEventDetails) {
            this.lambdaFunctionStartFailedEventDetails = lambdaFunctionStartFailedEventDetails != null ? lambdaFunctionStartFailedEventDetails
                    .build() : null;
        }

        public final LambdaFunctionSucceededEventDetails.Builder getLambdaFunctionSucceededEventDetails() {
            return lambdaFunctionSucceededEventDetails != null ? lambdaFunctionSucceededEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunctionSucceededEventDetails(
                LambdaFunctionSucceededEventDetails lambdaFunctionSucceededEventDetails) {
            this.lambdaFunctionSucceededEventDetails = lambdaFunctionSucceededEventDetails;
            return this;
        }

        public final void setLambdaFunctionSucceededEventDetails(
                LambdaFunctionSucceededEventDetails.BuilderImpl lambdaFunctionSucceededEventDetails) {
            this.lambdaFunctionSucceededEventDetails = lambdaFunctionSucceededEventDetails != null ? lambdaFunctionSucceededEventDetails
                    .build() : null;
        }

        public final LambdaFunctionTimedOutEventDetails.Builder getLambdaFunctionTimedOutEventDetails() {
            return lambdaFunctionTimedOutEventDetails != null ? lambdaFunctionTimedOutEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunctionTimedOutEventDetails(
                LambdaFunctionTimedOutEventDetails lambdaFunctionTimedOutEventDetails) {
            this.lambdaFunctionTimedOutEventDetails = lambdaFunctionTimedOutEventDetails;
            return this;
        }

        public final void setLambdaFunctionTimedOutEventDetails(
                LambdaFunctionTimedOutEventDetails.BuilderImpl lambdaFunctionTimedOutEventDetails) {
            this.lambdaFunctionTimedOutEventDetails = lambdaFunctionTimedOutEventDetails != null ? lambdaFunctionTimedOutEventDetails
                    .build() : null;
        }

        public final StateEnteredEventDetails.Builder getStateEnteredEventDetails() {
            return stateEnteredEventDetails != null ? stateEnteredEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder stateEnteredEventDetails(StateEnteredEventDetails stateEnteredEventDetails) {
            this.stateEnteredEventDetails = stateEnteredEventDetails;
            return this;
        }

        public final void setStateEnteredEventDetails(StateEnteredEventDetails.BuilderImpl stateEnteredEventDetails) {
            this.stateEnteredEventDetails = stateEnteredEventDetails != null ? stateEnteredEventDetails.build() : null;
        }

        public final StateExitedEventDetails.Builder getStateExitedEventDetails() {
            return stateExitedEventDetails != null ? stateExitedEventDetails.toBuilder() : null;
        }

        @Override
        public final Builder stateExitedEventDetails(StateExitedEventDetails stateExitedEventDetails) {
            this.stateExitedEventDetails = stateExitedEventDetails;
            return this;
        }

        public final void setStateExitedEventDetails(StateExitedEventDetails.BuilderImpl stateExitedEventDetails) {
            this.stateExitedEventDetails = stateExitedEventDetails != null ? stateExitedEventDetails.build() : null;
        }

        @Override
        public HistoryEvent build() {
            return new HistoryEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
