/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Limits settings on protections for your subscription.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectionLimits implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectionLimits.Builder, ProtectionLimits> {
    private static final SdkField<List<Limit>> PROTECTED_RESOURCE_TYPE_LIMITS_FIELD = SdkField
            .<List<Limit>> builder(MarshallingType.LIST)
            .memberName("ProtectedResourceTypeLimits")
            .getter(getter(ProtectionLimits::protectedResourceTypeLimits))
            .setter(setter(Builder::protectedResourceTypeLimits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceTypeLimits")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Limit> builder(MarshallingType.SDK_POJO)
                                            .constructor(Limit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PROTECTED_RESOURCE_TYPE_LIMITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Limit> protectedResourceTypeLimits;

    private ProtectionLimits(BuilderImpl builder) {
        this.protectedResourceTypeLimits = builder.protectedResourceTypeLimits;
    }

    /**
     * Returns true if the ProtectedResourceTypeLimits property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasProtectedResourceTypeLimits() {
        return protectedResourceTypeLimits != null && !(protectedResourceTypeLimits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The maximum number of resource types that you can specify in a protection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProtectedResourceTypeLimits()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The maximum number of resource types that you can specify in a protection.
     */
    public final List<Limit> protectedResourceTypeLimits() {
        return protectedResourceTypeLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasProtectedResourceTypeLimits() ? protectedResourceTypeLimits() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectionLimits)) {
            return false;
        }
        ProtectionLimits other = (ProtectionLimits) obj;
        return hasProtectedResourceTypeLimits() == other.hasProtectedResourceTypeLimits()
                && Objects.equals(protectedResourceTypeLimits(), other.protectedResourceTypeLimits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectionLimits")
                .add("ProtectedResourceTypeLimits", hasProtectedResourceTypeLimits() ? protectedResourceTypeLimits() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectedResourceTypeLimits":
            return Optional.ofNullable(clazz.cast(protectedResourceTypeLimits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectionLimits, T> g) {
        return obj -> g.apply((ProtectionLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectionLimits> {
        /**
         * <p>
         * The maximum number of resource types that you can specify in a protection.
         * </p>
         * 
         * @param protectedResourceTypeLimits
         *        The maximum number of resource types that you can specify in a protection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedResourceTypeLimits(Collection<Limit> protectedResourceTypeLimits);

        /**
         * <p>
         * The maximum number of resource types that you can specify in a protection.
         * </p>
         * 
         * @param protectedResourceTypeLimits
         *        The maximum number of resource types that you can specify in a protection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedResourceTypeLimits(Limit... protectedResourceTypeLimits);

        /**
         * <p>
         * The maximum number of resource types that you can specify in a protection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Limit>.Builder} avoiding the need to create
         * one manually via {@link List<Limit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Limit>.Builder#build()} is called immediately and its result
         * is passed to {@link #protectedResourceTypeLimits(List<Limit>)}.
         * 
         * @param protectedResourceTypeLimits
         *        a consumer that will call methods on {@link List<Limit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protectedResourceTypeLimits(List<Limit>)
         */
        Builder protectedResourceTypeLimits(Consumer<Limit.Builder>... protectedResourceTypeLimits);
    }

    static final class BuilderImpl implements Builder {
        private List<Limit> protectedResourceTypeLimits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectionLimits model) {
            protectedResourceTypeLimits(model.protectedResourceTypeLimits);
        }

        public final List<Limit.Builder> getProtectedResourceTypeLimits() {
            List<Limit.Builder> result = LimitsCopier.copyToBuilder(this.protectedResourceTypeLimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder protectedResourceTypeLimits(Collection<Limit> protectedResourceTypeLimits) {
            this.protectedResourceTypeLimits = LimitsCopier.copy(protectedResourceTypeLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedResourceTypeLimits(Limit... protectedResourceTypeLimits) {
            protectedResourceTypeLimits(Arrays.asList(protectedResourceTypeLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedResourceTypeLimits(Consumer<Limit.Builder>... protectedResourceTypeLimits) {
            protectedResourceTypeLimits(Stream.of(protectedResourceTypeLimits).map(c -> Limit.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProtectedResourceTypeLimits(Collection<Limit.BuilderImpl> protectedResourceTypeLimits) {
            this.protectedResourceTypeLimits = LimitsCopier.copyFromBuilder(protectedResourceTypeLimits);
        }

        @Override
        public ProtectionLimits build() {
            return new ProtectionLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
