/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.shield.model.AssociateDrtLogBucketRequest;
import software.amazon.awssdk.services.shield.model.AssociateDrtLogBucketResponse;
import software.amazon.awssdk.services.shield.model.AssociateDrtRoleRequest;
import software.amazon.awssdk.services.shield.model.AssociateDrtRoleResponse;
import software.amazon.awssdk.services.shield.model.AssociateHealthCheckRequest;
import software.amazon.awssdk.services.shield.model.AssociateHealthCheckResponse;
import software.amazon.awssdk.services.shield.model.AssociateProactiveEngagementDetailsRequest;
import software.amazon.awssdk.services.shield.model.AssociateProactiveEngagementDetailsResponse;
import software.amazon.awssdk.services.shield.model.CreateProtectionGroupRequest;
import software.amazon.awssdk.services.shield.model.CreateProtectionGroupResponse;
import software.amazon.awssdk.services.shield.model.CreateProtectionRequest;
import software.amazon.awssdk.services.shield.model.CreateProtectionResponse;
import software.amazon.awssdk.services.shield.model.CreateSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.CreateSubscriptionResponse;
import software.amazon.awssdk.services.shield.model.DeleteProtectionGroupRequest;
import software.amazon.awssdk.services.shield.model.DeleteProtectionGroupResponse;
import software.amazon.awssdk.services.shield.model.DeleteProtectionRequest;
import software.amazon.awssdk.services.shield.model.DeleteProtectionResponse;
import software.amazon.awssdk.services.shield.model.DescribeAttackRequest;
import software.amazon.awssdk.services.shield.model.DescribeAttackResponse;
import software.amazon.awssdk.services.shield.model.DescribeAttackStatisticsRequest;
import software.amazon.awssdk.services.shield.model.DescribeAttackStatisticsResponse;
import software.amazon.awssdk.services.shield.model.DescribeDrtAccessRequest;
import software.amazon.awssdk.services.shield.model.DescribeDrtAccessResponse;
import software.amazon.awssdk.services.shield.model.DescribeEmergencyContactSettingsRequest;
import software.amazon.awssdk.services.shield.model.DescribeEmergencyContactSettingsResponse;
import software.amazon.awssdk.services.shield.model.DescribeProtectionGroupRequest;
import software.amazon.awssdk.services.shield.model.DescribeProtectionGroupResponse;
import software.amazon.awssdk.services.shield.model.DescribeProtectionRequest;
import software.amazon.awssdk.services.shield.model.DescribeProtectionResponse;
import software.amazon.awssdk.services.shield.model.DescribeSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.DescribeSubscriptionResponse;
import software.amazon.awssdk.services.shield.model.DisableProactiveEngagementRequest;
import software.amazon.awssdk.services.shield.model.DisableProactiveEngagementResponse;
import software.amazon.awssdk.services.shield.model.DisassociateDrtLogBucketRequest;
import software.amazon.awssdk.services.shield.model.DisassociateDrtLogBucketResponse;
import software.amazon.awssdk.services.shield.model.DisassociateDrtRoleRequest;
import software.amazon.awssdk.services.shield.model.DisassociateDrtRoleResponse;
import software.amazon.awssdk.services.shield.model.DisassociateHealthCheckRequest;
import software.amazon.awssdk.services.shield.model.DisassociateHealthCheckResponse;
import software.amazon.awssdk.services.shield.model.EnableProactiveEngagementRequest;
import software.amazon.awssdk.services.shield.model.EnableProactiveEngagementResponse;
import software.amazon.awssdk.services.shield.model.GetSubscriptionStateRequest;
import software.amazon.awssdk.services.shield.model.GetSubscriptionStateResponse;
import software.amazon.awssdk.services.shield.model.ListAttacksRequest;
import software.amazon.awssdk.services.shield.model.ListAttacksResponse;
import software.amazon.awssdk.services.shield.model.ListProtectionGroupsRequest;
import software.amazon.awssdk.services.shield.model.ListProtectionGroupsResponse;
import software.amazon.awssdk.services.shield.model.ListProtectionsRequest;
import software.amazon.awssdk.services.shield.model.ListProtectionsResponse;
import software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupRequest;
import software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupResponse;
import software.amazon.awssdk.services.shield.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.shield.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.shield.model.TagResourceRequest;
import software.amazon.awssdk.services.shield.model.TagResourceResponse;
import software.amazon.awssdk.services.shield.model.UntagResourceRequest;
import software.amazon.awssdk.services.shield.model.UntagResourceResponse;
import software.amazon.awssdk.services.shield.model.UpdateEmergencyContactSettingsRequest;
import software.amazon.awssdk.services.shield.model.UpdateEmergencyContactSettingsResponse;
import software.amazon.awssdk.services.shield.model.UpdateProtectionGroupRequest;
import software.amazon.awssdk.services.shield.model.UpdateProtectionGroupResponse;
import software.amazon.awssdk.services.shield.model.UpdateSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.UpdateSubscriptionResponse;
import software.amazon.awssdk.services.shield.paginators.ListAttacksPublisher;
import software.amazon.awssdk.services.shield.paginators.ListProtectionGroupsPublisher;
import software.amazon.awssdk.services.shield.paginators.ListProtectionsPublisher;
import software.amazon.awssdk.services.shield.paginators.ListResourcesInProtectionGroupPublisher;

/**
 * Service client for accessing AWS Shield asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>AWS Shield Advanced</fullname>
 * <p>
 * This is the <i>AWS Shield Advanced API Reference</i>. This guide is for developers who need detailed information
 * about the AWS Shield Advanced API actions, data types, and errors. For detailed information about AWS WAF and AWS
 * Shield Advanced features and an overview of how to use the AWS WAF and AWS Shield Advanced APIs, see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF and AWS Shield Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ShieldAsyncClient extends SdkClient {
    String SERVICE_NAME = "shield";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "shield";

    /**
     * Create a {@link ShieldAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ShieldAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ShieldAsyncClient}.
     */
    static ShieldAsyncClientBuilder builder() {
        return new DefaultShieldAsyncClientBuilder();
    }

    /**
     * <p>
     * Authorizes the DDoS Response Team (DRT) to access the specified Amazon S3 bucket containing your AWS WAF logs.
     * You can associate up to 10 Amazon S3 buckets with your subscription.
     * </p>
     * <p>
     * To use the services of the DRT and make an <code>AssociateDRTLogBucket</code> request, you must be subscribed to
     * the <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     *
     * @param associateDrtLogBucketRequest
     * @return A Java Future containing the result of the AssociateDRTLogBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>NoAssociatedRoleException The ARN of the role that you specifed does not exist.</li>
     *         <li>LimitsExceededException Exception that indicates that the operation would exceed a limit.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>AccessDeniedForDependencyException In order to grant the necessary access to the DDoS Response Team
     *         (DRT), the user submitting the request must have the <code>iam:PassRole</code> permission. This error
     *         indicates the user did not have the appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.AssociateDRTLogBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateDRTLogBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateDrtLogBucketResponse> associateDRTLogBucket(
            AssociateDrtLogBucketRequest associateDrtLogBucketRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Authorizes the DDoS Response Team (DRT) to access the specified Amazon S3 bucket containing your AWS WAF logs.
     * You can associate up to 10 Amazon S3 buckets with your subscription.
     * </p>
     * <p>
     * To use the services of the DRT and make an <code>AssociateDRTLogBucket</code> request, you must be subscribed to
     * the <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDrtLogBucketRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateDrtLogBucketRequest#builder()}
     * </p>
     *
     * @param associateDrtLogBucketRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDRTLogBucketRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateDRTLogBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>NoAssociatedRoleException The ARN of the role that you specifed does not exist.</li>
     *         <li>LimitsExceededException Exception that indicates that the operation would exceed a limit.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>AccessDeniedForDependencyException In order to grant the necessary access to the DDoS Response Team
     *         (DRT), the user submitting the request must have the <code>iam:PassRole</code> permission. This error
     *         indicates the user did not have the appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.AssociateDRTLogBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateDRTLogBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateDrtLogBucketResponse> associateDRTLogBucket(
            Consumer<AssociateDrtLogBucketRequest.Builder> associateDrtLogBucketRequest) {
        return associateDRTLogBucket(AssociateDrtLogBucketRequest.builder().applyMutation(associateDrtLogBucketRequest).build());
    }

    /**
     * <p>
     * Authorizes the DDoS Response Team (DRT), using the specified role, to access your AWS account to assist with DDoS
     * attack mitigation during potential attacks. This enables the DRT to inspect your AWS WAF configuration and create
     * or update AWS WAF rules and web ACLs.
     * </p>
     * <p>
     * You can associate only one <code>RoleArn</code> with your subscription. If you submit an
     * <code>AssociateDRTRole</code> request for an account that already has an associated role, the new
     * <code>RoleArn</code> will replace the existing <code>RoleArn</code>.
     * </p>
     * <p>
     * Prior to making the <code>AssociateDRTRole</code> request, you must attach the <a href=
     * "https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy"
     * >AWSShieldDRTAccessPolicy</a> managed policy to the role you will specify in the request. For more information
     * see <a
     * href=" https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Attaching and
     * Detaching IAM Policies</a>. The role must also trust the service principal <code> drt.shield.amazonaws.com</code>
     * . For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">IAM JSON
     * Policy Elements: Principal</a>.
     * </p>
     * <p>
     * The DRT will have access only to your AWS WAF and Shield resources. By submitting this request, you authorize the
     * DRT to inspect your AWS WAF and Shield configuration and create and update AWS WAF rules and web ACLs on your
     * behalf. The DRT takes these actions only if explicitly authorized by you.
     * </p>
     * <p>
     * You must have the <code>iam:PassRole</code> permission to make an <code>AssociateDRTRole</code> request. For more
     * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a
     * User Permissions to Pass a Role to an AWS Service</a>.
     * </p>
     * <p>
     * To use the services of the DRT and make an <code>AssociateDRTRole</code> request, you must be subscribed to the
     * <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     *
     * @param associateDrtRoleRequest
     * @return A Java Future containing the result of the AssociateDRTRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>AccessDeniedForDependencyException In order to grant the necessary access to the DDoS Response Team
     *         (DRT), the user submitting the request must have the <code>iam:PassRole</code> permission. This error
     *         indicates the user did not have the appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.AssociateDRTRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateDRTRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateDrtRoleResponse> associateDRTRole(AssociateDrtRoleRequest associateDrtRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Authorizes the DDoS Response Team (DRT), using the specified role, to access your AWS account to assist with DDoS
     * attack mitigation during potential attacks. This enables the DRT to inspect your AWS WAF configuration and create
     * or update AWS WAF rules and web ACLs.
     * </p>
     * <p>
     * You can associate only one <code>RoleArn</code> with your subscription. If you submit an
     * <code>AssociateDRTRole</code> request for an account that already has an associated role, the new
     * <code>RoleArn</code> will replace the existing <code>RoleArn</code>.
     * </p>
     * <p>
     * Prior to making the <code>AssociateDRTRole</code> request, you must attach the <a href=
     * "https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy"
     * >AWSShieldDRTAccessPolicy</a> managed policy to the role you will specify in the request. For more information
     * see <a
     * href=" https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Attaching and
     * Detaching IAM Policies</a>. The role must also trust the service principal <code> drt.shield.amazonaws.com</code>
     * . For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">IAM JSON
     * Policy Elements: Principal</a>.
     * </p>
     * <p>
     * The DRT will have access only to your AWS WAF and Shield resources. By submitting this request, you authorize the
     * DRT to inspect your AWS WAF and Shield configuration and create and update AWS WAF rules and web ACLs on your
     * behalf. The DRT takes these actions only if explicitly authorized by you.
     * </p>
     * <p>
     * You must have the <code>iam:PassRole</code> permission to make an <code>AssociateDRTRole</code> request. For more
     * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a
     * User Permissions to Pass a Role to an AWS Service</a>.
     * </p>
     * <p>
     * To use the services of the DRT and make an <code>AssociateDRTRole</code> request, you must be subscribed to the
     * <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDrtRoleRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateDrtRoleRequest#builder()}
     * </p>
     *
     * @param associateDrtRoleRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDRTRoleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateDRTRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>AccessDeniedForDependencyException In order to grant the necessary access to the DDoS Response Team
     *         (DRT), the user submitting the request must have the <code>iam:PassRole</code> permission. This error
     *         indicates the user did not have the appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.AssociateDRTRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateDRTRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateDrtRoleResponse> associateDRTRole(
            Consumer<AssociateDrtRoleRequest.Builder> associateDrtRoleRequest) {
        return associateDRTRole(AssociateDrtRoleRequest.builder().applyMutation(associateDrtRoleRequest).build());
    }

    /**
     * <p>
     * Adds health-based detection to the Shield Advanced protection for a resource. Shield Advanced health-based
     * detection uses the health of your AWS resource to improve responsiveness and accuracy in attack detection and
     * mitigation.
     * </p>
     * <p>
     * You define the health check in Route 53 and then associate it with your Shield Advanced protection. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option"
     * >Shield Advanced Health-Based Detection</a> in the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF and AWS Shield Developer Guide</a>.
     * </p>
     *
     * @param associateHealthCheckRequest
     * @return A Java Future containing the result of the AssociateHealthCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>LimitsExceededException Exception that indicates that the operation would exceed a limit.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.AssociateHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateHealthCheck" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateHealthCheckResponse> associateHealthCheck(
            AssociateHealthCheckRequest associateHealthCheckRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds health-based detection to the Shield Advanced protection for a resource. Shield Advanced health-based
     * detection uses the health of your AWS resource to improve responsiveness and accuracy in attack detection and
     * mitigation.
     * </p>
     * <p>
     * You define the health check in Route 53 and then associate it with your Shield Advanced protection. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option"
     * >Shield Advanced Health-Based Detection</a> in the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF and AWS Shield Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateHealthCheckRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateHealthCheckRequest#builder()}
     * </p>
     *
     * @param associateHealthCheckRequest
     *        A {@link Consumer} that will call methods on {@link AssociateHealthCheckRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateHealthCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>LimitsExceededException Exception that indicates that the operation would exceed a limit.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.AssociateHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateHealthCheck" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateHealthCheckResponse> associateHealthCheck(
            Consumer<AssociateHealthCheckRequest.Builder> associateHealthCheckRequest) {
        return associateHealthCheck(AssociateHealthCheckRequest.builder().applyMutation(associateHealthCheckRequest).build());
    }

    /**
     * <p>
     * Initializes proactive engagement and sets the list of contacts for the DDoS Response Team (DRT) to use. You must
     * provide at least one phone number in the emergency contact list.
     * </p>
     * <p>
     * After you have initialized proactive engagement using this call, to disable or enable proactive engagement, use
     * the calls <code>DisableProactiveEngagement</code> and <code>EnableProactiveEngagement</code>.
     * </p>
     * <note>
     * <p>
     * This call defines the list of email addresses and phone numbers that the DDoS Response Team (DRT) can use to
     * contact you for escalations to the DRT and to initiate proactive customer support.
     * </p>
     * <p>
     * The contacts that you provide in the request replace any contacts that were already defined. If you already have
     * contacts defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code> and
     * then provide it to this call.
     * </p>
     * </note>
     *
     * @param associateProactiveEngagementDetailsRequest
     * @return A Java Future containing the result of the AssociateProactiveEngagementDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.AssociateProactiveEngagementDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateProactiveEngagementDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateProactiveEngagementDetailsResponse> associateProactiveEngagementDetails(
            AssociateProactiveEngagementDetailsRequest associateProactiveEngagementDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initializes proactive engagement and sets the list of contacts for the DDoS Response Team (DRT) to use. You must
     * provide at least one phone number in the emergency contact list.
     * </p>
     * <p>
     * After you have initialized proactive engagement using this call, to disable or enable proactive engagement, use
     * the calls <code>DisableProactiveEngagement</code> and <code>EnableProactiveEngagement</code>.
     * </p>
     * <note>
     * <p>
     * This call defines the list of email addresses and phone numbers that the DDoS Response Team (DRT) can use to
     * contact you for escalations to the DRT and to initiate proactive customer support.
     * </p>
     * <p>
     * The contacts that you provide in the request replace any contacts that were already defined. If you already have
     * contacts defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code> and
     * then provide it to this call.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateProactiveEngagementDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateProactiveEngagementDetailsRequest#builder()}
     * </p>
     *
     * @param associateProactiveEngagementDetailsRequest
     *        A {@link Consumer} that will call methods on {@link AssociateProactiveEngagementDetailsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateProactiveEngagementDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.AssociateProactiveEngagementDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateProactiveEngagementDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateProactiveEngagementDetailsResponse> associateProactiveEngagementDetails(
            Consumer<AssociateProactiveEngagementDetailsRequest.Builder> associateProactiveEngagementDetailsRequest) {
        return associateProactiveEngagementDetails(AssociateProactiveEngagementDetailsRequest.builder()
                .applyMutation(associateProactiveEngagementDetailsRequest).build());
    }

    /**
     * <p>
     * Enables AWS Shield Advanced for a specific AWS resource. The resource can be an Amazon CloudFront distribution,
     * Elastic Load Balancing load balancer, AWS Global Accelerator accelerator, Elastic IP Address, or an Amazon Route
     * 53 hosted zone.
     * </p>
     * <p>
     * You can add protection to only a single resource with each CreateProtection request. If you want to add
     * protection to multiple resources at once, use the <a href="https://console.aws.amazon.com/waf/">AWS WAF
     * console</a>. For more information see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html">Getting Started with AWS
     * Shield Advanced</a> and <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/configure-new-protection.html">Add AWS Shield
     * Advanced Protection to more AWS Resources</a>.
     * </p>
     *
     * @param createProtectionRequest
     * @return A Java Future containing the result of the CreateProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidResourceException Exception that indicates that the resource is invalid. You might not have
     *         access to the resource, or the resource might not exist.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>LimitsExceededException Exception that indicates that the operation would exceed a limit.</li>
     *         <li>ResourceAlreadyExistsException Exception indicating the specified resource already exists. If
     *         available, this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.CreateProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProtectionResponse> createProtection(CreateProtectionRequest createProtectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables AWS Shield Advanced for a specific AWS resource. The resource can be an Amazon CloudFront distribution,
     * Elastic Load Balancing load balancer, AWS Global Accelerator accelerator, Elastic IP Address, or an Amazon Route
     * 53 hosted zone.
     * </p>
     * <p>
     * You can add protection to only a single resource with each CreateProtection request. If you want to add
     * protection to multiple resources at once, use the <a href="https://console.aws.amazon.com/waf/">AWS WAF
     * console</a>. For more information see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html">Getting Started with AWS
     * Shield Advanced</a> and <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/configure-new-protection.html">Add AWS Shield
     * Advanced Protection to more AWS Resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProtectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateProtectionRequest#builder()}
     * </p>
     *
     * @param createProtectionRequest
     *        A {@link Consumer} that will call methods on {@link CreateProtectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidResourceException Exception that indicates that the resource is invalid. You might not have
     *         access to the resource, or the resource might not exist.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>LimitsExceededException Exception that indicates that the operation would exceed a limit.</li>
     *         <li>ResourceAlreadyExistsException Exception indicating the specified resource already exists. If
     *         available, this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.CreateProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProtectionResponse> createProtection(
            Consumer<CreateProtectionRequest.Builder> createProtectionRequest) {
        return createProtection(CreateProtectionRequest.builder().applyMutation(createProtectionRequest).build());
    }

    /**
     * <p>
     * Creates a grouping of protected resources so they can be handled as a collective. This resource grouping improves
     * the accuracy of detection and reduces false positives.
     * </p>
     *
     * @param createProtectionGroupRequest
     * @return A Java Future containing the result of the CreateProtectionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceAlreadyExistsException Exception indicating the specified resource already exists. If
     *         available, this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>LimitsExceededException Exception that indicates that the operation would exceed a limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.CreateProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtectionGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateProtectionGroupResponse> createProtectionGroup(
            CreateProtectionGroupRequest createProtectionGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a grouping of protected resources so they can be handled as a collective. This resource grouping improves
     * the accuracy of detection and reduces false positives.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProtectionGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateProtectionGroupRequest#builder()}
     * </p>
     *
     * @param createProtectionGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateProtectionGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateProtectionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceAlreadyExistsException Exception indicating the specified resource already exists. If
     *         available, this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>LimitsExceededException Exception that indicates that the operation would exceed a limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.CreateProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtectionGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateProtectionGroupResponse> createProtectionGroup(
            Consumer<CreateProtectionGroupRequest.Builder> createProtectionGroupRequest) {
        return createProtectionGroup(CreateProtectionGroupRequest.builder().applyMutation(createProtectionGroupRequest).build());
    }

    /**
     * <p>
     * Activates AWS Shield Advanced for an account.
     * </p>
     * <p>
     * When you initally create a subscription, your subscription is set to be automatically renewed at the end of the
     * existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request.
     * </p>
     *
     * @param createSubscriptionRequest
     * @return A Java Future containing the result of the CreateSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceAlreadyExistsException Exception indicating the specified resource already exists. If
     *         available, this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.CreateSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionResponse> createSubscription(CreateSubscriptionRequest createSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates AWS Shield Advanced for an account.
     * </p>
     * <p>
     * When you initally create a subscription, your subscription is set to be automatically renewed at the end of the
     * existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSubscriptionRequest#builder()}
     * </p>
     *
     * @param createSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceAlreadyExistsException Exception indicating the specified resource already exists. If
     *         available, this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.CreateSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionResponse> createSubscription(
            Consumer<CreateSubscriptionRequest.Builder> createSubscriptionRequest) {
        return createSubscription(CreateSubscriptionRequest.builder().applyMutation(createSubscriptionRequest).build());
    }

    /**
     * <p>
     * Activates AWS Shield Advanced for an account.
     * </p>
     * <p>
     * When you initally create a subscription, your subscription is set to be automatically renewed at the end of the
     * existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request.
     * </p>
     *
     * @return A Java Future containing the result of the CreateSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceAlreadyExistsException Exception indicating the specified resource already exists. If
     *         available, this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.CreateSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionResponse> createSubscription() {
        return createSubscription(CreateSubscriptionRequest.builder().build());
    }

    /**
     * <p>
     * Deletes an AWS Shield Advanced <a>Protection</a>.
     * </p>
     *
     * @param deleteProtectionRequest
     * @return A Java Future containing the result of the DeleteProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DeleteProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProtectionResponse> deleteProtection(DeleteProtectionRequest deleteProtectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an AWS Shield Advanced <a>Protection</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProtectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteProtectionRequest#builder()}
     * </p>
     *
     * @param deleteProtectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProtectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DeleteProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProtectionResponse> deleteProtection(
            Consumer<DeleteProtectionRequest.Builder> deleteProtectionRequest) {
        return deleteProtection(DeleteProtectionRequest.builder().applyMutation(deleteProtectionRequest).build());
    }

    /**
     * <p>
     * Removes the specified protection group.
     * </p>
     *
     * @param deleteProtectionGroupRequest
     * @return A Java Future containing the result of the DeleteProtectionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DeleteProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteProtectionGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteProtectionGroupResponse> deleteProtectionGroup(
            DeleteProtectionGroupRequest deleteProtectionGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified protection group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProtectionGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteProtectionGroupRequest#builder()}
     * </p>
     *
     * @param deleteProtectionGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProtectionGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteProtectionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DeleteProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteProtectionGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteProtectionGroupResponse> deleteProtectionGroup(
            Consumer<DeleteProtectionGroupRequest.Builder> deleteProtectionGroupRequest) {
        return deleteProtectionGroup(DeleteProtectionGroupRequest.builder().applyMutation(deleteProtectionGroupRequest).build());
    }

    /**
     * <p>
     * Describes the details of a DDoS attack.
     * </p>
     *
     * @param describeAttackRequest
     * @return A Java Future containing the result of the DescribeAttack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>AccessDeniedException Exception that indicates the specified <code>AttackId</code> does not exist, or
     *         the requester does not have the appropriate permissions to access the <code>AttackId</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeAttack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeAttack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAttackResponse> describeAttack(DescribeAttackRequest describeAttackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the details of a DDoS attack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAttackRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAttackRequest#builder()}
     * </p>
     *
     * @param describeAttackRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAttackRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeAttack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>AccessDeniedException Exception that indicates the specified <code>AttackId</code> does not exist, or
     *         the requester does not have the appropriate permissions to access the <code>AttackId</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeAttack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeAttack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAttackResponse> describeAttack(Consumer<DescribeAttackRequest.Builder> describeAttackRequest) {
        return describeAttack(DescribeAttackRequest.builder().applyMutation(describeAttackRequest).build());
    }

    /**
     * <p>
     * Provides information about the number and type of attacks AWS Shield has detected in the last year for all
     * resources that belong to your account, regardless of whether you've defined Shield protections for them. This
     * operation is available to Shield customers as well as to Shield Advanced customers.
     * </p>
     * <p>
     * The operation returns data for the time range of midnight UTC, one year ago, to midnight UTC, today. For example,
     * if the current time is <code>2020-10-26 15:39:32 PDT</code>, equal to <code>2020-10-26 22:39:32 UTC</code>, then
     * the time range for the attack data returned is from <code>2019-10-26 00:00:00 UTC</code> to
     * <code>2020-10-26 00:00:00 UTC</code>.
     * </p>
     * <p>
     * The time range indicates the period covered by the attack statistics data items.
     * </p>
     *
     * @param describeAttackStatisticsRequest
     * @return A Java Future containing the result of the DescribeAttackStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeAttackStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeAttackStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAttackStatisticsResponse> describeAttackStatistics(
            DescribeAttackStatisticsRequest describeAttackStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the number and type of attacks AWS Shield has detected in the last year for all
     * resources that belong to your account, regardless of whether you've defined Shield protections for them. This
     * operation is available to Shield customers as well as to Shield Advanced customers.
     * </p>
     * <p>
     * The operation returns data for the time range of midnight UTC, one year ago, to midnight UTC, today. For example,
     * if the current time is <code>2020-10-26 15:39:32 PDT</code>, equal to <code>2020-10-26 22:39:32 UTC</code>, then
     * the time range for the attack data returned is from <code>2019-10-26 00:00:00 UTC</code> to
     * <code>2020-10-26 00:00:00 UTC</code>.
     * </p>
     * <p>
     * The time range indicates the period covered by the attack statistics data items.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAttackStatisticsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAttackStatisticsRequest#builder()}
     * </p>
     *
     * @param describeAttackStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAttackStatisticsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAttackStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeAttackStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeAttackStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAttackStatisticsResponse> describeAttackStatistics(
            Consumer<DescribeAttackStatisticsRequest.Builder> describeAttackStatisticsRequest) {
        return describeAttackStatistics(DescribeAttackStatisticsRequest.builder().applyMutation(describeAttackStatisticsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the current role and list of Amazon S3 log buckets used by the DDoS Response Team (DRT) to access your
     * AWS account while assisting with attack mitigation.
     * </p>
     *
     * @param describeDrtAccessRequest
     * @return A Java Future containing the result of the DescribeDRTAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeDRTAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeDRTAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDrtAccessResponse> describeDRTAccess(DescribeDrtAccessRequest describeDrtAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current role and list of Amazon S3 log buckets used by the DDoS Response Team (DRT) to access your
     * AWS account while assisting with attack mitigation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDrtAccessRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDrtAccessRequest#builder()}
     * </p>
     *
     * @param describeDrtAccessRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDRTAccessRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDRTAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeDRTAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeDRTAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDrtAccessResponse> describeDRTAccess(
            Consumer<DescribeDrtAccessRequest.Builder> describeDrtAccessRequest) {
        return describeDRTAccess(DescribeDrtAccessRequest.builder().applyMutation(describeDrtAccessRequest).build());
    }

    /**
     * <p>
     * A list of email addresses and phone numbers that the DDoS Response Team (DRT) can use to contact you if you have
     * proactive engagement enabled, for escalations to the DRT and to initiate proactive customer support.
     * </p>
     *
     * @param describeEmergencyContactSettingsRequest
     * @return A Java Future containing the result of the DescribeEmergencyContactSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeEmergencyContactSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeEmergencyContactSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEmergencyContactSettingsResponse> describeEmergencyContactSettings(
            DescribeEmergencyContactSettingsRequest describeEmergencyContactSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of email addresses and phone numbers that the DDoS Response Team (DRT) can use to contact you if you have
     * proactive engagement enabled, for escalations to the DRT and to initiate proactive customer support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEmergencyContactSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEmergencyContactSettingsRequest#builder()}
     * </p>
     *
     * @param describeEmergencyContactSettingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEmergencyContactSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeEmergencyContactSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeEmergencyContactSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeEmergencyContactSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEmergencyContactSettingsResponse> describeEmergencyContactSettings(
            Consumer<DescribeEmergencyContactSettingsRequest.Builder> describeEmergencyContactSettingsRequest) {
        return describeEmergencyContactSettings(DescribeEmergencyContactSettingsRequest.builder()
                .applyMutation(describeEmergencyContactSettingsRequest).build());
    }

    /**
     * <p>
     * Lists the details of a <a>Protection</a> object.
     * </p>
     *
     * @param describeProtectionRequest
     * @return A Java Future containing the result of the DescribeProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeProtectionResponse> describeProtection(DescribeProtectionRequest describeProtectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the details of a <a>Protection</a> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProtectionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeProtectionRequest#builder()}
     * </p>
     *
     * @param describeProtectionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProtectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeProtectionResponse> describeProtection(
            Consumer<DescribeProtectionRequest.Builder> describeProtectionRequest) {
        return describeProtection(DescribeProtectionRequest.builder().applyMutation(describeProtectionRequest).build());
    }

    /**
     * <p>
     * Returns the specification for the specified protection group.
     * </p>
     *
     * @param describeProtectionGroupRequest
     * @return A Java Future containing the result of the DescribeProtectionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtectionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProtectionGroupResponse> describeProtectionGroup(
            DescribeProtectionGroupRequest describeProtectionGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the specification for the specified protection group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProtectionGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeProtectionGroupRequest#builder()}
     * </p>
     *
     * @param describeProtectionGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProtectionGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeProtectionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtectionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProtectionGroupResponse> describeProtectionGroup(
            Consumer<DescribeProtectionGroupRequest.Builder> describeProtectionGroupRequest) {
        return describeProtectionGroup(DescribeProtectionGroupRequest.builder().applyMutation(describeProtectionGroupRequest)
                .build());
    }

    /**
     * <p>
     * Provides details about the AWS Shield Advanced subscription for an account.
     * </p>
     *
     * @param describeSubscriptionRequest
     * @return A Java Future containing the result of the DescribeSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSubscriptionResponse> describeSubscription(
            DescribeSubscriptionRequest describeSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about the AWS Shield Advanced subscription for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSubscriptionRequest#builder()}
     * </p>
     *
     * @param describeSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSubscriptionResponse> describeSubscription(
            Consumer<DescribeSubscriptionRequest.Builder> describeSubscriptionRequest) {
        return describeSubscription(DescribeSubscriptionRequest.builder().applyMutation(describeSubscriptionRequest).build());
    }

    /**
     * <p>
     * Provides details about the AWS Shield Advanced subscription for an account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSubscriptionResponse> describeSubscription() {
        return describeSubscription(DescribeSubscriptionRequest.builder().build());
    }

    /**
     * <p>
     * Removes authorization from the DDoS Response Team (DRT) to notify contacts about escalations to the DRT and to
     * initiate proactive customer support.
     * </p>
     *
     * @param disableProactiveEngagementRequest
     * @return A Java Future containing the result of the DisableProactiveEngagement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DisableProactiveEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisableProactiveEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableProactiveEngagementResponse> disableProactiveEngagement(
            DisableProactiveEngagementRequest disableProactiveEngagementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes authorization from the DDoS Response Team (DRT) to notify contacts about escalations to the DRT and to
     * initiate proactive customer support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableProactiveEngagementRequest.Builder} avoiding
     * the need to create one manually via {@link DisableProactiveEngagementRequest#builder()}
     * </p>
     *
     * @param disableProactiveEngagementRequest
     *        A {@link Consumer} that will call methods on {@link DisableProactiveEngagementRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisableProactiveEngagement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DisableProactiveEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisableProactiveEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableProactiveEngagementResponse> disableProactiveEngagement(
            Consumer<DisableProactiveEngagementRequest.Builder> disableProactiveEngagementRequest) {
        return disableProactiveEngagement(DisableProactiveEngagementRequest.builder()
                .applyMutation(disableProactiveEngagementRequest).build());
    }

    /**
     * <p>
     * Removes the DDoS Response Team's (DRT) access to the specified Amazon S3 bucket containing your AWS WAF logs.
     * </p>
     * <p>
     * To make a <code>DisassociateDRTLogBucket</code> request, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are
     * not subscribed to one of these support plans, but had been previously and had granted the DRT access to your
     * account, you can submit a <code>DisassociateDRTLogBucket</code> request to remove this access.
     * </p>
     *
     * @param disassociateDrtLogBucketRequest
     * @return A Java Future containing the result of the DisassociateDRTLogBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>NoAssociatedRoleException The ARN of the role that you specifed does not exist.</li>
     *         <li>AccessDeniedForDependencyException In order to grant the necessary access to the DDoS Response Team
     *         (DRT), the user submitting the request must have the <code>iam:PassRole</code> permission. This error
     *         indicates the user did not have the appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DisassociateDRTLogBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTLogBucket"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateDrtLogBucketResponse> disassociateDRTLogBucket(
            DisassociateDrtLogBucketRequest disassociateDrtLogBucketRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the DDoS Response Team's (DRT) access to the specified Amazon S3 bucket containing your AWS WAF logs.
     * </p>
     * <p>
     * To make a <code>DisassociateDRTLogBucket</code> request, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are
     * not subscribed to one of these support plans, but had been previously and had granted the DRT access to your
     * account, you can submit a <code>DisassociateDRTLogBucket</code> request to remove this access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDrtLogBucketRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateDrtLogBucketRequest#builder()}
     * </p>
     *
     * @param disassociateDrtLogBucketRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateDRTLogBucketRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateDRTLogBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>NoAssociatedRoleException The ARN of the role that you specifed does not exist.</li>
     *         <li>AccessDeniedForDependencyException In order to grant the necessary access to the DDoS Response Team
     *         (DRT), the user submitting the request must have the <code>iam:PassRole</code> permission. This error
     *         indicates the user did not have the appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DisassociateDRTLogBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTLogBucket"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateDrtLogBucketResponse> disassociateDRTLogBucket(
            Consumer<DisassociateDrtLogBucketRequest.Builder> disassociateDrtLogBucketRequest) {
        return disassociateDRTLogBucket(DisassociateDrtLogBucketRequest.builder().applyMutation(disassociateDrtLogBucketRequest)
                .build());
    }

    /**
     * <p>
     * Removes the DDoS Response Team's (DRT) access to your AWS account.
     * </p>
     * <p>
     * To make a <code>DisassociateDRTRole</code> request, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are
     * not subscribed to one of these support plans, but had been previously and had granted the DRT access to your
     * account, you can submit a <code>DisassociateDRTRole</code> request to remove this access.
     * </p>
     *
     * @param disassociateDrtRoleRequest
     * @return A Java Future containing the result of the DisassociateDRTRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DisassociateDRTRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateDrtRoleResponse> disassociateDRTRole(
            DisassociateDrtRoleRequest disassociateDrtRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the DDoS Response Team's (DRT) access to your AWS account.
     * </p>
     * <p>
     * To make a <code>DisassociateDRTRole</code> request, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are
     * not subscribed to one of these support plans, but had been previously and had granted the DRT access to your
     * account, you can submit a <code>DisassociateDRTRole</code> request to remove this access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDrtRoleRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateDrtRoleRequest#builder()}
     * </p>
     *
     * @param disassociateDrtRoleRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateDRTRoleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateDRTRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DisassociateDRTRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateDrtRoleResponse> disassociateDRTRole(
            Consumer<DisassociateDrtRoleRequest.Builder> disassociateDrtRoleRequest) {
        return disassociateDRTRole(DisassociateDrtRoleRequest.builder().applyMutation(disassociateDrtRoleRequest).build());
    }

    /**
     * <p>
     * Removes the DDoS Response Team's (DRT) access to your AWS account.
     * </p>
     * <p>
     * To make a <code>DisassociateDRTRole</code> request, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are
     * not subscribed to one of these support plans, but had been previously and had granted the DRT access to your
     * account, you can submit a <code>DisassociateDRTRole</code> request to remove this access.
     * </p>
     *
     * @return A Java Future containing the result of the DisassociateDRTRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DisassociateDRTRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateDrtRoleResponse> disassociateDRTRole() {
        return disassociateDRTRole(DisassociateDrtRoleRequest.builder().build());
    }

    /**
     * <p>
     * Removes health-based detection from the Shield Advanced protection for a resource. Shield Advanced health-based
     * detection uses the health of your AWS resource to improve responsiveness and accuracy in attack detection and
     * mitigation.
     * </p>
     * <p>
     * You define the health check in Route 53 and then associate or disassociate it with your Shield Advanced
     * protection. For more information, see <a href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option"
     * >Shield Advanced Health-Based Detection</a> in the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF and AWS Shield Developer Guide</a>.
     * </p>
     *
     * @param disassociateHealthCheckRequest
     * @return A Java Future containing the result of the DisassociateHealthCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DisassociateHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateHealthCheck"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateHealthCheckResponse> disassociateHealthCheck(
            DisassociateHealthCheckRequest disassociateHealthCheckRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes health-based detection from the Shield Advanced protection for a resource. Shield Advanced health-based
     * detection uses the health of your AWS resource to improve responsiveness and accuracy in attack detection and
     * mitigation.
     * </p>
     * <p>
     * You define the health check in Route 53 and then associate or disassociate it with your Shield Advanced
     * protection. For more information, see <a href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option"
     * >Shield Advanced Health-Based Detection</a> in the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF and AWS Shield Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateHealthCheckRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateHealthCheckRequest#builder()}
     * </p>
     *
     * @param disassociateHealthCheckRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateHealthCheckRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateHealthCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DisassociateHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateHealthCheck"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateHealthCheckResponse> disassociateHealthCheck(
            Consumer<DisassociateHealthCheckRequest.Builder> disassociateHealthCheckRequest) {
        return disassociateHealthCheck(DisassociateHealthCheckRequest.builder().applyMutation(disassociateHealthCheckRequest)
                .build());
    }

    /**
     * <p>
     * Authorizes the DDoS Response Team (DRT) to use email and phone to notify contacts about escalations to the DRT
     * and to initiate proactive customer support.
     * </p>
     *
     * @param enableProactiveEngagementRequest
     * @return A Java Future containing the result of the EnableProactiveEngagement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.EnableProactiveEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/EnableProactiveEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableProactiveEngagementResponse> enableProactiveEngagement(
            EnableProactiveEngagementRequest enableProactiveEngagementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Authorizes the DDoS Response Team (DRT) to use email and phone to notify contacts about escalations to the DRT
     * and to initiate proactive customer support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableProactiveEngagementRequest.Builder} avoiding
     * the need to create one manually via {@link EnableProactiveEngagementRequest#builder()}
     * </p>
     *
     * @param enableProactiveEngagementRequest
     *        A {@link Consumer} that will call methods on {@link EnableProactiveEngagementRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the EnableProactiveEngagement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.EnableProactiveEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/EnableProactiveEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableProactiveEngagementResponse> enableProactiveEngagement(
            Consumer<EnableProactiveEngagementRequest.Builder> enableProactiveEngagementRequest) {
        return enableProactiveEngagement(EnableProactiveEngagementRequest.builder()
                .applyMutation(enableProactiveEngagementRequest).build());
    }

    /**
     * <p>
     * Returns the <code>SubscriptionState</code>, either <code>Active</code> or <code>Inactive</code>.
     * </p>
     *
     * @param getSubscriptionStateRequest
     * @return A Java Future containing the result of the GetSubscriptionState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.GetSubscriptionState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/GetSubscriptionState" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionStateResponse> getSubscriptionState(
            GetSubscriptionStateRequest getSubscriptionStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <code>SubscriptionState</code>, either <code>Active</code> or <code>Inactive</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionStateRequest.Builder} avoiding the
     * need to create one manually via {@link GetSubscriptionStateRequest#builder()}
     * </p>
     *
     * @param getSubscriptionStateRequest
     *        A {@link Consumer} that will call methods on {@link GetSubscriptionStateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSubscriptionState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.GetSubscriptionState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/GetSubscriptionState" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionStateResponse> getSubscriptionState(
            Consumer<GetSubscriptionStateRequest.Builder> getSubscriptionStateRequest) {
        return getSubscriptionState(GetSubscriptionStateRequest.builder().applyMutation(getSubscriptionStateRequest).build());
    }

    /**
     * <p>
     * Returns the <code>SubscriptionState</code>, either <code>Active</code> or <code>Inactive</code>.
     * </p>
     *
     * @return A Java Future containing the result of the GetSubscriptionState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.GetSubscriptionState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/GetSubscriptionState" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionStateResponse> getSubscriptionState() {
        return getSubscriptionState(GetSubscriptionStateRequest.builder().build());
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     *
     * @param listAttacksRequest
     * @return A Java Future containing the result of the ListAttacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListAttacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAttacksResponse> listAttacks(ListAttacksRequest listAttacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttacksRequest.Builder} avoiding the need to
     * create one manually via {@link ListAttacksRequest#builder()}
     * </p>
     *
     * @param listAttacksRequest
     *        A {@link Consumer} that will call methods on {@link ListAttacksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAttacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListAttacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAttacksResponse> listAttacks(Consumer<ListAttacksRequest.Builder> listAttacksRequest) {
        return listAttacks(ListAttacksRequest.builder().applyMutation(listAttacksRequest).build());
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     *
     * @return A Java Future containing the result of the ListAttacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListAttacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAttacksResponse> listAttacks() {
        return listAttacks(ListAttacksRequest.builder().build());
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAttacks(software.amazon.awssdk.services.shield.model.ListAttacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListAttacksPublisher publisher = client.listAttacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListAttacksPublisher publisher = client.listAttacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.shield.model.ListAttacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.shield.model.ListAttacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttacks(software.amazon.awssdk.services.shield.model.ListAttacksRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListAttacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttacksPublisher listAttacksPaginator() {
        return listAttacksPaginator(ListAttacksRequest.builder().build());
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAttacks(software.amazon.awssdk.services.shield.model.ListAttacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListAttacksPublisher publisher = client.listAttacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListAttacksPublisher publisher = client.listAttacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.shield.model.ListAttacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.shield.model.ListAttacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttacks(software.amazon.awssdk.services.shield.model.ListAttacksRequest)} operation.</b>
     * </p>
     *
     * @param listAttacksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListAttacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttacksPublisher listAttacksPaginator(ListAttacksRequest listAttacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAttacks(software.amazon.awssdk.services.shield.model.ListAttacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListAttacksPublisher publisher = client.listAttacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListAttacksPublisher publisher = client.listAttacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.shield.model.ListAttacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.shield.model.ListAttacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttacks(software.amazon.awssdk.services.shield.model.ListAttacksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttacksRequest.Builder} avoiding the need to
     * create one manually via {@link ListAttacksRequest#builder()}
     * </p>
     *
     * @param listAttacksRequest
     *        A {@link Consumer} that will call methods on {@link ListAttacksRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListAttacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttacksPublisher listAttacksPaginator(Consumer<ListAttacksRequest.Builder> listAttacksRequest) {
        return listAttacksPaginator(ListAttacksRequest.builder().applyMutation(listAttacksRequest).build());
    }

    /**
     * <p>
     * Retrieves the <a>ProtectionGroup</a> objects for the account.
     * </p>
     *
     * @param listProtectionGroupsRequest
     * @return A Java Future containing the result of the ListProtectionGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListProtectionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtectionGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListProtectionGroupsResponse> listProtectionGroups(
            ListProtectionGroupsRequest listProtectionGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the <a>ProtectionGroup</a> objects for the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectionGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProtectionGroupsRequest#builder()}
     * </p>
     *
     * @param listProtectionGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListProtectionGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListProtectionGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListProtectionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtectionGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListProtectionGroupsResponse> listProtectionGroups(
            Consumer<ListProtectionGroupsRequest.Builder> listProtectionGroupsRequest) {
        return listProtectionGroups(ListProtectionGroupsRequest.builder().applyMutation(listProtectionGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves the <a>ProtectionGroup</a> objects for the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtectionGroups(software.amazon.awssdk.services.shield.model.ListProtectionGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionGroupsPublisher publisher = client.listProtectionGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionGroupsPublisher publisher = client.listProtectionGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.shield.model.ListProtectionGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.shield.model.ListProtectionGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectionGroups(software.amazon.awssdk.services.shield.model.ListProtectionGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProtectionGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListProtectionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtectionGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectionGroupsPublisher listProtectionGroupsPaginator(ListProtectionGroupsRequest listProtectionGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the <a>ProtectionGroup</a> objects for the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtectionGroups(software.amazon.awssdk.services.shield.model.ListProtectionGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionGroupsPublisher publisher = client.listProtectionGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionGroupsPublisher publisher = client.listProtectionGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.shield.model.ListProtectionGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.shield.model.ListProtectionGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectionGroups(software.amazon.awssdk.services.shield.model.ListProtectionGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectionGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProtectionGroupsRequest#builder()}
     * </p>
     *
     * @param listProtectionGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListProtectionGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListProtectionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtectionGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectionGroupsPublisher listProtectionGroupsPaginator(
            Consumer<ListProtectionGroupsRequest.Builder> listProtectionGroupsRequest) {
        return listProtectionGroupsPaginator(ListProtectionGroupsRequest.builder().applyMutation(listProtectionGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all <a>Protection</a> objects for the account.
     * </p>
     *
     * @param listProtectionsRequest
     * @return A Java Future containing the result of the ListProtections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListProtections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProtectionsResponse> listProtections(ListProtectionsRequest listProtectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all <a>Protection</a> objects for the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListProtectionsRequest#builder()}
     * </p>
     *
     * @param listProtectionsRequest
     *        A {@link Consumer} that will call methods on {@link ListProtectionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListProtections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListProtections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProtectionsResponse> listProtections(
            Consumer<ListProtectionsRequest.Builder> listProtectionsRequest) {
        return listProtections(ListProtectionsRequest.builder().applyMutation(listProtectionsRequest).build());
    }

    /**
     * <p>
     * Lists all <a>Protection</a> objects for the account.
     * </p>
     *
     * @return A Java Future containing the result of the ListProtections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListProtections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProtectionsResponse> listProtections() {
        return listProtections(ListProtectionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all <a>Protection</a> objects for the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtections(software.amazon.awssdk.services.shield.model.ListProtectionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionsPublisher publisher = client.listProtectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionsPublisher publisher = client.listProtectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.shield.model.ListProtectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.shield.model.ListProtectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtections(software.amazon.awssdk.services.shield.model.ListProtectionsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListProtections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProtectionsPublisher listProtectionsPaginator() {
        return listProtectionsPaginator(ListProtectionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all <a>Protection</a> objects for the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtections(software.amazon.awssdk.services.shield.model.ListProtectionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionsPublisher publisher = client.listProtectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionsPublisher publisher = client.listProtectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.shield.model.ListProtectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.shield.model.ListProtectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtections(software.amazon.awssdk.services.shield.model.ListProtectionsRequest)} operation.</b>
     * </p>
     *
     * @param listProtectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListProtections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProtectionsPublisher listProtectionsPaginator(ListProtectionsRequest listProtectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all <a>Protection</a> objects for the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtections(software.amazon.awssdk.services.shield.model.ListProtectionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionsPublisher publisher = client.listProtectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionsPublisher publisher = client.listProtectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.shield.model.ListProtectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.shield.model.ListProtectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtections(software.amazon.awssdk.services.shield.model.ListProtectionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListProtectionsRequest#builder()}
     * </p>
     *
     * @param listProtectionsRequest
     *        A {@link Consumer} that will call methods on {@link ListProtectionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListProtections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProtectionsPublisher listProtectionsPaginator(Consumer<ListProtectionsRequest.Builder> listProtectionsRequest) {
        return listProtectionsPaginator(ListProtectionsRequest.builder().applyMutation(listProtectionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the resources that are included in the protection group.
     * </p>
     *
     * @param listResourcesInProtectionGroupRequest
     * @return A Java Future containing the result of the ListResourcesInProtectionGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListResourcesInProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListResourcesInProtectionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourcesInProtectionGroupResponse> listResourcesInProtectionGroup(
            ListResourcesInProtectionGroupRequest listResourcesInProtectionGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resources that are included in the protection group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesInProtectionGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourcesInProtectionGroupRequest#builder()}
     * </p>
     *
     * @param listResourcesInProtectionGroupRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesInProtectionGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListResourcesInProtectionGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListResourcesInProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListResourcesInProtectionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourcesInProtectionGroupResponse> listResourcesInProtectionGroup(
            Consumer<ListResourcesInProtectionGroupRequest.Builder> listResourcesInProtectionGroupRequest) {
        return listResourcesInProtectionGroup(ListResourcesInProtectionGroupRequest.builder()
                .applyMutation(listResourcesInProtectionGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves the resources that are included in the protection group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourcesInProtectionGroup(software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListResourcesInProtectionGroupPublisher publisher = client.listResourcesInProtectionGroupPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListResourcesInProtectionGroupPublisher publisher = client.listResourcesInProtectionGroupPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcesInProtectionGroup(software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourcesInProtectionGroupRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListResourcesInProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListResourcesInProtectionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesInProtectionGroupPublisher listResourcesInProtectionGroupPaginator(
            ListResourcesInProtectionGroupRequest listResourcesInProtectionGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resources that are included in the protection group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourcesInProtectionGroup(software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListResourcesInProtectionGroupPublisher publisher = client.listResourcesInProtectionGroupPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListResourcesInProtectionGroupPublisher publisher = client.listResourcesInProtectionGroupPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcesInProtectionGroup(software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesInProtectionGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourcesInProtectionGroupRequest#builder()}
     * </p>
     *
     * @param listResourcesInProtectionGroupRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesInProtectionGroupRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListResourcesInProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListResourcesInProtectionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesInProtectionGroupPublisher listResourcesInProtectionGroupPaginator(
            Consumer<ListResourcesInProtectionGroupRequest.Builder> listResourcesInProtectionGroupRequest) {
        return listResourcesInProtectionGroupPaginator(ListResourcesInProtectionGroupRequest.builder()
                .applyMutation(listResourcesInProtectionGroupRequest).build());
    }

    /**
     * <p>
     * Gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS Shield.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidResourceException Exception that indicates that the resource is invalid. You might not have
     *         access to the resource, or the resource might not exist.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS Shield.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidResourceException Exception that indicates that the resource is invalid. You might not have
     *         access to the resource, or the resource might not exist.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds or updates tags for a resource in AWS Shield.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidResourceException Exception that indicates that the resource is invalid. You might not have
     *         access to the resource, or the resource might not exist.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tags for a resource in AWS Shield.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidResourceException Exception that indicates that the resource is invalid. You might not have
     *         access to the resource, or the resource might not exist.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource in AWS Shield.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidResourceException Exception that indicates that the resource is invalid. You might not have
     *         access to the resource, or the resource might not exist.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource in AWS Shield.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidResourceException Exception that indicates that the resource is invalid. You might not have
     *         access to the resource, or the resource might not exist.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the details of the list of email addresses and phone numbers that the DDoS Response Team (DRT) can use to
     * contact you if you have proactive engagement enabled, for escalations to the DRT and to initiate proactive
     * customer support.
     * </p>
     *
     * @param updateEmergencyContactSettingsRequest
     * @return A Java Future containing the result of the UpdateEmergencyContactSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.UpdateEmergencyContactSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateEmergencyContactSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEmergencyContactSettingsResponse> updateEmergencyContactSettings(
            UpdateEmergencyContactSettingsRequest updateEmergencyContactSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details of the list of email addresses and phone numbers that the DDoS Response Team (DRT) can use to
     * contact you if you have proactive engagement enabled, for escalations to the DRT and to initiate proactive
     * customer support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEmergencyContactSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateEmergencyContactSettingsRequest#builder()}
     * </p>
     *
     * @param updateEmergencyContactSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEmergencyContactSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateEmergencyContactSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.UpdateEmergencyContactSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateEmergencyContactSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEmergencyContactSettingsResponse> updateEmergencyContactSettings(
            Consumer<UpdateEmergencyContactSettingsRequest.Builder> updateEmergencyContactSettingsRequest) {
        return updateEmergencyContactSettings(UpdateEmergencyContactSettingsRequest.builder()
                .applyMutation(updateEmergencyContactSettingsRequest).build());
    }

    /**
     * <p>
     * Updates an existing protection group. A protection group is a grouping of protected resources so they can be
     * handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives.
     * </p>
     *
     * @param updateProtectionGroupRequest
     * @return A Java Future containing the result of the UpdateProtectionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.UpdateProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateProtectionGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateProtectionGroupResponse> updateProtectionGroup(
            UpdateProtectionGroupRequest updateProtectionGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing protection group. A protection group is a grouping of protected resources so they can be
     * handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProtectionGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateProtectionGroupRequest#builder()}
     * </p>
     *
     * @param updateProtectionGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProtectionGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateProtectionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.UpdateProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateProtectionGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateProtectionGroupResponse> updateProtectionGroup(
            Consumer<UpdateProtectionGroupRequest.Builder> updateProtectionGroupRequest) {
        return updateProtectionGroup(UpdateProtectionGroupRequest.builder().applyMutation(updateProtectionGroupRequest).build());
    }

    /**
     * <p>
     * Updates the details of an existing subscription. Only enter values for parameters you want to change. Empty
     * parameters are not updated.
     * </p>
     *
     * @param updateSubscriptionRequest
     * @return A Java Future containing the result of the UpdateSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>LockedSubscriptionException You are trying to update a subscription that has not yet completed the
     *         1-year commitment. You can change the <code>AutoRenew</code> parameter during the last 30 days of your
     *         subscription. This exception indicates that you are attempting to change <code>AutoRenew</code> prior to
     *         that period.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.UpdateSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSubscriptionResponse> updateSubscription(UpdateSubscriptionRequest updateSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details of an existing subscription. Only enter values for parameters you want to change. Empty
     * parameters are not updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSubscriptionRequest#builder()}
     * </p>
     *
     * @param updateSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>LockedSubscriptionException You are trying to update a subscription that has not yet completed the
     *         1-year commitment. You can change the <code>AutoRenew</code> parameter during the last 30 days of your
     *         subscription. This exception indicates that you are attempting to change <code>AutoRenew</code> prior to
     *         that period.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist. If available,
     *         this exception includes details in additional properties.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         If available, this exception includes details in additional properties.</li>
     *         <li>OptimisticLockException Exception that indicates that the resource state has been modified by another
     *         client. Retrieve the resource and then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.UpdateSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSubscriptionResponse> updateSubscription(
            Consumer<UpdateSubscriptionRequest.Builder> updateSubscriptionRequest) {
        return updateSubscription(UpdateSubscriptionRequest.builder().applyMutation(updateSubscriptionRequest).build());
    }
}
