/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contact information that the DRT can use to contact you if you have proactive engagement enabled, for escalations to
 * the DRT and to initiate proactive customer support.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmergencyContact implements SdkPojo, Serializable,
        ToCopyableBuilder<EmergencyContact.Builder, EmergencyContact> {
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(EmergencyContact::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(EmergencyContact::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> CONTACT_NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactNotes").getter(getter(EmergencyContact::contactNotes)).setter(setter(Builder::contactNotes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactNotes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ADDRESS_FIELD,
            PHONE_NUMBER_FIELD, CONTACT_NOTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String emailAddress;

    private final String phoneNumber;

    private final String contactNotes;

    private EmergencyContact(BuilderImpl builder) {
        this.emailAddress = builder.emailAddress;
        this.phoneNumber = builder.phoneNumber;
        this.contactNotes = builder.contactNotes;
    }

    /**
     * <p>
     * The email address for the contact.
     * </p>
     * 
     * @return The email address for the contact.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The phone number for the contact.
     * </p>
     * 
     * @return The phone number for the contact.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * Additional notes regarding the contact.
     * </p>
     * 
     * @return Additional notes regarding the contact.
     */
    public final String contactNotes() {
        return contactNotes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(contactNotes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmergencyContact)) {
            return false;
        }
        EmergencyContact other = (EmergencyContact) obj;
        return Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(contactNotes(), other.contactNotes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmergencyContact").add("EmailAddress", emailAddress()).add("PhoneNumber", phoneNumber())
                .add("ContactNotes", contactNotes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "ContactNotes":
            return Optional.ofNullable(clazz.cast(contactNotes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmergencyContact, T> g) {
        return obj -> g.apply((EmergencyContact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmergencyContact> {
        /**
         * <p>
         * The email address for the contact.
         * </p>
         * 
         * @param emailAddress
         *        The email address for the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The phone number for the contact.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number for the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * Additional notes regarding the contact.
         * </p>
         * 
         * @param contactNotes
         *        Additional notes regarding the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactNotes(String contactNotes);
    }

    static final class BuilderImpl implements Builder {
        private String emailAddress;

        private String phoneNumber;

        private String contactNotes;

        private BuilderImpl() {
        }

        private BuilderImpl(EmergencyContact model) {
            emailAddress(model.emailAddress);
            phoneNumber(model.phoneNumber);
            contactNotes(model.contactNotes);
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final String getContactNotes() {
            return contactNotes;
        }

        @Override
        public final Builder contactNotes(String contactNotes) {
            this.contactNotes = contactNotes;
            return this;
        }

        public final void setContactNotes(String contactNotes) {
            this.contactNotes = contactNotes;
        }

        @Override
        public EmergencyContact build() {
            return new EmergencyContact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
