/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSubscriptionStateResponse extends ShieldResponse implements
        ToCopyableBuilder<GetSubscriptionStateResponse.Builder, GetSubscriptionStateResponse> {
    private static final SdkField<String> SUBSCRIPTION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionState").getter(getter(GetSubscriptionStateResponse::subscriptionStateAsString))
            .setter(setter(Builder::subscriptionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_STATE_FIELD));

    private final String subscriptionState;

    private GetSubscriptionStateResponse(BuilderImpl builder) {
        super(builder);
        this.subscriptionState = builder.subscriptionState;
    }

    /**
     * <p>
     * The status of the subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subscriptionState}
     * will return {@link SubscriptionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #subscriptionStateAsString}.
     * </p>
     * 
     * @return The status of the subscription.
     * @see SubscriptionState
     */
    public final SubscriptionState subscriptionState() {
        return SubscriptionState.fromValue(subscriptionState);
    }

    /**
     * <p>
     * The status of the subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subscriptionState}
     * will return {@link SubscriptionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #subscriptionStateAsString}.
     * </p>
     * 
     * @return The status of the subscription.
     * @see SubscriptionState
     */
    public final String subscriptionStateAsString() {
        return subscriptionState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSubscriptionStateResponse)) {
            return false;
        }
        GetSubscriptionStateResponse other = (GetSubscriptionStateResponse) obj;
        return Objects.equals(subscriptionStateAsString(), other.subscriptionStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSubscriptionStateResponse").add("SubscriptionState", subscriptionStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscriptionState":
            return Optional.ofNullable(clazz.cast(subscriptionStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSubscriptionStateResponse, T> g) {
        return obj -> g.apply((GetSubscriptionStateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ShieldResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSubscriptionStateResponse> {
        /**
         * <p>
         * The status of the subscription.
         * </p>
         * 
         * @param subscriptionState
         *        The status of the subscription.
         * @see SubscriptionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionState
         */
        Builder subscriptionState(String subscriptionState);

        /**
         * <p>
         * The status of the subscription.
         * </p>
         * 
         * @param subscriptionState
         *        The status of the subscription.
         * @see SubscriptionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionState
         */
        Builder subscriptionState(SubscriptionState subscriptionState);
    }

    static final class BuilderImpl extends ShieldResponse.BuilderImpl implements Builder {
        private String subscriptionState;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSubscriptionStateResponse model) {
            super(model);
            subscriptionState(model.subscriptionState);
        }

        public final String getSubscriptionState() {
            return subscriptionState;
        }

        public final void setSubscriptionState(String subscriptionState) {
            this.subscriptionState = subscriptionState;
        }

        @Override
        @Transient
        public final Builder subscriptionState(String subscriptionState) {
            this.subscriptionState = subscriptionState;
            return this;
        }

        @Override
        @Transient
        public final Builder subscriptionState(SubscriptionState subscriptionState) {
            this.subscriptionState(subscriptionState == null ? null : subscriptionState.toString());
            return this;
        }

        @Override
        public GetSubscriptionStateResponse build() {
            return new GetSubscriptionStateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
