/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProtectionGroupResponse extends ShieldResponse implements
        ToCopyableBuilder<DescribeProtectionGroupResponse.Builder, DescribeProtectionGroupResponse> {
    private static final SdkField<ProtectionGroup> PROTECTION_GROUP_FIELD = SdkField
            .<ProtectionGroup> builder(MarshallingType.SDK_POJO).memberName("ProtectionGroup")
            .getter(getter(DescribeProtectionGroupResponse::protectionGroup)).setter(setter(Builder::protectionGroup))
            .constructor(ProtectionGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTION_GROUP_FIELD));

    private final ProtectionGroup protectionGroup;

    private DescribeProtectionGroupResponse(BuilderImpl builder) {
        super(builder);
        this.protectionGroup = builder.protectionGroup;
    }

    /**
     * <p>
     * A grouping of protected resources that you and Shield Advanced can monitor as a collective. This resource
     * grouping improves the accuracy of detection and reduces false positives.
     * </p>
     * 
     * @return A grouping of protected resources that you and Shield Advanced can monitor as a collective. This resource
     *         grouping improves the accuracy of detection and reduces false positives.
     */
    public final ProtectionGroup protectionGroup() {
        return protectionGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protectionGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProtectionGroupResponse)) {
            return false;
        }
        DescribeProtectionGroupResponse other = (DescribeProtectionGroupResponse) obj;
        return Objects.equals(protectionGroup(), other.protectionGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProtectionGroupResponse").add("ProtectionGroup", protectionGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectionGroup":
            return Optional.ofNullable(clazz.cast(protectionGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProtectionGroupResponse, T> g) {
        return obj -> g.apply((DescribeProtectionGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ShieldResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProtectionGroupResponse> {
        /**
         * <p>
         * A grouping of protected resources that you and Shield Advanced can monitor as a collective. This resource
         * grouping improves the accuracy of detection and reduces false positives.
         * </p>
         * 
         * @param protectionGroup
         *        A grouping of protected resources that you and Shield Advanced can monitor as a collective. This
         *        resource grouping improves the accuracy of detection and reduces false positives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectionGroup(ProtectionGroup protectionGroup);

        /**
         * <p>
         * A grouping of protected resources that you and Shield Advanced can monitor as a collective. This resource
         * grouping improves the accuracy of detection and reduces false positives.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectionGroup.Builder} avoiding the
         * need to create one manually via {@link ProtectionGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProtectionGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #protectionGroup(ProtectionGroup)}.
         * 
         * @param protectionGroup
         *        a consumer that will call methods on {@link ProtectionGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protectionGroup(ProtectionGroup)
         */
        default Builder protectionGroup(Consumer<ProtectionGroup.Builder> protectionGroup) {
            return protectionGroup(ProtectionGroup.builder().applyMutation(protectionGroup).build());
        }
    }

    static final class BuilderImpl extends ShieldResponse.BuilderImpl implements Builder {
        private ProtectionGroup protectionGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProtectionGroupResponse model) {
            super(model);
            protectionGroup(model.protectionGroup);
        }

        public final ProtectionGroup.Builder getProtectionGroup() {
            return protectionGroup != null ? protectionGroup.toBuilder() : null;
        }

        public final void setProtectionGroup(ProtectionGroup.BuilderImpl protectionGroup) {
            this.protectionGroup = protectionGroup != null ? protectionGroup.build() : null;
        }

        @Override
        public final Builder protectionGroup(ProtectionGroup protectionGroup) {
            this.protectionGroup = protectionGroup;
            return this;
        }

        @Override
        public DescribeProtectionGroupResponse build() {
            return new DescribeProtectionGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
