/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the
 * protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic
 * application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced creates
 * the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with the resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResponseAction implements SdkPojo, Serializable, ToCopyableBuilder<ResponseAction.Builder, ResponseAction> {
    private static final SdkField<BlockAction> BLOCK_FIELD = SdkField.<BlockAction> builder(MarshallingType.SDK_POJO)
            .memberName("Block").getter(getter(ResponseAction::block)).setter(setter(Builder::block))
            .constructor(BlockAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Block").build()).build();

    private static final SdkField<CountAction> COUNT_FIELD = SdkField.<CountAction> builder(MarshallingType.SDK_POJO)
            .memberName("Count").getter(getter(ResponseAction::count)).setter(setter(Builder::count))
            .constructor(CountAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_FIELD, COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final BlockAction block;

    private final CountAction count;

    private ResponseAction(BuilderImpl builder) {
        this.block = builder.block;
        this.count = builder.count;
    }

    /**
     * <p>
     * Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Block</code> action.
     * </p>
     * <p>
     * You must specify exactly one action, either <code>Block</code> or <code>Count</code>.
     * </p>
     * 
     * @return Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Block</code> action.
     *         </p>
     *         <p>
     *         You must specify exactly one action, either <code>Block</code> or <code>Count</code>.
     */
    public final BlockAction block() {
        return block;
    }

    /**
     * <p>
     * Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Count</code> action.
     * </p>
     * <p>
     * You must specify exactly one action, either <code>Block</code> or <code>Count</code>.
     * </p>
     * 
     * @return Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Count</code> action.
     *         </p>
     *         <p>
     *         You must specify exactly one action, either <code>Block</code> or <code>Count</code>.
     */
    public final CountAction count() {
        return count;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(block());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseAction)) {
            return false;
        }
        ResponseAction other = (ResponseAction) obj;
        return Objects.equals(block(), other.block()) && Objects.equals(count(), other.count());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResponseAction").add("Block", block()).add("Count", count()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Block":
            return Optional.ofNullable(clazz.cast(block()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResponseAction, T> g) {
        return obj -> g.apply((ResponseAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResponseAction> {
        /**
         * <p>
         * Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Block</code> action.
         * </p>
         * <p>
         * You must specify exactly one action, either <code>Block</code> or <code>Count</code>.
         * </p>
         * 
         * @param block
         *        Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Block</code> action.
         *        </p>
         *        <p>
         *        You must specify exactly one action, either <code>Block</code> or <code>Count</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder block(BlockAction block);

        /**
         * <p>
         * Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Block</code> action.
         * </p>
         * <p>
         * You must specify exactly one action, either <code>Block</code> or <code>Count</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link BlockAction.Builder} avoiding the need to
         * create one manually via {@link BlockAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link BlockAction.Builder#build()} is called immediately and its result
         * is passed to {@link #block(BlockAction)}.
         * 
         * @param block
         *        a consumer that will call methods on {@link BlockAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #block(BlockAction)
         */
        default Builder block(Consumer<BlockAction.Builder> block) {
            return block(BlockAction.builder().applyMutation(block).build());
        }

        /**
         * <p>
         * Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Count</code> action.
         * </p>
         * <p>
         * You must specify exactly one action, either <code>Block</code> or <code>Count</code>.
         * </p>
         * 
         * @param count
         *        Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Count</code> action.
         *        </p>
         *        <p>
         *        You must specify exactly one action, either <code>Block</code> or <code>Count</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(CountAction count);

        /**
         * <p>
         * Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Count</code> action.
         * </p>
         * <p>
         * You must specify exactly one action, either <code>Block</code> or <code>Count</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CountAction.Builder} avoiding the need to
         * create one manually via {@link CountAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link CountAction.Builder#build()} is called immediately and its result
         * is passed to {@link #count(CountAction)}.
         * 
         * @param count
         *        a consumer that will call methods on {@link CountAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #count(CountAction)
         */
        default Builder count(Consumer<CountAction.Builder> count) {
            return count(CountAction.builder().applyMutation(count).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BlockAction block;

        private CountAction count;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseAction model) {
            block(model.block);
            count(model.count);
        }

        public final BlockAction.Builder getBlock() {
            return block != null ? block.toBuilder() : null;
        }

        public final void setBlock(BlockAction.BuilderImpl block) {
            this.block = block != null ? block.build() : null;
        }

        @Override
        public final Builder block(BlockAction block) {
            this.block = block;
            return this;
        }

        public final CountAction.Builder getCount() {
            return count != null ? count.toBuilder() : null;
        }

        public final void setCount(CountAction.BuilderImpl count) {
            this.count = count != null ? count.build() : null;
        }

        @Override
        public final Builder count(CountAction count) {
            this.count = count;
            return this;
        }

        @Override
        public ResponseAction build() {
            return new ResponseAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
