/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Limits settings for your subscription.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscriptionLimits implements SdkPojo, Serializable,
        ToCopyableBuilder<SubscriptionLimits.Builder, SubscriptionLimits> {
    private static final SdkField<ProtectionLimits> PROTECTION_LIMITS_FIELD = SdkField
            .<ProtectionLimits> builder(MarshallingType.SDK_POJO).memberName("ProtectionLimits")
            .getter(getter(SubscriptionLimits::protectionLimits)).setter(setter(Builder::protectionLimits))
            .constructor(ProtectionLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionLimits").build()).build();

    private static final SdkField<ProtectionGroupLimits> PROTECTION_GROUP_LIMITS_FIELD = SdkField
            .<ProtectionGroupLimits> builder(MarshallingType.SDK_POJO).memberName("ProtectionGroupLimits")
            .getter(getter(SubscriptionLimits::protectionGroupLimits)).setter(setter(Builder::protectionGroupLimits))
            .constructor(ProtectionGroupLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionGroupLimits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTION_LIMITS_FIELD,
            PROTECTION_GROUP_LIMITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ProtectionLimits protectionLimits;

    private final ProtectionGroupLimits protectionGroupLimits;

    private SubscriptionLimits(BuilderImpl builder) {
        this.protectionLimits = builder.protectionLimits;
        this.protectionGroupLimits = builder.protectionGroupLimits;
    }

    /**
     * <p>
     * Limits settings on protections for your subscription.
     * </p>
     * 
     * @return Limits settings on protections for your subscription.
     */
    public final ProtectionLimits protectionLimits() {
        return protectionLimits;
    }

    /**
     * <p>
     * Limits settings on protection groups for your subscription.
     * </p>
     * 
     * @return Limits settings on protection groups for your subscription.
     */
    public final ProtectionGroupLimits protectionGroupLimits() {
        return protectionGroupLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(protectionLimits());
        hashCode = 31 * hashCode + Objects.hashCode(protectionGroupLimits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscriptionLimits)) {
            return false;
        }
        SubscriptionLimits other = (SubscriptionLimits) obj;
        return Objects.equals(protectionLimits(), other.protectionLimits())
                && Objects.equals(protectionGroupLimits(), other.protectionGroupLimits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubscriptionLimits").add("ProtectionLimits", protectionLimits())
                .add("ProtectionGroupLimits", protectionGroupLimits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectionLimits":
            return Optional.ofNullable(clazz.cast(protectionLimits()));
        case "ProtectionGroupLimits":
            return Optional.ofNullable(clazz.cast(protectionGroupLimits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscriptionLimits, T> g) {
        return obj -> g.apply((SubscriptionLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubscriptionLimits> {
        /**
         * <p>
         * Limits settings on protections for your subscription.
         * </p>
         * 
         * @param protectionLimits
         *        Limits settings on protections for your subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectionLimits(ProtectionLimits protectionLimits);

        /**
         * <p>
         * Limits settings on protections for your subscription.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectionLimits.Builder} avoiding the
         * need to create one manually via {@link ProtectionLimits#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProtectionLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #protectionLimits(ProtectionLimits)}.
         * 
         * @param protectionLimits
         *        a consumer that will call methods on {@link ProtectionLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protectionLimits(ProtectionLimits)
         */
        default Builder protectionLimits(Consumer<ProtectionLimits.Builder> protectionLimits) {
            return protectionLimits(ProtectionLimits.builder().applyMutation(protectionLimits).build());
        }

        /**
         * <p>
         * Limits settings on protection groups for your subscription.
         * </p>
         * 
         * @param protectionGroupLimits
         *        Limits settings on protection groups for your subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectionGroupLimits(ProtectionGroupLimits protectionGroupLimits);

        /**
         * <p>
         * Limits settings on protection groups for your subscription.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectionGroupLimits.Builder} avoiding
         * the need to create one manually via {@link ProtectionGroupLimits#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProtectionGroupLimits.Builder#build()} is called immediately and
         * its result is passed to {@link #protectionGroupLimits(ProtectionGroupLimits)}.
         * 
         * @param protectionGroupLimits
         *        a consumer that will call methods on {@link ProtectionGroupLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protectionGroupLimits(ProtectionGroupLimits)
         */
        default Builder protectionGroupLimits(Consumer<ProtectionGroupLimits.Builder> protectionGroupLimits) {
            return protectionGroupLimits(ProtectionGroupLimits.builder().applyMutation(protectionGroupLimits).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProtectionLimits protectionLimits;

        private ProtectionGroupLimits protectionGroupLimits;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscriptionLimits model) {
            protectionLimits(model.protectionLimits);
            protectionGroupLimits(model.protectionGroupLimits);
        }

        public final ProtectionLimits.Builder getProtectionLimits() {
            return protectionLimits != null ? protectionLimits.toBuilder() : null;
        }

        public final void setProtectionLimits(ProtectionLimits.BuilderImpl protectionLimits) {
            this.protectionLimits = protectionLimits != null ? protectionLimits.build() : null;
        }

        @Override
        public final Builder protectionLimits(ProtectionLimits protectionLimits) {
            this.protectionLimits = protectionLimits;
            return this;
        }

        public final ProtectionGroupLimits.Builder getProtectionGroupLimits() {
            return protectionGroupLimits != null ? protectionGroupLimits.toBuilder() : null;
        }

        public final void setProtectionGroupLimits(ProtectionGroupLimits.BuilderImpl protectionGroupLimits) {
            this.protectionGroupLimits = protectionGroupLimits != null ? protectionGroupLimits.build() : null;
        }

        @Override
        public final Builder protectionGroupLimits(ProtectionGroupLimits protectionGroupLimits) {
            this.protectionGroupLimits = protectionGroupLimits;
            return this;
        }

        @Override
        public SubscriptionLimits build() {
            return new SubscriptionLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
