/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationLayerAutomaticResponseRequest extends ShieldRequest implements
        ToCopyableBuilder<UpdateApplicationLayerAutomaticResponseRequest.Builder, UpdateApplicationLayerAutomaticResponseRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(UpdateApplicationLayerAutomaticResponseRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<ResponseAction> ACTION_FIELD = SdkField.<ResponseAction> builder(MarshallingType.SDK_POJO)
            .memberName("Action").getter(getter(UpdateApplicationLayerAutomaticResponseRequest::action))
            .setter(setter(Builder::action)).constructor(ResponseAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            ACTION_FIELD));

    private final String resourceArn;

    private final ResponseAction action;

    private UpdateApplicationLayerAutomaticResponseRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.action = builder.action;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the resource.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the
     * protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic
     * application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced
     * creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with
     * the resource.
     * </p>
     * 
     * @return Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf
     *         of the protected resource in response to DDoS attacks. You specify this as part of the configuration for
     *         the automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation.
     *         Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that
     *         you have associated with the resource.
     */
    public final ResponseAction action() {
        return action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationLayerAutomaticResponseRequest)) {
            return false;
        }
        UpdateApplicationLayerAutomaticResponseRequest other = (UpdateApplicationLayerAutomaticResponseRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(action(), other.action());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationLayerAutomaticResponseRequest").add("ResourceArn", resourceArn())
                .add("Action", action()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationLayerAutomaticResponseRequest, T> g) {
        return obj -> g.apply((UpdateApplicationLayerAutomaticResponseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ShieldRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateApplicationLayerAutomaticResponseRequest> {
        /**
         * <p>
         * The ARN (Amazon Resource Name) of the resource.
         * </p>
         * 
         * @param resourceArn
         *        The ARN (Amazon Resource Name) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of
         * the protected resource in response to DDoS attacks. You specify this as part of the configuration for the
         * automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield
         * Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have
         * associated with the resource.
         * </p>
         * 
         * @param action
         *        Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on
         *        behalf of the protected resource in response to DDoS attacks. You specify this as part of the
         *        configuration for the automatic application layer DDoS mitigation feature, when you enable or update
         *        automatic mitigation. Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group,
         *        inside the web ACL that you have associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(ResponseAction action);

        /**
         * <p>
         * Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of
         * the protected resource in response to DDoS attacks. You specify this as part of the configuration for the
         * automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield
         * Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have
         * associated with the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResponseAction.Builder} avoiding the need
         * to create one manually via {@link ResponseAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResponseAction.Builder#build()} is called immediately and its
         * result is passed to {@link #action(ResponseAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link ResponseAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(ResponseAction)
         */
        default Builder action(Consumer<ResponseAction.Builder> action) {
            return action(ResponseAction.builder().applyMutation(action).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ShieldRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private ResponseAction action;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationLayerAutomaticResponseRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            action(model.action);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final ResponseAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(ResponseAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(ResponseAction action) {
            this.action = action;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationLayerAutomaticResponseRequest build() {
            return new UpdateApplicationLayerAutomaticResponseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
