/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies how many protections of a given type you can create.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Limit implements SdkPojo, Serializable, ToCopyableBuilder<Limit.Builder, Limit> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Limit::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Long> MAX_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Max")
            .getter(getter(Limit::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MAX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Long max;

    private Limit(BuilderImpl builder) {
        this.type = builder.type;
        this.max = builder.max;
    }

    /**
     * <p>
     * The type of protection.
     * </p>
     * 
     * @return The type of protection.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The maximum number of protections that can be created for the specified <code>Type</code>.
     * </p>
     * 
     * @return The maximum number of protections that can be created for the specified <code>Type</code>.
     */
    public final Long max() {
        return max;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Limit)) {
            return false;
        }
        Limit other = (Limit) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(max(), other.max());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Limit").add("Type", type()).add("Max", max()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Max":
            return Optional.ofNullable(clazz.cast(max()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Limit, T> g) {
        return obj -> g.apply((Limit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Limit> {
        /**
         * <p>
         * The type of protection.
         * </p>
         * 
         * @param type
         *        The type of protection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The maximum number of protections that can be created for the specified <code>Type</code>.
         * </p>
         * 
         * @param max
         *        The maximum number of protections that can be created for the specified <code>Type</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Long max);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Long max;

        private BuilderImpl() {
        }

        private BuilderImpl(Limit model) {
            type(model.type);
            max(model.max);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Long getMax() {
            return max;
        }

        public final void setMax(Long max) {
            this.max = max;
        }

        @Override
        @Transient
        public final Builder max(Long max) {
            this.max = max;
            return this;
        }

        @Override
        public Limit build() {
            return new Limit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
