/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAttacksRequest extends ShieldRequest implements
        ToCopyableBuilder<ListAttacksRequest.Builder, ListAttacksRequest> {
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceArns")
            .getter(getter(ListAttacksRequest::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TimeRange> START_TIME_FIELD = SdkField.<TimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("StartTime").getter(getter(ListAttacksRequest::startTime)).setter(setter(Builder::startTime))
            .constructor(TimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<TimeRange> END_TIME_FIELD = SdkField.<TimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("EndTime").getter(getter(ListAttacksRequest::endTime)).setter(setter(Builder::endTime))
            .constructor(TimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAttacksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListAttacksRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARNS_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<String> resourceArns;

    private final TimeRange startTime;

    private final TimeRange endTime;

    private final String nextToken;

    private final Integer maxResults;

    private ListAttacksRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArns = builder.resourceArns;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceArns() {
        return resourceArns != null && !(resourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the resource that was attacked. If this is left blank, all applicable resources
     * for this account will be included.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceArns} method.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the resource that was attacked. If this is left blank, all applicable
     *         resources for this account will be included.
     */
    public final List<String> resourceArns() {
        return resourceArns;
    }

    /**
     * <p>
     * The start of the time period for the attacks. This is a <code>timestamp</code> type. The sample request above
     * indicates a <code>number</code> type because the default used by WAF is Unix time in seconds. However any valid
     * <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp
     * format</a> is allowed.
     * </p>
     * 
     * @return The start of the time period for the attacks. This is a <code>timestamp</code> type. The sample request
     *         above indicates a <code>number</code> type because the default used by WAF is Unix time in seconds.
     *         However any valid <a
     *         href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp
     *         format</a> is allowed.
     */
    public final TimeRange startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time period for the attacks. This is a <code>timestamp</code> type. The sample request above
     * indicates a <code>number</code> type because the default used by WAF is Unix time in seconds. However any valid
     * <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp
     * format</a> is allowed.
     * </p>
     * 
     * @return The end of the time period for the attacks. This is a <code>timestamp</code> type. The sample request
     *         above indicates a <code>number</code> type because the default used by WAF is Unix time in seconds.
     *         However any valid <a
     *         href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp
     *         format</a> is allowed.
     */
    public final TimeRange endTime() {
        return endTime;
    }

    /**
     * <p>
     * The <code>ListAttacksRequest.NextMarker</code> value from a previous call to <code>ListAttacksRequest</code>.
     * Pass null if this is the first call.
     * </p>
     * 
     * @return The <code>ListAttacksRequest.NextMarker</code> value from a previous call to
     *         <code>ListAttacksRequest</code>. Pass null if this is the first call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of <a>AttackSummary</a> objects to return. If you leave this blank, Shield Advanced returns
     * the first 20 results.
     * </p>
     * <p>
     * This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of
     * objects returned could be less than <code>MaxResults</code>, even if there are still more objects yet to return.
     * If there are more objects to return, Shield Advanced returns a value in <code>NextToken</code> that you can use
     * in your next request, to get the next batch of objects.
     * </p>
     * 
     * @return The maximum number of <a>AttackSummary</a> objects to return. If you leave this blank, Shield Advanced
     *         returns the first 20 results.</p>
     *         <p>
     *         This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number
     *         of objects returned could be less than <code>MaxResults</code>, even if there are still more objects yet
     *         to return. If there are more objects to return, Shield Advanced returns a value in <code>NextToken</code>
     *         that you can use in your next request, to get the next batch of objects.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceArns() ? resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttacksRequest)) {
            return false;
        }
        ListAttacksRequest other = (ListAttacksRequest) obj;
        return hasResourceArns() == other.hasResourceArns() && Objects.equals(resourceArns(), other.resourceArns())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAttacksRequest").add("ResourceArns", hasResourceArns() ? resourceArns() : null)
                .add("StartTime", startTime()).add("EndTime", endTime()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAttacksRequest, T> g) {
        return obj -> g.apply((ListAttacksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ShieldRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAttacksRequest> {
        /**
         * <p>
         * The ARN (Amazon Resource Name) of the resource that was attacked. If this is left blank, all applicable
         * resources for this account will be included.
         * </p>
         * 
         * @param resourceArns
         *        The ARN (Amazon Resource Name) of the resource that was attacked. If this is left blank, all
         *        applicable resources for this account will be included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the resource that was attacked. If this is left blank, all applicable
         * resources for this account will be included.
         * </p>
         * 
         * @param resourceArns
         *        The ARN (Amazon Resource Name) of the resource that was attacked. If this is left blank, all
         *        applicable resources for this account will be included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);

        /**
         * <p>
         * The start of the time period for the attacks. This is a <code>timestamp</code> type. The sample request above
         * indicates a <code>number</code> type because the default used by WAF is Unix time in seconds. However any
         * valid <a
         * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp
         * format</a> is allowed.
         * </p>
         * 
         * @param startTime
         *        The start of the time period for the attacks. This is a <code>timestamp</code> type. The sample
         *        request above indicates a <code>number</code> type because the default used by WAF is Unix time in
         *        seconds. However any valid <a
         *        href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp
         *        format</a> is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(TimeRange startTime);

        /**
         * <p>
         * The start of the time period for the attacks. This is a <code>timestamp</code> type. The sample request above
         * indicates a <code>number</code> type because the default used by WAF is Unix time in seconds. However any
         * valid <a
         * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp
         * format</a> is allowed.
         * </p>
         * This is a convenience that creates an instance of the {@link TimeRange.Builder} avoiding the need to create
         * one manually via {@link TimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeRange.Builder#build()} is called immediately and its result
         * is passed to {@link #startTime(TimeRange)}.
         * 
         * @param startTime
         *        a consumer that will call methods on {@link TimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTime(TimeRange)
         */
        default Builder startTime(Consumer<TimeRange.Builder> startTime) {
            return startTime(TimeRange.builder().applyMutation(startTime).build());
        }

        /**
         * <p>
         * The end of the time period for the attacks. This is a <code>timestamp</code> type. The sample request above
         * indicates a <code>number</code> type because the default used by WAF is Unix time in seconds. However any
         * valid <a
         * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp
         * format</a> is allowed.
         * </p>
         * 
         * @param endTime
         *        The end of the time period for the attacks. This is a <code>timestamp</code> type. The sample request
         *        above indicates a <code>number</code> type because the default used by WAF is Unix time in seconds.
         *        However any valid <a
         *        href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp
         *        format</a> is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(TimeRange endTime);

        /**
         * <p>
         * The end of the time period for the attacks. This is a <code>timestamp</code> type. The sample request above
         * indicates a <code>number</code> type because the default used by WAF is Unix time in seconds. However any
         * valid <a
         * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp
         * format</a> is allowed.
         * </p>
         * This is a convenience that creates an instance of the {@link TimeRange.Builder} avoiding the need to create
         * one manually via {@link TimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeRange.Builder#build()} is called immediately and its result
         * is passed to {@link #endTime(TimeRange)}.
         * 
         * @param endTime
         *        a consumer that will call methods on {@link TimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endTime(TimeRange)
         */
        default Builder endTime(Consumer<TimeRange.Builder> endTime) {
            return endTime(TimeRange.builder().applyMutation(endTime).build());
        }

        /**
         * <p>
         * The <code>ListAttacksRequest.NextMarker</code> value from a previous call to <code>ListAttacksRequest</code>.
         * Pass null if this is the first call.
         * </p>
         * 
         * @param nextToken
         *        The <code>ListAttacksRequest.NextMarker</code> value from a previous call to
         *        <code>ListAttacksRequest</code>. Pass null if this is the first call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of <a>AttackSummary</a> objects to return. If you leave this blank, Shield Advanced
         * returns the first 20 results.
         * </p>
         * <p>
         * This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of
         * objects returned could be less than <code>MaxResults</code>, even if there are still more objects yet to
         * return. If there are more objects to return, Shield Advanced returns a value in <code>NextToken</code> that
         * you can use in your next request, to get the next batch of objects.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of <a>AttackSummary</a> objects to return. If you leave this blank, Shield Advanced
         *        returns the first 20 results.</p>
         *        <p>
         *        This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the
         *        number of objects returned could be less than <code>MaxResults</code>, even if there are still more
         *        objects yet to return. If there are more objects to return, Shield Advanced returns a value in
         *        <code>NextToken</code> that you can use in your next request, to get the next batch of objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ShieldRequest.BuilderImpl implements Builder {
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private TimeRange startTime;

        private TimeRange endTime;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttacksRequest model) {
            super(model);
            resourceArns(model.resourceArns);
            startTime(model.startTime);
            endTime(model.endTime);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getResourceArns() {
            if (resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnFilterListCopier.copy(resourceArns);
        }

        @Override
        @Transient
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnFilterListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final TimeRange.Builder getStartTime() {
            return startTime != null ? startTime.toBuilder() : null;
        }

        public final void setStartTime(TimeRange.BuilderImpl startTime) {
            this.startTime = startTime != null ? startTime.build() : null;
        }

        @Override
        @Transient
        public final Builder startTime(TimeRange startTime) {
            this.startTime = startTime;
            return this;
        }

        public final TimeRange.Builder getEndTime() {
            return endTime != null ? endTime.toBuilder() : null;
        }

        public final void setEndTime(TimeRange.BuilderImpl endTime) {
            this.endTime = endTime != null ? endTime.build() : null;
        }

        @Override
        @Transient
        public final Builder endTime(TimeRange endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAttacksRequest build() {
            return new ListAttacksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
