/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAttacksResponse extends ShieldResponse implements
        ToCopyableBuilder<ListAttacksResponse.Builder, ListAttacksResponse> {
    private static final SdkField<List<AttackSummary>> ATTACK_SUMMARIES_FIELD = SdkField
            .<List<AttackSummary>> builder(MarshallingType.LIST)
            .memberName("AttackSummaries")
            .getter(getter(ListAttacksResponse::attackSummaries))
            .setter(setter(Builder::attackSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttackSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttackSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAttacksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACK_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AttackSummary> attackSummaries;

    private final String nextToken;

    private ListAttacksResponse(BuilderImpl builder) {
        super(builder);
        this.attackSummaries = builder.attackSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttackSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttackSummaries() {
        return attackSummaries != null && !(attackSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attack information for the specified time range.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttackSummaries} method.
     * </p>
     * 
     * @return The attack information for the specified time range.
     */
    public final List<AttackSummary> attackSummaries() {
        return attackSummaries;
    }

    /**
     * <p>
     * The token returned by a previous call to indicate that there is more data available. If not null, more results
     * are available. Pass this value for the <code>NextMarker</code> parameter in a subsequent call to
     * <code>ListAttacks</code> to retrieve the next set of items.
     * </p>
     * <p>
     * Shield Advanced might return the list of <a>AttackSummary</a> objects in batches smaller than the number
     * specified by MaxResults. If there are more attack summary objects to return, Shield Advanced will always also
     * return a <code>NextToken</code>.
     * </p>
     * 
     * @return The token returned by a previous call to indicate that there is more data available. If not null, more
     *         results are available. Pass this value for the <code>NextMarker</code> parameter in a subsequent call to
     *         <code>ListAttacks</code> to retrieve the next set of items.</p>
     *         <p>
     *         Shield Advanced might return the list of <a>AttackSummary</a> objects in batches smaller than the number
     *         specified by MaxResults. If there are more attack summary objects to return, Shield Advanced will always
     *         also return a <code>NextToken</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttackSummaries() ? attackSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttacksResponse)) {
            return false;
        }
        ListAttacksResponse other = (ListAttacksResponse) obj;
        return hasAttackSummaries() == other.hasAttackSummaries() && Objects.equals(attackSummaries(), other.attackSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAttacksResponse").add("AttackSummaries", hasAttackSummaries() ? attackSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttackSummaries":
            return Optional.ofNullable(clazz.cast(attackSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAttacksResponse, T> g) {
        return obj -> g.apply((ListAttacksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ShieldResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAttacksResponse> {
        /**
         * <p>
         * The attack information for the specified time range.
         * </p>
         * 
         * @param attackSummaries
         *        The attack information for the specified time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackSummaries(Collection<AttackSummary> attackSummaries);

        /**
         * <p>
         * The attack information for the specified time range.
         * </p>
         * 
         * @param attackSummaries
         *        The attack information for the specified time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackSummaries(AttackSummary... attackSummaries);

        /**
         * <p>
         * The attack information for the specified time range.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttackSummary>.Builder} avoiding the need
         * to create one manually via {@link List<AttackSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttackSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #attackSummaries(List<AttackSummary>)}.
         * 
         * @param attackSummaries
         *        a consumer that will call methods on {@link List<AttackSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attackSummaries(List<AttackSummary>)
         */
        Builder attackSummaries(Consumer<AttackSummary.Builder>... attackSummaries);

        /**
         * <p>
         * The token returned by a previous call to indicate that there is more data available. If not null, more
         * results are available. Pass this value for the <code>NextMarker</code> parameter in a subsequent call to
         * <code>ListAttacks</code> to retrieve the next set of items.
         * </p>
         * <p>
         * Shield Advanced might return the list of <a>AttackSummary</a> objects in batches smaller than the number
         * specified by MaxResults. If there are more attack summary objects to return, Shield Advanced will always also
         * return a <code>NextToken</code>.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to indicate that there is more data available. If not null, more
         *        results are available. Pass this value for the <code>NextMarker</code> parameter in a subsequent call
         *        to <code>ListAttacks</code> to retrieve the next set of items.</p>
         *        <p>
         *        Shield Advanced might return the list of <a>AttackSummary</a> objects in batches smaller than the
         *        number specified by MaxResults. If there are more attack summary objects to return, Shield Advanced
         *        will always also return a <code>NextToken</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ShieldResponse.BuilderImpl implements Builder {
        private List<AttackSummary> attackSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttacksResponse model) {
            super(model);
            attackSummaries(model.attackSummaries);
            nextToken(model.nextToken);
        }

        public final List<AttackSummary.Builder> getAttackSummaries() {
            List<AttackSummary.Builder> result = AttackSummariesCopier.copyToBuilder(this.attackSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttackSummaries(Collection<AttackSummary.BuilderImpl> attackSummaries) {
            this.attackSummaries = AttackSummariesCopier.copyFromBuilder(attackSummaries);
        }

        @Override
        @Transient
        public final Builder attackSummaries(Collection<AttackSummary> attackSummaries) {
            this.attackSummaries = AttackSummariesCopier.copy(attackSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attackSummaries(AttackSummary... attackSummaries) {
            attackSummaries(Arrays.asList(attackSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attackSummaries(Consumer<AttackSummary.Builder>... attackSummaries) {
            attackSummaries(Stream.of(attackSummaries).map(c -> AttackSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAttacksResponse build() {
            return new ListAttacksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
