/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProtectionGroupsResponse extends ShieldResponse implements
        ToCopyableBuilder<ListProtectionGroupsResponse.Builder, ListProtectionGroupsResponse> {
    private static final SdkField<List<ProtectionGroup>> PROTECTION_GROUPS_FIELD = SdkField
            .<List<ProtectionGroup>> builder(MarshallingType.LIST)
            .memberName("ProtectionGroups")
            .getter(getter(ListProtectionGroupsResponse::protectionGroups))
            .setter(setter(Builder::protectionGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProtectionGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProtectionGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListProtectionGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTION_GROUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ProtectionGroup> protectionGroups;

    private final String nextToken;

    private ListProtectionGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.protectionGroups = builder.protectionGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProtectionGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProtectionGroups() {
        return protectionGroups != null && !(protectionGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtectionGroups} method.
     * </p>
     * 
     * @return
     */
    public final List<ProtectionGroup> protectionGroups() {
        return protectionGroups;
    }

    /**
     * <p>
     * If you specify a value for <code>MaxResults</code> and you have more protection groups than the value of
     * MaxResults, Shield Advanced returns this token that you can use in your next request, to get the next batch of
     * objects.
     * </p>
     * 
     * @return If you specify a value for <code>MaxResults</code> and you have more protection groups than the value of
     *         MaxResults, Shield Advanced returns this token that you can use in your next request, to get the next
     *         batch of objects.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProtectionGroups() ? protectionGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProtectionGroupsResponse)) {
            return false;
        }
        ListProtectionGroupsResponse other = (ListProtectionGroupsResponse) obj;
        return hasProtectionGroups() == other.hasProtectionGroups()
                && Objects.equals(protectionGroups(), other.protectionGroups()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProtectionGroupsResponse")
                .add("ProtectionGroups", hasProtectionGroups() ? protectionGroups() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectionGroups":
            return Optional.ofNullable(clazz.cast(protectionGroups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProtectionGroupsResponse, T> g) {
        return obj -> g.apply((ListProtectionGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ShieldResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListProtectionGroupsResponse> {
        /**
         * <p/>
         * 
         * @param protectionGroups
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectionGroups(Collection<ProtectionGroup> protectionGroups);

        /**
         * <p/>
         * 
         * @param protectionGroups
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectionGroups(ProtectionGroup... protectionGroups);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link List<ProtectionGroup>.Builder} avoiding the need
         * to create one manually via {@link List<ProtectionGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProtectionGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #protectionGroups(List<ProtectionGroup>)}.
         * 
         * @param protectionGroups
         *        a consumer that will call methods on {@link List<ProtectionGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protectionGroups(List<ProtectionGroup>)
         */
        Builder protectionGroups(Consumer<ProtectionGroup.Builder>... protectionGroups);

        /**
         * <p>
         * If you specify a value for <code>MaxResults</code> and you have more protection groups than the value of
         * MaxResults, Shield Advanced returns this token that you can use in your next request, to get the next batch
         * of objects.
         * </p>
         * 
         * @param nextToken
         *        If you specify a value for <code>MaxResults</code> and you have more protection groups than the value
         *        of MaxResults, Shield Advanced returns this token that you can use in your next request, to get the
         *        next batch of objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ShieldResponse.BuilderImpl implements Builder {
        private List<ProtectionGroup> protectionGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProtectionGroupsResponse model) {
            super(model);
            protectionGroups(model.protectionGroups);
            nextToken(model.nextToken);
        }

        public final List<ProtectionGroup.Builder> getProtectionGroups() {
            List<ProtectionGroup.Builder> result = ProtectionGroupsCopier.copyToBuilder(this.protectionGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProtectionGroups(Collection<ProtectionGroup.BuilderImpl> protectionGroups) {
            this.protectionGroups = ProtectionGroupsCopier.copyFromBuilder(protectionGroups);
        }

        @Override
        @Transient
        public final Builder protectionGroups(Collection<ProtectionGroup> protectionGroups) {
            this.protectionGroups = ProtectionGroupsCopier.copy(protectionGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder protectionGroups(ProtectionGroup... protectionGroups) {
            protectionGroups(Arrays.asList(protectionGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder protectionGroups(Consumer<ProtectionGroup.Builder>... protectionGroups) {
            protectionGroups(Stream.of(protectionGroups).map(c -> ProtectionGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProtectionGroupsResponse build() {
            return new ListProtectionGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
