/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDrtAccessResponse extends ShieldResponse implements
        ToCopyableBuilder<DescribeDrtAccessResponse.Builder, DescribeDrtAccessResponse> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeDrtAccessResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<String>> LOG_BUCKET_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LogBucketList")
            .getter(getter(DescribeDrtAccessResponse::logBucketList))
            .setter(setter(Builder::logBucketList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogBucketList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            LOG_BUCKET_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String roleArn;

    private final List<String> logBucketList;

    private DescribeDrtAccessResponse(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.logBucketList = builder.logBucketList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role the SRT used to access your Amazon Web Services account.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role the SRT used to access your Amazon Web Services account.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogBucketList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogBucketList() {
        return logBucketList != null && !(logBucketList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Amazon S3 buckets accessed by the SRT.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogBucketList} method.
     * </p>
     * 
     * @return The list of Amazon S3 buckets accessed by the SRT.
     */
    public final List<String> logBucketList() {
        return logBucketList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogBucketList() ? logBucketList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDrtAccessResponse)) {
            return false;
        }
        DescribeDrtAccessResponse other = (DescribeDrtAccessResponse) obj;
        return Objects.equals(roleArn(), other.roleArn()) && hasLogBucketList() == other.hasLogBucketList()
                && Objects.equals(logBucketList(), other.logBucketList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDrtAccessResponse").add("RoleArn", roleArn())
                .add("LogBucketList", hasLogBucketList() ? logBucketList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "LogBucketList":
            return Optional.ofNullable(clazz.cast(logBucketList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("LogBucketList", LOG_BUCKET_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDrtAccessResponse, T> g) {
        return obj -> g.apply((DescribeDrtAccessResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ShieldResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDrtAccessResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role the SRT used to access your Amazon Web Services account.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role the SRT used to access your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The list of Amazon S3 buckets accessed by the SRT.
         * </p>
         * 
         * @param logBucketList
         *        The list of Amazon S3 buckets accessed by the SRT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logBucketList(Collection<String> logBucketList);

        /**
         * <p>
         * The list of Amazon S3 buckets accessed by the SRT.
         * </p>
         * 
         * @param logBucketList
         *        The list of Amazon S3 buckets accessed by the SRT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logBucketList(String... logBucketList);
    }

    static final class BuilderImpl extends ShieldResponse.BuilderImpl implements Builder {
        private String roleArn;

        private List<String> logBucketList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDrtAccessResponse model) {
            super(model);
            roleArn(model.roleArn);
            logBucketList(model.logBucketList);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Collection<String> getLogBucketList() {
            if (logBucketList instanceof SdkAutoConstructList) {
                return null;
            }
            return logBucketList;
        }

        public final void setLogBucketList(Collection<String> logBucketList) {
            this.logBucketList = LogBucketListCopier.copy(logBucketList);
        }

        @Override
        public final Builder logBucketList(Collection<String> logBucketList) {
            this.logBucketList = LogBucketListCopier.copy(logBucketList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logBucketList(String... logBucketList) {
            logBucketList(Arrays.asList(logBucketList));
            return this;
        }

        @Override
        public DescribeDrtAccessResponse build() {
            return new DescribeDrtAccessResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
