/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Narrows the set of protections that the call retrieves. You can retrieve a single protection by providing its name or
 * the ARN (Amazon Resource Name) of its protected resource. You can also retrieve all protections for a specific
 * resource type. You can provide up to one criteria per filter type. Shield Advanced returns protections that exactly
 * match all of the filter criteria that you provide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InclusionProtectionFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<InclusionProtectionFilters.Builder, InclusionProtectionFilters> {
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceArns")
            .getter(getter(InclusionProtectionFilters::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PROTECTION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProtectionNames")
            .getter(getter(InclusionProtectionFilters::protectionNames))
            .setter(setter(Builder::protectionNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(InclusionProtectionFilters::resourceTypesAsStrings))
            .setter(setter(Builder::resourceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARNS_FIELD,
            PROTECTION_NAMES_FIELD, RESOURCE_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> resourceArns;

    private final List<String> protectionNames;

    private final List<String> resourceTypes;

    private InclusionProtectionFilters(BuilderImpl builder) {
        this.resourceArns = builder.resourceArns;
        this.protectionNames = builder.protectionNames;
        this.resourceTypes = builder.resourceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceArns() {
        return resourceArns != null && !(resourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the resource whose protection you want to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceArns} method.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the resource whose protection you want to retrieve.
     */
    public final List<String> resourceArns() {
        return resourceArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProtectionNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProtectionNames() {
        return protectionNames != null && !(protectionNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the protection that you want to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtectionNames} method.
     * </p>
     * 
     * @return The name of the protection that you want to retrieve.
     */
    public final List<String> protectionNames() {
        return protectionNames;
    }

    /**
     * <p>
     * The type of protected resource whose protections you want to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return The type of protected resource whose protections you want to retrieve.
     */
    public final List<ProtectedResourceType> resourceTypes() {
        return ProtectedResourceTypeFiltersCopier.copyStringToEnum(resourceTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of protected resource whose protections you want to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return The type of protected resource whose protections you want to retrieve.
     */
    public final List<String> resourceTypesAsStrings() {
        return resourceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceArns() ? resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProtectionNames() ? protectionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InclusionProtectionFilters)) {
            return false;
        }
        InclusionProtectionFilters other = (InclusionProtectionFilters) obj;
        return hasResourceArns() == other.hasResourceArns() && Objects.equals(resourceArns(), other.resourceArns())
                && hasProtectionNames() == other.hasProtectionNames()
                && Objects.equals(protectionNames(), other.protectionNames()) && hasResourceTypes() == other.hasResourceTypes()
                && Objects.equals(resourceTypesAsStrings(), other.resourceTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InclusionProtectionFilters").add("ResourceArns", hasResourceArns() ? resourceArns() : null)
                .add("ProtectionNames", hasProtectionNames() ? protectionNames() : null)
                .add("ResourceTypes", hasResourceTypes() ? resourceTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        case "ProtectionNames":
            return Optional.ofNullable(clazz.cast(protectionNames()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceArns", RESOURCE_ARNS_FIELD);
        map.put("ProtectionNames", PROTECTION_NAMES_FIELD);
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InclusionProtectionFilters, T> g) {
        return obj -> g.apply((InclusionProtectionFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InclusionProtectionFilters> {
        /**
         * <p>
         * The ARN (Amazon Resource Name) of the resource whose protection you want to retrieve.
         * </p>
         * 
         * @param resourceArns
         *        The ARN (Amazon Resource Name) of the resource whose protection you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the resource whose protection you want to retrieve.
         * </p>
         * 
         * @param resourceArns
         *        The ARN (Amazon Resource Name) of the resource whose protection you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);

        /**
         * <p>
         * The name of the protection that you want to retrieve.
         * </p>
         * 
         * @param protectionNames
         *        The name of the protection that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectionNames(Collection<String> protectionNames);

        /**
         * <p>
         * The name of the protection that you want to retrieve.
         * </p>
         * 
         * @param protectionNames
         *        The name of the protection that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectionNames(String... protectionNames);

        /**
         * <p>
         * The type of protected resource whose protections you want to retrieve.
         * </p>
         * 
         * @param resourceTypes
         *        The type of protected resource whose protections you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(Collection<String> resourceTypes);

        /**
         * <p>
         * The type of protected resource whose protections you want to retrieve.
         * </p>
         * 
         * @param resourceTypes
         *        The type of protected resource whose protections you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(String... resourceTypes);

        /**
         * <p>
         * The type of protected resource whose protections you want to retrieve.
         * </p>
         * 
         * @param resourceTypes
         *        The type of protected resource whose protections you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<ProtectedResourceType> resourceTypes);

        /**
         * <p>
         * The type of protected resource whose protections you want to retrieve.
         * </p>
         * 
         * @param resourceTypes
         *        The type of protected resource whose protections you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(ProtectedResourceType... resourceTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> protectionNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InclusionProtectionFilters model) {
            resourceArns(model.resourceArns);
            protectionNames(model.protectionNames);
            resourceTypesWithStrings(model.resourceTypes);
        }

        public final Collection<String> getResourceArns() {
            if (resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnFiltersCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnFiltersCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final Collection<String> getProtectionNames() {
            if (protectionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return protectionNames;
        }

        public final void setProtectionNames(Collection<String> protectionNames) {
            this.protectionNames = ProtectionNameFiltersCopier.copy(protectionNames);
        }

        @Override
        public final Builder protectionNames(Collection<String> protectionNames) {
            this.protectionNames = ProtectionNameFiltersCopier.copy(protectionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectionNames(String... protectionNames) {
            protectionNames(Arrays.asList(protectionNames));
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ProtectedResourceTypeFiltersCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ProtectedResourceTypeFiltersCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String... resourceTypes) {
            resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ProtectedResourceType> resourceTypes) {
            this.resourceTypes = ProtectedResourceTypeFiltersCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ProtectedResourceType... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public InclusionProtectionFilters build() {
            return new InclusionProtectionFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
