/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProtectionsRequest extends ShieldRequest implements
        ToCopyableBuilder<ListProtectionsRequest.Builder, ListProtectionsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListProtectionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListProtectionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<InclusionProtectionFilters> INCLUSION_FILTERS_FIELD = SdkField
            .<InclusionProtectionFilters> builder(MarshallingType.SDK_POJO).memberName("InclusionFilters")
            .getter(getter(ListProtectionsRequest::inclusionFilters)).setter(setter(Builder::inclusionFilters))
            .constructor(InclusionProtectionFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionFilters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, INCLUSION_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final InclusionProtectionFilters inclusionFilters;

    private ListProtectionsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.inclusionFilters = builder.inclusionFilters;
    }

    /**
     * <p>
     * When you request a list of objects from Shield Advanced, if the response does not include all of the remaining
     * available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the
     * next batch of objects by requesting the list again and providing the token that was returned by the prior call in
     * your request.
     * </p>
     * <p>
     * You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the
     * <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but
     * may return fewer, even if more objects are still available.
     * </p>
     * <p>
     * Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a
     * <code>NextToken</code> value.
     * </p>
     * <p>
     * On your first call to a list operation, leave this setting empty.
     * </p>
     * 
     * @return When you request a list of objects from Shield Advanced, if the response does not include all of the
     *         remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You
     *         can retrieve the next batch of objects by requesting the list again and providing the token that was
     *         returned by the prior call in your request. </p>
     *         <p>
     *         You can indicate the maximum number of objects that you want Shield Advanced to return for a single call
     *         with the <code>MaxResults</code> setting. Shield Advanced will not return more than
     *         <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.
     *         </p>
     *         <p>
     *         Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include
     *         a <code>NextToken</code> value.
     *         </p>
     *         <p>
     *         On your first call to a list operation, leave this setting empty.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might
     * return fewer objects than you indicate in this setting, even if more objects are available. If there are more
     * objects remaining, Shield Advanced will always also return a <code>NextToken</code> value in the response.
     * </p>
     * <p>
     * The default setting is 20.
     * </p>
     * 
     * @return The greatest number of objects that you want Shield Advanced to return to the list request. Shield
     *         Advanced might return fewer objects than you indicate in this setting, even if more objects are
     *         available. If there are more objects remaining, Shield Advanced will always also return a
     *         <code>NextToken</code> value in the response.</p>
     *         <p>
     *         The default setting is 20.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Narrows the set of protections that the call retrieves. You can retrieve a single protection by providing its
     * name or the ARN (Amazon Resource Name) of its protected resource. You can also retrieve all protections for a
     * specific resource type. You can provide up to one criteria per filter type. Shield Advanced returns protections
     * that exactly match all of the filter criteria that you provide.
     * </p>
     * 
     * @return Narrows the set of protections that the call retrieves. You can retrieve a single protection by providing
     *         its name or the ARN (Amazon Resource Name) of its protected resource. You can also retrieve all
     *         protections for a specific resource type. You can provide up to one criteria per filter type. Shield
     *         Advanced returns protections that exactly match all of the filter criteria that you provide.
     */
    public final InclusionProtectionFilters inclusionFilters() {
        return inclusionFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(inclusionFilters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProtectionsRequest)) {
            return false;
        }
        ListProtectionsRequest other = (ListProtectionsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(inclusionFilters(), other.inclusionFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProtectionsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("InclusionFilters", inclusionFilters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "InclusionFilters":
            return Optional.ofNullable(clazz.cast(inclusionFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("InclusionFilters", INCLUSION_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProtectionsRequest, T> g) {
        return obj -> g.apply((ListProtectionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ShieldRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListProtectionsRequest> {
        /**
         * <p>
         * When you request a list of objects from Shield Advanced, if the response does not include all of the
         * remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can
         * retrieve the next batch of objects by requesting the list again and providing the token that was returned by
         * the prior call in your request.
         * </p>
         * <p>
         * You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with
         * the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code>
         * objects, but may return fewer, even if more objects are still available.
         * </p>
         * <p>
         * Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a
         * <code>NextToken</code> value.
         * </p>
         * <p>
         * On your first call to a list operation, leave this setting empty.
         * </p>
         * 
         * @param nextToken
         *        When you request a list of objects from Shield Advanced, if the response does not include all of the
         *        remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response.
         *        You can retrieve the next batch of objects by requesting the list again and providing the token that
         *        was returned by the prior call in your request. </p>
         *        <p>
         *        You can indicate the maximum number of objects that you want Shield Advanced to return for a single
         *        call with the <code>MaxResults</code> setting. Shield Advanced will not return more than
         *        <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.
         *        </p>
         *        <p>
         *        Whenever more objects remain that Shield Advanced has not yet returned to you, the response will
         *        include a <code>NextToken</code> value.
         *        </p>
         *        <p>
         *        On your first call to a list operation, leave this setting empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced
         * might return fewer objects than you indicate in this setting, even if more objects are available. If there
         * are more objects remaining, Shield Advanced will always also return a <code>NextToken</code> value in the
         * response.
         * </p>
         * <p>
         * The default setting is 20.
         * </p>
         * 
         * @param maxResults
         *        The greatest number of objects that you want Shield Advanced to return to the list request. Shield
         *        Advanced might return fewer objects than you indicate in this setting, even if more objects are
         *        available. If there are more objects remaining, Shield Advanced will always also return a
         *        <code>NextToken</code> value in the response.</p>
         *        <p>
         *        The default setting is 20.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Narrows the set of protections that the call retrieves. You can retrieve a single protection by providing its
         * name or the ARN (Amazon Resource Name) of its protected resource. You can also retrieve all protections for a
         * specific resource type. You can provide up to one criteria per filter type. Shield Advanced returns
         * protections that exactly match all of the filter criteria that you provide.
         * </p>
         * 
         * @param inclusionFilters
         *        Narrows the set of protections that the call retrieves. You can retrieve a single protection by
         *        providing its name or the ARN (Amazon Resource Name) of its protected resource. You can also retrieve
         *        all protections for a specific resource type. You can provide up to one criteria per filter type.
         *        Shield Advanced returns protections that exactly match all of the filter criteria that you provide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionFilters(InclusionProtectionFilters inclusionFilters);

        /**
         * <p>
         * Narrows the set of protections that the call retrieves. You can retrieve a single protection by providing its
         * name or the ARN (Amazon Resource Name) of its protected resource. You can also retrieve all protections for a
         * specific resource type. You can provide up to one criteria per filter type. Shield Advanced returns
         * protections that exactly match all of the filter criteria that you provide.
         * </p>
         * This is a convenience method that creates an instance of the {@link InclusionProtectionFilters.Builder}
         * avoiding the need to create one manually via {@link InclusionProtectionFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InclusionProtectionFilters.Builder#build()} is called immediately
         * and its result is passed to {@link #inclusionFilters(InclusionProtectionFilters)}.
         * 
         * @param inclusionFilters
         *        a consumer that will call methods on {@link InclusionProtectionFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inclusionFilters(InclusionProtectionFilters)
         */
        default Builder inclusionFilters(Consumer<InclusionProtectionFilters.Builder> inclusionFilters) {
            return inclusionFilters(InclusionProtectionFilters.builder().applyMutation(inclusionFilters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ShieldRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private InclusionProtectionFilters inclusionFilters;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProtectionsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            inclusionFilters(model.inclusionFilters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final InclusionProtectionFilters.Builder getInclusionFilters() {
            return inclusionFilters != null ? inclusionFilters.toBuilder() : null;
        }

        public final void setInclusionFilters(InclusionProtectionFilters.BuilderImpl inclusionFilters) {
            this.inclusionFilters = inclusionFilters != null ? inclusionFilters.build() : null;
        }

        @Override
        public final Builder inclusionFilters(InclusionProtectionFilters inclusionFilters) {
            this.inclusionFilters = inclusionFilters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListProtectionsRequest build() {
            return new ListProtectionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
