/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a DDoS attack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttackDetail implements SdkPojo, Serializable, ToCopyableBuilder<AttackDetail.Builder, AttackDetail> {
    private static final SdkField<String> ATTACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttackId").getter(getter(AttackDetail::attackId)).setter(setter(Builder::attackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackId").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(AttackDetail::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<List<SubResourceSummary>> SUB_RESOURCES_FIELD = SdkField
            .<List<SubResourceSummary>> builder(MarshallingType.LIST)
            .memberName("SubResources")
            .getter(getter(AttackDetail::subResources))
            .setter(setter(Builder::subResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubResourceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubResourceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(AttackDetail::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(AttackDetail::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<List<SummarizedCounter>> ATTACK_COUNTERS_FIELD = SdkField
            .<List<SummarizedCounter>> builder(MarshallingType.LIST)
            .memberName("AttackCounters")
            .getter(getter(AttackDetail::attackCounters))
            .setter(setter(Builder::attackCounters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackCounters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SummarizedCounter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SummarizedCounter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AttackProperty>> ATTACK_PROPERTIES_FIELD = SdkField
            .<List<AttackProperty>> builder(MarshallingType.LIST)
            .memberName("AttackProperties")
            .getter(getter(AttackDetail::attackProperties))
            .setter(setter(Builder::attackProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttackProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttackProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Mitigation>> MITIGATIONS_FIELD = SdkField
            .<List<Mitigation>> builder(MarshallingType.LIST)
            .memberName("Mitigations")
            .getter(getter(AttackDetail::mitigations))
            .setter(setter(Builder::mitigations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mitigations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Mitigation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Mitigation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACK_ID_FIELD,
            RESOURCE_ARN_FIELD, SUB_RESOURCES_FIELD, START_TIME_FIELD, END_TIME_FIELD, ATTACK_COUNTERS_FIELD,
            ATTACK_PROPERTIES_FIELD, MITIGATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attackId;

    private final String resourceArn;

    private final List<SubResourceSummary> subResources;

    private final Instant startTime;

    private final Instant endTime;

    private final List<SummarizedCounter> attackCounters;

    private final List<AttackProperty> attackProperties;

    private final List<Mitigation> mitigations;

    private AttackDetail(BuilderImpl builder) {
        this.attackId = builder.attackId;
        this.resourceArn = builder.resourceArn;
        this.subResources = builder.subResources;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.attackCounters = builder.attackCounters;
        this.attackProperties = builder.attackProperties;
        this.mitigations = builder.mitigations;
    }

    /**
     * <p>
     * The unique identifier (ID) of the attack.
     * </p>
     * 
     * @return The unique identifier (ID) of the attack.
     */
    public final String attackId() {
        return attackId;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the resource that was attacked.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the resource that was attacked.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubResources() {
        return subResources != null && !(subResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If applicable, additional detail about the resource being attacked, for example, IP address or URL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubResources} method.
     * </p>
     * 
     * @return If applicable, additional detail about the resource being attacked, for example, IP address or URL.
     */
    public final List<SubResourceSummary> subResources() {
        return subResources;
    }

    /**
     * <p>
     * The time the attack started, in Unix time in seconds.
     * </p>
     * 
     * @return The time the attack started, in Unix time in seconds.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time the attack ended, in Unix time in seconds.
     * </p>
     * 
     * @return The time the attack ended, in Unix time in seconds.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttackCounters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttackCounters() {
        return attackCounters != null && !(attackCounters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of counters that describe the attack for the specified time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttackCounters} method.
     * </p>
     * 
     * @return List of counters that describe the attack for the specified time period.
     */
    public final List<SummarizedCounter> attackCounters() {
        return attackCounters;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttackProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttackProperties() {
        return attackProperties != null && !(attackProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of objects that provide details of the Shield event.
     * </p>
     * <p>
     * For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon
     * CloudWatch metrics. For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms">Shield
     * metrics and alarms</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttackProperties} method.
     * </p>
     * 
     * @return The array of objects that provide details of the Shield event. </p>
     *         <p>
     *         For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon
     *         CloudWatch metrics. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms"
     *         >Shield metrics and alarms</a> in the <i>WAF Developer Guide</i>.
     */
    public final List<AttackProperty> attackProperties() {
        return attackProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Mitigations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMitigations() {
        return mitigations != null && !(mitigations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of mitigation actions taken for the attack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMitigations} method.
     * </p>
     * 
     * @return List of mitigation actions taken for the attack.
     */
    public final List<Mitigation> mitigations() {
        return mitigations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attackId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubResources() ? subResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttackCounters() ? attackCounters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttackProperties() ? attackProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMitigations() ? mitigations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackDetail)) {
            return false;
        }
        AttackDetail other = (AttackDetail) obj;
        return Objects.equals(attackId(), other.attackId()) && Objects.equals(resourceArn(), other.resourceArn())
                && hasSubResources() == other.hasSubResources() && Objects.equals(subResources(), other.subResources())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && hasAttackCounters() == other.hasAttackCounters() && Objects.equals(attackCounters(), other.attackCounters())
                && hasAttackProperties() == other.hasAttackProperties()
                && Objects.equals(attackProperties(), other.attackProperties()) && hasMitigations() == other.hasMitigations()
                && Objects.equals(mitigations(), other.mitigations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttackDetail").add("AttackId", attackId()).add("ResourceArn", resourceArn())
                .add("SubResources", hasSubResources() ? subResources() : null).add("StartTime", startTime())
                .add("EndTime", endTime()).add("AttackCounters", hasAttackCounters() ? attackCounters() : null)
                .add("AttackProperties", hasAttackProperties() ? attackProperties() : null)
                .add("Mitigations", hasMitigations() ? mitigations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttackId":
            return Optional.ofNullable(clazz.cast(attackId()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "SubResources":
            return Optional.ofNullable(clazz.cast(subResources()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "AttackCounters":
            return Optional.ofNullable(clazz.cast(attackCounters()));
        case "AttackProperties":
            return Optional.ofNullable(clazz.cast(attackProperties()));
        case "Mitigations":
            return Optional.ofNullable(clazz.cast(mitigations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttackId", ATTACK_ID_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("SubResources", SUB_RESOURCES_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("AttackCounters", ATTACK_COUNTERS_FIELD);
        map.put("AttackProperties", ATTACK_PROPERTIES_FIELD);
        map.put("Mitigations", MITIGATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttackDetail, T> g) {
        return obj -> g.apply((AttackDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttackDetail> {
        /**
         * <p>
         * The unique identifier (ID) of the attack.
         * </p>
         * 
         * @param attackId
         *        The unique identifier (ID) of the attack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackId(String attackId);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the resource that was attacked.
         * </p>
         * 
         * @param resourceArn
         *        The ARN (Amazon Resource Name) of the resource that was attacked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * If applicable, additional detail about the resource being attacked, for example, IP address or URL.
         * </p>
         * 
         * @param subResources
         *        If applicable, additional detail about the resource being attacked, for example, IP address or URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subResources(Collection<SubResourceSummary> subResources);

        /**
         * <p>
         * If applicable, additional detail about the resource being attacked, for example, IP address or URL.
         * </p>
         * 
         * @param subResources
         *        If applicable, additional detail about the resource being attacked, for example, IP address or URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subResources(SubResourceSummary... subResources);

        /**
         * <p>
         * If applicable, additional detail about the resource being attacked, for example, IP address or URL.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.shield.model.SubResourceSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.shield.model.SubResourceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.shield.model.SubResourceSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #subResources(List<SubResourceSummary>)}.
         * 
         * @param subResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.shield.model.SubResourceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subResources(java.util.Collection<SubResourceSummary>)
         */
        Builder subResources(Consumer<SubResourceSummary.Builder>... subResources);

        /**
         * <p>
         * The time the attack started, in Unix time in seconds.
         * </p>
         * 
         * @param startTime
         *        The time the attack started, in Unix time in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time the attack ended, in Unix time in seconds.
         * </p>
         * 
         * @param endTime
         *        The time the attack ended, in Unix time in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * List of counters that describe the attack for the specified time period.
         * </p>
         * 
         * @param attackCounters
         *        List of counters that describe the attack for the specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackCounters(Collection<SummarizedCounter> attackCounters);

        /**
         * <p>
         * List of counters that describe the attack for the specified time period.
         * </p>
         * 
         * @param attackCounters
         *        List of counters that describe the attack for the specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackCounters(SummarizedCounter... attackCounters);

        /**
         * <p>
         * List of counters that describe the attack for the specified time period.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.shield.model.SummarizedCounter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.shield.model.SummarizedCounter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.shield.model.SummarizedCounter.Builder#build()} is called immediately
         * and its result is passed to {@link #attackCounters(List<SummarizedCounter>)}.
         * 
         * @param attackCounters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.shield.model.SummarizedCounter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attackCounters(java.util.Collection<SummarizedCounter>)
         */
        Builder attackCounters(Consumer<SummarizedCounter.Builder>... attackCounters);

        /**
         * <p>
         * The array of objects that provide details of the Shield event.
         * </p>
         * <p>
         * For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon
         * CloudWatch metrics. For more information, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms"
         * >Shield metrics and alarms</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * 
         * @param attackProperties
         *        The array of objects that provide details of the Shield event. </p>
         *        <p>
         *        For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in
         *        Amazon CloudWatch metrics. For more information, see <a href=
         *        "https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms"
         *        >Shield metrics and alarms</a> in the <i>WAF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackProperties(Collection<AttackProperty> attackProperties);

        /**
         * <p>
         * The array of objects that provide details of the Shield event.
         * </p>
         * <p>
         * For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon
         * CloudWatch metrics. For more information, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms"
         * >Shield metrics and alarms</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * 
         * @param attackProperties
         *        The array of objects that provide details of the Shield event. </p>
         *        <p>
         *        For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in
         *        Amazon CloudWatch metrics. For more information, see <a href=
         *        "https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms"
         *        >Shield metrics and alarms</a> in the <i>WAF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackProperties(AttackProperty... attackProperties);

        /**
         * <p>
         * The array of objects that provide details of the Shield event.
         * </p>
         * <p>
         * For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon
         * CloudWatch metrics. For more information, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms"
         * >Shield metrics and alarms</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.shield.model.AttackProperty.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.shield.model.AttackProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.shield.model.AttackProperty.Builder#build()} is called immediately and
         * its result is passed to {@link #attackProperties(List<AttackProperty>)}.
         * 
         * @param attackProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.shield.model.AttackProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attackProperties(java.util.Collection<AttackProperty>)
         */
        Builder attackProperties(Consumer<AttackProperty.Builder>... attackProperties);

        /**
         * <p>
         * List of mitigation actions taken for the attack.
         * </p>
         * 
         * @param mitigations
         *        List of mitigation actions taken for the attack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mitigations(Collection<Mitigation> mitigations);

        /**
         * <p>
         * List of mitigation actions taken for the attack.
         * </p>
         * 
         * @param mitigations
         *        List of mitigation actions taken for the attack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mitigations(Mitigation... mitigations);

        /**
         * <p>
         * List of mitigation actions taken for the attack.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.shield.model.Mitigation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.shield.model.Mitigation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.shield.model.Mitigation.Builder#build()} is called immediately and its
         * result is passed to {@link #mitigations(List<Mitigation>)}.
         * 
         * @param mitigations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.shield.model.Mitigation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mitigations(java.util.Collection<Mitigation>)
         */
        Builder mitigations(Consumer<Mitigation.Builder>... mitigations);
    }

    static final class BuilderImpl implements Builder {
        private String attackId;

        private String resourceArn;

        private List<SubResourceSummary> subResources = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private List<SummarizedCounter> attackCounters = DefaultSdkAutoConstructList.getInstance();

        private List<AttackProperty> attackProperties = DefaultSdkAutoConstructList.getInstance();

        private List<Mitigation> mitigations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttackDetail model) {
            attackId(model.attackId);
            resourceArn(model.resourceArn);
            subResources(model.subResources);
            startTime(model.startTime);
            endTime(model.endTime);
            attackCounters(model.attackCounters);
            attackProperties(model.attackProperties);
            mitigations(model.mitigations);
        }

        public final String getAttackId() {
            return attackId;
        }

        public final void setAttackId(String attackId) {
            this.attackId = attackId;
        }

        @Override
        public final Builder attackId(String attackId) {
            this.attackId = attackId;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final List<SubResourceSummary.Builder> getSubResources() {
            List<SubResourceSummary.Builder> result = SubResourceSummaryListCopier.copyToBuilder(this.subResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubResources(Collection<SubResourceSummary.BuilderImpl> subResources) {
            this.subResources = SubResourceSummaryListCopier.copyFromBuilder(subResources);
        }

        @Override
        public final Builder subResources(Collection<SubResourceSummary> subResources) {
            this.subResources = SubResourceSummaryListCopier.copy(subResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subResources(SubResourceSummary... subResources) {
            subResources(Arrays.asList(subResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subResources(Consumer<SubResourceSummary.Builder>... subResources) {
            subResources(Stream.of(subResources).map(c -> SubResourceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<SummarizedCounter.Builder> getAttackCounters() {
            List<SummarizedCounter.Builder> result = SummarizedCounterListCopier.copyToBuilder(this.attackCounters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttackCounters(Collection<SummarizedCounter.BuilderImpl> attackCounters) {
            this.attackCounters = SummarizedCounterListCopier.copyFromBuilder(attackCounters);
        }

        @Override
        public final Builder attackCounters(Collection<SummarizedCounter> attackCounters) {
            this.attackCounters = SummarizedCounterListCopier.copy(attackCounters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackCounters(SummarizedCounter... attackCounters) {
            attackCounters(Arrays.asList(attackCounters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackCounters(Consumer<SummarizedCounter.Builder>... attackCounters) {
            attackCounters(Stream.of(attackCounters).map(c -> SummarizedCounter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AttackProperty.Builder> getAttackProperties() {
            List<AttackProperty.Builder> result = AttackPropertiesCopier.copyToBuilder(this.attackProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttackProperties(Collection<AttackProperty.BuilderImpl> attackProperties) {
            this.attackProperties = AttackPropertiesCopier.copyFromBuilder(attackProperties);
        }

        @Override
        public final Builder attackProperties(Collection<AttackProperty> attackProperties) {
            this.attackProperties = AttackPropertiesCopier.copy(attackProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackProperties(AttackProperty... attackProperties) {
            attackProperties(Arrays.asList(attackProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackProperties(Consumer<AttackProperty.Builder>... attackProperties) {
            attackProperties(Stream.of(attackProperties).map(c -> AttackProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Mitigation.Builder> getMitigations() {
            List<Mitigation.Builder> result = MitigationListCopier.copyToBuilder(this.mitigations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMitigations(Collection<Mitigation.BuilderImpl> mitigations) {
            this.mitigations = MitigationListCopier.copyFromBuilder(mitigations);
        }

        @Override
        public final Builder mitigations(Collection<Mitigation> mitigations) {
            this.mitigations = MitigationListCopier.copy(mitigations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mitigations(Mitigation... mitigations) {
            mitigations(Arrays.asList(mitigations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mitigations(Consumer<Mitigation.Builder>... mitigations) {
            mitigations(Stream.of(mitigations).map(c -> Mitigation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AttackDetail build() {
            return new AttackDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
