/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarizes all DDoS attacks for a specified time period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttackSummary implements SdkPojo, Serializable, ToCopyableBuilder<AttackSummary.Builder, AttackSummary> {
    private static final SdkField<String> ATTACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttackId").getter(getter(AttackSummary::attackId)).setter(setter(Builder::attackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackId").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(AttackSummary::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(AttackSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(AttackSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<List<AttackVectorDescription>> ATTACK_VECTORS_FIELD = SdkField
            .<List<AttackVectorDescription>> builder(MarshallingType.LIST)
            .memberName("AttackVectors")
            .getter(getter(AttackSummary::attackVectors))
            .setter(setter(Builder::attackVectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackVectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttackVectorDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttackVectorDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACK_ID_FIELD,
            RESOURCE_ARN_FIELD, START_TIME_FIELD, END_TIME_FIELD, ATTACK_VECTORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attackId;

    private final String resourceArn;

    private final Instant startTime;

    private final Instant endTime;

    private final List<AttackVectorDescription> attackVectors;

    private AttackSummary(BuilderImpl builder) {
        this.attackId = builder.attackId;
        this.resourceArn = builder.resourceArn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.attackVectors = builder.attackVectors;
    }

    /**
     * <p>
     * The unique identifier (ID) of the attack.
     * </p>
     * 
     * @return The unique identifier (ID) of the attack.
     */
    public final String attackId() {
        return attackId;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the resource that was attacked.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the resource that was attacked.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The start time of the attack, in Unix time in seconds.
     * </p>
     * 
     * @return The start time of the attack, in Unix time in seconds.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the attack, in Unix time in seconds.
     * </p>
     * 
     * @return The end time of the attack, in Unix time in seconds.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttackVectors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttackVectors() {
        return attackVectors != null && !(attackVectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of attacks for a specified time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttackVectors} method.
     * </p>
     * 
     * @return The list of attacks for a specified time period.
     */
    public final List<AttackVectorDescription> attackVectors() {
        return attackVectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attackId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttackVectors() ? attackVectors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackSummary)) {
            return false;
        }
        AttackSummary other = (AttackSummary) obj;
        return Objects.equals(attackId(), other.attackId()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && hasAttackVectors() == other.hasAttackVectors() && Objects.equals(attackVectors(), other.attackVectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttackSummary").add("AttackId", attackId()).add("ResourceArn", resourceArn())
                .add("StartTime", startTime()).add("EndTime", endTime())
                .add("AttackVectors", hasAttackVectors() ? attackVectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttackId":
            return Optional.ofNullable(clazz.cast(attackId()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "AttackVectors":
            return Optional.ofNullable(clazz.cast(attackVectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttackId", ATTACK_ID_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("AttackVectors", ATTACK_VECTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttackSummary, T> g) {
        return obj -> g.apply((AttackSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttackSummary> {
        /**
         * <p>
         * The unique identifier (ID) of the attack.
         * </p>
         * 
         * @param attackId
         *        The unique identifier (ID) of the attack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackId(String attackId);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the resource that was attacked.
         * </p>
         * 
         * @param resourceArn
         *        The ARN (Amazon Resource Name) of the resource that was attacked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The start time of the attack, in Unix time in seconds.
         * </p>
         * 
         * @param startTime
         *        The start time of the attack, in Unix time in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time of the attack, in Unix time in seconds.
         * </p>
         * 
         * @param endTime
         *        The end time of the attack, in Unix time in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The list of attacks for a specified time period.
         * </p>
         * 
         * @param attackVectors
         *        The list of attacks for a specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackVectors(Collection<AttackVectorDescription> attackVectors);

        /**
         * <p>
         * The list of attacks for a specified time period.
         * </p>
         * 
         * @param attackVectors
         *        The list of attacks for a specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackVectors(AttackVectorDescription... attackVectors);

        /**
         * <p>
         * The list of attacks for a specified time period.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.shield.model.AttackVectorDescription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.shield.model.AttackVectorDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.shield.model.AttackVectorDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #attackVectors(List<AttackVectorDescription>)}.
         * 
         * @param attackVectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.shield.model.AttackVectorDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attackVectors(java.util.Collection<AttackVectorDescription>)
         */
        Builder attackVectors(Consumer<AttackVectorDescription.Builder>... attackVectors);
    }

    static final class BuilderImpl implements Builder {
        private String attackId;

        private String resourceArn;

        private Instant startTime;

        private Instant endTime;

        private List<AttackVectorDescription> attackVectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttackSummary model) {
            attackId(model.attackId);
            resourceArn(model.resourceArn);
            startTime(model.startTime);
            endTime(model.endTime);
            attackVectors(model.attackVectors);
        }

        public final String getAttackId() {
            return attackId;
        }

        public final void setAttackId(String attackId) {
            this.attackId = attackId;
        }

        @Override
        public final Builder attackId(String attackId) {
            this.attackId = attackId;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<AttackVectorDescription.Builder> getAttackVectors() {
            List<AttackVectorDescription.Builder> result = AttackVectorDescriptionListCopier.copyToBuilder(this.attackVectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttackVectors(Collection<AttackVectorDescription.BuilderImpl> attackVectors) {
            this.attackVectors = AttackVectorDescriptionListCopier.copyFromBuilder(attackVectors);
        }

        @Override
        public final Builder attackVectors(Collection<AttackVectorDescription> attackVectors) {
            this.attackVectors = AttackVectorDescriptionListCopier.copy(attackVectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackVectors(AttackVectorDescription... attackVectors) {
            attackVectors(Arrays.asList(attackVectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackVectors(Consumer<AttackVectorDescription.Builder>... attackVectors) {
            attackVectors(Stream.of(attackVectors).map(c -> AttackVectorDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AttackSummary build() {
            return new AttackSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
