/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a signing job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SigningJob implements SdkPojo, Serializable, ToCopyableBuilder<SigningJob.Builder, SigningJob> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SigningJob::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO)
            .getter(getter(SigningJob::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<SignedObject> SIGNED_OBJECT_FIELD = SdkField.<SignedObject> builder(MarshallingType.SDK_POJO)
            .getter(getter(SigningJob::signedObject)).setter(setter(Builder::signedObject)).constructor(SignedObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signedObject").build()).build();

    private static final SdkField<SigningMaterial> SIGNING_MATERIAL_FIELD = SdkField
            .<SigningMaterial> builder(MarshallingType.SDK_POJO).getter(getter(SigningJob::signingMaterial))
            .setter(setter(Builder::signingMaterial)).constructor(SigningMaterial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingMaterial").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(SigningJob::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SigningJob::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, SOURCE_FIELD,
            SIGNED_OBJECT_FIELD, SIGNING_MATERIAL_FIELD, CREATED_AT_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final Source source;

    private final SignedObject signedObject;

    private final SigningMaterial signingMaterial;

    private final Instant createdAt;

    private final String status;

    private SigningJob(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.source = builder.source;
        this.signedObject = builder.signedObject;
        this.signingMaterial = builder.signingMaterial;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the signing job.
     * </p>
     * 
     * @return The ID of the signing job.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * A <code>Source</code> that contains information about a signing job's code image source.
     * </p>
     * 
     * @return A <code>Source</code> that contains information about a signing job's code image source.
     */
    public Source source() {
        return source;
    }

    /**
     * <p>
     * A <code>SignedObject</code> structure that contains information about a signing job's signed code image.
     * </p>
     * 
     * @return A <code>SignedObject</code> structure that contains information about a signing job's signed code image.
     */
    public SignedObject signedObject() {
        return signedObject;
    }

    /**
     * <p>
     * A <code>SigningMaterial</code> object that contains the Amazon Resource Name (ARN) of the certificate used for
     * the signing job.
     * </p>
     * 
     * @return A <code>SigningMaterial</code> object that contains the Amazon Resource Name (ARN) of the certificate
     *         used for the signing job.
     */
    public SigningMaterial signingMaterial() {
        return signingMaterial;
    }

    /**
     * <p>
     * The date and time that the signing job was created.
     * </p>
     * 
     * @return The date and time that the signing job was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The status of the signing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SigningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the signing job.
     * @see SigningStatus
     */
    public SigningStatus status() {
        return SigningStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the signing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SigningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the signing job.
     * @see SigningStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(signedObject());
        hashCode = 31 * hashCode + Objects.hashCode(signingMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningJob)) {
            return false;
        }
        SigningJob other = (SigningJob) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(source(), other.source())
                && Objects.equals(signedObject(), other.signedObject())
                && Objects.equals(signingMaterial(), other.signingMaterial()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("SigningJob").add("JobId", jobId()).add("Source", source()).add("SignedObject", signedObject())
                .add("SigningMaterial", signingMaterial()).add("CreatedAt", createdAt()).add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "signedObject":
            return Optional.ofNullable(clazz.cast(signedObject()));
        case "signingMaterial":
            return Optional.ofNullable(clazz.cast(signingMaterial()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigningJob, T> g) {
        return obj -> g.apply((SigningJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SigningJob> {
        /**
         * <p>
         * The ID of the signing job.
         * </p>
         * 
         * @param jobId
         *        The ID of the signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * A <code>Source</code> that contains information about a signing job's code image source.
         * </p>
         * 
         * @param source
         *        A <code>Source</code> that contains information about a signing job's code image source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * <p>
         * A <code>Source</code> that contains information about a signing job's code image source.
         * </p>
         * This is a convenience that creates an instance of the {@link Source.Builder} avoiding the need to create one
         * manually via {@link Source#builder()}.
         *
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * A <code>SignedObject</code> structure that contains information about a signing job's signed code image.
         * </p>
         * 
         * @param signedObject
         *        A <code>SignedObject</code> structure that contains information about a signing job's signed code
         *        image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signedObject(SignedObject signedObject);

        /**
         * <p>
         * A <code>SignedObject</code> structure that contains information about a signing job's signed code image.
         * </p>
         * This is a convenience that creates an instance of the {@link SignedObject.Builder} avoiding the need to
         * create one manually via {@link SignedObject#builder()}.
         *
         * When the {@link Consumer} completes, {@link SignedObject.Builder#build()} is called immediately and its
         * result is passed to {@link #signedObject(SignedObject)}.
         * 
         * @param signedObject
         *        a consumer that will call methods on {@link SignedObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signedObject(SignedObject)
         */
        default Builder signedObject(Consumer<SignedObject.Builder> signedObject) {
            return signedObject(SignedObject.builder().applyMutation(signedObject).build());
        }

        /**
         * <p>
         * A <code>SigningMaterial</code> object that contains the Amazon Resource Name (ARN) of the certificate used
         * for the signing job.
         * </p>
         * 
         * @param signingMaterial
         *        A <code>SigningMaterial</code> object that contains the Amazon Resource Name (ARN) of the certificate
         *        used for the signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingMaterial(SigningMaterial signingMaterial);

        /**
         * <p>
         * A <code>SigningMaterial</code> object that contains the Amazon Resource Name (ARN) of the certificate used
         * for the signing job.
         * </p>
         * This is a convenience that creates an instance of the {@link SigningMaterial.Builder} avoiding the need to
         * create one manually via {@link SigningMaterial#builder()}.
         *
         * When the {@link Consumer} completes, {@link SigningMaterial.Builder#build()} is called immediately and its
         * result is passed to {@link #signingMaterial(SigningMaterial)}.
         * 
         * @param signingMaterial
         *        a consumer that will call methods on {@link SigningMaterial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signingMaterial(SigningMaterial)
         */
        default Builder signingMaterial(Consumer<SigningMaterial.Builder> signingMaterial) {
            return signingMaterial(SigningMaterial.builder().applyMutation(signingMaterial).build());
        }

        /**
         * <p>
         * The date and time that the signing job was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the signing job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The status of the signing job.
         * </p>
         * 
         * @param status
         *        The status of the signing job.
         * @see SigningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the signing job.
         * </p>
         * 
         * @param status
         *        The status of the signing job.
         * @see SigningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningStatus
         */
        Builder status(SigningStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private Source source;

        private SignedObject signedObject;

        private SigningMaterial signingMaterial;

        private Instant createdAt;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningJob model) {
            jobId(model.jobId);
            source(model.source);
            signedObject(model.signedObject);
            signingMaterial(model.signingMaterial);
            createdAt(model.createdAt);
            status(model.status);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final SignedObject.Builder getSignedObject() {
            return signedObject != null ? signedObject.toBuilder() : null;
        }

        @Override
        public final Builder signedObject(SignedObject signedObject) {
            this.signedObject = signedObject;
            return this;
        }

        public final void setSignedObject(SignedObject.BuilderImpl signedObject) {
            this.signedObject = signedObject != null ? signedObject.build() : null;
        }

        public final SigningMaterial.Builder getSigningMaterial() {
            return signingMaterial != null ? signingMaterial.toBuilder() : null;
        }

        @Override
        public final Builder signingMaterial(SigningMaterial signingMaterial) {
            this.signingMaterial = signingMaterial;
            return this;
        }

        public final void setSigningMaterial(SigningMaterial.BuilderImpl signingMaterial) {
            this.signingMaterial = signingMaterial != null ? signingMaterial.build() : null;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SigningStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public SigningJob build() {
            return new SigningJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
