/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the signing configurations and parameters that is used to perform an AWS Signer job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SigningPlatform implements SdkPojo, Serializable, ToCopyableBuilder<SigningPlatform.Builder, SigningPlatform> {
    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SigningPlatform::platformId)).setter(setter(Builder::platformId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SigningPlatform::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> PARTNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SigningPlatform::partner)).setter(setter(Builder::partner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partner").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SigningPlatform::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SigningPlatform::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<SigningConfiguration> SIGNING_CONFIGURATION_FIELD = SdkField
            .<SigningConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(SigningPlatform::signingConfiguration))
            .setter(setter(Builder::signingConfiguration)).constructor(SigningConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingConfiguration").build())
            .build();

    private static final SdkField<SigningImageFormat> SIGNING_IMAGE_FORMAT_FIELD = SdkField
            .<SigningImageFormat> builder(MarshallingType.SDK_POJO).getter(getter(SigningPlatform::signingImageFormat))
            .setter(setter(Builder::signingImageFormat)).constructor(SigningImageFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingImageFormat").build())
            .build();

    private static final SdkField<Integer> MAX_SIZE_IN_MB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SigningPlatform::maxSizeInMB)).setter(setter(Builder::maxSizeInMB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSizeInMB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_ID_FIELD,
            DISPLAY_NAME_FIELD, PARTNER_FIELD, TARGET_FIELD, CATEGORY_FIELD, SIGNING_CONFIGURATION_FIELD,
            SIGNING_IMAGE_FORMAT_FIELD, MAX_SIZE_IN_MB_FIELD));

    private static final long serialVersionUID = 1L;

    private final String platformId;

    private final String displayName;

    private final String partner;

    private final String target;

    private final String category;

    private final SigningConfiguration signingConfiguration;

    private final SigningImageFormat signingImageFormat;

    private final Integer maxSizeInMB;

    private SigningPlatform(BuilderImpl builder) {
        this.platformId = builder.platformId;
        this.displayName = builder.displayName;
        this.partner = builder.partner;
        this.target = builder.target;
        this.category = builder.category;
        this.signingConfiguration = builder.signingConfiguration;
        this.signingImageFormat = builder.signingImageFormat;
        this.maxSizeInMB = builder.maxSizeInMB;
    }

    /**
     * <p>
     * The ID of an AWS Signer platform.
     * </p>
     * 
     * @return The ID of an AWS Signer platform.
     */
    public String platformId() {
        return platformId;
    }

    /**
     * <p>
     * The display name of an AWS Signer platform.
     * </p>
     * 
     * @return The display name of an AWS Signer platform.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * Any partner entities linked to an AWS Signer platform.
     * </p>
     * 
     * @return Any partner entities linked to an AWS Signer platform.
     */
    public String partner() {
        return partner;
    }

    /**
     * <p>
     * The types of targets that can be signed by an AWS Signer platform.
     * </p>
     * 
     * @return The types of targets that can be signed by an AWS Signer platform.
     */
    public String target() {
        return target;
    }

    /**
     * <p>
     * The category of an AWS Signer platform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link Category#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of an AWS Signer platform.
     * @see Category
     */
    public Category category() {
        return Category.fromValue(category);
    }

    /**
     * <p>
     * The category of an AWS Signer platform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link Category#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of an AWS Signer platform.
     * @see Category
     */
    public String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * The configuration of an AWS Signer platform. This includes the designated hash algorithm and encryption algorithm
     * of a signing platform.
     * </p>
     * 
     * @return The configuration of an AWS Signer platform. This includes the designated hash algorithm and encryption
     *         algorithm of a signing platform.
     */
    public SigningConfiguration signingConfiguration() {
        return signingConfiguration;
    }

    /**
     * <p>
     * The signing image format that is used by an AWS Signer platform.
     * </p>
     * 
     * @return The signing image format that is used by an AWS Signer platform.
     */
    public SigningImageFormat signingImageFormat() {
        return signingImageFormat;
    }

    /**
     * <p>
     * The maximum size (in MB) of code that can be signed by a AWS Signer platform.
     * </p>
     * 
     * @return The maximum size (in MB) of code that can be signed by a AWS Signer platform.
     */
    public Integer maxSizeInMB() {
        return maxSizeInMB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(partner());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(signingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(signingImageFormat());
        hashCode = 31 * hashCode + Objects.hashCode(maxSizeInMB());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningPlatform)) {
            return false;
        }
        SigningPlatform other = (SigningPlatform) obj;
        return Objects.equals(platformId(), other.platformId()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(partner(), other.partner()) && Objects.equals(target(), other.target())
                && Objects.equals(categoryAsString(), other.categoryAsString())
                && Objects.equals(signingConfiguration(), other.signingConfiguration())
                && Objects.equals(signingImageFormat(), other.signingImageFormat())
                && Objects.equals(maxSizeInMB(), other.maxSizeInMB());
    }

    @Override
    public String toString() {
        return ToString.builder("SigningPlatform").add("PlatformId", platformId()).add("DisplayName", displayName())
                .add("Partner", partner()).add("Target", target()).add("Category", categoryAsString())
                .add("SigningConfiguration", signingConfiguration()).add("SigningImageFormat", signingImageFormat())
                .add("MaxSizeInMB", maxSizeInMB()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "platformId":
            return Optional.ofNullable(clazz.cast(platformId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "partner":
            return Optional.ofNullable(clazz.cast(partner()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "signingConfiguration":
            return Optional.ofNullable(clazz.cast(signingConfiguration()));
        case "signingImageFormat":
            return Optional.ofNullable(clazz.cast(signingImageFormat()));
        case "maxSizeInMB":
            return Optional.ofNullable(clazz.cast(maxSizeInMB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigningPlatform, T> g) {
        return obj -> g.apply((SigningPlatform) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SigningPlatform> {
        /**
         * <p>
         * The ID of an AWS Signer platform.
         * </p>
         * 
         * @param platformId
         *        The ID of an AWS Signer platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformId(String platformId);

        /**
         * <p>
         * The display name of an AWS Signer platform.
         * </p>
         * 
         * @param displayName
         *        The display name of an AWS Signer platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * Any partner entities linked to an AWS Signer platform.
         * </p>
         * 
         * @param partner
         *        Any partner entities linked to an AWS Signer platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partner(String partner);

        /**
         * <p>
         * The types of targets that can be signed by an AWS Signer platform.
         * </p>
         * 
         * @param target
         *        The types of targets that can be signed by an AWS Signer platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The category of an AWS Signer platform.
         * </p>
         * 
         * @param category
         *        The category of an AWS Signer platform.
         * @see Category
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Category
         */
        Builder category(String category);

        /**
         * <p>
         * The category of an AWS Signer platform.
         * </p>
         * 
         * @param category
         *        The category of an AWS Signer platform.
         * @see Category
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Category
         */
        Builder category(Category category);

        /**
         * <p>
         * The configuration of an AWS Signer platform. This includes the designated hash algorithm and encryption
         * algorithm of a signing platform.
         * </p>
         * 
         * @param signingConfiguration
         *        The configuration of an AWS Signer platform. This includes the designated hash algorithm and
         *        encryption algorithm of a signing platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingConfiguration(SigningConfiguration signingConfiguration);

        /**
         * <p>
         * The configuration of an AWS Signer platform. This includes the designated hash algorithm and encryption
         * algorithm of a signing platform.
         * </p>
         * This is a convenience that creates an instance of the {@link SigningConfiguration.Builder} avoiding the need
         * to create one manually via {@link SigningConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SigningConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #signingConfiguration(SigningConfiguration)}.
         * 
         * @param signingConfiguration
         *        a consumer that will call methods on {@link SigningConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signingConfiguration(SigningConfiguration)
         */
        default Builder signingConfiguration(Consumer<SigningConfiguration.Builder> signingConfiguration) {
            return signingConfiguration(SigningConfiguration.builder().applyMutation(signingConfiguration).build());
        }

        /**
         * <p>
         * The signing image format that is used by an AWS Signer platform.
         * </p>
         * 
         * @param signingImageFormat
         *        The signing image format that is used by an AWS Signer platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingImageFormat(SigningImageFormat signingImageFormat);

        /**
         * <p>
         * The signing image format that is used by an AWS Signer platform.
         * </p>
         * This is a convenience that creates an instance of the {@link SigningImageFormat.Builder} avoiding the need to
         * create one manually via {@link SigningImageFormat#builder()}.
         *
         * When the {@link Consumer} completes, {@link SigningImageFormat.Builder#build()} is called immediately and its
         * result is passed to {@link #signingImageFormat(SigningImageFormat)}.
         * 
         * @param signingImageFormat
         *        a consumer that will call methods on {@link SigningImageFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signingImageFormat(SigningImageFormat)
         */
        default Builder signingImageFormat(Consumer<SigningImageFormat.Builder> signingImageFormat) {
            return signingImageFormat(SigningImageFormat.builder().applyMutation(signingImageFormat).build());
        }

        /**
         * <p>
         * The maximum size (in MB) of code that can be signed by a AWS Signer platform.
         * </p>
         * 
         * @param maxSizeInMB
         *        The maximum size (in MB) of code that can be signed by a AWS Signer platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSizeInMB(Integer maxSizeInMB);
    }

    static final class BuilderImpl implements Builder {
        private String platformId;

        private String displayName;

        private String partner;

        private String target;

        private String category;

        private SigningConfiguration signingConfiguration;

        private SigningImageFormat signingImageFormat;

        private Integer maxSizeInMB;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningPlatform model) {
            platformId(model.platformId);
            displayName(model.displayName);
            partner(model.partner);
            target(model.target);
            category(model.category);
            signingConfiguration(model.signingConfiguration);
            signingImageFormat(model.signingImageFormat);
            maxSizeInMB(model.maxSizeInMB);
        }

        public final String getPlatformId() {
            return platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getPartner() {
            return partner;
        }

        @Override
        public final Builder partner(String partner) {
            this.partner = partner;
            return this;
        }

        public final void setPartner(String partner) {
            this.partner = partner;
        }

        public final String getTarget() {
            return target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getCategory() {
            return category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(Category category) {
            this.category(category.toString());
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final SigningConfiguration.Builder getSigningConfiguration() {
            return signingConfiguration != null ? signingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder signingConfiguration(SigningConfiguration signingConfiguration) {
            this.signingConfiguration = signingConfiguration;
            return this;
        }

        public final void setSigningConfiguration(SigningConfiguration.BuilderImpl signingConfiguration) {
            this.signingConfiguration = signingConfiguration != null ? signingConfiguration.build() : null;
        }

        public final SigningImageFormat.Builder getSigningImageFormat() {
            return signingImageFormat != null ? signingImageFormat.toBuilder() : null;
        }

        @Override
        public final Builder signingImageFormat(SigningImageFormat signingImageFormat) {
            this.signingImageFormat = signingImageFormat;
            return this;
        }

        public final void setSigningImageFormat(SigningImageFormat.BuilderImpl signingImageFormat) {
            this.signingImageFormat = signingImageFormat != null ? signingImageFormat.build() : null;
        }

        public final Integer getMaxSizeInMB() {
            return maxSizeInMB;
        }

        @Override
        public final Builder maxSizeInMB(Integer maxSizeInMB) {
            this.maxSizeInMB = maxSizeInMB;
            return this;
        }

        public final void setMaxSizeInMB(Integer maxSizeInMB) {
            this.maxSizeInMB = maxSizeInMB;
        }

        @Override
        public SigningPlatform build() {
            return new SigningPlatform(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
