/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a code signing operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SigningConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SigningConfiguration.Builder, SigningConfiguration> {
    private static final SdkField<EncryptionAlgorithmOptions> ENCRYPTION_ALGORITHM_OPTIONS_FIELD = SdkField
            .<EncryptionAlgorithmOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(SigningConfiguration::encryptionAlgorithmOptions))
            .setter(setter(Builder::encryptionAlgorithmOptions))
            .constructor(EncryptionAlgorithmOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionAlgorithmOptions").build())
            .build();

    private static final SdkField<HashAlgorithmOptions> HASH_ALGORITHM_OPTIONS_FIELD = SdkField
            .<HashAlgorithmOptions> builder(MarshallingType.SDK_POJO).getter(getter(SigningConfiguration::hashAlgorithmOptions))
            .setter(setter(Builder::hashAlgorithmOptions)).constructor(HashAlgorithmOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hashAlgorithmOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENCRYPTION_ALGORITHM_OPTIONS_FIELD, HASH_ALGORITHM_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final EncryptionAlgorithmOptions encryptionAlgorithmOptions;

    private final HashAlgorithmOptions hashAlgorithmOptions;

    private SigningConfiguration(BuilderImpl builder) {
        this.encryptionAlgorithmOptions = builder.encryptionAlgorithmOptions;
        this.hashAlgorithmOptions = builder.hashAlgorithmOptions;
    }

    /**
     * <p>
     * The encryption algorithm options that are available for a code signing job.
     * </p>
     * 
     * @return The encryption algorithm options that are available for a code signing job.
     */
    public EncryptionAlgorithmOptions encryptionAlgorithmOptions() {
        return encryptionAlgorithmOptions;
    }

    /**
     * <p>
     * The hash algorithm options that are available for a a code signing job.
     * </p>
     * 
     * @return The hash algorithm options that are available for a a code signing job.
     */
    public HashAlgorithmOptions hashAlgorithmOptions() {
        return hashAlgorithmOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionAlgorithmOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hashAlgorithmOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningConfiguration)) {
            return false;
        }
        SigningConfiguration other = (SigningConfiguration) obj;
        return Objects.equals(encryptionAlgorithmOptions(), other.encryptionAlgorithmOptions())
                && Objects.equals(hashAlgorithmOptions(), other.hashAlgorithmOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SigningConfiguration").add("EncryptionAlgorithmOptions", encryptionAlgorithmOptions())
                .add("HashAlgorithmOptions", hashAlgorithmOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "encryptionAlgorithmOptions":
            return Optional.ofNullable(clazz.cast(encryptionAlgorithmOptions()));
        case "hashAlgorithmOptions":
            return Optional.ofNullable(clazz.cast(hashAlgorithmOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigningConfiguration, T> g) {
        return obj -> g.apply((SigningConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SigningConfiguration> {
        /**
         * <p>
         * The encryption algorithm options that are available for a code signing job.
         * </p>
         * 
         * @param encryptionAlgorithmOptions
         *        The encryption algorithm options that are available for a code signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionAlgorithmOptions(EncryptionAlgorithmOptions encryptionAlgorithmOptions);

        /**
         * <p>
         * The encryption algorithm options that are available for a code signing job.
         * </p>
         * This is a convenience that creates an instance of the {@link EncryptionAlgorithmOptions.Builder} avoiding the
         * need to create one manually via {@link EncryptionAlgorithmOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionAlgorithmOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionAlgorithmOptions(EncryptionAlgorithmOptions)}.
         * 
         * @param encryptionAlgorithmOptions
         *        a consumer that will call methods on {@link EncryptionAlgorithmOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionAlgorithmOptions(EncryptionAlgorithmOptions)
         */
        default Builder encryptionAlgorithmOptions(Consumer<EncryptionAlgorithmOptions.Builder> encryptionAlgorithmOptions) {
            return encryptionAlgorithmOptions(EncryptionAlgorithmOptions.builder().applyMutation(encryptionAlgorithmOptions)
                    .build());
        }

        /**
         * <p>
         * The hash algorithm options that are available for a a code signing job.
         * </p>
         * 
         * @param hashAlgorithmOptions
         *        The hash algorithm options that are available for a a code signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hashAlgorithmOptions(HashAlgorithmOptions hashAlgorithmOptions);

        /**
         * <p>
         * The hash algorithm options that are available for a a code signing job.
         * </p>
         * This is a convenience that creates an instance of the {@link HashAlgorithmOptions.Builder} avoiding the need
         * to create one manually via {@link HashAlgorithmOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link HashAlgorithmOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #hashAlgorithmOptions(HashAlgorithmOptions)}.
         * 
         * @param hashAlgorithmOptions
         *        a consumer that will call methods on {@link HashAlgorithmOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hashAlgorithmOptions(HashAlgorithmOptions)
         */
        default Builder hashAlgorithmOptions(Consumer<HashAlgorithmOptions.Builder> hashAlgorithmOptions) {
            return hashAlgorithmOptions(HashAlgorithmOptions.builder().applyMutation(hashAlgorithmOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EncryptionAlgorithmOptions encryptionAlgorithmOptions;

        private HashAlgorithmOptions hashAlgorithmOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningConfiguration model) {
            encryptionAlgorithmOptions(model.encryptionAlgorithmOptions);
            hashAlgorithmOptions(model.hashAlgorithmOptions);
        }

        public final EncryptionAlgorithmOptions.Builder getEncryptionAlgorithmOptions() {
            return encryptionAlgorithmOptions != null ? encryptionAlgorithmOptions.toBuilder() : null;
        }

        @Override
        public final Builder encryptionAlgorithmOptions(EncryptionAlgorithmOptions encryptionAlgorithmOptions) {
            this.encryptionAlgorithmOptions = encryptionAlgorithmOptions;
            return this;
        }

        public final void setEncryptionAlgorithmOptions(EncryptionAlgorithmOptions.BuilderImpl encryptionAlgorithmOptions) {
            this.encryptionAlgorithmOptions = encryptionAlgorithmOptions != null ? encryptionAlgorithmOptions.build() : null;
        }

        public final HashAlgorithmOptions.Builder getHashAlgorithmOptions() {
            return hashAlgorithmOptions != null ? hashAlgorithmOptions.toBuilder() : null;
        }

        @Override
        public final Builder hashAlgorithmOptions(HashAlgorithmOptions hashAlgorithmOptions) {
            this.hashAlgorithmOptions = hashAlgorithmOptions;
            return this;
        }

        public final void setHashAlgorithmOptions(HashAlgorithmOptions.BuilderImpl hashAlgorithmOptions) {
            this.hashAlgorithmOptions = hashAlgorithmOptions != null ? hashAlgorithmOptions.build() : null;
        }

        @Override
        public SigningConfiguration build() {
            return new SigningConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
