/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An <code>S3Source</code> object that contains information about the S3 bucket where you saved your unsigned code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Source implements SdkPojo, Serializable, ToCopyableBuilder<Source.Builder, Source> {
    private static final SdkField<S3Source> S3_FIELD = SdkField.<S3Source> builder(MarshallingType.SDK_POJO).memberName("s3")
            .getter(getter(Source::s3)).setter(setter(Builder::s3)).constructor(S3Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Source s3;

    private Source(BuilderImpl builder) {
        this.s3 = builder.s3;
    }

    /**
     * <p>
     * The <code>S3Source</code> object.
     * </p>
     * 
     * @return The <code>S3Source</code> object.
     */
    public S3Source s3() {
        return s3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source) obj;
        return Objects.equals(s3(), other.s3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Source").add("S3", s3()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3":
            return Optional.ofNullable(clazz.cast(s3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Source, T> g) {
        return obj -> g.apply((Source) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Source> {
        /**
         * <p>
         * The <code>S3Source</code> object.
         * </p>
         * 
         * @param s3
         *        The <code>S3Source</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3Source s3);

        /**
         * <p>
         * The <code>S3Source</code> object.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Source.Builder} avoiding the need to create
         * one manually via {@link S3Source#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Source.Builder#build()} is called immediately and its result is
         * passed to {@link #s3(S3Source)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3Source)
         */
        default Builder s3(Consumer<S3Source.Builder> s3) {
            return s3(S3Source.builder().applyMutation(s3).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Source s3;

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            s3(model.s3);
        }

        public final S3Source.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        @Override
        public final Builder s3(S3Source s3) {
            this.s3 = s3;
            return this;
        }

        public final void setS3(S3Source.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public Source build() {
            return new Source(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
