/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProfilePermissionsResponse extends SignerResponse implements
        ToCopyableBuilder<ListProfilePermissionsResponse.Builder, ListProfilePermissionsResponse> {
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(ListProfilePermissionsResponse::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final SdkField<Integer> POLICY_SIZE_BYTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("policySizeBytes").getter(getter(ListProfilePermissionsResponse::policySizeBytes))
            .setter(setter(Builder::policySizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policySizeBytes").build()).build();

    private static final SdkField<List<Permission>> PERMISSIONS_FIELD = SdkField
            .<List<Permission>> builder(MarshallingType.LIST)
            .memberName("permissions")
            .getter(getter(ListProfilePermissionsResponse::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Permission> builder(MarshallingType.SDK_POJO)
                                            .constructor(Permission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListProfilePermissionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_ID_FIELD,
            POLICY_SIZE_BYTES_FIELD, PERMISSIONS_FIELD, NEXT_TOKEN_FIELD));

    private final String revisionId;

    private final Integer policySizeBytes;

    private final List<Permission> permissions;

    private final String nextToken;

    private ListProfilePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.revisionId = builder.revisionId;
        this.policySizeBytes = builder.policySizeBytes;
        this.permissions = builder.permissions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier for the current revision of profile permissions.
     * </p>
     * 
     * @return The identifier for the current revision of profile permissions.
     */
    public String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * Total size of the policy associated with the Signing Profile in bytes.
     * </p>
     * 
     * @return Total size of the policy associated with the Signing Profile in bytes.
     */
    public Integer policySizeBytes() {
        return policySizeBytes;
    }

    /**
     * Returns true if the Permissions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of permissions associated with the Signing Profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of permissions associated with the Signing Profile.
     */
    public List<Permission> permissions() {
        return permissions;
    }

    /**
     * <p>
     * String for specifying the next set of paginated results.
     * </p>
     * 
     * @return String for specifying the next set of paginated results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(policySizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfilePermissionsResponse)) {
            return false;
        }
        ListProfilePermissionsResponse other = (ListProfilePermissionsResponse) obj;
        return Objects.equals(revisionId(), other.revisionId()) && Objects.equals(policySizeBytes(), other.policySizeBytes())
                && hasPermissions() == other.hasPermissions() && Objects.equals(permissions(), other.permissions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListProfilePermissionsResponse").add("RevisionId", revisionId())
                .add("PolicySizeBytes", policySizeBytes()).add("Permissions", hasPermissions() ? permissions() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "policySizeBytes":
            return Optional.ofNullable(clazz.cast(policySizeBytes()));
        case "permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProfilePermissionsResponse, T> g) {
        return obj -> g.apply((ListProfilePermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SignerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListProfilePermissionsResponse> {
        /**
         * <p>
         * The identifier for the current revision of profile permissions.
         * </p>
         * 
         * @param revisionId
         *        The identifier for the current revision of profile permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * Total size of the policy associated with the Signing Profile in bytes.
         * </p>
         * 
         * @param policySizeBytes
         *        Total size of the policy associated with the Signing Profile in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policySizeBytes(Integer policySizeBytes);

        /**
         * <p>
         * List of permissions associated with the Signing Profile.
         * </p>
         * 
         * @param permissions
         *        List of permissions associated with the Signing Profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<Permission> permissions);

        /**
         * <p>
         * List of permissions associated with the Signing Profile.
         * </p>
         * 
         * @param permissions
         *        List of permissions associated with the Signing Profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Permission... permissions);

        /**
         * <p>
         * List of permissions associated with the Signing Profile.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Permission>.Builder} avoiding the need to
         * create one manually via {@link List<Permission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Permission>.Builder#build()} is called immediately and its
         * result is passed to {@link #permissions(List<Permission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link List<Permission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(List<Permission>)
         */
        Builder permissions(Consumer<Permission.Builder>... permissions);

        /**
         * <p>
         * String for specifying the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        String for specifying the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SignerResponse.BuilderImpl implements Builder {
        private String revisionId;

        private Integer policySizeBytes;

        private List<Permission> permissions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfilePermissionsResponse model) {
            super(model);
            revisionId(model.revisionId);
            policySizeBytes(model.policySizeBytes);
            permissions(model.permissions);
            nextToken(model.nextToken);
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final Integer getPolicySizeBytes() {
            return policySizeBytes;
        }

        @Override
        public final Builder policySizeBytes(Integer policySizeBytes) {
            this.policySizeBytes = policySizeBytes;
            return this;
        }

        public final void setPolicySizeBytes(Integer policySizeBytes) {
            this.policySizeBytes = policySizeBytes;
        }

        public final Collection<Permission.Builder> getPermissions() {
            if (permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return permissions != null ? permissions.stream().map(Permission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionsCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<Permission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> Permission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPermissions(Collection<Permission.BuilderImpl> permissions) {
            this.permissions = PermissionsCopier.copyFromBuilder(permissions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListProfilePermissionsResponse build() {
            return new ListProfilePermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
