/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The validity period for a signing job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignatureValidityPeriod implements SdkPojo, Serializable,
        ToCopyableBuilder<SignatureValidityPeriod.Builder, SignatureValidityPeriod> {
    private static final SdkField<Integer> VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("value")
            .getter(getter(SignatureValidityPeriod::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SignatureValidityPeriod::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer value;

    private final String type;

    private SignatureValidityPeriod(BuilderImpl builder) {
        this.value = builder.value;
        this.type = builder.type;
    }

    /**
     * <p>
     * The numerical value of the time unit for signature validity.
     * </p>
     * 
     * @return The numerical value of the time unit for signature validity.
     */
    public final Integer value() {
        return value;
    }

    /**
     * <p>
     * The time unit for signature validity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ValidityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The time unit for signature validity.
     * @see ValidityType
     */
    public final ValidityType type() {
        return ValidityType.fromValue(type);
    }

    /**
     * <p>
     * The time unit for signature validity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ValidityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The time unit for signature validity.
     * @see ValidityType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignatureValidityPeriod)) {
            return false;
        }
        SignatureValidityPeriod other = (SignatureValidityPeriod) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignatureValidityPeriod").add("Value", value()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SignatureValidityPeriod, T> g) {
        return obj -> g.apply((SignatureValidityPeriod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SignatureValidityPeriod> {
        /**
         * <p>
         * The numerical value of the time unit for signature validity.
         * </p>
         * 
         * @param value
         *        The numerical value of the time unit for signature validity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Integer value);

        /**
         * <p>
         * The time unit for signature validity.
         * </p>
         * 
         * @param type
         *        The time unit for signature validity.
         * @see ValidityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidityType
         */
        Builder type(String type);

        /**
         * <p>
         * The time unit for signature validity.
         * </p>
         * 
         * @param type
         *        The time unit for signature validity.
         * @see ValidityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidityType
         */
        Builder type(ValidityType type);
    }

    static final class BuilderImpl implements Builder {
        private Integer value;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SignatureValidityPeriod model) {
            value(model.value);
            type(model.type);
        }

        public final Integer getValue() {
            return value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ValidityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public SignatureValidityPeriod build() {
            return new SignatureValidityPeriod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
